<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function will install the module Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$db =& $gCms->GetDb();

// mysql-specific, but ignored by other database
$taboptarray = array('mysql' => 'TYPE=MyISAM');

$dict = NewDataDictionary($db);

// Table schema description
$flds = "
	gss_id I KEY,
	date " . CMS_ADODB_DT . ",
	location C(50),
	hometeam C(50),
	visitorteam C(50),
	hometeam_id I,
	visitorteam_id I,
	hometeam_score C(5),
	visitorteam_score C(5),
	season_id I
	";

// Create it. This should do error checking.
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_tss_gameschedule_score",$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// Create a sequence
$db->CreateSequence(cms_db_prefix()."module_tss_gameschedule_score_seq");

// Create permissions
$this->CreatePermission('Use TeamSportScores', 'Use Team Sport Scores');
$this->CreatePermission('Modify TeamSportScores', 'Modify Team Sport Scores');

// create a preference
#$this->SetPreference("prepare_auto_rss", false);

// Register events that the Team Sport Scores will issue. Other modules
// or user tags will be able to subscribe to these events, and trigger
// other actions when it gets called.
$this->CreateEvent( 'OnTeamSportScoresPreferenceChange' );
$this->CreateEvent( 'OnMatchDeleted' );

// Prepare default template(s)
$template = file_get_contents(dirname(__FILE__).'/templates/dftsummary.tpl');
$this->SetTemplate('summary_template',$template,'TeamSportScores');

// Mention installation in the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));

?>