<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

#The tabs
echo $this->StartTabHeaders();
if (FALSE == empty($params['active_tab']))
{
	$tab = $params['active_tab'];
} else {
	$tab = '';
}

if (! $this->CheckPermission('Use TeamSportScores'))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

$this->DisplayAdminNav($id, $params, $returnid);

echo $this->SetTabHeader('matches',$this->Lang('matches'), ('matches' == $tab)?true:false);
echo $this->SetTabHeader('templates',$this->Lang('templates'), ('templates' == $tab)?true:false);
echo $this->EndTabHeaders();

# The content of the tabs
echo $this->StartTabContent();
if ($this->CheckPermission('Use TeamSportScores'))
{
	// --- Start tab Matches ---
	echo $this->StartTab('matches', $params);

	$newhometeam = '';
	$newvisitorteam = '';
	$newfuture = false; // If true only future (non played games) are showed
	$sortby = '';
	/*
	if (isset($params['submitfilter']))
	{
		if (isset($params['newhometeam']))
	  	{
	  	 	 $newhometeam = $params['newhometeam'];
	  	}
		if (isset($params['sortby']))
		{
		 	 $sortby = $params['sortby'];
		}
	}
	*/

	// Prepare the basic statement
	$query = "SELECT * FROM ".cms_db_prefix()."module_tss_gameschedule_score";
	$dbresult = $db->Execute($query);

	$rowclass = 'row1';

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['gss_id'];
		$onerow->hometeam = $this->CreateLink($id, 'editmatch', $returnid, $row['hometeam'], array('gss_id'=>$row['gss_id']));
		$onerow->visitorteam = $this->CreateLink($id, 'editmatch', $returnid, $row['visitorteam'], array('gss_id'=>$row['gss_id']));
		$onerow->matchdate = $row['date'];
		
		if ($row['hometeam_score'] != NULL) {
			$onerow->match_score = $row['hometeam_score'].' - '.$row['visitorteam_score'];
		}
		else {
			$onerow->match_score = $this->Lang('noscoreavailable');
		}
		/* Show the icons needed for editing, deleting */
		$onerow->editlink = $this->CreateLink($id, 'editmatch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('gss_id'=>$row['gss_id']));
		$onerow->deletelink = $this->CreateLink($id, 'deletematch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('gss_id'=>$row['gss_id']), $this->Lang('areyousurematch'));

		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}

	$this->smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin'));

	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

	#Setup links
	$this->smarty->assign('addmatchlink', $this->CreateLink($id, 'addmatch', $returnid, $this->Lang('addmatch'), array(), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addmatchlink', $this->CreateLink($id, 'addmatch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addjobschedule'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addmatch', $returnid, $this->Lang('addmatch'), array(), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('titlehometeam', $this->Lang('title_hometeam'));
	$this->smarty->assign('titlevisitorteam', $this->Lang('title_visitorteam'));
	$this->smarty->assign('titlematchdate', $this->Lang('title_matchdate'));
	$this->smarty->assign('titlescore', $this->Lang('title_score'));

	$this->smarty->assign('formend', $this->CreateFormEnd());
	#Display template
	echo $this->ProcessTemplate('listmatches.tpl');

	echo $this->EndTab();
	#--- End tab Matches ---
  
	// --- Start tab Templates ---
	echo $this->StartTab('templates', $params);
	
	$this->smarty->assign('startform', $this->CreateFormStart ($id, 'save_admin_templates', $returnid));
	$this->smarty->assign('title_summary_template',$this->Lang('title_summary_template'));
	$this->smarty->assign('input_summary_template', $this->CreateTextArea(false,
	  $id, $this->GetTemplate('summary_template', 'TeamSportScores'),
	  'input_summary_template', '','','','',80,25));
	$this->smarty->assign('submittemplates', $this->CreateInputSubmit($id, 'submittemplates', $this->Lang('title_save_templates')));
	$this->smarty->assign('endform', $this->CreateFormEnd ());

	// Display the Admin templates
	echo $this->ProcessTemplate ('admintemplates.tpl');
	echo $this->EndTab();
	#--- End tab Templates ---

  
}
echo $this->EndTabContent();

?>