﻿<?php

if (!isset($gCms)) exit;
if(! $this->CheckPermission( 'Use TruetypeText' ) ) exit;

include_once dirname(__FILE__).'/class.style.php';
include_once dirname(__FILE__).'/class.replacements.php';


// scan font files ***********************************************
$fontfiles = $this->getFonts();

// load styles ***************************************************
$TTTsl = new TTTstylelist();

$sampletext = '';

// load automatic replacements ************************************
$TTTrl = new TTTreplacementlist();







//******************                   Display interface                       *********************************************
$active = (isset($params['active_tab']) ? $params['active_tab'] : '');


// check if ttf support is included. If not, access is forbidden ***************************
if (!function_exists('imagettfbbox') || !function_exists('imagettftext'))
{
	echo $this->ShowErrors($this->Lang('error_nottffunctions'));
	return;
}

// check if fontfiles are available. *****************************
if (count($fontfiles)==0)
{
	echo $this->ShowErrors($this->Lang('error_nofontfile'));
	$active = 'fonts';
}

echo $this->StartTabHeaders();
echo $this->SetTabHeader('styles',$this->Lang('Styles'), ($active=='styles'));
echo $this->SetTabHeader('autoreplace',$this->Lang('Autoreplace'), ($active=='autoreplace'));
echo $this->SetTabHeader('fonts',$this->Lang('Fonts'), ($active=='fonts'));
echo $this->SetTabHeader('properties',$this->Lang('Properties'), ($active=='properties'));
echo $this->EndTabHeaders();
echo $this->StartTabContent();

# "Styles" tab ***********************************
echo $this->StartTab("styles");

$items = array();
$rowclass = 'row1';
foreach ($TTTsl->styles as $style)
{
	$row = new stdClass();
	$row->rowclass = $rowclass;
	$row->name = $style->name;
	$row->calltag = '{cms_module module="TruetypeText" style="'.$style->name.'" text="<em>mytext</em>"}';
	$row->img = $style->getimage($style->name);
	$row->sample = $this->getHTMLimg($style, $row->name);
	$row->editlink = $this->CreateLink($id, 'editstyle', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('editstyle'),'','','systemicon'), array('styleid' => $style->id));
	$row->copylink = $this->CreateLink($id, 'copystyle', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/copy.gif', $this->Lang('copystyle'),'','','systemicon'), array('styleid' => $style->id));
	$row->deletelink = $this->CreateLink($id, 'deletestyle', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('deletestyle'),'','','systemicon'), array('styleid' => $style->id), $this->Lang('areyousure'));
	array_push($items, $row);
	$rowclass = ($rowclass=="row1" ? "row2" : "row1");
}

$this->smarty->assign_by_ref('items', $items);
$this->smarty->assign('itemcount', count($items));
$this->smarty->assign('stylenametext', $this->Lang('stylename'));
$this->smarty->assign('styleimgtext', $this->Lang('example'));
$this->smarty->assign('calltagtext', $this->Lang('tagtouse'));
$this->smarty->assign('nofilestext', $this->Lang('nostyles'));
if (count($fontfiles)>0)
	$this->smarty->assign('addlink', $this->CreateLink($id, 'addstyle', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addstyle'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addstyle', $returnid, $this->Lang('addstyle'), array(), '', false, false, 'class="pageoptions"'));
else
	echo $this->showerrors($this->lang('error_nofontfile'));
echo $this->ProcessTemplate('styleslist.tpl');

if (count($fontfiles)>0)
{
	echo $this->CreateFieldsetStart($id,'fieldset', $this->lang('predefinedstyles'));
	echo $this->CreateLink($id, 'addpredefinedstyle', $returnid, $this->Lang('addpredefinedmirror'), array('predefinedstyle'=>'mirror'));
	echo '<br />'.$this->CreateLink($id, 'addpredefinedstyle', $returnid, $this->Lang('addpredefinedshadow'), array('predefinedstyle'=>'shadow'));
	echo '<br />'.$this->CreateLink($id, 'addpredefinedstyle', $returnid, $this->Lang('addpredefinedghost'), array('predefinedstyle'=>'ghost'));
	echo '<br />'.$this->CreateLink($id, 'addpredefinedstyle', $returnid, $this->Lang('addpredefineddouble'), array('predefinedstyle'=>'double'));
	echo $this->CreateFieldsetEnd();
}


echo $this->EndTab();

# "autoreplace" tab ***********************************
echo $this->StartTab("autoreplace");


$replacefunctions = array('ContentPostRender'=>'ContentPostRender', 'ContentPostCompile'=>'ContentPostCompile', $this->lang("replacementdisabled")=>"");
$this->smarty->assign('replacefunctiontext', $this->Lang('replacefunction'));
$this->smarty->assign('replacefunctioninput',$this->CreateInputDropdown($id, 'replacefunction', $replacefunctions, -1, $this->getpreference('replacefunction', '')));
$this->smarty->assign('save', $this->CreateInputSubmit($id,'save', $this->Lang('save')));

echo $this->CreateFieldsetStart($id,'fieldset', $this->lang('replacemoment'));
echo $this->CreateFormStart($id,'changereplacefunction',$returnid);
echo $this->ProcessTemplate('replaceparams.tpl');
echo $this->CreateFormEnd();
echo $this->CreateFieldsetEnd();




$items = array();
$rowclass = 'row1';
foreach ($TTTrl->replacements as $replacement)
{
	$row = new stdClass();
	$row->rowclass = $rowclass;
	$row->tag = $replacement->tag;
	$row->additional = $replacement->additional;
	$style = & $TTTsl->getstyle($replacement->style);
	if (!$style) $row->style = $this->Lang('unknownstyle');
	else $row->style = $style->name;
	$row->editlink = $this->CreateLink($id, 'editreplacement', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('editreplacement'),'','','systemicon'), array('replacementid' => $replacement->id));
	$row->deletelink = $this->CreateLink($id, 'deletereplacement', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('deletereplacement'),'','','systemicon'), array('replacementid' => $replacement->id), $this->Lang('areyousure'));
	array_push($items, $row);
	$rowclass = ($rowclass=="row1" ? "row2" : "row1");
}

$this->smarty->assign_by_ref('items', $items);
$this->smarty->assign('itemcount', count($items));
$this->smarty->assign('replacementtagtext', $this->Lang('tag'));
$this->smarty->assign('replacementadditionaltext', $this->Lang('additional'));
$this->smarty->assign('replacementstyletext', $this->Lang('style'));
$this->smarty->assign('noreplacementtext', $this->Lang('noreplacements'));
if (count($TTTsl->styles)>0)
	$this->smarty->assign('addlink', $this->CreateLink($id, 'addreplacement', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addreplacement'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addreplacement', $returnid, $this->Lang('addreplacement'), array(), '', false, false, 'class="pageoptions"'));
else
	echo $this->showerrors($this->lang('error_nostyle'));

echo $this->ProcessTemplate('replacementslist.tpl');
	
echo $this->EndTab();







# "fonts" tab ***********************************
echo $this->StartTab("fonts");

$items = array();
$rowclass = 'row1';
foreach ($fontfiles as $file)
{
	$row = new stdClass();
	$row->rowclass = $rowclass;
	$row->filename = $file;
	
	$TTTstyle = new TTTstyle();
	$TTTstyle->loadelements('text;'.$file.';20;#000000;0;0;0');
	$row->img = $TTTstyle->getimage($file);
	
	
	$row->styles = '';
	foreach ($TTTsl->getstylesbyfont($file) as $style)
		$row->styles .= ($row->styles != '' ? ', ' : '').$style->name;
	if ($row->styles == '')
	{
		$row->styles = '<em>'.$this->lang('notused').'</em>';
		$row->deletelink = $this->CreateLink($id, 'deletefont', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('deletefont'),'','','systemicon'), array('fontfile' => $file), $this->Lang('areyousure'));
	}
	array_push($items, $row);
}
$this->smarty->assign_by_ref('items', $items);
$this->smarty->assign('itemcount', count($items));
$this->smarty->assign('filenametext', $this->Lang('fontfiles'));
$this->smarty->assign('stylestext', $this->Lang('usedinstyles'));
$this->smarty->assign('nofilestext', $this->Lang('nofontfiles'));
echo $this->ProcessTemplate('fontfileslist.tpl');

$this->smarty->assign('startform', $this->CreateFormStart($id,'importfont',$returnid,'post', 'multipart/form-data'));
$this->smarty->assign('prompt_browse', $this->Lang('upload'));
$this->smarty->assign('input_browse', $this->CreateFileUploadInput($id,'input_browse'));
$this->smarty->assign('submit', $this->CreateInputSubmit($id,'submit', $this->Lang('import')));
$this->smarty->assign('endform', $this->CreateFormEnd());
echo $this->ProcessTemplate('import.tpl');
echo $this->EndTab();

# "properties" tab ***********************************
echo $this->StartTab("properties");

$this->smarty->assign('sampletexttext', $this->Lang('sampletext'));
$this->smarty->assign('sampletextinput',$this->CreateInputText($id, 'sampletext', $this->getpreference('sampletext', 'Hello, how are you ?'),50,50));
$this->smarty->assign('save', $this->CreateInputSubmit($id,'save', $this->Lang('save')));

echo $this->CreateFormStart($id,'changesampletext',$returnid);
echo $this->ProcessTemplate('sampletext.tpl');
echo $this->CreateFormEnd();




$files = get_recursive_file_list(cms_join_path(dirname(__FILE__), 'cache'), array('index.html'), -1, "FILES");
$size = 0;

foreach ($files as $file) $size += filesize($file);

if ($size >(1024*1024)) {$size = number_format($filesize/(1024*1024))." MB";} else {
	if ($size >(1024))  {$size = number_format($size/1024)." KB";} else {
		$size = number_format($size)." B";
	}
}

echo $this->lang('filenumberandsize', array(count($files), $size)).'<br />';

echo $this->CreateLink($id, 'clearcache', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('clearcache'),'','','systemicon')).$this->CreateLink($id, 'clearcache', $returnid, $this->Lang('clearcache'));

echo $this->EndTab();

echo $this->EndTabContent();


?>
