﻿<?php

if (!isset($gCms)) exit;
if(! $this->CheckPermission( 'Use TruetypeText' ) ) exit;

if (isset($params['back']) || !isset($params['styleid']))
	$this->Redirect($id, 'defaultadmin', $returnid);


include_once cms_join_path(dirname(__FILE__),'class.style.php');

$styleid = (isset($params['styleid']) ? $params['styleid'] : false);
$name = (isset($params['name']) ? $params['name'] : false);
$backgroundcolor = (isset($params['backgroundcolor']) ? strtoupper($params['backgroundcolor']) : false);
$format = (isset($params['format']) ? $params['format'] : false);
$fulllineheight = isset($params['fulllineheight']);
$maxwidth = (isset($params['maxwidth']) ? $params['maxwidth'] : '');
$pictureperword = isset($params['pictureperword']);
$transparent = isset($params['transparent']);

echo $styleid.'|'.$name.'|'.$backgroundcolor.'|'.$format.'|'.($fulllineheight?'ok':'nok').'|'.$maxwidth.'|'.($pictureperword?'ok':'nok').'|'.($transparent?'ok':'nok');

$newparams = array('styleid' => $styleid);
$errors = array();

if (!is_numeric($maxwidth) || $maxwidth<0)
	$errors[] = $this->lang('error_maxwidth');

if (preg_match('/^#?([A-F0-9]{6}|[A-F0-9]{8})$/i', $backgroundcolor)==0)
	$errors[] = $this->lang('error_colorformat');

$TTTsl = new TTTstylelist();
if ($name == '')
	$errors[] = $this->lang('error_emptyname');
elseif (is_numeric($name))
	$errors[] = $this->lang('error_nameisnumeric');
else
{
	$otherstyle = $TTTsl->getstyle($name);
	if ($otherstyle && $otherstyle->id != $styleid)
		$errors[] = $this->lang('error_namealreadyexists');
}

if (count($errors)>0)
	$newparams['module_error'] = implode('<br />', $errors);
else
{
	$TTTstyle = & $TTTsl->getstyle($styleid);
	$TTTstyle->name = $name;
	$TTTstyle->backgroundcolor = $backgroundcolor;
	$TTTstyle->format = $format;
	$TTTstyle->fulllineheight = $fulllineheight;
	$TTTstyle->maxwidth = $maxwidth;
	$TTTstyle->pictureperword = $pictureperword;
	$TTTstyle->transparent = $transparent;
	
	if ($TTTstyle->updateDb())
		$newparams['module_message'] = $this->lang('stylesaved');
	else
		$newparams['module_error'] = $this->lang('error_unabletosavestyle');
}

$this->Redirect($id, 'editstyle', $returnid, $newparams);



?>