<?php
if (!isset($gCms)) exit;

	/*---------------------------------------------------------
	   Install()
	   When your module is installed, you may need to do some
	   setup. Typical things that happen here are the creation
	   and prepopulation of database tables, database sequences,
	   permissions, preferences, etc.
	   	   
	   For information on the creation of database tables,
	   check out the ADODB Data Dictionary page at
	   http://phplens.com/lens/adodb/docs-datadict.htm
	   
	   This function can return a string in case of any error,
	   and CMS will not consider the module installed.
	   Successful installs should return FALSE or nothing at all.
	  ---------------------------------------------------------*/
		
		// get a reference to the database
		$db = $this->cms->db;
		
		// mysql-specific, ignored by other databases
		// sets up options for the table
		$table_options = array('mysql' => 'TYPE=MyISAM');
		
		// create table to store feed information
		$table = NewDataDictionary($db);
		
			// add some fields to the table...
			$table_fields = "id I KEY,
							 feed_name C(100),
							 feed_url C(2000)";
							 
			// add the table "module_rss2html_feeds"
			$sqlarray = $table->CreateTableSQL(cms_db_prefix() . 'module_rss2html_feeds', $table_fields, $table_options);
			$table->ExecuteSQLArray($sqlarray);
			
			// create the sequence table
			$db->CreateSequence(cms_db_prefix() . 'module_rss2html_feeds_seq');
			
		// install a default template
		$this->SetTemplate('Default',
			'<h2>{$rss->channel.title}</h2>
				<p><em>{$rss->channel.link}</em></p>
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
				{foreach from=$rss->items item=item}
					<tr style="background: {cycle values="#CCCCCC, #FFFFFF"}">
						<td><h3 style="margin: 0; display: inline;"><strong><a href="{$item.link}">{$item.title}</a></h3></strong> - <em>{$item.pubdate}</em>
						<p style="margin: 0;">{$item.summary}</p></td>
					</tr>
				{/foreach}
				</table>');
		
			
		// permissions
		$this->CreatePermission('Use RSS2HTML','Use RSS2HTML');

		// put mention into the admin log
		$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));
		
?>