<?php
$lang['friendlyname'] = 'RSS2HTML';
$lang['postinstall'] = 'RSS2HTML Successfully Installed! Set "Use RSS2HTML" permissions to use this module!';
$lang['postuninstall'] = 'RSS2HTML Successfully Installed"';
$lang['really_uninstall'] = 'Really? Are you sure
you want to uninstall RSS2HTML?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'The RSS2HTML module allows you to output an RSS feed as HTML. The output is fully customizable via Smarty templates.';

$lang['error'] = 'Error!';
$land['admin_title'] = 'RSS2HTML Admin Panel';
$lang['admindescription'] = 'RSS2HTML';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['feeds'] = 'Feeds';
$lang['templates'] = 'Templates';
$lang['preferences'] = 'Preferences';
$lang['title_feeds'] = 'Feeds';
$lang['title_templates'] = 'Templates';
$lang['title_preferences'] = 'Preferences';
$lang['feedid'] = 'Feed ID';
$lang['feedname'] = 'Feed Name';
$lang['feedurl'] = 'Feed URL';
$lang['addfeed'] = 'Add a Feed';
$lang['error_nofeedname'] = 'Please provide a name for the RSS feed.';
$lang['error_nofeedurl'] = 'Please provide a URL to the RSS feed.';
$lang['error_invalidfeedurl'] = 'Please provide a VALID URL to the RSS feed.';
$lang['error_addfeed'] = 'There was an unknown error when adding the feed. Please try again';
$lang['feedadded'] = "The feed was successfully added!";
$lang['error_addfeed'] = 'There was an unknown error when editing the feed. Please try again';
$lang['feededited'] = "The feed was successfully edited!";
$lang['areyousure'] = "Are you sure you want to remove this feed?";
$lang['feeddeleted'] = "The feed has successfully been removed.";
$lang['nofeedwiththatid'] = "There is no feed with the provided id. Please check the id and try again.";
$lang['edit'] = "Edit";
$lang['update'] = "Update";
$lang['delete'] = "Remove";
$lang['error_invalidfeed'] = "The feed provided was not in a valid format. Please provide a URL to a valid RSS feed.";
$lang['error_feedexists'] =  "A feed with that name already exists. Please give the feed a unique name";

$lang['addtemplate'] = "Add Template";
$lang['templatenametext'] = "Template Name";
$lang['templatecontenttext'] = "Template Content";
$lang['notemplatebythatname'] = "No template by that name could be found.";
$lang['templateadded'] = "The template was added successfully!";
$lang['error_templatename_req'] = "'Template Name' is a required field.";
$lang['error_templatecontent_req'] = "'Template Content' is a required field.";
$lang['templateexists'] = "A template by that name already exists. Please enter a different name.";
$lang['templateedited'] = "The template was successfully updated!";
$lang['templatedeleted'] = "The template was successfully deleted!";
$lang['areyousuretemplate'] = "Are you sure you want to delete this template?";
$lang['templatehelp'] = '<p>The variable \'rss\' contains all the elements of an RSS feed parsed into a number of arrays.  Below is an example of how to access various parts of the feed (this is by no means a complete list): </p>
<ul>
    <li>The \'channel\' array. <strong>Note that more elements may be available depending on the feed.
        </strong>
        <ul>
            <li>The title of the feed - <em>$rss-&gt;channel.title</em></li>
            <li>The  language of the feed - <em>$rss-&gt;channel.language</em></li>
            <li>The site of where the feed originates - <em>$rss-&gt;channel.link</em></li>
            <li>The description of the feed - <em>$rss-&gt;channel.description</em></li>
            <li>The feed\'s tagline - <em>$rss-&gt;channel.tagline</em></li>
        </ul>
    </li>
	<br />
    <li>The \'items\' array. <strong>Note that more elements may be available depending on the feed.   
        </strong>
        <ul>
            <li>The title of the item - <em>$item.title </em></li>
            <li>The link to the item - <em>$item.link </em></li>
            <li>The description of the item - <em>$item.description </em></li>
            <li>The publish date of the item - <em>$item.pubdate </em></li>
            <li>The GUID of the item - <em>$item.guid </em></li>
            <li>The summary of the item - <em>$item.summary </em></li>
            <li>The date/timestamp of the item -  <em>$item.date_timestamp </em></li>
        </ul>
    </li>
</ul>';

$lang['enabledtext'] = "Cache Enabled";
$lang['agetext'] = "Cache Age";
$lang['agetext2'] = "(in seconds, may use an expression)";
$lang['dirtext'] = "Cache Directory";
$lang['prefsupdated'] = "Preferences updated successfully!";

$lang['changelog'] = '<ul>
<li>Version 0.1 - 13 November 2007. Initial Release.</li>
</ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>The RSS2HTML module allows you to output an RSS feed as HTML. The output is fully customizable via Smarty templates.</p>
<h3>How Do I Use It</h3>
<p>First, go to Content->RSS2HTML and create a feed. The feed\'s name must be unique and the feed url must be a valid RSS feed.</p>
<p>To display a feed based on the default template (included), put the following code in your page:</p>
<p style="font-family: Courier New; font-size: 8pt;">{cms_module name="RSS2HTML" feed="[feed name]"}</p>
<p>If you\'d like to use a different template that you have defined, use the following:</p>
<p style="font-family: Courier New; font-size: 8pt;">{cms_module name="RSS2HTML" feed="[feed name]" template="[template name]"}</p>
<h3>What Parameters Does It Take</h3>
<ul>
	<li>(required) feed="[feed name]" - the name given to the feed</li>
	<li>(optional) template="[template name]" - the name of the template to use</li>
	<li>(optional) numitems=<em>x</em> where <em>x</em> is the number of items to display from the feed
</ul>' . $lang['templatehelp'] . '
<h3>Support</h3>
<p>As per the GPL, this software is provided as-is. Please read the text of the license for the full disclaimer.</p>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2007, James Dixon <a href="mailto:jim.w.dixon@gmail.com">&lt;jim.w.dixon@gmail.com&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>';
?>
