<?php
	if (!isset($gCms)) exit;
	
	// make sure the user has permission
	if (!$this->CheckPermission('Modify RSS2HTML'))
	{
		echo $this->ShowErrors($this->Lang('needpermission', array('Modify RSS2HTML')));
		return;
	}

	// if the user cancelled, return them to the default admin screen
	if (isset($params['cancel']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'templates'));
	}
	
	// give the form id to smarty
	$smarty->assign('formid', $id);

	// initialize
	$templatename = (isset($params['templatename']) ? $params['templatename'] : '');
	$templatecontent = (isset($params['templatecontent']) ? $params['templatecontent'] : '');
	
	
	// check to see if the form has posted
	if (strtolower($_SERVER['REQUEST_METHOD']) == 'post')
	{		
		if ($templatecontent == '')
			echo $this->ShowErrors($this->Lang('error_templatecontent_req'));
		
		if ($templatename != '' && $templatecontent != '')
		{
			$template = $this->GetTemplate($templatename, $this->GetName());

			$this->SetTemplate($templatename, $templatecontent);
			
			$params = array('tab_message'=> 'templateedited', 'active_tab' => 'templates');
			$this->Redirect($id, 'defaultadmin', $returnid, $params);
		}
	}
	else if ($templatename != '')
	{
		$template = $this->GetTemplate($templatename, $this->GetName());

		if (!empty($template))
		{	
			$templatecontent = $template;
		}
	}
	else
	{
		$this->ShowErrors($this->Lang('notemplatebythatname'));
	}
	
	// setup template
	$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'templatename', $templatename));
	$this->smarty->assign('startform', $this->CreateFormStart($id, 'edittemplate', $returnid));
	$this->smarty->assign('endform', $this->CreateFormEnd());
	$this->smarty->assign('templatenametext', $this->Lang('templatenametext'));
	$this->smarty->assign('inputtemplatename', $this->CreateInputText($id, 'templatename', $templatename, 30, 100, 'disabled="disabled"'));
	$this->smarty->assign('templatecontenttext', $this->Lang('templatecontenttext'));
	$this->smarty->assign('inputtemplatecontent', $this->CreateTextArea(false, $id, $templatecontent, 'templatecontent', '', '', '', '', '80', '20', '', 'html'));
	$this->smarty->assign('templatehelp', $this->Lang('templatehelp'));
	$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'update', $this->Lang('update')));
	$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
	
	echo $this->ProcessTemplate('edittemplate.tpl');
?>