<?php
	if (!isset($gCms)) exit;
	
	// make sure the user has permission
	if (!$this->CheckPermission('Modify RSS2HTML'))
	{
		echo $this->ShowErrors($this->Lang('needpermission', array('Modify RSS2HTML')));
		return;
	}

	// if the user cancelled, return them to the default admin screen
	if (isset($params['cancel']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid);
	}
	
	// initialize
	$cacheenabled = NULL;
	$cacheage = $this->GetPreference('CACHE_AGE', '60*60');
	$cachedir = $this->GetPreference('CACHE_DIR', './modules/RSS2HTML/cache');
	
	// give the form id to smarty
	$smarty->assign('formid', $id);
	
	if (isset($params['action']) && $params['action'] == 'editprefs')
	{
		if (isset($params['cacheenabled']))
		{
			$cacheenabled = $params['cacheenabled'] ? "true" : "false";
		}
		
		if (isset($params['cacheage']))
		{
			$cacheage = $params['cacheage'];
		}
		
		if (isset($params['cachedir']))
		{
			$cachedir = $params['cachedir'];
		}
		
		// update preferences
		$this->SetPreference('CACHING_ENABLED', $cacheenabled);
		$this->SetPreference('CACHE_AGE', $cacheage);
		$this->SetPreference('CACHE_DIR', $cachedir);
		
		// redirect
		$params = array('tab_message'=> 'prefsupdated', 'active_tab' => 'preferences');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}

?>