<?php
	if (!isset($gCms)) exit;
	
	// make sure the user has permission
	if (!$this->CheckPermission('Modify RSS2HTML'))
	{
		echo $this->ShowErrors($this->Lang('needpermission', array('Modify RSS2HTML')));
		return;
	}

	// if the user cancelled, return them to the default admin screen
	if (isset($params['cancel']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid);
	}
	
	// give the form id to smarty
	$smarty->assign('formid', $id);
	
	// initialize
	$feedid = NULL;
	$feedname = '';
	$feedurl = '';
		
	// check to see if the form has posted
	if (strtolower($_SERVER['REQUEST_METHOD']) == 'post')
	{
		$errors = false;
		
		if (isset($params['feedid']) && is_numeric($params['feedid']))
		{
			$feedid = $params['feedid'];
		}
		
		if (isset($params['feedname']) && $params['feedname'] != '')
		{
			$feedname = $params['feedname'];
		}
		else
		{
			echo $this->ShowErrors($this->Lang('error_nofeedname'));
			$errors = true;
		}
		
		if (isset($params['feedurl']) && $params['feedurl'] != '')
		{
			$feedurl = $params['feedurl'];
			
			// regex to check for a syntactically-correct url
			if (!preg_match('/^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i', $feedurl))
			{
				echo $this->ShowErrors($this->Lang('error_invalidfeedurl'));
				$errors = true;
			}
		}
		else
		{
			echo $this->ShowErrors($this->Lang('error_nofeedurl'));
			$errors = true;
		}
		
		// if there were no errors, proceed to add/edit the feed
		if (!$errors)
		{
			if ($params['action'] == 'editfeed')
			{
				$query = 'UPDATE '.cms_db_prefix().'module_rss2html_feeds SET feed_name = ?, feed_url = ? WHERE id = ?';
				$result = $db->Execute($query, array($feedname, $feedurl, $feedid));
				
				if (!$result)
				{
					echo $this->ShowErrors($this->Lang('error_editfeed') . "<br />" . $db->ErrorMsg());
				}
				else
				{				
					$options = array('tab_message'=> 'feededited', 'active_tab' => 'feeds');
					$this->Redirect($id, 'defaultadmin', $returnid, $options);
				}
			}
		}
	}
	else
	{
		if (isset($params['feedid']) && is_numeric($params['feedid']))
		{	
			$feedid = $params['feedid'];
			$query = 'SELECT * FROM ' . cms_db_prefix() . 'module_rss2html_feeds WHERE id = ? LIMIT 1';
			$result = $db->GetRow($query, array($feedid));
			
			if ($result)
			{
				$feedname = $result['feed_name'];
				$feedurl = $result['feed_url'];
			}
			else
			{
				echo $this->ShowErrors($this->Lang('nofeedwiththatid'));
			}
		}
		else
		{
			$this->Redirect($id, 'defaultadmin', $returnid, array());
		}
	}
	
	// setup template
	$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'feedid', $feedid));
	$this->smarty->assign('startform', $this->CreateFormStart($id, 'editfeed', $returnid));
	$this->smarty->assign('endform', $this->CreateFormEnd());
	$this->smarty->assign('feednametext', $this->Lang('feedname'));
	$this->smarty->assign('inputfeedname', $this->CreateInputText($id, 'feedname', $feedname, 30, 100));
	$this->smarty->assign('feedurltext', $this->Lang('feedurl'));
	$this->smarty->assign('inputfeedurl', $this->CreateInputText($id, 'feedurl', $feedurl, 30, 2000));
	$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
	$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
	
	echo $this->ProcessTemplate('editfeed.tpl');
?>