<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for RSS2HTML "default" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// we need to grab the magpie library in order to make sure the user is adding a valid feed
require_once(dirname(__FILE__) . '/lib/magpierss/rss_fetch.inc');

// setup prefs - these functions must be called before fetch_rss
init($this->GetPreference('CACHING_ENABLED', 'true'), 
	 $this->GetPreference('CACHE_DIR', './modules/RSS2HTML/cache'),
	 $this->GetPreference('CACHE_AGE', '60*60'));


$template = "Default";

// check to see if the user passed a template
if (isset($params['template']))
{
	$template = $params['template'];
}

// see if a feed name was passed, if not, notify the user and do nothing
if (isset($params['feed']))
{
	$feed = $params['feed'];
}
else
{
	echo "RSS2HTML: No feed specified";
	return;
}

$numitems = 0;		// unlimited

if (isset($params['numitems']) && is_numeric($params['numitems']))
{
	$numitems = $params['numitems'];
}

// grab the feed information
$query = "SELECT feed_url FROM " . cms_db_prefix() . "module_rss2html_feeds WHERE feed_name = ? LIMIT 1";
$result = $db->GetRow($query, array($feed));

// attempt to parse the feed
if ($result)
{
	$rss = fetch_rss($result['feed_url']);

	if ($rss)
	{
		if ($numitems > 0)
		{
			$items = array_slice($rss->items, 0, $numitems);
			$rss->items = $items;
		}
		else
		{
			$items = $rss->items;
		}
		
		$smarty->assign("rss", $rss);
		$rss->items = $items;
	}
	else
	{
		$smarty->assign("feedtitle","Problem with: $url");
	}
}

echo $this->ProcessTemplateFromDatabase($template);

?>