<?php
	error_reporting(E_ERROR);

	if (!isset($gCms)) exit;
	
	// make sure the user has permission
	if (!$this->CheckPermission('Modify RSS2HTML'))
	{
		echo $this->ShowErrors($this->Lang('needpermission', array('Modify RSS2HTML')));
		return;
	}

	// if the user cancelled, return them to the default admin screen
	if (isset($params['cancel']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid);
	}
	
	// perform the action
	
	// give the form id to smarty
	$smarty->assign('formid', $id);

	$feedid = NULL;
	$feedname = '';
	$feedurl = '';

	// check to see if the form has posted
	if (strtolower($_SERVER['REQUEST_METHOD']) == 'post')
	{
		// we need to grab the magpie library in order to make sure the user is adding a valid feed
		require_once(dirname(__FILE__) . '/lib/magpierss/rss_fetch.inc');
		
		$errors = false;
		
		if (isset($params['feedid']) && is_numeric($params['feedid']))
		{
			$feedid = $params['feedid'];
		}
		
		if (isset($params['feedname']) && $params['feedname'] != '')
		{
			$feedname = $params['feedname'];
		}
		else
		{
			echo $this->ShowErrors($this->Lang('error_nofeedname'));
			$errors = true;
		}
		
		if (isset($params['feedurl']) && $params['feedurl'] != '')
		{
			$feedurl = $params['feedurl'];
			
			// regex to check for a syntactically-correct url
			if (!preg_match('/^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i', $feedurl))
			{
				echo $this->ShowErrors($this->Lang('error_invalidfeedurl'));
				$errors = true;
			}
			// if the url was valid, check to make sure the url points to a valid RSS feed
			else
			{
				$rss = fetch_rss($feedurl);
				
				if (!$rss)
				{
					echo $this->ShowErrors($this->Lang('error_invalidfeed'));
					$errors = true;
				}
			}
		}
		else
		{
			echo $this->ShowErrors($this->Lang('error_nofeedurl'));
			$errors = true;
		}
		
		// if there were no errors, proceed to add/edit the feed
		if (!$errors)
		{
			if ($params['action'] == 'addfeed')
			{
				$query = "SELECT id FROM " . cms_db_prefix() . "module_rss2html_feeds WHERE feed_name = ? LIMIT 1";
				$result = $db->GetRow($query, array($feedname));
				
				if (!$result)
				{
					$feedid = $db->GenID(cms_db_prefix()."module_rss2html_feeds_seq");
					$query = 'INSERT INTO '.cms_db_prefix().'module_rss2html_feeds (id, feed_name, feed_url) VALUES (?,?,?)';
					$result = $db->Execute($query, array($feedid, $feedname, $feedurl));
					
					if (!$result)
					{
						echo $this->ShowErrors($this->Lang('error_addfeed') . "<br />" . $db->ErrorMsg());
					}
					else
					{				
						$params = array('tab_message'=> 'feedadded', 'active_tab' => 'feeds');
						$this->Redirect($id, 'defaultadmin', $returnid, $params);
					}
				}
				else
				{
					echo $this->ShowErrors($this->Lang('error_feedexists'));
				}
			}
		}
	}
	
	// setup template
	$this->smarty->assign('hidden', '');
	$this->smarty->assign('startform', $this->CreateFormStart($id, 'addfeed', $returnid));
	$this->smarty->assign('endform', $this->CreateFormEnd());
	$this->smarty->assign('feednametext', $this->Lang('feedname'));
	$this->smarty->assign('inputfeedname', $this->CreateInputText($id, 'feedname', $feedname, 30, 100));
	$this->smarty->assign('feedurltext', $this->Lang('feedurl'));
	$this->smarty->assign('inputfeedurl', $this->CreateInputText($id, 'feedurl', $feedurl, 30, 2000));
	$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
	$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
	
	echo $this->ProcessTemplate('editfeed.tpl');
?>