<?php
#---------------------------------------------------------------------------------------------------
# Module: Allinoneaccessibility
# Author: Skynet Technologies USA LLC
# Copyright: (C) 2023 Skynet Technologies USA LLC, hello@skynettechnologies.com
# Licence: GNU General Public License version 3
#          see /Allinoneaccessibility/lang/LICENCE.txt or <http://www.gnu.org/licenses/gpl-3.0.html>
#---------------------------------------------------------------------------------------------------

if( !defined('CMS_VERSION') ) exit;

if( !$this->CheckPermission(Allinoneaccessibility::MANAGE_PERM) ) return;

// Get hostname from config
$aioa_website_hostname = parse_url($config['root_url'], PHP_URL_HOST);

// Prepare data object for Smarty template
$dataObj = [
    'aioa_website_hostname' => $aioa_website_hostname,
    'username' => null, // optional placeholder if template expects it
    'email' => null,    // optional placeholder if template expects it
    'settinglink' => null,
    'status' => null,
    'manage_domain' => null
];

// Convert to object and assign to Smarty template
$data = (object) $dataObj;
$tpl = $smarty->CreateTemplate($this->GetTemplateResource('defaultadmin.tpl'), null, null, $smarty);
$tpl->assign('data', $data);
$tpl->display();
