<?php
#---------------------------------------------------------------------------------------------------
# Module: Allinoneaccessibility
# Author: Skynet Technologies USA LLC
# Copyright: (C) 2023 Skynet Technologies USA LLC, hello@skynettechnologies.com
# Module's homepage is: http://dev.cmsmadesimple.org/projects/allinoneaccessibility
# Licence: GNU General Public License version 3
#          see /Allinoneaccessibility/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2019 by CMS Made Simple Foundation (copyright@cmsmadesimple.org)
# Project's homepage is: http://www.cmsmadesimple.org
#---------------------------------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify it under the terms of the
# GNU General Public License as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#---------------------------------------------------------------------------------------------------

class Allinoneaccessibility extends CMSModule
{
    const MANAGE_PERM = 'manage_allinoneaccessibility';

    public function GetVersion() {
        return '1.0.8';
    }

    public function GetFriendlyName() {
        return $this->Lang('friendlyname');
    }

    public function GetAdminDescription() {
        return $this->Lang('admindescription');
    }

    public function IsPluginModule() {
        return TRUE;
    }

    public function HasAdmin() {
        return TRUE;
    }

    public function VisibleToAdminUser() {
        return $this->CheckPermission(self::MANAGE_PERM);
    }

    public function GetAuthor() {
        return 'Skynet Technologies USA LLC';
    }

    public function GetAuthorEmail() {
        return 'hello@skynettechnologies.com ';
    }

    public function UninstallPreMessage() {
        return $this->Lang('ask_uninstall');
    }

    public function InitializeFrontend() {
        $this->RegisterModulePlugin();
        $this->AddCSS($this->GetModuleURLPath() . '/css/allinoneaccessibility.css');
        $this->AddHeaderJS($this->GetModuleURLPath() . '/js/allinoneaccessibility.js');
        \CMSMS\HookManager::add_hook('Core::ContentPostCompile', [$this,'PostRenderHook']);
    }

    public function GetAdminHeaderHTML() {
        $admin_css = $this->GetModuleURLPath() . '/css/allinoneaccessibility.css'; // Example CSS for admin
        // Add the CSS to the admin page header
        $this->AddCSS($admin_css);
        // Optionally, you can return custom HTML (like a <script> tag) in the admin header if necessary
        return parent::GetAdminHeaderHTML(); // Always call the parent to ensure other hooks are processed
    }

    public function AdminDefault($params) {
       $smarty->assign('module_url', $this->GetModuleURLPath());
       return parent::AdminDefault();
    }

    public function PostRenderHook($params)
    {
        $domain = $_SERVER['HTTP_HOST'] ?? '';
        $domainBase64 = base64_encode($domain);
        /* Widget defaults */
        $color   = '#420083';
        $token   = '';
        $position = 'bottom_right';
        $icon_type  = 'aioa-icon-type-1';
        $icon_size  = 'aioa-medium-icon';

        /* Call API */
        $apiUrl = 'https://ada.skynettechnologies.us/api/add-user-domain';
        $ch = curl_init($apiUrl);

        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode([
                'website' => $domainBase64
            ]),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json'
            ],
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_TIMEOUT => 10,
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        $apiResponse = json_decode($response, true);
        /* 0 = EU | 1 = NON-EU */
        $noRequiredEu = $apiResponse['website_data']['no_required_eu'] ?? 1;
        /* Decide widget URL */
        if ($noRequiredEu == 0) {
            // EU
            $src = 'https://eu.skynettechnologies.com/accessibility/js/all-in-one-accessibility-js-widget-minify.js'
                . '?aioa_reg_req=true'
                . '&colorcode=' . urlencode($color)
                . '&token=' . urlencode($token)
                . '&position=' . urlencode($position);
        } else {
            // NON-EU
            $src = 'https://www.skynettechnologies.com/accessibility/js/all-in-one-accessibility-js-widget-minify.js'
                . '?aioa_reg_req=true'
                . '&colorcode=' . urlencode($color)
                . '&token=' . urlencode($token)
                . '&position=' . urlencode($position);
        }
        /* Append script (do NOT overwrite page content) */
        $params['content'] .= "<!-- AIOA EU CHECK: no_required_eu={$noRequiredEu} -->";
        $params['content'] .= '<script id="aioa-adawidget" src="' . $src . '" defer></script>';
        return $params;
    }
}
