<?php
$lang['friendlyname'] = 'Master3395s Disqus';
$lang['postinstall'] = 'Melding etter installasjon: Husk å sette "Bruk MAS_Disqus"-tillatelser for å bruke denne modulen!';
$lang['postuninstall'] = 'Melding etter avinstallasjon: "Fy søren! Mislykket igjen!"';
$lang['really_uninstall'] = 'Er du sikker? Vil du virkelig avinstallere denne flotte modulen?';
$lang['uninstalled'] = 'Modul avinstallert.';
$lang['installed'] = 'Modulversjon %s installert.';
$lang['upgraded'] = 'Modulversjon %s oppgradert.';

$lang['prefsupdated'] = 'Modulinnstillinger oppdatert.';
$lang['submit'] = 'Lagre';
$lang['accessdenied'] = 'Tilgang nektet. Vennligst sjekk tillatelsene dine.';
$lang['shortname_null'] = 'parameteren shortname kan ikke være null';
$lang['success'] = 'Lagret med suksess.';

$lang['moddescription'] = 'Forbedret Disqus-integrasjonsmodul med donasjonssystem, forbedret administrasjonsgrensesnitt og uavhengige tillatelser.';
$lang['changelog'] = '<ul>
<li><strong>Versjon 1.1.1, 17.10.2025, Master3395</strong> : Dokumentasjonsforbedringer, forbedret visning av parameterhjelp og fullstendig norsk bokmål oversettelse.
  <ul>
    <li><strong>Forbedret Parameterhjelp:</strong> Oppdaterte individuelle parameterhjelpestrenger for å vises som profesjonelle mini-tabeller som matcher hoveddokumentasjonsformatet</li>
    <li><strong>Forbedret Tabellformatering:</strong> Forbedret Tag-parametere referansetabell med bedre kolonneproporsjoner og visuelt hierarki</li>
    <li><strong>Konsistent Dokumentasjon:</strong> Standardiserte parameterbeskrivelser på tvers av alle hjelpekontekster for bedre brukeropplevelse</li>
    <li><strong>Profesjonelt Utseende:</strong> Parameterhjelp vises nå med riktig tabellstruktur, tydelig typeinformasjon og kravnivåer</li>
    <li><strong>Bedre Lesbarhet:</strong> Forbedret formatering med punktlister, kodeeksempler og strukturerte beskrivelser</li>
    <li><strong>Norsk Bokmål Oversettelse:</strong> Fullstendig profesjonell oversettelse av alle 826 linjer inkludert omfattende 13-seksjoners hjelpedokumentasjon, brukergrensesnittstrenger, endringslogg og parameterhjelp</li>
  </ul>
</li>
<li><strong>Versjon 1.1, 17.10.2025, Master3395</strong> : Stor oppdatering med donasjonssystem og forbedret administrasjonsgrensesnitt.
  <ul>
    <li><strong>Lagt til Donasjonsfane:</strong> PayPal.me-integrasjon for donasjoner med justerbart beløp</li>
    <li><strong>Forbedret Administrasjonsgrensesnitt:</strong> Grensesnitt med faner for Innstillinger, Administrasjonsinnstillinger og Donasjoner</li>
    <li><strong>Forbedret Feilhåndtering:</strong> Inline valideringsfeil i stedet for globale bannermeldinger</li>
    <li><strong>Oppdatering av Tillatelsessystem:</strong> Uavhengig "Bruk MAS_Disqus"-tillatelse (ingen konflikt med den originale Disqus-modulen)</li>
    <li><strong>Administrasjonsinnstillinger:</strong> Mulighet til å vise/skjule donasjonsfane med vedvarende innstillinger</li>
    <li><strong>Sponsorgjenkjenning:</strong> News Targeted-nettstedet oppført som modulens sponsor</li>
    <li><strong>Skjemavalidering:</strong> Riktig validering av Disqus shortname med inline feilmeldinger</li>
    <li><strong>Brukeropplevelse:</strong> Renere grensesnitt med bedre organisering og visuell tilbakemelding</li>
    <li><strong>Moduluavhengighet:</strong> Fullstendig uavhengig fra den originale Disqus-modulen, men opprettholder kompatibilitet</li>
    <li><strong>PHP-kompatibilitet:</strong> Støtter PHP 7.4+ for maksimal levetid og fremtidig kompatibilitet. <strong>Anbefalt: PHP 8.x</strong> for optimal ytelse og sikkerhet.</li>
  </ul>
</li>
<li>Versjon 1.0, august 2019, Master3395 : første utgivelse.</li>
</ul>';
$lang['help'] = '
<div id="mas-disqus-help-documentation">

<h3>1. Moduloversikt</h3>
<p><strong>MAS_Disqus</strong> er en forbedret Disqus-integrasjonsmodul for CMS Made Simple som tilbyr kraftig kommentarfunksjonalitet med avanserte funksjoner og forbedret administrasjon.</p>

<h4>Hovedfunksjoner</h4>
<ul>
    <li><strong>Forbedret Administrasjonsgrensesnitt:</strong> Moderne grensesnitt med faner for enkel konfigurasjon</li>
    <li><strong>Donasjonssystem:</strong> Integrert PayPal.me-støtte for modulsponsing</li>
    <li><strong>Uavhengige Tillatelser:</strong> Fungerer uavhengig av den originale Disqus-modulen</li>
    <li><strong>Forbedret Feilhåndtering:</strong> Inline validering med tydelige feilmeldinger</li>
    <li><strong>Fleksibel Integrasjon:</strong> Fungerer med News, CGBlog og tilpassede innholdstyper</li>
    <li><strong>Kommentartellere:</strong> Vis antall kommentarer på sammendragssider</li>
    <li><strong>PHP 8.x-kompatibel:</strong> Fremtidssikker med moderne PHP-støtte</li>
    <li><strong>SEO-vennlig:</strong> Tilpassbare URLer og titler for optimal synlighet i søkemotorer</li>
</ul>

<h4>Fordeler Over Original Disqus-modul</h4>
<ul>
    <li>Kan kjøre sammen med den originale Disqus-modulen uten konflikter</li>
    <li>Separat tillatelsessystem ("Bruk MAS_Disqus")</li>
    <li>Forbedrede administrative kontroller og innstillinger</li>
    <li>Bedre feilhåndtering og tilbakemelding til brukeren</li>
    <li>Aktiv vedlikehold og oppdateringer</li>
</ul>

<h3>2. Tekniske Krav</h3>

<h4>Minimumskrav</h4>
<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 10px 0;">
    <tr>
        <th style="background-color: #f0f0f0; text-align: left;">Komponent</th>
        <th style="background-color: #f0f0f0; text-align: left;">Minimumsversjon</th>
        <th style="background-color: #f0f0f0; text-align: left;">Anbefalt</th>
    </tr>
    <tr>
        <td>PHP</td>
        <td>7.4.0</td>
        <td>8.0 eller høyere</td>
    </tr>
    <tr>
        <td>CMS Made Simple</td>
        <td>2.2.10</td>
        <td>Siste stabile versjon</td>
    </tr>
    <tr>
        <td>Disqus-konto</td>
        <td>Gratis konto</td>
        <td>Verifisert konto</td>
    </tr>
</table>

<h4>Nødvendige Tillatelser</h4>
<p>Brukere trenger <strong>"Bruk MAS_Disqus"</strong>-tillatelsen for å få tilgang til modulens administrasjonsgrensesnitt. Dette kan konfigureres i:</p>
<p><code>Utvidelser &gt; Brukere &amp; Grupper &gt; Grupper &gt; [Din Gruppe] &gt; Tillatelser</code></p>

<h4>Serverkrav</h4>
<ul>
    <li>JavaScript må være aktivert i besøkendes nettlesere</li>
    <li>Utgående HTTPS-tilkoblinger til Disqus-servere</li>
    <li>Ingen spesielle PHP-utvidelser kreves</li>
</ul>

<h3>3. Installasjons- og Oppsettsveiledning</h3>

<h4>Steg 1: Installer Modulen</h4>
<ol>
    <li>Last ned MAS_Disqus-modulpakken</li>
    <li>Naviger til <code>Utvidelser &gt; Moduler</code> i din CMSMS-administrasjon</li>
    <li>Klikk "Tilgjengelige Moduler" eller last opp modulpakken</li>
    <li>Finn MAS_Disqus og klikk "Installer"</li>
    <li>Vent på bekreftelsesmelding</li>
</ol>

<h4>Steg 2: Opprett Din Disqus-konto</h4>
<ol>
    <li>Besøk <a href="https://disqus.com" target="_blank">https://disqus.com</a></li>
    <li>Klikk "Get Started" og velg "I want to install Disqus on my site"</li>
    <li>Fyll inn nettstedsdetaljene dine</li>
    <li>Velg en plan (gratisplanen er tilstrekkelig for de fleste nettsteder)</li>
    <li>Merk deg ditt <strong>shortname</strong> (også kalt "site shortname") - du trenger dette!</li>
</ol>

<h4>Steg 3: Konfigurer Modultillatelser</h4>
<ol>
    <li>Gå til <code>Brukere &amp; Grupper &gt; Grupper</code></li>
    <li>Rediger gruppen som skal administrere Disqus</li>
    <li>Finn og aktiver <strong>"Bruk MAS_Disqus"</strong>-tillatelsen</li>
    <li>Lagre gruppeinnstillingene</li>
</ol>

<h4>Steg 4: Skriv Inn Ditt Disqus Shortname</h4>
<ol>
    <li>Naviger til <code>Utvidelser &gt; MAS_Disqus</code></li>
    <li>Skriv inn ditt Disqus shortname i "Innstillinger"-fanen</li>
    <li>Klikk "Lagre"</li>
    <li>Du skal se en forhåndsvisning av Disqus i aksjon under innstillingene</li>
</ol>

<h4>Steg 5: Test Din Installasjon</h4>
<p>Etter å ha lagret ditt shortname, rull ned for å se testforhåndsvisningen. Hvis du ser Disqus-grensesnittet, er installasjonen vellykket!</p>

<h3>4. Konfigurasjon og Innstillinger</h3>

<h4>Innstillinger-fanen</h4>
<p><strong>Innstillinger</strong>-fanen inneholder din primære Disqus-konfigurasjon:</p>

<h5>Disqus Shortname</h5>
<p>Din unike Disqus-identifikator. Dette er <strong>påkrevd</strong> for at modulen skal fungere. Finn dette i din Disqus-konto under Settings &gt; General &gt; Shortname.</p>

<h5>Aktiver i Forhåndsvisningsmodus</h5>
<p><strong>Ikke anbefalt:</strong> Når aktivert, vil Disqus-kommentarer vises selv i CMSMS forhåndsvisningsmodus. La dette være deaktivert for å unngå forvirring mellom forhåndsvisning og direkteinnhold.</p>

<h4>Administrasjonsinnstillinger-fanen</h4>
<p>Administrative preferanser for moduladferd:</p>

<h5>Vis Donasjonsfane</h5>
<p>Kontroller om Donasjonsfanen vises i modulgrensesnittet. Aktiver dette for å støtte modulutvikleren!</p>

<h4>Donasjoner-fanen</h4>
<p>Hvis du synes denne modulen er verdifull, vær så snill å vurdere å støtte utviklingen:</p>
<ul>
    <li>PayPal.me-integrasjon for enkle donasjoner</li>
    <li>Foreslått beløp: 5€ (eller det du kan avse)</li>
    <li>Kommersielle brukere: donasjoner er spesielt verdsatt</li>
    <li>Doner 30€+ for sponsorgjenkjenning med din bedriftslenke</li>
</ul>

<p><strong>Nåværende Sponsorer:</strong> Takk til <a href="https://newstargeted.com" target="_blank">News Targeted</a> for å støtte denne modulen!</p>

<h3>5. Implementeringseksempler</h3>

<h4>Grunnleggende Implementering</h4>

<h5>Steg 1: Legg til Tellerscript (Engangsoppsett)</h5>
<p>Legg til denne taggen <strong>én gang</strong> på slutten av hovedmalen din, rett før den avsluttende <code>&lt;/body&gt;</code>-taggen:</p>
<pre>{MAS_Disqus action=\'counter\'}</pre>

<p><strong>Merk:</strong> Dette aktiverer kommentartellere på hele nettstedet ditt. Legg det kun til én gang i hovedlayoutmalen.</p>

<h5>Steg 2: Legg til Kommentarer til Innhold</h5>
<p>Sett inn denne taggen der du vil at kommentarer skal vises (vanligvis i detalj-/enkeltinnholdsmaler):</p>
<pre>{MAS_Disqus mas_disqus_identifier=$entry->id}</pre>

<h4>News-modulintegrasjon</h4>

<h5>Detaljmal (Vis Kommentarer)</h5>
<p>Legg til i din News-detaljmal (vanligvis <code>News/Summary.tpl</code> eller tilpasset mal):</p>
<pre>&lt;!-- Ditt nyhetsartikkelinnhold --&gt;
&lt;h1&gt;{$entry->title}&lt;/h1&gt;
&lt;div class="news-content"&gt;{$entry->content}&lt;/div&gt;

&lt;!-- Disqus-kommentarseksjon --&gt;
&lt;div class="comments-section"&gt;
    &lt;h3&gt;Kommentarer&lt;/h3&gt;
    {MAS_Disqus mas_disqus_identifier=$entry->id}
&lt;/div&gt;</pre>

<h5>Sammendragsmal (Vis Kommentartellere)</h5>
<p>Legg til kommentartellere i din News-sammendragsmal:</p>

<p><strong>Alternativ 1: Enkel Identifikator</strong></p>
<pre>&lt;p class="links"&gt;
    [{$entry->morelink}] 
    [&lt;a href="{$entry->moreurl}#disqus_thread" 
       title="Vis kommentarer" 
       data-disqus-identifier="{$entry->id}"&gt;
        Kommentarer
    &lt;/a&gt;]
&lt;/p&gt;</pre>

<p><strong>Alternativ 2: Prefikset Identifikator (Anbefalt)</strong></p>
<pre>{capture name=xxx assign=sid}news_{$entry->id}{/capture}
&lt;p class="links"&gt;
    [{$entry->morelink}] 
    [&lt;a href="{$entry->moreurl}#disqus_thread" 
       title="Vis kommentarer" 
       data-disqus-identifier="{$sid}"&gt;
        Kommentarer
    &lt;/a&gt;]
&lt;/p&gt;</pre>

<h5>Med Tilpasset Tittel</h5>
<pre>{$entry->title|cms_escape:htmlall assign=\'title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</pre>

<h4>CGBlog-integrasjon</h4>

<h5>Bloggdetaljmal</h5>
<pre>&lt;!-- Ditt blogginnlegg innhold --&gt;
&lt;article class="blog-post"&gt;
    &lt;h1&gt;{$entry->title}&lt;/h1&gt;
    &lt;div class="post-content"&gt;{$entry->content}&lt;/div&gt;
    
    &lt;!-- Kommentarseksjon --&gt;
    &lt;div class="blog-comments"&gt;
        {capture assign=blog_id}blog_{$entry->id}{/capture}
        {MAS_Disqus mas_disqus_identifier=$blog_id}
    &lt;/div&gt;
&lt;/article&gt;</pre>

<h5>Bloggsammendrag med Teller</h5>
<pre>{capture assign=blog_id}blog_{$entry->id}{/capture}
&lt;div class="post-meta"&gt;
    &lt;a href="{$entry->moreurl}#disqus_thread" 
       data-disqus-identifier="{$blog_id}"&gt;
        Vis Kommentarer
    &lt;/a&gt;
&lt;/div&gt;</pre>

<h4>Tilpasset Innholdsintegrasjon</h4>

<h5>Generisk Innholdstype</h5>
<pre>{capture assign=custom_id}content_{$item->id}{/capture}
{$item->title|cms_escape:htmlall assign=\'safe_title\'}
{MAS_Disqus mas_disqus_identifier=$custom_id mas_disqus_title=$safe_title}</pre>

<h5>Flere Innholdstyper på Samme Nettsted</h5>
<p>Bruk prefikser for å holde diskusjoner atskilte:</p>
<pre>&lt;!-- For News --&gt;
{capture assign=news_id}news_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$news_id}

&lt;!-- For Blog --&gt;
{capture assign=blog_id}blog_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$blog_id}

&lt;!-- For Tilpassede Artikler --&gt;
{capture assign=article_id}article_{$item->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$article_id}</pre>

<h3>6. Avansert Bruk</h3>

<h4>Tilpassede Identifikatorer</h4>

<h5>Forstå mas_disqus_identifier</h5>
<p><code>mas_disqus_identifier</code>-parameteren identifiserer unikt hver diskusjon. Best practices:</p>

<ul>
    <li><strong>Må være unik:</strong> Hvert innholdselement trenger en unik identifikator</li>
    <li><strong>Bør være permanent:</strong> Ikke endre identifikatorer etter at kommentarer er postet</li>
    <li><strong>Bruk prefikser:</strong> Hjelper med å organisere diskusjoner etter innholdstype</li>
    <li><strong>Unngå spesialtegn:</strong> Hold deg til alfanumeriske tegn og understreker</li>
</ul>

<h5>Hvorfor Bruke Prefikser?</h5>
<p>Prefikser som <code>news_</code>, <code>blog_</code>, <code>article_</code> hjelper med å:</p>
<ul>
    <li>Forhindre ID-kollisjoner mellom forskjellige innholdstyper</li>
    <li>Organisere diskusjoner i Disqus-administrasjonspanelet</li>
    <li>Migrere innhold mellom systemer enklere</li>
    <li>Feilsøke og løse problemer raskere</li>
</ul>

<h5>Eksempel på Prefiksstrategier</h5>
<pre>&lt;!-- Enkel numerisk ID --&gt;
{MAS_Disqus mas_disqus_identifier=$entry->id}

&lt;!-- Prefikset ID (anbefalt) --&gt;
{capture assign=nid}news_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$nid}

&lt;!-- Flerlagsprefikser --&gt;
{capture assign=cid}news_technology_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$cid}

&lt;!-- Slug-basert identifikator --&gt;
{capture assign=sid}news_{$entry->alias}{/capture}
{MAS_Disqus mas_disqus_identifier=$sid}</pre>

<h4>Tilpassede URLer</h4>

<h5>Når Skal man Bruke mas_disqus_url</h5>
<p>Overstyr automatisk URL-deteksjon når:</p>
<ul>
    <li>Du bruker query-parametere som skaper dupliserte sider</li>
    <li>Innhold er tilgjengelig via flere URLer</li>
    <li>Du implementerer kanoniske URLer for SEO</li>
    <li>Du arbeider med CDN eller proxy-oppsett</li>
</ul>

<h5>URL-eksempler</h5>
<pre>&lt;!-- Bruk kanonisk URL --&gt;
{capture assign=canonical_url}{cms_selflink}{/capture}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url=$canonical_url}

&lt;!-- Bruk absolutt URL --&gt;
{capture assign=abs_url}https://ditdomene.no{$entry->url}{/capture}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url=$abs_url}</pre>

<h4>Tilpassede Titler</h4>

<h5>Bruk av mas_disqus_title</h5>
<p>Kontroller diskusjonstittelen som vises i Disqus:</p>

<pre>&lt;!-- Grunnleggende tittel --&gt;
{$entry->title|cms_escape:htmlall assign=\'title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}

&lt;!-- Forbedret tittel med kategori --&gt;
{capture assign=full_title}{$category->name}: {$entry->title}{/capture}
{$full_title|cms_escape:htmlall assign=\'safe_title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$safe_title}

&lt;!-- SEO-optimalisert tittel --&gt;
{capture assign=seo_title}{$entry->title} - {$sitename}{/capture}
{$seo_title|cms_escape:htmlall assign=\'title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</pre>

<h4>Kategoriintegrasjon</h4>

<h5>Bruk av mas_disqus_category_id</h5>
<p>Koble ditt CMSMS-innhold til Disqus-kategorier:</p>

<pre>&lt;!-- Koble News-kategori til Disqus-kategori --&gt;
{if $entry->category_id == 1}
    {assign var=\'disqus_cat\' value=\'123456\'}
{elseif $entry->category_id == 2}
    {assign var=\'disqus_cat\' value=\'789012\'}
{/if}

{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_category_id=$disqus_cat}</pre>

<p><strong>Merk:</strong> Disqus-kategori-IDer finnes i ditt Disqus-administrasjonspanel under Settings &gt; Community &gt; Categories.</p>

<h3>7. Tag-parametere Referanse</h3>

<table border="1" cellpadding="8" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 10px 0;">
    <tr>
        <th style="background-color: #f0f0f0; text-align: left; width: 25%;">Parameter</th>
        <th style="background-color: #f0f0f0; text-align: left; width: 12%;">Type</th>
        <th style="background-color: #f0f0f0; text-align: left; width: 63%;">Beskrivelse</th>
    </tr>
    <tr>
        <td><code>action</code></td>
        <td>String</td>
        <td>
            <strong>Valgfri.</strong> Kontrollerer visningsmodus:<br>
            - Standard (utelatt): Viser kommentartråd<br>
            - <code>\'counter\'</code>: Laster kommentartellerscript<br>
            <br>
            <strong>Eksempel:</strong><br>
            <code>{MAS_Disqus action=\'counter\'}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_identifier</code></td>
        <td>String</td>
        <td>
            <strong>Påkrevd (unntatt for counter).</strong> Unik identifikator for diskusjonen.<br>
            - Må være unik per innholdselement<br>
            - Bør forbli konstant over tid<br>
            - Best practice: bruk prefikser (news_, blog_)<br>
            <br>
            <strong>Eksempler:</strong><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id}</code><br>
            <code>{MAS_Disqus mas_disqus_identifier="news_{$entry->id}"}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_url</code></td>
        <td>String (URL)</td>
        <td>
            <strong>Valgfri.</strong> Overstyr side-URLen som detekteres av Disqus.<br>
            - Må være en gyldig, absolutt URL<br>
            - Nyttig for implementering av kanonisk URL<br>
            - Hjelper med å forhindre dupliserte diskusjoner<br>
            <br>
            <strong>Eksempel:</strong><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url="https://ditdomene.no/news/{$entry->alias}"}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_title</code></td>
        <td>String</td>
        <td>
            <strong>Valgfri.</strong> Overstyr sidetittelen i Disqus.<br>
            - Vises i Disqus-administrasjon og varsler<br>
            - Bør være riktig escapet for HTML<br>
            - Nyttig for SEO og organisering<br>
            <br>
            <strong>Eksempler:</strong><br>
            <code>{$entry->title|cms_escape:htmlall assign=\'title\'}</code><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_category_id</code></td>
        <td>Integer</td>
        <td>
            <strong>Valgfri.</strong> Tildel diskusjon til en Disqus-kategori.<br>
            - Kategori-ID fra Disqus-administrasjonspanel<br>
            - Hjelper med å organisere diskusjoner i Disqus<br>
            - Tillater kategori-spesifikke modereringsregler<br>
            <br>
            <strong>Eksempel:</strong><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_category_id=123456}</code>
        </td>
    </tr>
</table>

<h4>Komplett Eksempel med Alle Parametere</h4>
<pre>{capture assign=news_id}news_{$entry->id}{/capture}
{capture assign=canonical_url}https://ditdomene.no{$entry->url}{/capture}
{$entry->title|cms_escape:htmlall assign=\'safe_title\'}

{MAS_Disqus 
    mas_disqus_identifier=$news_id 
    mas_disqus_url=$canonical_url 
    mas_disqus_title=$safe_title 
    mas_disqus_category_id=123456}</pre>

<h3>8. Feilsøkingsveiledning</h3>

<h4>Kommentarer Vises Ikke</h4>
<p><strong>Mulige årsaker og løsninger:</strong></p>
<ul>
    <li><strong>Manglende shortname:</strong> Verifiser at shortname er angitt i Innstillinger-fanen</li>
    <li><strong>JavaScript deaktivert:</strong> Forsikre deg om at besøkendes nettleser har JavaScript aktivert</li>
    <li><strong>Feil identifikator:</strong> Sjekk at mas_disqus_identifier er riktig satt</li>
    <li><strong>Tillatelser:</strong> Verifiser at "Bruk MAS_Disqus"-tillatelse er gitt</li>
    <li><strong>Forhåndsvisningsmodus:</strong> Disqus er deaktivert i forhåndsvisningsmodus som standard (anbefalt)</li>
    <li><strong>Nettlesercache:</strong> Tøm nettlesercachen og last siden på nytt</li>
    <li><strong>Brannmur blokkering:</strong> Sjekk om brannmuren blokkerer Disqus-servere</li>
</ul>

<h4>Teller Viser Feil Verdier</h4>
<p><strong>Vanlige problemer:</strong></p>
<ul>
    <li><strong>Tellerscript ikke lastet:</strong> Forsikre deg om at <code>{MAS_Disqus action=\'counter\'}</code> er i hovedmalen din</li>
    <li><strong>Identifikator-misforhold:</strong> data-disqus-identifier i sammendrag må matche mas_disqus_identifier i detalj</li>
    <li><strong>Cache-forsinkelse:</strong> Disqus-tellere oppdateres hvert par minutter, ikke umiddelbart</li>
    <li><strong>Manglende anker:</strong> Lenken må inkludere <code>#disqus_thread</code>-anker</li>
</ul>

<h4>Tillatselsesfeil</h4>
<p><strong>Feil: "Tilgang nektet. Vennligst sjekk tillatelsene dine."</strong></p>
<ol>
    <li>Naviger til Brukere &amp; Grupper &gt; Grupper</li>
    <li>Rediger den aktuelle gruppen</li>
    <li>Finn "Bruk MAS_Disqus"-tillatelse</li>
    <li>Aktiver avkrysningsboksen</li>
    <li>Lagre gruppeinnstillinger</li>
    <li>Logg ut og logg inn igjen</li>
</ol>

<h4>Flere Kommentarseksjoner på Samme Side</h4>
<p><strong>Problem:</strong> Flere instanser av MAS_Disqus-tag på én side forårsaker problemer.</p>
<p><strong>Løsning:</strong> Bruk kun ÉN MAS_Disqus-tag per side (unntatt for counter-action).</p>

<h4>Migrering fra Original Disqus-modul</h4>
<p><strong>For å bevare eksisterende kommentarer ved migrering:</strong></p>
<ol>
    <li>Merk deg identifikatorformatet brukt i den originale modulen</li>
    <li>Bruk identisk identifikatorformat i MAS_Disqus</li>
    <li>Test på en enkelt side først</li>
    <li>Verifiser at kommentarer vises korrekt</li>
    <li>Rull ut til resterende sider</li>
</ol>

<p><strong>Eksempel:</strong> Hvis den originale modulen brukte <code>disqus_identifier=$entry->id</code>, bruk <code>mas_disqus_identifier=$entry->id</code> (samme verdi).</p>

<h4>JavaScript-konflikter</h4>
<p><strong>Symptomer:</strong> Disqus laster delvis eller ikke i det hele tatt, konsollefeil.</p>
<p><strong>Løsninger:</strong></p>
<ul>
    <li>Sjekk nettleserkonsollen for JavaScript-feil</li>
    <li>Forsikre deg om at jQuery eller andre biblioteker ikke kommer i konflikt</li>
    <li>Verifiser at tellerscript er lastet etter hovedinnhold</li>
    <li>Test med annen JavaScript midlertidig deaktivert</li>
</ul>

<h4>Ytelsesbetraktninger</h4>
<p><strong>Disqus kan påvirke sideinnlastingstid:</strong></p>
<ul>
    <li>Disqus laster asynkront (blokkerer ikke siderendering)</li>
    <li>Vurder lazy loading for sider med mange kommentarer</li>
    <li>Overvåk sidehastighet med verktøy som Google PageSpeed Insights</li>
    <li>Disqus-embed er optimalisert, men legger til eksterne ressurser</li>
</ul>

<h3>9. Best Practices</h3>

<h4>SEO-optimalisering</h4>
<ul>
    <li><strong>Bruk beskrivende titler:</strong> Sett mas_disqus_title for å forbedre søkesynlighet</li>
    <li><strong>Implementer kanoniske URLer:</strong> Bruk mas_disqus_url for å forhindre duplikat innholdsproblemer</li>
    <li><strong>Aktiver Disqus SEO-funksjoner:</strong> Konfigurer i Disqus-administrasjonspanel</li>
    <li><strong>Overvåk indekserte kommentarer:</strong> Disqus-kommentarer kan crawles av søkemotorer</li>
</ul>

<h4>Ytelsesanbefalinger</h4>
<ul>
    <li><strong>Plasser tellerscript på sidens bunn:</strong> Forbedrer opplevd lastetid</li>
    <li><strong>Bruk caching klokt:</strong> Ikke cache sider med bruker-spesifikk kommentardata</li>
    <li><strong>Minimer identifikatorlengde:</strong> Kortere identifikatorer = litt raskere lasting</li>
    <li><strong>Vurder CDN:</strong> Bruk CDN for nettstedet ditt for å forbedre global ytelse</li>
</ul>

<h4>Sikkerhetsbetraktninger</h4>
<ul>
    <li><strong>Escape titler:</strong> Bruk alltid <code>cms_escape:htmlall</code> på brukergenerert innhold</li>
    <li><strong>Valider identifikatorer:</strong> Forsikre deg om at identifikatorer ikke inneholder ondsinnet kode</li>
    <li><strong>Konfigurer moderering:</strong> Sett opp kommentarmoderering i Disqus-administrasjon</li>
    <li><strong>Overvåk spam:</strong> Aktiver Disqus spam-filtreringsfunksjoner</li>
    <li><strong>Se over tillatelser regelmessig:</strong> Kontroller hvem som har "Bruk MAS_Disqus"-tillatelse</li>
</ul>

<h4>Innholdsorganiseringsstrategier</h4>
<ul>
    <li><strong>Konsistent prefiksing:</strong> Bruk alltid samme prefiksmønster (news_, blog_, osv.)</li>
    <li><strong>Dokumenter ditt oppsett:</strong> Hold en oversikt over identifikatorformater som brukes</li>
    <li><strong>Planlegg for migrering:</strong> Velg identifikatorer som vil forbli gyldige langsiktig</li>
    <li><strong>Test før utrulling:</strong> Verifiser kommentartråder på testside først</li>
</ul>

<h4>Vedlikehold og Overvåking</h4>
<ul>
    <li><strong>Regelmessige oppdateringer:</strong> Hold MAS_Disqus-modulen oppdatert</li>
    <li><strong>Overvåk Disqus-dashbordet:</strong> Se gjennom kommentaraktivitet og modereringskø</li>
    <li><strong>Backup diskusjoner:</strong> Eksporter kommentarer periodisk fra Disqus</li>
    <li><strong>Test etter oppgraderinger:</strong> Verifiser funksjonalitet etter CMSMS eller moduloppdateringer</li>
    <li><strong>Spor ytelse:</strong> Overvåk sideinnlastingseffekten av Disqus-embed</li>
</ul>

<h3>10. Ofte Stilte Spørsmål</h3>

<h4>Kan jeg bruke dette sammen med den originale Disqus-modulen?</h4>
<p><strong>Ja!</strong> MAS_Disqus har et uavhengig tillatelsessystem og kommer ikke i konflikt med den originale Disqus-modulen. Du kan bruke begge på samme nettsted, selv om det anbefales å standardisere på én for enkelhets skyld.</p>

<h4>Hvordan migrerer jeg fra den originale Disqus-modulen?</h4>
<p>For å bevare eksisterende kommentarer:</p>
<ol>
    <li>Identifiser identifikatorformatet brukt i den originale modulen</li>
    <li>Erstatt <code>{Disqus}</code>-tags med <code>{MAS_Disqus}</code>-tags</li>
    <li>Erstatt <code>disqus_identifier</code> med <code>mas_disqus_identifier</code> (behold samme verdi)</li>
    <li>Behold samme shortname</li>
    <li>Test på én side først for å verifisere at kommentarer vises</li>
</ol>

<h4>Hvorfor vises ikke kommentarene mine?</h4>
<p>Vanligste årsaker:</p>
<ul>
    <li>Shortname ikke konfigurert eller feil</li>
    <li>JavaScript deaktivert i nettleser</li>
    <li>Manglende eller feil identifikator</li>
    <li>Visning i forhåndsvisningsmodus (Disqus deaktivert som standard)</li>
    <li>Manglende tillatelser ("Bruk MAS_Disqus")</li>
</ul>
<p>Se Feilsøkingsveiledning (seksjon 8) for detaljerte løsninger.</p>

<h4>Hvordan tilpasser jeg utseendet?</h4>
<p>Disqus-utseende konfigureres i din Disqus-konto:</p>
<ol>
    <li>Logg inn på din Disqus-konto på disqus.com</li>
    <li>Gå til Settings &gt; General</li>
    <li>Velg fargetema og layoutalternativer</li>
    <li>Endringer gjøres automatisk på hele nettstedet</li>
</ol>
<p>For avansert tilpasning tilbyr Disqus CSS-tilpasning (tilgjengelig med betalte planer).</p>

<h4>Kan jeg bruke forskjellige shortnames for forskjellige seksjoner?</h4>
<p><strong>Nei.</strong> CMSMS-moduler er site-wide. Du kan kun bruke ett Disqus shortname per MAS_Disqus-installasjon. Du kan imidlertid:</p>
<ul>
    <li>Bruke Disqus-kategorier for å organisere forskjellige seksjoner</li>
    <li>Bruke identifikatorprefikser for å skille innholdstyper</li>
    <li>Installere flere CMSMS-instanser for virkelig separate nettsteder</li>
</ul>

<h4>Hvordan håndterer jeg flerspråklige nettsteder?</h4>
<p>For flerspråklige nettsteder:</p>
<ul>
    <li><strong>Alternativ 1:</strong> Én diskusjonstråd per innholdselement (alle språk ser samme kommentarer)</li>
    <li><strong>Alternativ 2:</strong> Legg til språkkode i identifikator (news_en_123, news_no_123) for separate diskusjoner</li>
    <li><strong>Alternativ 3:</strong> Bruk Disqus språkdeteksjonsfunksjon (konfigurert i Disqus-administrasjon)</li>
</ul>

<pre>&lt;!-- Separate diskusjoner per språk --&gt;
{capture assign=lang_id}news_{$lang}_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$lang_id}</pre>

<h4>Er Disqus gratis?</h4>
<p>Disqus tilbyr både gratis og betalte planer:</p>
<ul>
    <li><strong>Basic (Gratis):</strong> Inkluderer annonser, passende for de fleste nettsteder</li>
    <li><strong>Plus ($11/måned):</strong> Ingen annonser, avansert moderering</li>
    <li><strong>Pro ($89/måned):</strong> Premium-funksjoner, tilpasset CSS, prioritert support</li>
</ul>
<p>Gratisplanen er tilstrekkelig for de fleste CMSMS-nettsteder.</p>

<h4>Vil Disqus gjøre nettstedet mitt tregere?</h4>
<p>Disqus laster asynkront, så det blokkerer ikke siderendering. Men:</p>
<ul>
    <li>Det legger til eksterne ressurser (JavaScript, CSS, bilder)</li>
    <li>Effekten varierer basert på antall kommentarer og brukerens tilkobling</li>
    <li>De fleste brukere vil ikke legge merke til betydelig senking</li>
    <li>Overvåk med PageSpeed Insights for ditt spesifikke tilfelle</li>
</ul>

<h4>Kan jeg eksportere kommentarene mine fra Disqus?</h4>
<p><strong>Ja!</strong> Disqus tilbyr eksportfunksjonalitet:</p>
<ol>
    <li>Logg inn på Disqus-administrasjon</li>
    <li>Gå til Settings &gt; Export</li>
    <li>Be om eksport (XML-format)</li>
    <li>Motta nedlastingslenke via e-post</li>
</ol>
<p>Regelmessige backups anbefales for viktige diskusjoner.</p>

<h3>11. Versjonshistorikk og Funksjoner</h3>

<h4>Versjon 1.1 (17.10.2025)</h4>
<p><strong>Stor oppdatering</strong> - Forbedret funksjonalitet og forbedret brukeropplevelse:</p>
<ul>
    <li>Lagt til Donasjonsfane med PayPal.me-integrasjon</li>
    <li>Implementert administrasjonsgrensesnitt med faner (Innstillinger, Administrasjonsinnstillinger, Donasjoner)</li>
    <li>Forbedret feilhåndtering med inline valideringsmeldinger</li>
    <li>Uavhengig "Bruk MAS_Disqus" tillatelsessystem</li>
    <li>Administrasjonsinnstillinger for synlighet av donasjonsfane</li>
    <li>Sponsorgjenkjenningssystem</li>
    <li>Forbedret skjemavalidering og brukertilbakemelding</li>
    <li>PHP 7.4-8.x kompatibilitet (PHP 8.x anbefalt)</li>
    <li>Fullstendig moduluavhengighet fra original Disqus-modul</li>
</ul>

<h4>Versjon 1.0 (August 2019)</h4>
<p>Første utgivelse med kjerne Disqus-integreringsfunksjoner:</p>
<ul>
    <li>Grunnleggende Disqus-kommentarintegrasjon</li>
    <li>Kommentartellerfunksjonalitet</li>
    <li>News/CGBlog-integrasjonsstøtte</li>
    <li>Tilpasset identifikator- og tittelstøtte</li>
</ul>

<h4>Oppgraderingsbetraktninger</h4>
<p>Ved oppgradering fra v1.0 til v1.1:</p>
<ul>
    <li>Ingen databaseendringer kreves</li>
    <li>Eksisterende innstillinger bevares automatisk</li>
    <li>Nye tillatelser vises automatisk i gruppehåndtering</li>
    <li>Ingen malendringer nødvendig</li>
    <li>Kommentartråder forblir intakte</li>
</ul>

<h4>Fremtidig Kjøreplan</h4>
<p>Planlagte funksjoner for fremtidige utgivelser:</p>
<ul>
    <li>Siste kommentarer-widget</li>
    <li>Kommentarstatistikk-dashbord</li>
    <li>Avanserte cache-alternativer</li>
    <li>Lazy loading-konfigurasjon</li>
    <li>Flere tilpasningsmuligheter</li>
</ul>

<p><em>Forslag er velkomne! Kontakt oss gjennom støttekanalene nedenfor.</em></p>

<h3>12. Støtte og Ressurser</h3>

<h4>Dokumentasjon og Veiledninger</h4>
<ul>
    <li><strong>Denne Hjelpesiden:</strong> Omfattende moduldokumentasjon (du er her!)</li>
    <li><strong>Disqus Offisiell Dokumentasjon:</strong> <a href="https://help.disqus.com" target="_blank">https://help.disqus.com</a></li>
    <li><strong>CMSMS-dokumentasjon:</strong> <a href="https://docs.cmsmadesimple.org" target="_blank">https://docs.cmsmadesimple.org</a></li>
</ul>

<h4>Viktige Disqus-ressurser</h4>
<ul>
    <li><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables" target="_blank">JavaScript-konfigurasjonsvariabler</a></li>
    <li><a href="https://help.disqus.com/customer/portal/articles/472099-what-is-a-shortname" target="_blank">Hva er et Shortname?</a></li>
    <li><a href="https://help.disqus.com/customer/portal/articles/472007-i-m-receiving-the-message-we-were-unable-to-load-disqus-" target="_blank">Feilsøking: Kunne ikke laste Disqus</a></li>
</ul>

<h4>Modulstøtte</h4>
<p><strong>Kontakt:</strong> Master3395<br>
<strong>E-post:</strong> info [at] newstargeted [dot] com<br>
<strong>Nettsted:</strong> <a href="https://newstargeted.com/contact/" target="_blank">https://newstargeted.com/contact/</a></p>

<h4>Fellesskapsstøtte</h4>
<ul>
    <li><strong>CMSMS-forum:</strong> <a href="https://forum.cmsmadesimple.org" target="_blank">https://forum.cmsmadesimple.org</a></li>
    <li><strong>CMSMS Slack:</strong> Bli med i CMSMS-fellesskapets Slack-kanal</li>
</ul>

<h4>Feilrapporter og Funksjonsforespørsler</h4>
<p>Funnet en feil eller har et funksjonsforslag? Vennligst kontakt oss med:</p>
<ul>
    <li>Detaljert beskrivelse av problemet eller funksjonen</li>
    <li>Trinn for å reprodusere (for feil)</li>
    <li>Dine CMSMS- og PHP-versjoner</li>
    <li>MAS_Disqus-modulversjon</li>
    <li>Eventuelle feilmeldinger fra nettleserkonsollen</li>
</ul>

<h4>Støtt Utviklingen</h4>
<p>Hvis du synes MAS_Disqus er verdifullt, vær så snill å vurdere å:</p>
<ul>
    <li><strong>Donere:</strong> Bruk Donasjonsfanen for å støtte fortsatt utvikling</li>
    <li><strong>Sponsing:</strong> Doner 30€+ for gjenkjenning med din bedriftslenke</li>
    <li><strong>Spre ordet:</strong> Fortell andre CMSMS-brukere om MAS_Disqus</li>
    <li><strong>Bidra:</strong> Hjelp til med å forbedre dokumentasjon eller testing</li>
</ul>

<p><strong>Nåværende Sponsorer:</strong></p>
<ul>
    <li><a href="https://newstargeted.com" target="_blank">News Targeted</a> - Takk for din støtte!</li>
</ul>

<h3>13. Opphavsrett og Lisens</h3>

<h4>Opphavsrettserklæring</h4>
<p>Copyright &copy; 2019-2025, Master3395. Alle rettigheter reservert.<br>
E-post: info [at] newstargeted [dot] com<br>
Nettsted: <a href="https://newstargeted.com/contact/" target="_blank">https://newstargeted.com/contact/</a></p>

<h4>Lisens</h4>
<p>Denne modulen er utgitt under <a href="https://www.gnu.org/licenses/licenses.html#GPL" target="_blank">GNU General Public License v3.0</a>.</p>

<p><strong>Du har lov til å:</strong></p>
<ul>
    <li>Bruke denne modulen for personlige eller kommersielle prosjekter</li>
    <li>Modifisere modulen for å passe dine behov</li>
    <li>Distribuere kopier av modulen</li>
</ul>

<p><strong>Under følgende betingelser:</strong></p>
<ul>
    <li>Du må godta GPL-lisensvilkårene før du bruker modulen</li>
    <li>Eventuelle modifikasjoner må også utgis under GPL</li>
    <li>Du må bevare opphavsrettsnotiser</li>
    <li>Denne modulen leveres "som den er" uten garanti</li>
</ul>

<h4>Moduluavhengighet</h4>
<p>MAS_Disqus er fullstendig uavhengig av den originale Disqus-modulen for CMSMS. Den ble utviklet som et forbedret alternativ med tilleggsfunksjoner og forbedret administrasjon. Begge moduler kan eksistere sammen på samme CMSMS-installasjon uten konflikter.</p>

<h4>Tredjepartstjenester</h4>
<p>Denne modulen integreres med Disqus (disqus.com), en tredjepartskommentarplattform. Bruk av Disqus er underlagt Disqus sine egne tjenestevilkår og personvernregler. Vennligst se gjennom disse før du implementerer Disqus på nettstedet ditt:</p>
<ul>
    <li><a href="https://help.disqus.com/terms-and-policies/terms-of-service" target="_blank">Disqus Tjenestevilkår</a></li>
    <li><a href="https://help.disqus.com/terms-and-policies/disqus-privacy-policy" target="_blank">Disqus Personvernregler</a></li>
</ul>

<h4>Ansvarsfraskrivelse</h4>
<p>Dette programmet distribueres i håp om at det vil være nyttig, men <strong>UTEN NOEN GARANTI</strong>; uten engang underforstått garanti for <strong>SALGBARHET</strong> eller <strong>EGNETHET FOR ET BESTEMT FORMÅL</strong>. Se GNU General Public License for flere detaljer.</p>

<hr style="margin: 20px 0; border: none; border-top: 2px solid #ccc;">

<p style="text-align: center; margin-top: 20px; font-size: 0.9em; color: #666;">
    <strong>MAS_Disqus v1.1</strong> | 
    Forbedret Disqus-integrasjon for CMS Made Simple
</p>

</div>
';

$lang['title_d_Shortname_help'] = 'Disqus sitt Kortnavn (Shortname)';
$lang['title_isPreviewBlocked_help'] = 'aktiver disqus selv i forhåndsvisningsmodus (ikke anbefalt)';
$lang['title_test'] = 'Se resultatet i boksen nedenfor';


$lang['help_action'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Påkrevd</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Beskrivelse</td></tr><tr><td>String</td><td>Valgfri</td><td><strong>Kontrollerer visningsmodus:</strong><br/>- Standard (utelatt): Viser kommentartråd<br/>- \'counter\': Laster kommentartellerscript<br/><br/><strong>Eksempel:</strong><br/><code>{MAS_Disqus action=\'counter\'}</code></td></tr></table>';

$lang['help_disqus_identifier'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Påkrevd</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Beskrivelse</td></tr><tr><td>String</td><td>Påkrevd (unntatt counter)</td><td><strong>Unik identifikator for diskusjonen.</strong><br/>- Må være unik per innholdselement<br/>- Bør forbli konstant over tid<br/>- Best practice: bruk prefikser (news_, content_)<br/><br/><strong>Eksempler:</strong><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id}</code><br/><code>{MAS_Disqus mas_disqus_identifier="news_{$entry->id}"}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_identifier">Se mer informasjon i Disqus-dokumentasjonen</a></td></tr></table>';
$lang['help_disqus_url'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Påkrevd</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Beskrivelse</td></tr><tr><td>String (URL)</td><td>Valgfri</td><td><strong>Overstyr side-URLen som detekteres av Disqus.</strong><br/>- Må være en gyldig, absolutt URL<br/>- Nyttig for implementering av kanonisk URL<br/>- Hjelper med å forhindre dupliserte diskusjoner<br/><br/><strong>Eksempel:</strong><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url="https://ditdomene.no/news/{$entry->alias}"}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_url">Se mer informasjon i Disqus-dokumentasjonen</a></td></tr></table>';
$lang['help_disqus_title'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Påkrevd</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Beskrivelse</td></tr><tr><td>String</td><td>Valgfri</td><td><strong>Overstyr sidetittelen i Disqus.</strong><br/>- Vises i Disqus-administrasjon og varsler<br/>- Bør være riktig escapet for HTML<br/>- Nyttig for SEO og organisering<br/><br/><strong>Eksempler:</strong><br/><code>{$entry->title|cms_escape:htmlall assign=\'title\'}</code><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_title">Se mer informasjon i Disqus-dokumentasjonen</a></td></tr></table>';
$lang['help_disqus_category_id'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Påkrevd</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Beskrivelse</td></tr><tr><td>Integer</td><td>Valgfri</td><td><strong>Tildel diskusjon til en Disqus-kategori.</strong><br/>- Kategori-ID fra Disqus-administrasjonspanel<br/>- Hjelper med å organisere diskusjoner i Disqus<br/>- Tillater kategori-spesifikke modereringsregler<br/><br/><strong>Eksempel:</strong><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_category_id=123456}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_category_id">Se mer informasjon i Disqus-dokumentasjonen</a></td></tr></table>';

// Donasjonsfane språkstrenger
$lang['donationstab'] = 'Donasjoner';
$lang['donationstext'] = 'Mye tid og arbeid er lagt ned i å lage denne modulen. Vær så snill å vurdere en liten donasjon (for eksempel 5€, eller det du kan avse) ved å bruke PayPal-knappen nedenfor, spesielt hvis du bruker denne modulen i kommersiell sammenheng. Hvis du donerer mer enn 30€ kan du få en lenke til din bedrift på denne siden, hvis du ønsker det. Send meg en e-post om hva du ønsker vist, så legger jeg det inn i neste versjon. Takk!';
$lang['sponsors'] = 'Nåværende sponsorer, takk for din støtte!';
$lang['hidedonationssubmit'] = 'Skjul donasjonsfane';

// Innstillingsfane språkstrenger
$lang['settings'] = 'Innstillinger';
$lang['showdonationstab'] = 'Vis donasjonsfane';
$lang['settingsupdated'] = 'Innstillinger oppdatert med suksess';

// Valideringsfeilmeldinger
$lang['shortname_empty'] = 'Disqus Shortname kan ikke være tomt.';


?>
