<?php
$lang['friendlyname'] = 'Master3395s Disqus';
$lang['postinstall'] = 'Post Install Message, e.g., Be sure to set "Use MAS_Disqus" permissions to use this module!';
$lang['postuninstall'] = 'Post Uninstall Message, e.g., "Curses! Foiled Again!"';
$lang['really_uninstall'] = 'Really? You\'re sure you want to uninstall this fine module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module version %s upgraded.';

$lang['prefsupdated'] = 'Module preferences updated.';
$lang['submit'] = 'Save';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['shortname_null'] = 'the parameter shortname cannot be null';
$lang['success'] = 'Save with success.';

$lang['moddescription'] = 'Enhanced Disqus integration module with donations system, improved admin interface, and independent permissions.';
$lang['changelog'] = '<ul>
<li><strong>Version 1.1.1, 17.10.2025, Master3395</strong> : Documentation improvements, enhanced parameter help display, and complete Norwegian Bokmål translation.
  <ul>
    <li><strong>Enhanced Parameter Help:</strong> Updated individual parameter help strings to display as professional mini-tables matching the main documentation format</li>
    <li><strong>Improved Table Formatting:</strong> Enhanced Tag Parameters Reference table with better column proportions and visual hierarchy</li>
    <li><strong>Consistent Documentation:</strong> Standardized parameter descriptions across all help contexts for better user experience</li>
    <li><strong>Professional Appearance:</strong> Parameter help now displays with proper table structure, clear type information, and requirement levels</li>
    <li><strong>Better Readability:</strong> Improved formatting with bullet points, code examples, and structured descriptions</li>
    <li><strong>Norwegian Bokmål Translation:</strong> Complete professional translation of all 826 lines including comprehensive 13-section help documentation, UI strings, changelog, and parameter help</li>
  </ul>
</li>
<li><strong>Version 1.1, 17.10.2025, Master3395</strong> : Major update with donations system and improved admin interface.
  <ul>
    <li><strong>Added Donations Tab:</strong> PayPal.me integration for donations with customizable amount</li>
    <li><strong>Improved Admin Interface:</strong> Tabbed interface with Settings, Admin Settings, and Donations tabs</li>
    <li><strong>Enhanced Error Handling:</strong> Inline validation errors instead of global banner messages</li>
    <li><strong>Permission System Update:</strong> Independent "Use MAS_Disqus" permission (no longer conflicts with original Disqus module)</li>
    <li><strong>Admin Settings:</strong> Option to show/hide donations tab with persistent settings</li>
    <li><strong>Sponsor Recognition:</strong> News Targeted website listed as module sponsor</li>
    <li><strong>Form Validation:</strong> Proper validation for Disqus shortname with inline error messages</li>
    <li><strong>User Experience:</strong> Cleaner interface with better organization and visual feedback</li>
    <li><strong>Module Independence:</strong> Fully independent from original Disqus module while maintaining compatibility</li>
    <li><strong>PHP Compatibility:</strong> Supports PHP 7.4+ for maximum longevity and future compatibility. <strong>Recommended: PHP 8.x</strong> for optimal performance and security.</li>
  </ul>
</li>
<li>Version 1.0, August 2019, Master3395 : first release.</li>
</ul>';
$lang['help'] = '
<div id="mas-disqus-help-documentation">

<h3>1. Module Overview</h3>
<p><strong>MAS_Disqus</strong> is an enhanced Disqus integration module for CMS Made Simple that provides powerful commenting functionality with advanced features and improved administration.</p>

<h4>Key Features</h4>
<ul>
    <li><strong>Enhanced Admin Interface:</strong> Modern tabbed interface for easy configuration</li>
    <li><strong>Donations System:</strong> Integrated PayPal.me support for module sponsorship</li>
    <li><strong>Independent Permissions:</strong> Works independently from the original Disqus module</li>
    <li><strong>Improved Error Handling:</strong> Inline validation with clear error messages</li>
    <li><strong>Flexible Integration:</strong> Works with News, CGBlog, and custom content types</li>
    <li><strong>Comment Counters:</strong> Display comment counts on summary pages</li>
    <li><strong>PHP 8.x Compatible:</strong> Future-proof with modern PHP support</li>
    <li><strong>SEO Friendly:</strong> Customizable URLs and titles for optimal search engine visibility</li>
</ul>

<h4>Benefits Over Original Disqus Module</h4>
<ul>
    <li>Can run alongside the original Disqus module without conflicts</li>
    <li>Separate permission system ("Use MAS_Disqus")</li>
    <li>Enhanced administrative controls and settings</li>
    <li>Better error handling and user feedback</li>
    <li>Active maintenance and updates</li>
</ul>

<h3>2. Technical Requirements</h3>

<h4>Minimum Requirements</h4>
<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 10px 0;">
    <tr>
        <th style="background-color: #f0f0f0; text-align: left;">Component</th>
        <th style="background-color: #f0f0f0; text-align: left;">Minimum Version</th>
        <th style="background-color: #f0f0f0; text-align: left;">Recommended</th>
    </tr>
    <tr>
        <td>PHP</td>
        <td>7.4.0</td>
        <td>8.0 or higher</td>
    </tr>
    <tr>
        <td>CMS Made Simple</td>
        <td>2.2.10</td>
        <td>Latest stable version</td>
    </tr>
    <tr>
        <td>Disqus Account</td>
        <td>Free account</td>
        <td>Verified account</td>
    </tr>
</table>

<h4>Required Permissions</h4>
<p>Users need the <strong>"Use MAS_Disqus"</strong> permission to access the module\'s admin interface. This can be configured in:</p>
<p><code>Extensions &gt; Users &amp; Groups &gt; Groups &gt; [Your Group] &gt; Permissions</code></p>

<h4>Server Requirements</h4>
<ul>
    <li>JavaScript must be enabled in visitor browsers</li>
    <li>Outbound HTTPS connections to Disqus servers</li>
    <li>No special PHP extensions required</li>
</ul>

<h3>3. Installation &amp; Setup Guide</h3>

<h4>Step 1: Install the Module</h4>
<ol>
    <li>Download the MAS_Disqus module package</li>
    <li>Navigate to <code>Extensions &gt; Modules</code> in your CMSMS admin</li>
    <li>Click "Available Modules" or upload the module package</li>
    <li>Find MAS_Disqus and click "Install"</li>
    <li>Wait for confirmation message</li>
</ol>

<h4>Step 2: Create Your Disqus Account</h4>
<ol>
    <li>Visit <a href="https://disqus.com" target="_blank">https://disqus.com</a></li>
    <li>Click "Get Started" and choose "I want to install Disqus on my site"</li>
    <li>Fill in your website details</li>
    <li>Choose a plan (free plan is sufficient for most sites)</li>
    <li>Note your <strong>shortname</strong> (also called "site shortname") - you\'ll need this!</li>
</ol>

<h4>Step 3: Configure Module Permissions</h4>
<ol>
    <li>Go to <code>Users &amp; Groups &gt; Groups</code></li>
    <li>Edit the group that should manage Disqus</li>
    <li>Find and enable <strong>"Use MAS_Disqus"</strong> permission</li>
    <li>Save the group settings</li>
</ol>

<h4>Step 4: Enter Your Disqus Shortname</h4>
<ol>
    <li>Navigate to <code>Extensions &gt; MAS_Disqus</code></li>
    <li>Enter your Disqus shortname in the "Settings" tab</li>
    <li>Click "Save"</li>
    <li>You should see a preview of Disqus in action below the settings</li>
</ol>

<h4>Step 5: Test Your Installation</h4>
<p>After saving your shortname, scroll down to see the test preview. If you see the Disqus interface, your installation is successful!</p>

<h3>4. Configuration &amp; Settings</h3>

<h4>Settings Tab</h4>
<p>The <strong>Settings</strong> tab contains your primary Disqus configuration:</p>

<h5>Disqus Shortname</h5>
<p>Your unique Disqus identifier. This is <strong>required</strong> for the module to function. Find this in your Disqus account under Settings &gt; General &gt; Shortname.</p>

<h5>Enable in Preview Mode</h5>
<p><strong>Not recommended:</strong> When enabled, Disqus comments will appear even in CMSMS preview mode. Leave this disabled to avoid confusion between preview and live content.</p>

<h4>Admin Settings Tab</h4>
<p>Administrative preferences for module behavior:</p>

<h5>Show Donations Tab</h5>
<p>Control whether the Donations tab appears in the module interface. Enable this to support the module developer!</p>

<h4>Donations Tab</h4>
<p>If you find this module valuable, please consider supporting its development:</p>
<ul>
    <li>PayPal.me integration for easy donations</li>
    <li>Suggested amount: 5€ (or what you can spare)</li>
    <li>Commercial users: donations are especially appreciated</li>
    <li>Donate 30€+ for sponsor recognition with your company link</li>
</ul>

<p><strong>Current Sponsors:</strong> Thank you to <a href="https://newstargeted.com" target="_blank">News Targeted</a> for supporting this module!</p>

<h3>5. Implementation Examples</h3>

<h4>Basic Implementation</h4>

<h5>Step 1: Add Counter Script (One Time Setup)</h5>
<p>Add this tag <strong>once</strong> at the end of your main template, just before the closing <code>&lt;/body&gt;</code> tag:</p>
<pre>{MAS_Disqus action=\'counter\'}</pre>

<p><strong>Note:</strong> This enables comment counters throughout your site. Add it only once in your main layout template.</p>

<h5>Step 2: Add Comments to Content</h5>
<p>Insert this tag where you want comments to appear (typically in detail/single content templates):</p>
<pre>{MAS_Disqus mas_disqus_identifier=$entry->id}</pre>

<h4>News Module Integration</h4>

<h5>Detail Template (Show Comments)</h5>
<p>Add to your News detail template (typically <code>News/Summary.tpl</code> or custom template):</p>
<pre>&lt;!-- Your news article content --&gt;
&lt;h1&gt;{$entry->title}&lt;/h1&gt;
&lt;div class="news-content"&gt;{$entry->content}&lt;/div&gt;

&lt;!-- Disqus comments section --&gt;
&lt;div class="comments-section"&gt;
    &lt;h3&gt;Comments&lt;/h3&gt;
    {MAS_Disqus mas_disqus_identifier=$entry->id}
&lt;/div&gt;</pre>

<h5>Summary Template (Show Comment Counters)</h5>
<p>Add comment counters to your News summary template:</p>

<p><strong>Option 1: Simple Identifier</strong></p>
<pre>&lt;p class="links"&gt;
    [{$entry->morelink}] 
    [&lt;a href="{$entry->moreurl}#disqus_thread" 
       title="View comments" 
       data-disqus-identifier="{$entry->id}"&gt;
        Comments
    &lt;/a&gt;]
&lt;/p&gt;</pre>

<p><strong>Option 2: Prefixed Identifier (Recommended)</strong></p>
<pre>{capture name=xxx assign=sid}news_{$entry->id}{/capture}
&lt;p class="links"&gt;
    [{$entry->morelink}] 
    [&lt;a href="{$entry->moreurl}#disqus_thread" 
       title="View comments" 
       data-disqus-identifier="{$sid}"&gt;
        Comments
    &lt;/a&gt;]
&lt;/p&gt;</pre>

<h5>With Custom Title</h5>
<pre>{$entry->title|cms_escape:htmlall assign=\'title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</pre>

<h4>CGBlog Integration</h4>

<h5>Blog Detail Template</h5>
<pre>&lt;!-- Your blog post content --&gt;
&lt;article class="blog-post"&gt;
    &lt;h1&gt;{$entry->title}&lt;/h1&gt;
    &lt;div class="post-content"&gt;{$entry->content}&lt;/div&gt;
    
    &lt;!-- Comments section --&gt;
    &lt;div class="blog-comments"&gt;
        {capture assign=blog_id}blog_{$entry->id}{/capture}
        {MAS_Disqus mas_disqus_identifier=$blog_id}
    &lt;/div&gt;
&lt;/article&gt;</pre>

<h5>Blog Summary with Counter</h5>
<pre>{capture assign=blog_id}blog_{$entry->id}{/capture}
&lt;div class="post-meta"&gt;
    &lt;a href="{$entry->moreurl}#disqus_thread" 
       data-disqus-identifier="{$blog_id}"&gt;
        View Comments
    &lt;/a&gt;
&lt;/div&gt;</pre>

<h4>Custom Content Integration</h4>

<h5>Generic Content Type</h5>
<pre>{capture assign=custom_id}content_{$item->id}{/capture}
{$item->title|cms_escape:htmlall assign=\'safe_title\'}
{MAS_Disqus mas_disqus_identifier=$custom_id mas_disqus_title=$safe_title}</pre>

<h5>Multiple Content Types on Same Site</h5>
<p>Use prefixes to keep discussions separate:</p>
<pre>&lt;!-- For News --&gt;
{capture assign=news_id}news_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$news_id}

&lt;!-- For Blog --&gt;
{capture assign=blog_id}blog_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$blog_id}

&lt;!-- For Custom Articles --&gt;
{capture assign=article_id}article_{$item->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$article_id}</pre>

<h3>6. Advanced Usage</h3>

<h4>Custom Identifiers</h4>

<h5>Understanding mas_disqus_identifier</h5>
<p>The <code>mas_disqus_identifier</code> parameter uniquely identifies each discussion. Best practices:</p>

<ul>
    <li><strong>Must be unique:</strong> Each content item needs a unique identifier</li>
    <li><strong>Should be permanent:</strong> Don\'t change identifiers after comments are posted</li>
    <li><strong>Use prefixes:</strong> Helps organize discussions by content type</li>
    <li><strong>Avoid special characters:</strong> Stick to alphanumeric and underscores</li>
</ul>

<h5>Why Use Prefixes?</h5>
<p>Prefixes like <code>news_</code>, <code>blog_</code>, <code>article_</code> help:</p>
<ul>
    <li>Prevent ID collisions between different content types</li>
    <li>Organize discussions in Disqus admin panel</li>
    <li>Migrate content between systems more easily</li>
    <li>Debug and troubleshoot issues faster</li>
</ul>

<h5>Example Prefixing Strategies</h5>
<pre>&lt;!-- Simple numeric ID --&gt;
{MAS_Disqus mas_disqus_identifier=$entry->id}

&lt;!-- Prefixed ID (recommended) --&gt;
{capture assign=nid}news_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$nid}

&lt;!-- Multi-level prefix --&gt;
{capture assign=cid}news_technology_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$cid}

&lt;!-- Slug-based identifier --&gt;
{capture assign=sid}news_{$entry->alias}{/capture}
{MAS_Disqus mas_disqus_identifier=$sid}</pre>

<h4>Custom URLs</h4>

<h5>When to Use mas_disqus_url</h5>
<p>Override the automatic URL detection when:</p>
<ul>
    <li>Using query parameters that create duplicate pages</li>
    <li>Content is accessible via multiple URLs</li>
    <li>Implementing canonical URLs for SEO</li>
    <li>Working with CDN or proxy setups</li>
</ul>

<h5>URL Examples</h5>
<pre>&lt;!-- Use canonical URL --&gt;
{capture assign=canonical_url}{cms_selflink}{/capture}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url=$canonical_url}

&lt;!-- Use absolute URL --&gt;
{capture assign=abs_url}https://yourdomain.com{$entry->url}{/capture}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url=$abs_url}</pre>

<h4>Custom Titles</h4>

<h5>Using mas_disqus_title</h5>
<p>Control the discussion title that appears in Disqus:</p>

<pre>&lt;!-- Basic title --&gt;
{$entry->title|cms_escape:htmlall assign=\'title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}

&lt;!-- Enhanced title with category --&gt;
{capture assign=full_title}{$category->name}: {$entry->title}{/capture}
{$full_title|cms_escape:htmlall assign=\'safe_title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$safe_title}

&lt;!-- SEO-optimized title --&gt;
{capture assign=seo_title}{$entry->title} - {$sitename}{/capture}
{$seo_title|cms_escape:htmlall assign=\'title\'}
{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</pre>

<h4>Category Integration</h4>

<h5>Using mas_disqus_category_id</h5>
<p>Map your CMSMS content to Disqus categories:</p>

<pre>&lt;!-- Map News category to Disqus category --&gt;
{if $entry->category_id == 1}
    {assign var=\'disqus_cat\' value=\'123456\'}
{elseif $entry->category_id == 2}
    {assign var=\'disqus_cat\' value=\'789012\'}
{/if}

{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_category_id=$disqus_cat}</pre>

<p><strong>Note:</strong> Disqus category IDs are found in your Disqus admin panel under Settings &gt; Community &gt; Categories.</p>

<h3>7. Tag Parameters Reference</h3>

<table border="1" cellpadding="8" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 10px 0;">
    <tr>
        <th style="background-color: #f0f0f0; text-align: left; width: 25%;">Parameter</th>
        <th style="background-color: #f0f0f0; text-align: left; width: 12%;">Type</th>
        <th style="background-color: #f0f0f0; text-align: left; width: 63%;">Description</th>
    </tr>
    <tr>
        <td><code>action</code></td>
        <td>String</td>
        <td>
            <strong>Optional.</strong> Controls display mode:<br>
            - Default (omitted): Shows comment thread<br>
            - <code>\'counter\'</code>: Loads comment counter script<br>
            <br>
            <strong>Example:</strong><br>
            <code>{MAS_Disqus action=\'counter\'}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_identifier</code></td>
        <td>String</td>
        <td>
            <strong>Required (except for counter).</strong> Unique identifier for the discussion.<br>
            - Must be unique per content item<br>
            - Should remain constant over time<br>
            - Best practice: use prefixes (news_, blog_)<br>
            <br>
            <strong>Examples:</strong><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id}</code><br>
            <code>{MAS_Disqus mas_disqus_identifier="news_{$entry->id}"}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_url</code></td>
        <td>String (URL)</td>
        <td>
            <strong>Optional.</strong> Override the page URL detected by Disqus.<br>
            - Must be a valid, absolute URL<br>
            - Useful for canonical URL implementation<br>
            - Helps prevent duplicate discussions<br>
            <br>
            <strong>Example:</strong><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url="https://yourdomain.com/news/{$entry->alias}"}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_title</code></td>
        <td>String</td>
        <td>
            <strong>Optional.</strong> Override the page title in Disqus.<br>
            - Appears in Disqus admin and notifications<br>
            - Should be properly escaped for HTML<br>
            - Useful for SEO and organization<br>
            <br>
            <strong>Examples:</strong><br>
            <code>{$entry->title|cms_escape:htmlall assign=\'title\'}</code><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</code>
        </td>
    </tr>
    <tr>
        <td><code>mas_disqus_category_id</code></td>
        <td>Integer</td>
        <td>
            <strong>Optional.</strong> Assign discussion to a Disqus category.<br>
            - Category ID from Disqus admin panel<br>
            - Helps organize discussions in Disqus<br>
            - Allows category-specific moderation rules<br>
            <br>
            <strong>Example:</strong><br>
            <code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_category_id=123456}</code>
        </td>
    </tr>
</table>

<h4>Complete Example with All Parameters</h4>
<pre>{capture assign=news_id}news_{$entry->id}{/capture}
{capture assign=canonical_url}https://yourdomain.com{$entry->url}{/capture}
{$entry->title|cms_escape:htmlall assign=\'safe_title\'}

{MAS_Disqus 
    mas_disqus_identifier=$news_id 
    mas_disqus_url=$canonical_url 
    mas_disqus_title=$safe_title 
    mas_disqus_category_id=123456}</pre>

<h3>8. Troubleshooting Guide</h3>

<h4>Comments Not Appearing</h4>
<p><strong>Possible causes and solutions:</strong></p>
<ul>
    <li><strong>Missing shortname:</strong> Verify shortname is entered in Settings tab</li>
    <li><strong>JavaScript disabled:</strong> Ensure visitor\'s browser has JavaScript enabled</li>
    <li><strong>Wrong identifier:</strong> Check that mas_disqus_identifier is properly set</li>
    <li><strong>Permissions:</strong> Verify "Use MAS_Disqus" permission is granted</li>
    <li><strong>Preview mode:</strong> Disqus is disabled in preview mode by default (recommended)</li>
    <li><strong>Browser cache:</strong> Clear browser cache and reload page</li>
    <li><strong>Firewall blocking:</strong> Check if firewall blocks Disqus servers</li>
</ul>

<h4>Counter Showing Incorrect Values</h4>
<p><strong>Common issues:</strong></p>
<ul>
    <li><strong>Counter script not loaded:</strong> Ensure <code>{MAS_Disqus action=\'counter\'}</code> is in your main template</li>
    <li><strong>Identifier mismatch:</strong> data-disqus-identifier in summary must match mas_disqus_identifier in detail</li>
    <li><strong>Cache delay:</strong> Disqus counters update every few minutes, not instantly</li>
    <li><strong>Missing anchor:</strong> Link must include <code>#disqus_thread</code> anchor</li>
</ul>

<h4>Permission Errors</h4>
<p><strong>Error: "Access Denied. Please check your permissions."</strong></p>
<ol>
    <li>Navigate to Users &amp; Groups &gt; Groups</li>
    <li>Edit the appropriate group</li>
    <li>Find "Use MAS_Disqus" permission</li>
    <li>Enable the checkbox</li>
    <li>Save group settings</li>
    <li>Log out and log back in</li>
</ol>

<h4>Multiple Comment Sections on Same Page</h4>
<p><strong>Problem:</strong> Multiple instances of MAS_Disqus tag on one page cause issues.</p>
<p><strong>Solution:</strong> Use only ONE MAS_Disqus tag per page (except for the counter action).</p>

<h4>Migration from Original Disqus Module</h4>
<p><strong>To preserve existing comments when migrating:</strong></p>
<ol>
    <li>Note the identifier format used in original module</li>
    <li>Use identical identifier format in MAS_Disqus</li>
    <li>Test on a single page first</li>
    <li>Verify comments appear correctly</li>
    <li>Roll out to remaining pages</li>
</ol>

<p><strong>Example:</strong> If original module used <code>disqus_identifier=$entry->id</code>, use <code>mas_disqus_identifier=$entry->id</code> (same value).</p>

<h4>JavaScript Conflicts</h4>
<p><strong>Symptoms:</strong> Disqus loads partially or not at all, console errors.</p>
<p><strong>Solutions:</strong></p>
<ul>
    <li>Check browser console for JavaScript errors</li>
    <li>Ensure jQuery or other libraries don\'t conflict</li>
    <li>Verify counter script is loaded after main content</li>
    <li>Test with other JavaScript temporarily disabled</li>
</ul>

<h4>Performance Considerations</h4>
<p><strong>Disqus can impact page load time:</strong></p>
<ul>
    <li>Disqus loads asynchronously (doesn\'t block page rendering)</li>
    <li>Consider lazy loading for pages with many comments</li>
    <li>Monitor page speed with tools like Google PageSpeed Insights</li>
    <li>Disqus embed is optimized but adds external resources</li>
</ul>

<h3>9. Best Practices</h3>

<h4>SEO Optimization</h4>
<ul>
    <li><strong>Use descriptive titles:</strong> Set mas_disqus_title to improve search visibility</li>
    <li><strong>Implement canonical URLs:</strong> Use mas_disqus_url to prevent duplicate content issues</li>
    <li><strong>Enable Disqus SEO features:</strong> Configure in Disqus admin panel</li>
    <li><strong>Monitor indexed comments:</strong> Disqus comments can be crawled by search engines</li>
</ul>

<h4>Performance Recommendations</h4>
<ul>
    <li><strong>Place counter script at page bottom:</strong> Improves perceived load time</li>
    <li><strong>Use caching wisely:</strong> Don\'t cache pages with user-specific comment data</li>
    <li><strong>Minimize identifier length:</strong> Shorter identifiers = slightly faster loading</li>
    <li><strong>Consider CDN:</strong> Use CDN for your site to improve global performance</li>
</ul>

<h4>Security Considerations</h4>
<ul>
    <li><strong>Escape titles:</strong> Always use <code>cms_escape:htmlall</code> on user-generated content</li>
    <li><strong>Validate identifiers:</strong> Ensure identifiers don\'t contain malicious code</li>
    <li><strong>Configure moderation:</strong> Set up comment moderation in Disqus admin</li>
    <li><strong>Monitor spam:</strong> Enable Disqus spam filtering features</li>
    <li><strong>Review permissions regularly:</strong> Audit who has "Use MAS_Disqus" permission</li>
</ul>

<h4>Content Organization Strategies</h4>
<ul>
    <li><strong>Consistent prefixing:</strong> Always use the same prefix pattern (news_, blog_, etc.)</li>
    <li><strong>Document your scheme:</strong> Keep a record of identifier formats used</li>
    <li><strong>Plan for migration:</strong> Choose identifiers that will remain valid long-term</li>
    <li><strong>Test before deploying:</strong> Verify comment threads on staging site first</li>
</ul>

<h4>Maintenance and Monitoring</h4>
<ul>
    <li><strong>Regular updates:</strong> Keep MAS_Disqus module updated</li>
    <li><strong>Monitor Disqus dashboard:</strong> Review comment activity and moderation queue</li>
    <li><strong>Backup discussions:</strong> Export comments periodically from Disqus</li>
    <li><strong>Test after upgrades:</strong> Verify functionality after CMSMS or module updates</li>
    <li><strong>Track performance:</strong> Monitor page load impact of Disqus embed</li>
</ul>

<h3>10. Frequently Asked Questions</h3>

<h4>Can I use this alongside the original Disqus module?</h4>
<p><strong>Yes!</strong> MAS_Disqus has an independent permission system and won\'t conflict with the original Disqus module. You can use both on the same site, though it\'s recommended to standardize on one for simplicity.</p>

<h4>How do I migrate from the original Disqus module?</h4>
<p>To preserve existing comments:</p>
<ol>
    <li>Identify the identifier format used in the original module</li>
    <li>Replace <code>{Disqus}</code> tags with <code>{MAS_Disqus}</code> tags</li>
    <li>Replace <code>disqus_identifier</code> with <code>mas_disqus_identifier</code> (keep the same value)</li>
    <li>Keep the same shortname</li>
    <li>Test on one page first to verify comments appear</li>
</ol>

<h4>Why aren\'t my comments showing up?</h4>
<p>Most common causes:</p>
<ul>
    <li>Shortname not configured or incorrect</li>
    <li>JavaScript disabled in browser</li>
    <li>Missing or incorrect identifier</li>
    <li>Viewing in preview mode (Disqus disabled by default)</li>
    <li>Missing permissions ("Use MAS_Disqus")</li>
</ul>
<p>See the Troubleshooting Guide (section 8) for detailed solutions.</p>

<h4>How do I customize the appearance?</h4>
<p>Disqus appearance is configured in your Disqus account:</p>
<ol>
    <li>Log into your Disqus account at disqus.com</li>
    <li>Go to Settings &gt; General</li>
    <li>Choose your color scheme and layout options</li>
    <li>Changes apply site-wide automatically</li>
</ol>
<p>For advanced customization, Disqus offers CSS customization (available with paid plans).</p>

<h4>Can I use different shortnames for different sections?</h4>
<p><strong>No.</strong> CMSMS modules are site-wide. You can only use one Disqus shortname per MAS_Disqus installation. However, you can:</p>
<ul>
    <li>Use Disqus categories to organize different sections</li>
    <li>Use identifier prefixes to distinguish content types</li>
    <li>Install multiple CMSMS instances for truly separate sites</li>
</ul>

<h4>How do I handle multilingual sites?</h4>
<p>For multilingual sites:</p>
<ul>
    <li><strong>Option 1:</strong> One discussion thread per content item (all languages see same comments)</li>
    <li><strong>Option 2:</strong> Add language code to identifier (news_en_123, news_no_123) for separate discussions</li>
    <li><strong>Option 3:</strong> Use Disqus language detection feature (configured in Disqus admin)</li>
</ul>

<pre>&lt;!-- Separate discussions per language --&gt;
{capture assign=lang_id}news_{$lang}_{$entry->id}{/capture}
{MAS_Disqus mas_disqus_identifier=$lang_id}</pre>

<h4>Is Disqus free?</h4>
<p>Disqus offers both free and paid plans:</p>
<ul>
    <li><strong>Basic (Free):</strong> Includes ads, suitable for most sites</li>
    <li><strong>Plus ($11/month):</strong> No ads, advanced moderation</li>
    <li><strong>Pro ($89/month):</strong> Premium features, custom CSS, priority support</li>
</ul>
<p>The free plan is sufficient for most CMSMS sites.</p>

<h4>Will Disqus slow down my site?</h4>
<p>Disqus loads asynchronously, so it doesn\'t block page rendering. However:</p>
<ul>
    <li>It adds external resources (JavaScript, CSS, images)</li>
    <li>Impact varies based on comment count and user\'s connection</li>
    <li>Most users won\'t notice significant slowdown</li>
    <li>Monitor with PageSpeed Insights for your specific case</li>
</ul>

<h4>Can I export my comments from Disqus?</h4>
<p><strong>Yes!</strong> Disqus provides export functionality:</p>
<ol>
    <li>Log into Disqus admin</li>
    <li>Go to Settings &gt; Export</li>
    <li>Request export (XML format)</li>
    <li>Receive download link via email</li>
</ol>
<p>Regular backups are recommended for important discussions.</p>

<h3>11. Version History &amp; Features</h3>

<h4>Version 1.1 (17.10.2025)</h4>
<p><strong>Major Update</strong> - Enhanced functionality and improved user experience:</p>
<ul>
    <li>Added Donations Tab with PayPal.me integration</li>
    <li>Implemented tabbed admin interface (Settings, Admin Settings, Donations)</li>
    <li>Enhanced error handling with inline validation messages</li>
    <li>Independent "Use MAS_Disqus" permission system</li>
    <li>Admin settings for donations tab visibility</li>
    <li>Sponsor recognition system</li>
    <li>Improved form validation and user feedback</li>
    <li>PHP 7.4-8.x compatibility (PHP 8.x recommended)</li>
    <li>Complete module independence from original Disqus module</li>
</ul>

<h4>Version 1.0 (August 2019)</h4>
<p>Initial release with core Disqus integration features:</p>
<ul>
    <li>Basic Disqus comment integration</li>
    <li>Comment counter functionality</li>
    <li>News/CGBlog integration support</li>
    <li>Custom identifier and title support</li>
</ul>

<h4>Upgrade Considerations</h4>
<p>When upgrading from v1.0 to v1.1:</p>
<ul>
    <li>No database changes required</li>
    <li>Existing settings preserved automatically</li>
    <li>New permissions appear automatically in group management</li>
    <li>No template changes needed</li>
    <li>Comment threads remain intact</li>
</ul>

<h4>Future Roadmap</h4>
<p>Planned features for future releases:</p>
<ul>
    <li>Recent comments widget</li>
    <li>Comment statistics dashboard</li>
    <li>Advanced caching options</li>
    <li>Lazy loading configuration</li>
    <li>Additional customization options</li>
</ul>

<p><em>Suggestions welcome! Contact us through the support channels below.</em></p>

<h3>12. Support &amp; Resources</h3>

<h4>Documentation &amp; Guides</h4>
<ul>
    <li><strong>This Help Page:</strong> Comprehensive module documentation (you are here!)</li>
    <li><strong>Disqus Official Docs:</strong> <a href="https://help.disqus.com" target="_blank">https://help.disqus.com</a></li>
    <li><strong>CMSMS Documentation:</strong> <a href="https://docs.cmsmadesimple.org" target="_blank">https://docs.cmsmadesimple.org</a></li>
</ul>

<h4>Key Disqus Resources</h4>
<ul>
    <li><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables" target="_blank">JavaScript Configuration Variables</a></li>
    <li><a href="https://help.disqus.com/customer/portal/articles/472099-what-is-a-shortname" target="_blank">What is a Shortname?</a></li>
    <li><a href="https://help.disqus.com/customer/portal/articles/472007-i-m-receiving-the-message-we-were-unable-to-load-disqus-" target="_blank">Troubleshooting: Unable to Load Disqus</a></li>
</ul>

<h4>Module Support</h4>
<p><strong>Contact:</strong> Master3395<br>
<strong>Email:</strong> info [at] newstargeted [dot] com<br>
<strong>Website:</strong> <a href="https://newstargeted.com/contact/" target="_blank">https://newstargeted.com/contact/</a></p>

<h4>Community Support</h4>
<ul>
    <li><strong>CMSMS Forums:</strong> <a href="https://forum.cmsmadesimple.org" target="_blank">https://forum.cmsmadesimple.org</a></li>
    <li><strong>CMSMS Slack:</strong> Join the CMSMS community Slack channel</li>
</ul>

<h4>Bug Reports &amp; Feature Requests</h4>
<p>Found a bug or have a feature suggestion? Please contact us with:</p>
<ul>
    <li>Detailed description of the issue or feature</li>
    <li>Steps to reproduce (for bugs)</li>
    <li>Your CMSMS and PHP versions</li>
    <li>MAS_Disqus module version</li>
    <li>Any error messages from browser console</li>
</ul>

<h4>Support Development</h4>
<p>If you find MAS_Disqus valuable, please consider:</p>
<ul>
    <li><strong>Donating:</strong> Use the Donations tab to support continued development</li>
    <li><strong>Sponsorship:</strong> Donate 30€+ for recognition with your company link</li>
    <li><strong>Spreading the word:</strong> Tell other CMSMS users about MAS_Disqus</li>
    <li><strong>Contributing:</strong> Help improve documentation or testing</li>
</ul>

<p><strong>Current Sponsors:</strong></p>
<ul>
    <li><a href="https://newstargeted.com" target="_blank">News Targeted</a> - Thank you for your support!</li>
</ul>

<h3>13. Copyright &amp; License</h3>

<h4>Copyright Notice</h4>
<p>Copyright &copy; 2019-2025, Master3395. All Rights Reserved.<br>
Email: info [at] newstargeted [dot] com<br>
Website: <a href="https://newstargeted.com/contact/" target="_blank">https://newstargeted.com/contact/</a></p>

<h4>License</h4>
<p>This module has been released under the <a href="https://www.gnu.org/licenses/licenses.html#GPL" target="_blank">GNU General Public License v3.0</a>.</p>

<p><strong>You are free to:</strong></p>
<ul>
    <li>Use this module for personal or commercial projects</li>
    <li>Modify the module to suit your needs</li>
    <li>Distribute copies of the module</li>
</ul>

<p><strong>Under the following conditions:</strong></p>
<ul>
    <li>You must agree to the GPL license terms before using the module</li>
    <li>Any modifications must also be released under GPL</li>
    <li>You must preserve copyright notices</li>
    <li>This module is provided "as is" without warranty</li>
</ul>

<h4>Module Independence</h4>
<p>MAS_Disqus is completely independent from the original Disqus module for CMSMS. It was developed as an enhanced alternative with additional features and improved administration. Both modules can coexist on the same CMSMS installation without conflicts.</p>

<h4>Third-Party Services</h4>
<p>This module integrates with Disqus (disqus.com), a third-party commenting platform. Use of Disqus is subject to Disqus\'s own terms of service and privacy policy. Please review these before implementing Disqus on your site:</p>
<ul>
    <li><a href="https://help.disqus.com/terms-and-policies/terms-of-service" target="_blank">Disqus Terms of Service</a></li>
    <li><a href="https://help.disqus.com/terms-and-policies/disqus-privacy-policy" target="_blank">Disqus Privacy Policy</a></li>
</ul>

<h4>Disclaimer</h4>
<p>This program is distributed in the hope that it will be useful, but <strong>WITHOUT ANY WARRANTY</strong>; without even the implied warranty of <strong>MERCHANTABILITY</strong> or <strong>FITNESS FOR A PARTICULAR PURPOSE</strong>. See the GNU General Public License for more details.</p>

<hr style="margin: 20px 0; border: none; border-top: 2px solid #ccc;">

<p style="text-align: center; margin-top: 20px; font-size: 0.9em; color: #666;">
    <strong>MAS_Disqus v1.1</strong> | 
    Enhanced Disqus Integration for CMS Made Simple
</p>

</div>
';

$lang['title_d_Shortname_help'] = 'Disqus\'s Shortname';
$lang['title_isPreviewBlocked_help'] = 'enable disqus even in the preview mode (not recommended)';
$lang['title_test'] = 'See the result in the box below';


$lang['help_action'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Required</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Description</td></tr><tr><td>String</td><td>Optional</td><td><strong>Controls display mode:</strong><br/>- Default (omitted): Shows comment thread<br/>- \'counter\': Loads comment counter script<br/><br/><strong>Example:</strong><br/><code>{MAS_Disqus action=\'counter\'}</code></td></tr></table>';

$lang['help_disqus_identifier'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Required</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Description</td></tr><tr><td>String</td><td>Required (except counter)</td><td><strong>Unique identifier for the discussion.</strong><br/>- Must be unique per content item<br/>- Should remain constant over time<br/>- Best practice: use prefixes (news_, content_)<br/><br/><strong>Examples:</strong><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id}</code><br/><code>{MAS_Disqus mas_disqus_identifier="news_{$entry->id}"}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_identifier">See more information on the Disqus documentation</a></td></tr></table>';
$lang['help_disqus_url'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Required</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Description</td></tr><tr><td>String (URL)</td><td>Optional</td><td><strong>Override the page URL detected by Disqus.</strong><br/>- Must be a valid, absolute URL<br/>- Useful for canonical URL implementation<br/>- Helps prevent duplicate discussions<br/><br/><strong>Example:</strong><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_url="https://yourdomain.com/news/{$entry->alias}"}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_url">See more information on the Disqus documentation</a></td></tr></table>';
$lang['help_disqus_title'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Required</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Description</td></tr><tr><td>String</td><td>Optional</td><td><strong>Override the page title in Disqus.</strong><br/>- Appears in Disqus admin and notifications<br/>- Should be properly escaped for HTML<br/>- Useful for SEO and organization<br/><br/><strong>Examples:</strong><br/><code>{$entry->title|cms_escape:htmlall assign=\'title\'}</code><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_title=$title}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_title">See more information on the Disqus documentation</a></td></tr></table>';
$lang['help_disqus_category_id'] = '<table border="1" cellpadding="5" cellspacing="0" style="border-collapse: collapse; width: 100%; margin: 5px 0; font-size: 0.9em;"><tr><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Type</td><td style="background-color: #f0f0f0; font-weight: bold; width: 20%;">Required</td><td style="background-color: #f0f0f0; font-weight: bold; width: 60%;">Description</td></tr><tr><td>Integer</td><td>Optional</td><td><strong>Assign discussion to a Disqus category.</strong><br/>- Category ID from Disqus admin panel<br/>- Helps organize discussions in Disqus<br/>- Allows category-specific moderation rules<br/><br/><strong>Example:</strong><br/><code>{MAS_Disqus mas_disqus_identifier=$entry->id mas_disqus_category_id=123456}</code><br/><br/><a href="https://help.disqus.com/customer/portal/articles/472098-javascript-configuration-variables#disqus_category_id">See more information on the Disqus documentation</a></td></tr></table>';

// Donations tab language strings
$lang['donationstab'] = 'Donations';
$lang['donationstext'] = 'A lot of time and effort has been put into creating this module. Please consider a small donation (5€ for instance, or what you can spare) using the PayPal-button below, especially if you use this module in a commercial context. If you donate more than 30€ you can have a link to your company on this page, if you wish to. Send me an email about what you would like shown and I will put it in for the next version. Thank you!';
$lang['sponsors'] = 'Current sponsors, thank you for your support!';
$lang['hidedonationssubmit'] = 'Hide donations tab';

// Settings tab language strings
$lang['settings'] = 'Settings';
$lang['showdonationstab'] = 'Show donations tab';
$lang['settingsupdated'] = 'Settings updated successfully';

// Validation error messages
$lang['shortname_empty'] = 'Disqus Shortname cannot be empty.';


?>
