<?php

if (!function_exists('cmsms')) exit;

if (! $this->VisibleToAdminUser()) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

// Handle hiding donations tab
if (isset($params["hidedonationssubmit"])) {
  $this->SetPreference("hidedonationstab",$this->GetVersion());
}

// Handle global success messages only (errors will be shown inline)
if (!empty($params['msg'])){
	echo $this->ShowMessage($this->Lang($params['msg']));
}

$activetab="";
if (isset($params["activetab"])) $activetab=$params["activetab"];

echo $this->StartTabHeaders();
echo $this->SetTabHeader("settings",$this->Lang('settings'),($activetab=="" || $activetab=="settings"));
echo $this->SetTabHeader("adminsettings","Admin Settings",($activetab=="adminsettings"));
if ($this->ShowDonationsTab()) {
  echo $this->SetTabHeader("donations",$this->Lang('donationstab'),($activetab=="donations"));
}
echo $this->EndTabHeaders();

echo $this->StartTabContent();

// Settings tab
echo $this->StartTab("settings");
// Content defines and Form stuff for the admin
$smarty->assign('start_form', $this->CreateFormStart($id, 'admin_save', $returnid));
$smarty->assign('input_d_shortname',$this->CreateInputText($id, 'd_shortname', $this->GetPreference('d_shortname','')));
$smarty->assign('input_isPreviewBlocked',$this->CreateInputCheckbox($id, 'isPreviewBlocked','1' , $this->GetPreference('isPreviewBlocked','0')). $this->Lang('title_isPreviewBlocked_help'));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->lang('submit')));
$smarty->assign('end_form', $this->CreateFormEnd());
$smarty->assign('title_test', $this->lang('title_test'));

// Handle inline error message
$error_message = '';
if (!empty($params['err']) && $params['err'] == 'shortname_empty') {
  $error_message = $this->Lang('shortname_empty');
}
$smarty->assign('error_message', $error_message);

echo $this->ProcessTemplate('settings.tpl');
echo "<div style='width:500px;border:1px solid #CCC; padding : 10px;'>";
include_once(dirname(__FILE__).'/action.default.php');
echo "</div>";
echo $this->EndTab();

// Admin Settings tab
echo $this->StartTab("adminsettings");
include(dirname(__FILE__)."/function.admin_settings.php");
echo $this->EndTab();

// Donations tab
if ($this->ShowDonationsTab()) {
  echo $this->StartTab("donations");
  include(dirname(__FILE__)."/function.donations.php");
  echo $this->EndTab();
}

echo $this->EndTabContent();
?>