<?php

if (!function_exists('cmsms')) exit;

if (!$this->VisibleToAdminUser()) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

// Validate shortname parameter
$shortname = isset($params['d_shortname']) ? trim($params['d_shortname']) : '';
if (empty($shortname)) {
  $this->Redirect($id, 'defaultadmin', $returnid, array('err' => 'shortname_empty', 'activetab' => 'settings'));
  return;
}

// Get other parameters
$isPreviewBlocked = isset($params['isPreviewBlocked']) ? $params['isPreviewBlocked'] : '0';

// Save preferences
$this->SetPreference('d_shortname', $shortname);
$this->SetPreference('isPreviewBlocked', $isPreviewBlocked);

// put mention into the admin log
$this->Audit( 0, 
	      $this->Lang('friendlyname'), 
	      $this->Lang('prefsupdated') );

// redirect back to admin with success message
$this->Redirect($id, 'defaultadmin', $returnid, array('msg' => 'prefsupdated', 'activetab' => 'settings'));

?>