<?php
/**
 * 
 * 7. Input parameter sanitizing
 * -----------------------------
 * 
 * Starting from 1.1 version of CMSMS module developers are urged to take closer
 * look of what parameters their module accepts and how they are sanitized.
 * 
 * Few new API functions are introduced, all parameters should be mapped for
 * everything to work smoothly. Use $this->SetParameterType('paramname',TYPE); 
 * to clean your input parameters (possible types are CLEAN_INT, CLEAN_STRING,
 * CLEAN_FLOAT, CLEAN_STRING)
 */

class MAS_Disqus extends CMSModule
{
  function GetName() {
    return 'MAS_Disqus';
  }
  
  function GetFriendlyName() {
    return $this->Lang('friendlyname');
  }

  function GetVersion() {
    return '1.1.1';
  }
  
  function GetHelp() {
    return $this->Lang('help');
  }
  
  function GetAuthor() {
    return 'master3395';
  }

  function GetAuthorEmail() {
    return 'info [at] newstargeted [dot] com';
  }

  function GetAuthorUrl() {
    return 'https://newstargeted.com/contact/';
  }
  
  function GetChangeLog() {
    return $this->Lang('changelog');
  }
  
  function IsPluginModule() {
    return true;
  }

  function HasAdmin() {
    return true;
  }
  
  function GetAdminSection() {
    return 'extensions';
  }

  function GetAdminDescription() {
    return $this->Lang('moddescription');
  }

  function VisibleToAdminUser() {
    return $this->CheckPermission('Use MAS_Disqus');
  }
  
  function GetDependencies() {
    return array();
  }

  function MinimumCMSVersion() {
    return "2.2.10";
  }

  function GetMinimumPHPVersion() {
    return "7.4.0";
  }

  function InitializeFrontend() {
    $this->RegisterModulePlugin(true, false); 

    $this->RestrictUnknownParams();
    
    $this->SetParameterType('action',CLEAN_STRING);
    $this->SetParameterType('mas_disqus_identifier',CLEAN_STRING);
    $this->SetParameterType('mas_disqus_url',CLEAN_STRING);
    $this->SetParameterType('mas_disqus_title',CLEAN_STRING);
    $this->SetParameterType('mas_disqus_category_id',CLEAN_INT);
  }

  function InitializeAdmin() {

    $this->CreateParameter('action', 'default', $this->Lang('help_action'));
    $this->CreateParameter('mas_disqus_identifier', 'null', $this->Lang('help_disqus_identifier'));
    $this->CreateParameter('mas_disqus_url','null',$this->Lang('help_disqus_url'));
    $this->CreateParameter('mas_disqus_title','null',$this->Lang('help_disqus_title'));
    $this->CreateParameter('mas_disqus_category_id','null',$this->Lang('help_disqus_category_id'));
  }

  function RegisterEvents() {

  }

  function InstallPostMessage() {
    return $this->Lang('postinstall');
  }

  function UninstallPostMessage() {
    return $this->Lang('postuninstall');
  }

  function UninstallPreMessage() {
    return $this->Lang('really_uninstall');
  }

  function ShowDonationsTab() {
    return ($this->GetPreference("hidedonationstab")!=$this->GetVersion());
  }
}
?>
