 <?php
 
# IwPopupManager -class.PopupItem.php
#
# Author : Infowebs - Musiscore
# Release : 0.2
#
# Release History
# Code Release		: 0.1		17-07-2025	- Initial Alpha Release
# Code Release		: 0.2		20-07-2025	- Added Pause option		
# Code Release		: 0.3		20-07-2025	- Added Duration option / Correct multiple typos		
# -----------------------------------------------------------------------
 class PopupItem
 {
    private $_data = array('id'=>null,'name'=>null,'description'=>null,'content'=>null,'active'=>null,'pause'=>null,'duration'=>null);
    public function __get($key)
    {
        switch( $key ) {
        case 'id':
        case 'name':
        case 'description':
		case 'content':
        case 'active':
		case 'pause':
		case 'duration':
            return $this->_data[$key];
        }
    }
    public function __set($key,$val)
    {
        switch( $key ) {
        case 'name':
        case 'description':
            $this->_data[$key] = trim($val);
            break;
        case 'content':
            $this->_data[$key] = trim($val);
            break;
        case 'active':
            $this->_data[$key] = trim($val);
            break;
		case 'pause':
            $this->_data[$key] = trim($val);
            break;
		case 'duration':
            $this->_data[$key] = trim($val);
            break;
        }
    }
    public function save()
    {
        if( !$this->is_valid() ) return FALSE;
        if( $this->id > 0 ) {
            $this->update();
        } else {
            $this->insert();
        }
    }
    public function is_valid()
    {
        if( !$this->name ) return false;
        return TRUE;
    }
    protected function insert()
    {
        echo "Active = $this->active";
		echo "Name = $this->name";
		$db = \cms_utils::get_db();
        $sql = 'INSERT INTO '.CMS_DB_PREFIX.'mod_iwpopupmanager (name,description,content,active, pause, duration) VALUES (?,?,?,?,?,?)';
        $dbr = $db->Execute($sql,array($this->name,$this->description,$this->content,$this->active,$this->pause, $this->duration));
        if( !$dbr ) return FALSE;
        $this->_data['id'] = $db->Insert_ID();
        return TRUE;
    }
    protected function update()
    {
        $db = \cms_utils::get_db();
        $sql = 'UPDATE '.CMS_DB_PREFIX.'mod_iwpopupmanager SET name = ?, description = ?, content = ?, active = ?, pause = ?, duration = ? WHERE id = ?';
        $dbr = $db->Execute($sql,array($this->name,$this->description,$this->content,$this->active,$this->pause,$this->duration,$this->id));
        if( !$dbr ) return FALSE;
        return TRUE;
    }
    public function delete()
    {
        if( !$this->id ) return FALSE;
        $db = \cms_utils::get_db();
        $sql = 'DELETE FROM '.CMS_DB_PREFIX.'mod_iwpopupmanager WHERE id = ?';
        $dbr = $db->Execute($sql,array($this->id));
        if( !$dbr ) return FALSE;
        $this->_data['id'] = null;
        return TRUE;
    }
    /** internal */
    public function fill_from_array($row)
    {
        foreach( $row as $key => $val ) {
            if( array_key_exists($key,$this->_data) ) {
                $this->_data[$key] = $val;
            }
        }
    }
 public static function &load_by_id($id)
    {
        $id = (int) $id;
        $db = \cms_utils::get_db();
        $sql = 'SELECT * FROM '.CMS_DB_PREFIX.'mod_iwpopupmanager WHERE id = ?';
        $row = $db->GetRow($sql,array($id));
        if( is_array($row) ) {
            $obj = new self();
            $obj->fill_from_array($row);
            return $obj;
        }
    }
 }
 ?>