<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.0
*/function
adminer_errors($cc,$ec){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$ec);}error_reporting(6135);set_error_handler('adminer_errors',2);$wc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($wc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$eh=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($eh)$$X=$eh;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$f;return$f;}function
adminer(){global$b;return$b;}function
version(){global$ga;return$ga;}function
idf_unescape($w){$ud=substr($w,-1);return
str_replace($ud.$ud,$ud,substr($w,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($jf,$wc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($_,$X)=each($jf)){foreach($X
as$md=>$W){unset($jf[$_][$md]);if(is_array($W)){$jf[$_][stripslashes($md)]=$W;$jf[]=&$jf[$_][stripslashes($md)];}else$jf[$_][stripslashes($md)]=($wc?$W:stripslashes($W));}}}}function
bracket_escape($w,$Aa=false){static$Rg=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($w,($Aa?array_flip($Rg):$Rg));}function
min_version($th,$Gd="",$g=null){global$f;if(!$g)$g=$f;$Rf=$g->server_info;if($Gd&&preg_match('~([\d.]+)-MariaDB~',$Rf,$D)){$Rf=$D[1];$th=$Gd;}return(version_compare($Rf,$th)>=0);}function
charset($f){return(min_version("5.5.3",0,$f)?"utf8mb4":"utf8");}function
script($ag,$Qg="\n"){return"<script".nonce().">$ag</script>$Qg";}function
script_src($jh){return"<script src='".h($jh)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($kg){return
str_replace("\0","&#0;",htmlspecialchars($kg,ENT_QUOTES,'utf-8'));}function
nl_br($kg){return
str_replace("\n","<br>",$kg);}function
checkbox($F,$Y,$Oa,$qd="",$re="",$Sa="",$rd=""){$K="<input type='checkbox' name='$F' value='".h($Y)."'".($Oa?" checked":"").($rd?" aria-labelledby='$rd'":"").">".($re?script("qsl('input').onclick = function () { $re };",""):"");return($qd!=""||$Sa?"<label".($Sa?" class='$Sa'":"").">$K".h($qd)."</label>":$K);}function
optionlist($ve,$Mf=null,$nh=false){$K="";foreach($ve
as$md=>$W){$we=array($md=>$W);if(is_array($W)){$K.='<optgroup label="'.h($md).'">';$we=$W;}foreach($we
as$_=>$X)$K.='<option'.($nh||is_string($_)?' value="'.h($_).'"':'').(($nh||is_string($_)?(string)$_:$X)===$Mf?' selected':'').'>'.h($X);if(is_array($W))$K.='</optgroup>';}return$K;}function
html_select($F,$ve,$Y="",$qe=true,$rd=""){if($qe)return"<select name='".h($F)."'".($rd?" aria-labelledby='$rd'":"").">".optionlist($ve,$Y)."</select>".(is_string($qe)?script("qsl('select').onchange = function () { $qe };",""):"");$K="";foreach($ve
as$_=>$X)$K.="<label><input type='radio' name='".h($F)."' value='".h($_)."'".($_==$Y?" checked":"").">".h($X)."</label>";return$K;}function
select_input($xa,$ve,$Y="",$qe="",$We=""){$zg=($ve?"select":"input");return"<$zg$xa".($ve?"><option value=''>$We".optionlist($ve,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$We'>").($qe?script("qsl('$zg').onchange = $qe;",""):"");}function
confirm($E="",$Nf="qsl('input')"){return
script("$Nf.onclick = function () { return confirm('".($E?js_escape($E):lang(0))."'); };","");}function
print_fieldset($v,$zd,$wh=false){echo"<fieldset><legend>","<a href='#fieldset-$v'>$zd</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$v');",""),"</legend>","<div id='fieldset-$v'".($wh?"":" class='hidden'").">\n";}function
bold($Ha,$Sa=""){return($Ha?" class='active $Sa'":($Sa?" class='$Sa'":""));}function
odd($K=' class="odd"'){static$u=0;if(!$K)$u=-1;return($u++%2?$K:'');}function
js_escape($kg){return
addcslashes($kg,"\r\n'\\/");}function
json_row($_,$X=null){static$xc=true;if($xc)echo"{";if($_!=""){echo($xc?"":",")."\n\t\"".addcslashes($_,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$xc=false;}else{echo"\n}\n";$xc=true;}}function
ini_bool($ad){$X=ini_get($ad);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$K;if($K===null)$K=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$K;}function
set_password($sh,$O,$V,$Re){$_SESSION["pwds"][$sh][$O][$V]=($_COOKIE["adminer_key"]&&is_string($Re)?array(encrypt_string($Re,$_COOKIE["adminer_key"])):$Re);}function
get_password(){$K=get_session("pwds");if(is_array($K))$K=($_COOKIE["adminer_key"]?decrypt_string($K[0],$_COOKIE["adminer_key"]):false);return$K;}function
q($kg){global$f;return$f->quote($kg);}function
get_vals($I,$c=0){global$f;$K=array();$J=$f->query($I);if(is_object($J)){while($L=$J->fetch_row())$K[]=$L[$c];}return$K;}function
get_key_vals($I,$g=null,$Uf=true){global$f;if(!is_object($g))$g=$f;$K=array();$J=$g->query($I);if(is_object($J)){while($L=$J->fetch_row()){if($Uf)$K[$L[0]]=$L[1];else$K[]=$L[0];}}return$K;}function
get_rows($I,$g=null,$l="<p class='error'>"){global$f;$gb=(is_object($g)?$g:$f);$K=array();$J=$gb->query($I);if(is_object($J)){while($L=$J->fetch_assoc())$K[]=$L;}elseif(!$J&&!is_object($g)&&$l&&defined("PAGE_HEADER"))echo$l.error()."\n";return$K;}function
unique_array($L,$y){foreach($y
as$x){if(preg_match("~PRIMARY|UNIQUE~",$x["type"])){$K=array();foreach($x["columns"]as$_){if(!isset($L[$_]))continue
2;$K[$_]=$L[$_];}return$K;}}}function
escape_key($_){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$_,$D))return$D[1].idf_escape(idf_unescape($D[2])).$D[3];return
idf_escape($_);}function
where($Z,$n=array()){global$f,$z;$K=array();foreach((array)$Z["where"]as$_=>$X){$_=bracket_escape($_,1);$c=escape_key($_);$K[]=$c.($z=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($z=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n[$_],q($X))));if($z=="sql"&&preg_match('~char|text~',$n[$_]["type"])&&preg_match("~[^ -@]~",$X))$K[]="$c = ".q($X)." COLLATE ".charset($f)."_bin";}foreach((array)$Z["null"]as$_)$K[]=escape_key($_)." IS NULL";return
implode(" AND ",$K);}function
where_check($X,$n=array()){parse_str($X,$Na);remove_slashes(array(&$Na));return
where($Na,$n);}function
where_link($u,$c,$Y,$se="="){return"&where%5B$u%5D%5Bcol%5D=".urlencode($c)."&where%5B$u%5D%5Bop%5D=".urlencode(($Y!==null?$se:"IS NULL"))."&where%5B$u%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($d,$n,$N=array()){$K="";foreach($d
as$_=>$X){if($N&&!in_array(idf_escape($_),$N))continue;$va=convert_field($n[$_]);if($va)$K.=", $va AS ".idf_escape($_);}return$K;}function
cookie($F,$Y,$Bd=2592000){global$ba;return
header("Set-Cookie: $F=".urlencode($Y).($Bd?"; expires=".gmdate("D, d M Y H:i:s",time()+$Bd)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))@session_start();}function
stop_session($zc=false){$mh=ini_bool("session.use_cookies");if(!$mh||$zc){session_write_close();if($mh&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($_){return$_SESSION[$_][DRIVER][SERVER][$_GET["username"]];}function
set_session($_,$X){$_SESSION[$_][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($sh,$O,$V,$j=null){global$Kb;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($Kb))."|username|".($j!==null?"db|":"").session_name()),$D);return"$D[1]?".(sid()?SID."&":"").($sh!="server"||$O!=""?urlencode($sh)."=".urlencode($O)."&":"")."username=".urlencode($V).($j!=""?"&db=".urlencode($j):"").($D[2]?"&$D[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($C,$E=null){if($E!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($C!==null?$C:$_SERVER["REQUEST_URI"]))][]=$E;}if($C!==null){if($C=="")$C=".";header("Location: $C");exit;}}function
query_redirect($I,$C,$E,$rf=true,$jc=true,$qc=false,$Fg=""){global$f,$l,$b;if($jc){$gg=microtime(true);$qc=!$f->query($I);$Fg=format_time($gg);}$cg="";if($I)$cg=$b->messageQuery($I,$Fg,$qc);if($qc){$l=error().$cg.script("messagesPrint();");return
false;}if($rf)redirect($C,$E.$cg);return
true;}function
queries($I){global$f;static$mf=array();static$gg;if(!$gg)$gg=microtime(true);if($I===null)return
array(implode("\n",$mf),format_time($gg));$mf[]=(preg_match('~;$~',$I)?"DELIMITER ;;\n$I;\nDELIMITER ":$I).";";return$f->query($I);}function
apply_queries($I,$S,$fc='table'){foreach($S
as$Q){if(!queries("$I ".$fc($Q)))return
false;}return
true;}function
queries_redirect($C,$E,$rf){list($mf,$Fg)=queries(null);return
query_redirect($mf,$C,$E,$rf,false,!$rf,$Fg);}function
format_time($gg){return
lang(1,max(0,microtime(true)-$gg));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Je=""){return
substr(preg_replace("~(?<=[?&])($Je".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($G,$rb){return" ".($G==$rb?$G+1:'<a href="'.h(remove_from_uri("page").($G?"&page=$G".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($G+1)."</a>");}function
get_file($_,$zb=false){$uc=$_FILES[$_];if(!$uc)return
null;foreach($uc
as$_=>$X)$uc[$_]=(array)$X;$K='';foreach($uc["error"]as$_=>$l){if($l)return$l;$F=$uc["name"][$_];$Ng=$uc["tmp_name"][$_];$hb=file_get_contents($zb&&preg_match('~\.gz$~',$F)?"compress.zlib://$Ng":$Ng);if($zb){$gg=substr($hb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$gg,$xf))$hb=iconv("utf-16","utf-8",$hb);elseif($gg=="\xEF\xBB\xBF")$hb=substr($hb,3);$K.=$hb."\n\n";}else$K.=$hb;}return$K;}function
upload_error($l){$Md=($l==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($l?lang(2).($Md?" ".lang(3,$Md):""):lang(4));}function
repeat_pattern($Te,$_d){return
str_repeat("$Te{0,65535}",$_d/65535)."$Te{0,".($_d%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($kg,$_d=80,$og=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$_d).")($)?)u",$kg,$D))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$_d).")($)?)",$kg,$D);return
h($D[1]).$og.(isset($D[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($jf,$Wc=array(),$cf=''){$K=false;foreach($jf
as$_=>$X){if(!in_array($_,$Wc)){if(is_array($X))hidden_fields($X,array(),$_);else{$K=true;echo'<input type="hidden" name="'.h($cf?$cf."[$_]":$_).'" value="'.h($X).'">';}}}return$K;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$rc=false){$K=table_status($Q,$rc);return($K?$K:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$K=array();foreach($b->foreignKeys($Q)as$o){foreach($o["source"]as$X)$K[$X][]=$o;}return$K;}function
enum_input($U,$xa,$m,$Y,$Yb=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$Hd);$K=($Yb!==null?"<label><input type='$U'$xa value='$Yb'".((is_array($Y)?in_array($Yb,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Hd[1]as$u=>$X){$X=stripcslashes(str_replace("''","'",$X));$Oa=(is_int($Y)?$Y==$u+1:(is_array($Y)?in_array($u+1,$Y):$Y===$X));$K.=" <label><input type='$U'$xa value='".($u+1)."'".($Oa?' checked':'').'>'.h($b->editVal($X,$m)).'</label>';}return$K;}function
input($m,$Y,$r){global$Zg,$b,$z;$F=h(bracket_escape($m["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$ua=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$ua[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$ua);$r="json";}$zf=($z=="mssql"&&$m["auto_increment"]);if($zf&&!$_POST["save"])$r=null;$Fc=(isset($_GET["select"])||$zf?array("orig"=>lang(8)):array())+$b->editFunctions($m);$xa=" name='fields[$F]'";if($m["type"]=="enum")echo
h($Fc[""])."<td>".$b->editInput($_GET["edit"],$m,$xa,$Y);else{$Nc=(in_array($r,$Fc)||isset($Fc[$r]));echo(count($Fc)>1?"<select name='function[$F]'>".optionlist($Fc,$r===null||$Nc?$r:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Fc))).'<td>';$cd=$b->editInput($_GET["edit"],$m,$xa,$Y);if($cd!="")echo$cd;elseif(preg_match('~bool~',$m["type"]))echo"<input type='hidden'$xa value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$xa value='1'>";elseif($m["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$Hd);foreach($Hd[1]as$u=>$X){$X=stripcslashes(str_replace("''","'",$X));$Oa=(is_int($Y)?($Y>>$u)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$F][$u]' value='".(1<<$u)."'".($Oa?' checked':'').">".h($b->editVal($X,$m)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$m["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$F'>";elseif(($Dg=preg_match('~text|lob|memo~i',$m["type"]))||preg_match("~\n~",$Y)){if($Dg&&$z!="sqlite")$xa.=" cols='50' rows='12'";else{$M=min(12,substr_count($Y,"\n")+1);$xa.=" cols='30' rows='$M'".($M==1?" style='height: 1.2em;'":"");}echo"<textarea$xa>".h($Y).'</textarea>';}elseif($r=="json"||preg_match('~^jsonb?$~',$m["type"]))echo"<textarea$xa cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Od=(!preg_match('~int~',$m["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$m["length"],$D)?((preg_match("~binary~",$m["type"])?2:1)*$D[1]+($D[3]?1:0)+($D[2]&&!$m["unsigned"]?1:0)):($Zg[$m["type"]]?$Zg[$m["type"]]+($m["unsigned"]?0:1):0));if($z=='sql'&&min_version(5.6)&&preg_match('~time~',$m["type"]))$Od+=7;echo"<input".((!$Nc||$r==="")&&preg_match('~(?<!o)int(?!er)~',$m["type"])&&!preg_match('~\[\]~',$m["full_type"])?" type='number'":"")." value='".h($Y)."'".($Od?" data-maxlength='$Od'":"").(preg_match('~char|binary~',$m["type"])&&$Od>20?" size='40'":"")."$xa>";}echo$b->editHint($_GET["edit"],$m,$Y);$xc=0;foreach($Fc
as$_=>$X){if($_===""||!$X)break;$xc++;}if($xc)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $xc), oninput: function () { this.onchange(); }});");}}function
process_input($m){global$b,$k;$w=bracket_escape($m["field"]);$r=$_POST["function"][$w];$Y=$_POST["fields"][$w];if($m["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($m["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?idf_escape($m["field"]):false);if($r=="NULL")return"NULL";if($m["type"]=="set")return
array_sum((array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$m["type"])&&ini_bool("file_uploads")){$uc=get_file("fields-$w");if(!is_string($uc))return
false;return$k->quoteBinary($uc);}return$b->processInput($m,$Y,$r);}function
fields_from_edit(){global$k;$K=array();foreach((array)$_POST["field_keys"]as$_=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$_];$_POST["fields"][$X]=$_POST["field_vals"][$_];}}foreach((array)$_POST["fields"]as$_=>$X){$F=bracket_escape($_,1);$K[$F]=array("field"=>$F,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($_==$k->primary),);}return$K;}function
search_tables(){global$b,$f;$_GET["where"][0]["val"]=$_POST["query"];$Pf="<ul>\n";foreach(table_status('',true)as$Q=>$R){$F=$b->tableName($R);if(isset($R["Engine"])&&$F!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$J=$f->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$J||$J->fetch_row()){$ff="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$F</a>";echo"$Pf<li>".($J?$ff:"<p class='error'>$ff: ".error())."\n";$Pf="";}}}echo($Pf?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Vc,$Vd=false){global$b;$K=$b->dumpHeaders($Vc,$Vd);$Ge=$_POST["output"];if($Ge!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Vc).".$K".($Ge!="file"&&preg_match('~^[0-9a-z]+$~',$Ge)?".$Ge":""));session_write_close();ob_flush();flush();return$K;}function
dump_csv($L){foreach($L
as$_=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$L[$_]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$L)."\r\n";}function
apply_sql_function($r,$c){return($r?($r=="unixepoch"?"DATETIME($c, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$c)"):$c);}function
get_temp_dir(){$K=ini_get("upload_tmp_dir");if(!$K){if(function_exists('sys_get_temp_dir'))$K=sys_get_temp_dir();else{$vc=@tempnam("","");if(!$vc)return
false;$K=dirname($vc);unlink($vc);}}return$K;}function
file_open_lock($vc){$q=@fopen($vc,"r+");if(!$q){$q=@fopen($vc,"w");if(!$q)return;chmod($vc,0660);}flock($q,LOCK_EX);return$q;}function
file_write_unlock($q,$tb){rewind($q);fwrite($q,$tb);ftruncate($q,strlen($tb));flock($q,LOCK_UN);fclose($q);}function
password_file($h){$vc=get_temp_dir()."/adminer.key";$K=@file_get_contents($vc);if($K||!$h)return$K;$q=@fopen($vc,"w");if($q){chmod($vc,0660);$K=rand_string();fwrite($q,$K);fclose($q);}return$K;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$B,$m,$Eg){global$b;if(is_array($X)){$K="";foreach($X
as$md=>$W)$K.="<tr>".($X!=array_values($X)?"<th>".h($md):"")."<td>".select_value($W,$B,$m,$Eg);return"<table cellspacing='0'>$K</table>";}if(!$B)$B=$b->selectLink($X,$m);if($B===null){if(is_mail($X))$B="mailto:$X";if(is_url($X))$B=$X;}$K=$b->editVal($X,$m);if($K!==null){if(!is_utf8($K))$K="\0";elseif($Eg!=""&&is_shortable($m))$K=shorten_utf8($K,max(0,+$Eg));else$K=h($K);}return$b->selectVal($K,$B,$m,$X);}function
is_mail($Vb){$wa='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Jb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Te="$wa+(\\.$wa+)*@($Jb?\\.)+$Jb";return
is_string($Vb)&&preg_match("(^$Te(,\\s*$Te)*\$)i",$Vb);}function
is_url($kg){$Jb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Jb?\\.)+$Jb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$kg);}function
is_shortable($m){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$m["type"]);}function
count_rows($Q,$Z,$id,$t){global$z;$I=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($id&&($z=="sql"||count($t)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$t).")$I":"SELECT COUNT(*)".($id?" FROM (SELECT 1$I GROUP BY ".implode(", ",$t).") x":$I));}function
slow_query($I){global$b,$T,$k;$j=$b->database();$Gg=$b->queryTimeout();$Yf=$k->slowQuery($I,$Gg);if(!$Yf&&support("kill")&&is_object($g=connect())&&($j==""||$g->select_db($j))){$od=$g->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$od,'&token=',$T,'\');
}, ',1000*$Gg,');
</script>
';}else$g=null;ob_flush();flush();$K=@get_key_vals(($Yf?$Yf:$I),$g,false);if($g){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$K;}function
get_token(){$pf=rand(1,1e6);return($pf^$_SESSION["token"]).":$pf";}function
verify_token(){list($T,$pf)=explode(":",$_POST["token"]);return($pf^$_SESSION["token"])==$T;}function
lzw_decompress($Ea){$Gb=256;$Fa=8;$Ua=array();$_f=0;$Af=0;for($u=0;$u<strlen($Ea);$u++){$_f=($_f<<8)+ord($Ea[$u]);$Af+=8;if($Af>=$Fa){$Af-=$Fa;$Ua[]=$_f>>$Af;$_f&=(1<<$Af)-1;$Gb++;if($Gb>>$Fa)$Fa++;}}$Fb=range("\0","\xFF");$K="";foreach($Ua
as$u=>$Ta){$Ub=$Fb[$Ta];if(!isset($Ub))$Ub=$Bh.$Bh[0];$K.=$Ub;if($u)$Fb[]=$Bh.$Ub[0];$Bh=$Ub;}return$K;}function
on_help($ab,$Wf=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ab, $Wf) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$n,$L,$hh){global$b,$z,$T,$l;$tg=$b->tableName(table_status1($Q,true));page_header(($hh?lang(10):lang(11)),$l,array("select"=>array($Q,$tg)),$tg);$b->editRowPrint($Q,$n,$L,$hh);if($L===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$n)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($n
as$F=>$m){echo"<tr><th>".$b->fieldName($m);$_b=$_GET["set"][bracket_escape($F)];if($_b===null){$_b=$m["default"];if($m["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$_b,$xf))$_b=$xf[1];}$Y=($L!==null?($L[$F]!=""&&$z=="sql"&&preg_match("~enum|set~",$m["type"])?(is_array($L[$F])?array_sum($L[$F]):+$L[$F]):(is_bool($L[$F])?+$L[$F]:$L[$F])):(!$hh&&$m["auto_increment"]?"":(isset($_GET["select"])?false:$_b)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$m);$r=($_POST["save"]?(string)$_POST["function"][$F]:($hh&&preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$hh&&$Y==$m["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$m["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}input($m,$Y,$r);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($n){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($hh?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($hh?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($hh?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$n?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$T,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7t4yZf4iATVVf:Ϧ,:1Qݼb2`#>:7G1sLXD*bv<܌#e@:4!fot:<咾o\ni',a_:iBv|N4.5Nfivphl֚O= OFQk\$id2Tp6-Z6h:a,2#8А#6nJht4O42ok*r@p@!?6r[L:2Bj!HbP=!1V\"0\nSD7DڛC!!Gʌ +=tC.C:+=%c1MR/EȒ42䱠`8(ӹ[W=ySb=-ܹBS+ɯ@pL4Ydq63ĬAc܌Ψk[&>Zpkm]u-c:Ntδpҝ8=#[.ޯ~myPP|I֛Q9v[Q\nr'g+T2Vz48(	Ey*#j2]R)[NR\$<>:>\$;>\rHT\nwN wأ<Gw\\Y_Rt^>\r}S\rz4=\nL%J\",Z8i0u?s3#ى:㽖E]xs^8K^*0w~:iv2w^77cu+U%{P*4̼LX./!1Cqx!HFdLĠ`65fĆ=Hl V1\0a2;6_ه\0&ZSd)KE'n[X\0ZɊF[Pޘ@!Y,`\"ڷ0Ee9yF>9bF5:\0}Ĵ(\$37HMA6R{Mq7GCCm2(Ct>[-t/&C]etG̬4@r><Sq/QhmL#K|6fKP\r%tV=\"SH\$} )w,W\0Fu@b9\rr2#DXyOI>nǢ%'_t\rτz\\1hl]Q5Mp6kqh\$H~|!*4`SS tPP\\g7\n-:袪plB7Өc(wO0\\:wp4{TjO6HÊrq\n%%y']\$aZ.fcq*-FWkzjlg:\$\"N\r#dÂsc̠\"j\rՒPh1/DA)[knp76YR{MP@\n-a6[zJH,dlBho+#Dr^^eE ĜaPJGzt2XVȳB_%K=Eb弾§kU(.!ܮ8I.@Kxn:P32mH		C*:vT\nR0uҧ]P/JQd{L޳:Y2bT 34cV=L4r!BY6MeLio9< GƕЙMhm^UNTr5HiM/n흳T[-<__3/Xr(<uҖGNX20\r\$^:'9O;kfN'ab,V1HI!%6@\$EGڜ1(mUrս`iN+Ü)0lf0[UV-:I^\$sb\reugh~9߈bf+0 hXrݬ!\$e,w+3_Ak\nkrʛcuWdY\\={.čgp8t\rRZvJ:>Y|+@Ct\rjt6%?ǎ>/9F`וv~KRWzlmwL9Y*qxzSeݛ~Dxɟi72Oݻ_{53t_z3d)C\$?KӪP%T&&\0PNA^~p Ϝ\r\$b*+D6궦ψJ\$(olh&KBS>;zxoz>oZ\nʋ[vȜ2OxِV0f2Blbk6ZkhXcd0*KTH=πp0lV\rnm)((:#E:CC\rG\ré0i:`Z1Q\n:\r\0q:`-M#}1;q#|ShlD\0fiDpL``0y1\r=MQ\\%oq\01211 ќbi:\r/Ѣ `)0@I1NCOZ1q1 ,\rdIǦvj1 tB⁒0:01A2V0%fi3!&QRc%q&w%\rV#Qw`% m*ry&i+r{*(rg(#(2()R@i- 1\"\0R.e.r,ry(2Cb!Bޏ3%ҵ,R1&tba\rL-3\0Bp194O'R3*=\$[^iI;/3i5&}17# ѹ8\"789*23!!1\\\08rk9;S23ړ*:q]5S<#383#e=>~9S螳r)T*a@іbes:-*;,ؙ3!iLҲ#1 +n *@3i71_FS;3F\rA3>x: \r0@-/w7SJ3 .F\$OB%4+t'gLq\rJtJM2\r7T@)ⓣd2P>ΰFi಴\nr\0bk(DKQ1\"2tP\r,\$KCt5#)P#Pi.U2C~\"");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	Ojr7F;B̒>ЦV\rĖ|'Jz#PBY5\0NC^\n~LrR[̟RìgeZ\0x^i<Q/)%@ʐfBHf{%P\"\"@)DE(iM2S*yS\"e̒1ט\n4`ʩ>Q*ynTu~%+WXKQ[ʔlPYy#D٬D<FL@6']Ƌ\rF`!%\n0c˩%c8WrpG.TDoUL2*|\$:Xt5XYIp# ^\n:#D@1\r*K7@D\0CCxBhEnK,1\"*y[#!יٙl_/x\05Z4\0005Jh\"2%Yaa1SO4%niPߴq_ʽ6~I\\ddD3g^@^6_HD.ksL@ɈnI~\rb@ӀNt\0s]:uXb@^1\02?T6dLNe+\0:Ёlz6q=̺xN6O,%@s0\n\\)L<C|PbA>I\"	^K4gIXi@PjE&/1@f	Nx0coaߧ,C'y#6F@РH0{z3t|cXMJ.*B)ZDQ\0T-vXa*,*<b#xјdPKG8 yK	\\#=)gȑh&8])C\nô9zW\\gM 7!,9\$T\",%.F!˚ A--g\0002R>KE'U_I9˼j(Q@@4/7'J.RT\0]KSDAp5\rH0!´e	d@Rҝิ9S;7HBbxJ_viU`@SAMXGXiU*':VWJvDN'\$zh\$d_yZ]Y8ؔ]P*h֧e;pe\$kw*7NDTx_ԧGi&PԆt͆b\\EH\$iE\"cr0l?>C(W@322aI{B`ڳiŸGo^6E\rGMp1iIX\00032Kzl&ֆ'IL\\\"7>j(>jFG_& 10IA31=h q\0Fķ_JԳVΖ܆q՚	(/dOC_sm<gx\0\"\n@EkH\0J8(km[S4\nY40+L\n#Bӫb%R֖׭R:<\$!ۥr;	%|ʨ(|H\0]cҡ=0Z\"\"=X)fN6V}F=[ৢhu-\0tbW~QiJL5׭q#kbWnQT!encS[+ִE<-a]ŃYb\n\nJ~|JɃ8 Lpo NܨJ.ŃS2c9jy-`a\0*ֈ@\0+mg61Me\0Q _}!IGLf)Xo,Shx\0000\"h+LM јZ	j\0/\$>u*Z9Ze+JtzRKԯDyq0C-fmBI|HBsQlX.|c[ZhZlx@'mlKrQ26]ҷnd[񎩇d\"GJ9uBoZߖan@nlW|*gX\nn2F|x`DkuPP!Q\rr`W/	1[-o,71bUsN7Gq.\\Q\"CCT\"*?uts]٩Pz[[YFϹFD3\"]u۝)wz:#Iiwpɛ{o0n;\\x\0qm&~79[HqdLO2v|Bt\\ƤHdH\" N\n\0GgFF}\"&QEK{}\ryǎrכt7Nuó[Agh;S.Ҡ¥|y[Ն_bȨ!+RZX@0NP%jD¯z	[U\"{e8>EL4Jн07 d Q^`0`]c<g@hy8p.ef\nehaXmSjBژQ\"\rK3=>ǪAX[,,\"'<%aӴ.\$\0%\0sVpM\$@j>}Ve\$@̈́#(3:`UYu@V#EG/XD\$havxS\"]k18aя9dJROӊs`EJUom{lB8(\n}eib, ;N͇Q\\ǸI5yR\$!>\\ʉguj*?nM޲h\r%U(dNd#}pA:-\\A*42I\r֣ 0h@\\Ե83rq]d8\"Qƙ:cy4	ᑚdaΠ6>UA:@2\$eh2FəN+\rԀ(Ard*\0[#cj>!(SLeTM	9\0W:BD3J_@srue +'B}\"B\"z2rlxF[L˲Ea9cdb^,UC=/2/\$C#8}D6`^;6B0U7_=	,1j1V[.	H9(1ҏLzC	\$.Afh㖫DrY	He~or19م\\߄P)\"Q,eLw0\0;wXǝqo~>9>}dc\0gfq&9-J#3^4m/\0\0006n8>䈴.ӗcph_A@[7|9\$pMh>5KE=hAt^V	\"	cB;iQҠt@,\n)s`;4Iy-0yeʨUBv3HPG5s|\r\$01l3(*oF~PK.,'J/Ӳtd:n\njYz(wZ#Z	Io@1λ\$=VWz	nBaAq@Ip	@5ӖlH{UoXfӿ\\z.,-\\ڗ^y n^BqzX㉡\$*J72D4.!M0DFGLmc*mcI5Ɍ^tjl7替SQ.ihLڱB6Ԅh&Jl\\Wecf%kj pR=i@.(2klHUW\"ojp!S5pL'`\0O *Q3XlJ\08\n\r*a떞r`<&XBh8!x&Bht\$]n߆cL[Ƶd<`\0ςawO%;BCQ\r̭pPQZZAu=N&ia\nmK6I}n	t\nd)bp\"g'07u&@78XNx\$BZB/MgBiѧ\\mmIĀ;5=#&4PՍqA\\,qcޟ\ncBw\0BgjD@;=0mk\rĲ`'5k-{\0_Mu2׆q>)9W\nd+ԧG\rn4O:581:Κ?(yGgWK\r7m5.eHhJAk#L..\\=UЄ:>7W+^yDbGOZ4r(|xPr,y8qaܩO2kn#p2ǈؔ.cUcłj\$8Ĭ~7ZR:׆89Ψw(aL%-,쿌#f%8|c%XW\n}6H˞#&J,'zMMຑ܆ /y6YQںdәd:Ep2gg/,Ո'8^;UWN{OCziKXڔNdGRCJYiy#>zSMUcRORԾ0)0]:=Ϟt'\$srF67	=\$B!qs	1\"v%Il<b!ۮ6(Cd-^<H`~2KzKٜԱy,qA*\0}Cpb\\S5'(|MW5;\$5T|;kt@;9);i.;_F=DM`H\0	 N @%wdPb\$H|k[dCI!:l,<utNeϝW^w'6Dfu ihIZ:~ϣrz3+uoCs2buaXwWK	HԶ27>WyMJrpTL|`f:Atd|i[wjW 7aueA5Q' ʐ\03Ҿ\$\rk)a;H=֐~IGI<\"I1'蠙Gcm\0P\nw#>xB\"Em|2\$}<3PYXgod߶<qE\"`4g8r]\n:qVbTm9K&ғĤm7)@Qz=ߵűH\n}Oi}\r٣.vpJW&u550	5PI\n{ \rm@@ P x4i4+@\0,͛\\C1ӎ誕L>n\0	 ##@]/4JR IRr<ǯj?1Mv\nZ`v\0a-bψ+-yA[|7\r\$ZʭRtޓCErL	rgeR/`J	7~%Xo4di\"QrI:QDQQM~\0Q)ة*,i\0_(,^+c&S~opC@gրBA~s֤\0]/zÃ(_zFOڿ\\\rvEK0<??P=`D^=v*|\n@-\\?kDi4?0l#{%\r3F<P<k4*@}?F \0];?[\r:\0؜dND2?\\hU\0/֢	?Q4c2o5+\rL?N(ڌ(\0|>A[?[/ɿ;]/\\}so`2vh]0\0!PAXJl<\r/\"(D \\TvaRO.#PEH#C*)>tk\nP.0EIH\$f%P0]%ɻXFA@4[\0	)P AM`h\0pd@~A@AkA\no@H֡r\n\$CC;\0-)8s5@/\0zC~  eB^\"P\0XK1^{\n	!lZQR41jZߟ㩋á,gI<HOf\"H,R^yB`҉~ڴ}ۖ N፩q:~M>^k'\$ʈj\n\"	#;``Pqǿ\\\\+<:ca`\ndd\n@jn5p2p@0&0r.Hh\rwȴB	@|~\r\0C\01:CQ1\\pӑY[(Б.RGЍ0\"8P<%<#BX73₤5B	t(b4<&\rV\0G\n;\\");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0Psn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E<L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮\0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	->ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%2\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$q=file_open_lock(get_temp_dir()."/adminer.version");if($q)file_write_unlock($q,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$f,$k,$Kb,$Rb,$bc,$l,$Fc,$Jc,$ba,$bd,$z,$ca,$td,$pe,$Ve,$lg,$Oc,$T,$Tg,$Zg,$gh,$ga;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Ke=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Ke[]=true;call_user_func_array('session_set_cookie_params',$Ke);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$wc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$td=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($w,$ge=null){if(is_string($w)){$Ye=array_search($w,get_translations("en"));if($Ye!==false)$w=$Ye;}global$ca,$Tg;$Sg=($Tg[$w]?$Tg[$w]:$w);if(is_array($Sg)){$Ye=($ge==1?0:($ca=='cs'||$ca=='sk'?($ge&&$ge<5?1:2):($ca=='fr'?(!$ge?0:1):($ca=='pl'?($ge%10>1&&$ge%10<5&&$ge/10%10!=1?1:2):($ca=='sl'?($ge%100==1?0:($ge%100==2?1:($ge%100==3||$ge%100==4?2:3))):($ca=='lt'?($ge%10==1&&$ge%100!=11?0:($ge%10>1&&$ge/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($ge%10==1&&$ge%100!=11?0:($ge%10>1&&$ge%10<5&&$ge/10%10!=1?1:2)):1)))))));$Sg=$Sg[$Ye];}$ua=func_get_args();array_shift($ua);$Bc=str_replace("%d","%s",$Sg);if($Bc!=$Sg)$ua[0]=format_number($ge);return
vsprintf($Bc,$ua);}function
switch_lang(){global$ca,$td;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$td,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($td[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($td[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$la=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Hd,PREG_SET_ORDER);foreach($Hd
as$D)$la[$D[1]]=(isset($D[3])?$D[3]:1);arsort($la);foreach($la
as$_=>$H){if(isset($td[$_])){$ca=$_;break;}$_=preg_replace('~-.*~','',$_);if(!isset($la[$_])&&isset($td[$_])){$ca=$_;break;}}}$Tg=$_SESSION["translations"];if($_SESSION["translations_version"]!=1863087205){$Tg=array();$_SESSION["translations_version"]=1863087205;}function
get_translations($sd){switch($sd){case"en":$e="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3Q/ӗJ6g2qs_foE2<B6k@ZΦ#ƤnEcЂ>`@\$cB3:x߻8xJ\0|63,bׇx481Dc:CΎA&2,.(N'N78cC:EB6%Ш<\r=\$6-\n:ƀӫˌ3#94N)\0#t403WaAc@#пU2)0XIkl*8\00030[T6431@&\ru8>#}2m48C{C4 W>Ws2Y(	/˂\\b /d\"'~,r)s([3\\E\n%C˥z:PA,873B7B\rA Cx3\rJP *\r7(5BhU@OwjI~GF5!1ܐˎ[K06 gU%Ҥ:.hAGT/M8ŌT_qoc{2!Ȫ:)+`}Xl-˯mbJ2EH7N	S8l㇤\\[QmGQ}ޅk_&I؟^X>em2HL\rd𦩐R<O8׹\") VY\"\\e A s=\$0e[hsq\rDe\n=+ҫL1,~̈`qB@Pzu@\n\n\0)\$Dg \r(RA߫wLfi2d\\ʒO&\$魇b~'Č9t.aR\n>#os<@C4q<:@R\\7U\$*g!)I+%3֣&4pOz&.ZzD!.9TM&̨CLC'd16	G2ur1BxS\n0MST8̖91u%KV45es\$l1N82d#HlMO43MxCJ%q2'@BD!P\"j E	)&Ma='AT\nA[kv5\$879W\rQG;\0*{'lLGо5L\0 cdɅ0CMb8\n\n\nˈtt0H0a3b6y\0H+lfǓ4\$YɯI~'Z,S}ą9P/ST4Qh k@)P훿bmJ=-*x-YqʞSkV*rҩ`cM@>liIAa M/d\\1	Pvkx5C\0^00%Mz	}S{DqA~m%?DA%0`Wsg6Jw;'c^&\r8C&~ˮToUL-#Ģ9D[XAl=AgIA\\2,򂉼PIZѕ^FC2;%&C	f;CY(C画^01dr#I&(IjG,QnNsZZ켔vK^ZSudbY6*%栓kJr/&VBY/=D66/Ի1{d-}fvE<)u3Qm; պ\nKuNa5lM]\rn7VTsoᚳRli`#|St-JD~Cɑ5&G͍	劁m'NoF#J 4R}?Q}V~=޺5ZC2vm1RM*F>f]LVmd\n]-bQ)*zVS=*w^EeJjycM΍\\t(W#W^#Lܿg*HW3@>\0S} A_,΂&k=,>r[̉Ir+}xnJ)(\"wp4.mlOnc\" +VEAN\rb0/d%N&t\0lf/\nyO#8%an%\0=>/7SJ4+\$΂0#pЦ,C_	t;\"2.\"	päPzq\nt-nR\$\rV`D6b0l\r m\"(lI,\0\npe\\.JB®rLՊ6/\"fT3JVCN	V\r,/0v)jɄ.AFfJ)财@Z:(*,Dbp \"Mf@ξM1.qKi|5Q}q6\$'mƆckoXͫ4\0e` `@4X0B%Kl@\"vR%VHldVfHN*rP,/-t_\0c)fZ?MI*L(R";break;case"ar":$e="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\r㒞B+\\cY*+\"	)\"XؐeJT*IPFt\"et~&M# @\07M0:#m1C38CҎKz˭L9H4C(C@:t2tA#8^2x9ΣJ`|6-+3A#kt4px!򞐖&m?2XnjP<+!u11ڂHn\"@P0CtƎ\$^#%|\"e͖\$Y\\ERR<:0knB,BةZժjlkR<J#XZjY<ؽl<HƖiKk/#`ch50к@d(@)\"bԇYn1dFVf6>\r!o1lkȦmEڼyddy=sdyZ>l;s ZBE,VMpWP*A0(ΩmCόv7LUH{ٕǌLv^q_P1h1C3ҍ06J+!k&%`*\rEL7!\03`\07P<C8a=@@pu7`9\nR\n9|%^cKl*\$\0l r}Ɉ2xn4D\n}OAUTZ\n@9)%(қJ }U9UjR!J'獁U3oVDAGj߂K8\$TLjj7pK4蝐(x>@\\S2P\n	B(eQ\"ԫun\"C\rP:D|`8eMpXE^\"%'!	Fp4TH M#K(Ô!k0h֖_n~M鴖l00@㬔\r,ןaH PR_\n+1}urjC@pe4C\\*ӝΓL!Y:ja6q%lVK7zSۣ!GR38UI)D:TDfj]0@DoUn)9F2aΠFTS9\r@!0 UA[IJpYA7d~OlV(V8Q0&k{h2VץGZqBP)G>G,AFr9JG:UŇJLI&})B\$FԤ7>fAH4L c~iQ.lkY\r?d{T!dEgLchX|Gũ&Jڴ~CQ^;qZ`1|rja@\$;c6FZO;IZ0T\n	7. \$6n#HiFTVrpBWŵp \n@\"p~&\\.s!v'dEQh{bؠ Pv]p#:P1Hl/qA-n⪧H%dX2jօ~2}kK*6SB+][ѧfQ.L̾Bnț#ABhσ0J9ld#g\n\$r̵QVu<JNtL[d2%M@L4@d\n`L2	Cq\"%\0*4ƹ55;\"-;l\nG\rvZlWk-\\T@tr;\\\n\\;.Q58CzBhߖn>3 E#CȽξm̨1qkvp8d`T\n!Ae0iJ^Ǉ4( (̈F(}G-x \"ˈ'׾D%'X+Nx~!OTybڋ0RS&^W^\\zyfJ#۲ҊM:?Hs\$\0ۻOqwi lv/n ;Mag9>ܾ\\O2\\2 &<KSNv[̒?9hx2?I\"hvG yb01ͺȣ9B\nCCc<<䡋uX=}V.f,D	'dM\nipŠqo?FpqOLh.OdD&ŀ]j:ƭZ2l*B(lLňW̜C0g+zvp1ˤE+\"Vpx\"\\\0Pń&/lOF͌HbB FyH\nPp㏧\nMkPoPq̤8baBOVk1)hP8=\0%Q&ݯVl)'12 DʴC\nb>/POb/e0ob#f^ȐOtCdj?Ԭd4lpάb/XDqVq,F,<L1la\"^mm;\rG!&0qoq\"\r,*!n7!Y-r&q45!\r!s0{8:rHՑI2R9E\"o\"/fiØ f2/\nEh7\0rc(A2+2\$ҌPsvf\"2C\"c(,%r&ς&ΟҨC/xߧo(tއ&G\rR'-*-,/pWJGY\nDC@*K11җ2D>k&W(R.Ec+*V16Ҭk&qmC*bEl`M\"rt.O:.DNB6`g\rV@`tL`x}@Mf\rK\n`\nptHW;Ngo	Fj#0FF3ؓ;ZN_%u*29X\0EdtL{BƦ_&`\rTLI>.Rv`-!F/c3s0+ǃ#0{{H\0-hI\n:6cD4(t\0d\$YCq8DL+2*XblsqIԅDK &Z.e\0BNې{Ls\"Q^bF'Krh .^8lf*:Oq~l|Fƹ\"悬l6\rV7s@qª]Kc~x\"a\$	\0@	t\n`";break;case"bg":$e="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9.(+z>PKƁ>B\"vi>H%(Ypܚ\$*Z@*pBb6#tPx9莎1c300c(@;#7@8P`@O@2D49Ax^;p1̱@]x7IRxDlWCL4V6H7x.1ےГ8S)K;+\"%Ixږ˳{pHKr<Y-b+#=(ȆKJ&BIF4!Jxܥ\$KV #䃶\\Ij3	5yBHh(JrA%Vr䖎76tZa%hE0FVf>QF\"4\$ҩf(?)Ax/R>ؿ7hK\\\"⛝\$,+ye> \nb9+2z\$il]ȳ<J\\]:/rFm/(hNv'sv}N4;-zdswiz<~򵩒?gB #6PpAwScA<Ef8s9˜n:	+EO3=\"H~&\$W\$%Kp\0pd6PK4!E\r%TJE]L<J#ADCNI\"ێ:+Ir~8bH./5D%΢)^%%⃣6UEt@|FIŤd`x}1%TI\"aV3*Sb@:ܟdLK8C\"gS\0M)<Tʠ;Y*xrV*2@c,YNVZ-/GсI 솔i\"7eN/#(vq䛓ɭ!WĈp\\6d)u2T*RuRRV\nZ@HDW5~ё6d8=W p&mw97g\n gmSTw^Q\\/FܩтKTPd,uC`lCQ(he`3@iFêwO!: :e((jnXCd\n8G8I4m{^\rb=GBYH\n& (-ba1*(\rc`2%=m\r<9T(gJ=:&Czu(@'x{Xۉ@kЊlOH'AZu\rF\"Ó40 gTMC]e(e匯|J\r`'t#hqEII}Pdvn]ɚV(h)Gن<E;_SZbnk*8Eo,`}\$QxDl|SjjY/ *VRQʦ\r|F^+2(5 \n%27ĂJX),Q+*ez`Fcg`\"?;XfwGB옚w˩U˓Zɡ!*Y;#/)t2g44FnŞpY[Cߺjb\nv4R&^%ǌoRA^ofɍ\\BԏzJ0T{ljKʦ/=knҢrD+?2@X.Z'-S^B*	I[iᎣ=,7\"s(rMຆH͚s3KV9Tʝ@uG4X6Fɳ,am#1!Xd]rG!^|6F&vZ\r\\ԹϷb+9i3(qpc△vkx!tn>Ml*+n\$B0).w:J|[2؆QqHC^'\\g&_53KVb׷DX.X<NsM#8.w\\9lU-(4!*@@ !֟TݸM9'K{r('RnZ&a^0`\0|s>,*Lj`R\0<Ȋp+PdIB[r+01Cdn<p9΋\n @ǐNë\"olQД) p6D0`H&|\"ЇD&&pߣPi65,|.!</dndfm<-\"?*Z\r\r.^.H \"H0PJ#b?ҧόJBr@Bj&%Bc+f𐜈XBL_4|N,0ejco/mB!|%hR|l\"N:0p1䢍|'!G),txEffjGj(zJb~}T\n8\"6%-q#'?#Av!\$F\"fB!#7!gm|%Hu-1:#+,,P0P\0RڦI)M.2})*1*mp+VwlȒ}n+^d,W+r*QU2\"#=\"rq/,?/&PV4,fp@IS93u-1*b[SZa+Pd+#jYˏ쐎5*T-o5)\0Se&XGqw-d{.(1Pqi\$x+<\r8j~:n@l/pH<*d|,Βz90q.ҏx2)8\"8o_l%튞/K#juCݓb,+xĳ|ўu7*	6+DS'E{S'.\",~Dr8|pp648T<t􈒲tY9,?͆~7@MEHfͦ](R:arJ;7i6JB֊d%<gA/6tJNm3_8CONORJ2ލ&d+ef|U\rT^\nO4&CoKFu;P4*,zod*D2/yEUIt5Eh=T]C49<pB' %6fipfOUwGDĈÍK\$4Q	j^3u[^4cYv#K\$!GaQU@b iACpZ/8\$?	11:U,/(E\n	\rM.~hHQkkG92TMcVh_vm7n.ur+&:j@\0b:bchtj +h#_U'\r,.\"<~4@\nZ4pY1	\rVlL0CV+Ֆ|2sţUg1ruA/&^R%jP6N42`pW6?u04D1rGPZ(FkP|Krvw/b*TATRke5jTS&vtN ꑿ M-ck*r7zn{zFh@w;i6I}Tc㮤L|׽>yC[Gl.|WfA)FAv3_;OͻBJ\0Bn@Z3\$4BH\"צl%dhFD4	%8vt!/^Y[	\"4Ex6\\[Fe!/玊uq[0>x\rE\0^5Q00%N5TGĸ&u,N8";break;case"bn":$e="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9@0F+z3Ҟ22KW5bIm*yBQ8|NK2C*S\n^SS̐ l6 x>Ä[#r`5\0#;/^=H; X(90z\r8a^H\\0յ|7x7ㅥjC ^.A7`77^0ӊP}+r\"ej}RPF4S4|0/_B:Nss%P,>.ʞ J4#]INU@B9\rBv/NN7٦tˣSFTP@SRSEqP:y5\"ª\"[6V6.~OzF0J,jAyO10j\0H4L+ԺQ8<]a	Lw)q}.k%DtU1R1nÍ\$7I\"R.rFDF)ԛJTcDg! P)#0g!#݌fOV)HsAzaSA'vLlR,Kbest`L'znGJ{5iIB|\\S1P<&q>Qz.P~ra8G8F(%JSzz#Y\r4ʅ3؏Gw\$Y{pJ	(s@rGt0f\r8\0K2(*Cpy4U|37tָtR0pkj7S\n)T	D_;X\"\"RN0*|rk&Y1bq4E`O[ˁq.E̺R9/Ք`z }@X2MaL26w0^3!ƀ=BC#r^ּ؇IUbIJ\$@Ւ~kMjJl-\n\\tuֻCrly/H#U_\$6Wt`1\n5nd45\"d%EQ d7AW\rb<9NCf\nW9beMK0;H\rXUc:qnR{!%\0ъRQ6\n]\n/QeH1\rT@-b='Ur+Uybxw%s4R7j=P);\0	X{+\rc-fw?4U Vx> 겓[h\rp@RٚK-,WF_`Yxd(\nl4WR,(ޖb0)3I2XY@шל4ID5xB;f,BLk!VHy;vb@	>Kp82n\r+YVzc]BQ(\r!7T!ϕR	KHO	Rl+ i1|Qgb=Vd\n!-پfU\\JRѾ9WUzXK\0\0f,P-j4wG8gxlb+LD6d2)6G5[!PJ;)H#dxRd`6zmᣉ[,)+	DI0҈ɪɳx\r@^IaÊ7Ph]t<)\rͳh%FFhETxc]8#.dcK3ZwB苇\"<),@Nb)q~gPĵ巷9ֿ;2yr>]9[&a2)e*k{luOݜS\r!]J1pS:r>SO&U=;x\"b	۱ r/`W<oDHiB@qSZ4df87s!`N=ie(T#nu.8((CǊ0@*)l0J-nNGnQ()O`e:3N(~RNzO<w\$\"H \n`MV,W%vkj}n~t݌\\鎀#fA\n~kF@8}\"c	F֯8LbIO\nh)ꉶO1	h8Pp}p(0t'\nnfZd*S\0|#*)͞|=ê,OB\n,|n\0S	\$zΚb(gGoe	Y@M\$'*0KRR1Sނ,,f(خ<olQljTG(QibOJm.Oc\"LFzƅQ-ĭ-(E!L\$2lr-5N!4-tt3pP@ja&07(0F.\"J,ꮂfQxU\n-6(w#\nLk)Rv~d90R(pf(#5(*+,%)҈nvH/*.nflN(p\\T	##QD\"c2j#140U6SmguLi/H/0ԯ21/g'5g&bŠPyLd(Ȗ-?-8i0PҺhs-8sg	k3<ѕ<&?9>cae#(=/!:stwi@pCJ&AsΤ2ăuH=sD+Da@,jk^2/JB %	,s@,M,hcZ	4.TcK%>7(?(l*f+X&	.'UAT!^ƃRCNj0f/!GIGNB;xYMBKb؇d\rPb\\!Ok*	!Sϣ5BHdoA\nP~N@m<mⅎ=8/EHNXCHR>@Ue30/)[R}?U3QI<ABLU]c]TY2o[^B^:GAYεUY{A-Ua1a#i8O%a~I\$'Z-+c\"cq!!j; uԵZc!EpGZR^Ƥ{fJ\rYRY9/QC`0m_U@U.naO_6)DD*&(k䤒_\$hLG#e\\v'k#O&\0\0R\0JZH4O^Qxi4kghU@W#mvJ7ilkqhqpeqrul`G_TDs'(2IVq`;u=kvsVg.Pe4`cW`@GUh~4pgSQlaGDEa7oYmz5n0WCw{pG{#{ƪ5~*.FtgQBWNztRh'zGG{o԰@@m\r \rhMEqG?iN\r\r ̕E.`ni\nZx>I74;{7҆NLBK|8Fï|uG-N	JqS)N̎,dO츮(Q\0@7Dduv̇Q3FWhH!1#jvb2(jL7ga	j[@\0XHRf~W\n2-o@m>r!QY02rb8V;S\rjFeWqv	VÉRmrxߔuf[f)C<#@^h\nUϒN2튕&C\\07y>uurp-=2T%2mn S9T)MdTε)f @W汷4urSY6('{+5\$s:#`)N/R\$%=5	=h_{Ogg'[Gup&z@܀=CtYoR.v̑DEd@	\0t	@\n`";break;case"bs":$e="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乷/6f9>(c[Z4P *053*-R 29({T\$((8+#j((0h@4Lw`@ #C&3:x3Zr3p^8J22\r˘ڏ#x|KCHFCpb9X]0\r1+D78Q%L%u7*;B¸C\"2b:!-a\rKcuE\rڟcHr#@kkҿ7 3#֋Qˠ#ünH(cM3Z3?bN:D\"쾪nDV5.5hv0Ahӱ͍Ӣ∘e<HQ5=3thun=0B#PU.P@QP@h,\"')h*cʝ')x¶9+gP#lb4Ѭ\"6N)'(< tCipr;C&@K솮\"87]pC2h@3	LCm7)?\$:\0u UB9ߋ*+]o@ªR2*6:t`HAY?\r.a,3ܺ\ncL;֋prN	Ȝ術>K\$\$@	2\rde+\"A+`.ԐAтtiI*)],优dLɡ5?@`XnN.@98>	,ӭ5n46XGd9<3!is#>jaG5\n`er#~Xl\rc\0a<f,Y%\"(a113Iwr@Ĉr#/!/i\r\0(e9_ă#r4K*8h)5+CVmOA;â^L;u8'D~\ro\$\rCrt!'L])\$鰥 ) ;CdD\nԗ!O&Pa 0CF-d;	rfMVa\$4Qх!`)dÈu5H39'1ē%t54TɔAO\naQS*UA B)T,%Qp  7bC*ɩILsG}ԑ*C\nlWgiHF\nݝV\\\\L\$nX\r lL̓hv#f~\0\0U\n @A l2f	 Z@(L[)WIB:VBKh\ncyjNdbDޥb.t|ų5bgn!B-͂\\36=қP[UhcDs7D>'>*ȀENIS)\"SE'd@ߍJmŷϑL{Sj̱Dl7á0YsmezP\nP0e*)<&ՃS;qw1iޣAlPFPN	7<P%(FRRm#()-xAarKզAD8PBHG7kNr8YABU	9I@̑Y{Dm9<T8GdC8Py:m`7%g'}`\0I'|P(Xz;MFsym˄fQgo./E	\$p=of&ۇ|nMǶ\\p^8(Imx%HaZԊTO*ѵBIF)sugP;#Sd8\\EC(b0QI?\\T!j}u ]-N:*UFyIw=A>H̄|I4%=!z89w'Y[W},a=q|+h~뮬+zk{^#\"aa|V~jhk耠'ΔpXOCZ鐬x0(uLΆ\n'%BY^F/@C/n<&Pr+'N\0%8M\rap,(M\"Fy0D/1VL,Z&p'KA(pAicHd.Lb^zeOJ3f\n>\$>~(вZb0 \" /q\rhԓ ȕâF9\nkBP|\r\nkooPp\rBalX#	%0i~ͥU		\"`h-P`f8#lXp|*\rS\00%i'faN\"	MTa>J\",cNHH`2KQj#a'^T1~D?~e8(dCTI@@#A	 ÃC+!jT?#t\$#Q7i%Z6_qm#`A\\=I	\rj\nH1+cJFm,\r)O*)T:(f8eE:FBX`~{#W1+El*cr=#6\rVrxo+\$v#\\MbPGc\0\0\npqNj\r2T73N24U6F^\$nLT/'\\b10&b 816V3+nH@\rä8D@:B@	\"֡dumi`ʐTE\\2i#&\rbv*;K>*LG-@0\0T	>è+21*,`1iP3pk\n>(0\rl#BID B',8^F\r<nB_0;D;Ib98Zt13@.ԄG,\nMN2P:U";break;case"ca":$e="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]f%3M)pȺh@2:H!0pP:\n0ȍ#Қ1h2e1KV#s:BțFI4+cڢÔ|0cX70@;CI!p; XD49Ax^;́r?%r3^8J2\r:˪|B!^0P2ȣL\"&&\r:M2h 5(S1\"hılKGNp>\0<\0MaX 6j\nHADg#)\\c o`猣0Gò:Z9H`PDP> B^I\r87#`7b|27(pah&B+G`Kp<F\r#LVD03\n7Xp&.(CuaTģRL4%<9c+!DcҀi:7BZס& \"ը\\r\\<@S<T⠂:!ƌ#ɈJP6\\K &\r,!/62F\rѴ*:77K8\nU *\r}	\"3N\r%-C<3+ˌXż2Sގ}'w~R	\"b*0oBSFӀ-ʌIL	2&dК`wMܼCp/@eDADL;)Ff4t8&ungE^\"JQ/D&CpIOKS(r\\K\r1TΚSZmM4@MRPY?@GSt͙5!A:3r4֨{ITU:.Uh: O51\n!Fs	z/i(0a(Fn4FcYM~sfL!o\$p8\0P	@ DsErujSVzCaA;̷-'Ct.`l;7Jg@3ے7-8̞RO04R!aL)i7Ax\\II9VP)Nf%Fh9hN<@<YL[k]ÓDCɤf)%yibd>u3 T Ȥ0M1Je§*cEqmm4XLqTAu7JJDH*dLW\r}%\"YHp<`-'#O0r5wT0%xNT(@+1A\"j,0!f6JxD8dbÓ'8/S\$C1:띓Kv*^FyO	'T!%yoEъ?LjVSQ˾]fޖSQW,E#.\rpXDhz(nE4rQIe-\n|&хq\r\\!9g*\nKqt]wx<Ӎ	`LQȴe^ c*>48VF~d\r65|K,JdǱu 0QjrCs\n#SfNi&C0hth\rC4>pnO%NC	vcd>AaMf~IUX. x !\0ʱe}kWbM[~پǄ׮vp	ب/cݔI	&ēh\rg	P9:N*݉'gd=e;{{n\rZ\$jnZKb}|MF6Y2'luH	\$E \"d	'0r+H	ke[͠(@H#Y\rdj.AVx 57ohOǔ&lܴ}z	\0a\"d.㻁Z4\nwF6UtaQ0C݉{X]{#j՞Pku\n*5!h1?\0V,/;frUÕ\\QLI/mre/.U]Q(b.墴p'˅,jMCI:@R|\$7񻼡F4?䒞lV^3fio@M\"/M\0I%\0gC--ݏK60p\nj\\BpQ-L+	dwYd.CC4)&7\n=KdKOp3DS //ك2FG@4pLrkS0mfiZd+͆\nOeX}\n'odKn+o<ҭ0\"*c44,\",Ajq@FeW-\nhM޸m@* K6\$%pRbs0/q&}i-fyFe\"5k951MƧ1ŸZ(()oLΣ\r1)F[D,7q\nLA-:.сA\0<\$\"& B!# `@v턘T|X)/#ΌĲ\\N\"^%	/dk&\"2Z\$p&2{(&/` e4\rVBIF]OH0*&G\n@\npqG~1đ!m2m})0..8(Ȭ\"2e:i\0J1kCmC==\0#Аc+\"\$§e/qcP&h6Fr;1e'Biݮ0-lݯ0ZdV(haNƐBilDs798Ϝb\n0cP-d&̐}qYERrIXnR0\"dcd&ccVOOa@!EXj/GK3# i3t2\0003Z\\3+HVv%7\0pSDZJ2\0޲`.p@tBF6P%@&F	\0t	@\n`";break;case"cs":$e="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{53T9(5	(持B#Z-((\"H#z9¤0i.6#tC\"\$ɻ.Vc@5f!\02A\0\rX@2D49Ax^;p0\\x99cR2ɨƎF#2Rix!V+2ۏ! P74>:)c[^x6szCmE3Mӭf\rcռ(p5Ѣ9UL05HK\\U<h8*Q P7 P#BH1C-71b^k%\"cp޿S#p=C=3P@P2\";@HFMBb`ȈCd7,(K\\q*U(2wvŰNsQӍ+{FR&yRâsFFz4\0\$-[#lnňƿh]6VPP!C9X1P@*Cҳ\rn9Ҡ:4bFMx\$>ەQD9V8jqp0030̡FIX2E0#ejm4#HR9aC[M'^^؄V<s\r̓l	xy~okz_`a_\";|㼓^`y̹\r=Bk\\?@ Mՠb4lce̢%lTVGoȐu:K\\\"êOJ))pTR]K1rTRl@>D\\9H*Pt.rrC0CjOp47\n)5spXqFII4Wܼ֒e (&䠔VK	i.%dFQ9&<a:v	5b-șL*	<o?tpg<X\$\"RJ{HՂG]ESHvohQ4!qPVR-|l8a|^IFN#H\n\0yQ[=(*\0:\$H4b0C=\\h^єޘw#Ijt.خ,u(͆c>9	9))&ŪH.qO\0C\naH#HgvN;oI9\$!˘*8`8L]+EW9NM7gS\\h_1錁ThQRiB{ &R@5`5q \n<!@'0P\\h(l\$nyw0iټjW\nŘ8 \nlrO}@oDx*C|*P~L\$\"		XC\r!uk\\Y)5d<b*4֑ryo=\ndI	T7DUS,\\ʰBBd7&\$^H\$dU\"|qVl5W;JZم=\$6sCJ:-*LVui.ˁ/ + 7TӇ\"кh*6S[o9'*C*6	uD(ǌBj_XOt54Y-AN_E_;e,VMKzu*AZ2/s	g(C8J\\;\nfkj.d7z	EE	LoaA%.gT!\${I69@ߓNDK/U?^W(`bf_\nV'5O4pBm\r%ƕJO51]mU|&leڝf|e1z1\nuN[s	s~6arٹE=uhRz;f2t	]yxW=:׀s'Sؒ0\$i?iYH`'yrEUd0*דW1ij#ᔔx7!Ɣh(ߚ>?(\"&pJ1)u}nE\$^oxCΕY7PF0P'_0O<4~(:m^NcK\0\n:J 6HLTeI7\n]ظjz*\nE4H(JwxFUfڄ'`U@]eMb+)\\i\\殔%eGp+/\\YE`@\re`,)K\0&2з\rELIT#P7\"Vn\0=@\n P<\0dDpOp\0VĜ0#JgD C=n4k;yк Fp@C1MZ`plyx\r08\"3.Yi]bbAI»\$UX`I<dI2H:F*28ۣ̤LBi}#N+CbA1x1\\ٍxEjd<fi\0lQYXQuܱf0;\"!\rцƘ8\rZ\n\0/\0PQA\"O\$Z\$#gHg\$'Lf:=FE	b*2kӅ<A-%0P+0&+?lo\r^ÚFULl{-.ɇUP&BZ\$Dg#-1\0\".4ͯ2΢.-'M2:r?&R7D5\"g%R&@5\nw5;6-/r5\r	5q<Qp\"n˰mЭ:nw9I]9ӑ0Ȁ#S4s%`#*=d\\C9#9G:;ξm:n5f1Q?7?N?.(\rV;aƆI,@i?oNj1BQ	9hl\nZ\nऱS@I]F ntt#TqGEl3@T\$j\".D@FlURhB? YbE#/{]ņ8\r\r(N}KCo,Fj˴k,\n<@RVAPV(+O!{O6nnC@-̣	\rQ@4Oe1({\"jVS#Ss!Q5H<CT5BF\0eEE*D?\0a5BG(rN`,2O\nt\"1Y`2\"UoܾE#'U(rk^&QRr:4zȦ?]6S?[\"4BD1p<!C\\Q ";break;case"da":$e="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX')jR(Vñ&oY̘ BcbȢsBO2\rZ2\r(<-掎\r>1p1?4@:#@8?\0y\r	CC.8a^H\\(γzƃl\r:0\"px!N+0cj2?P5d3HH;ϓҎ|	B\"P0Cr3hhTp:\"Xޏ(*#US\r|J/`7ƞL0264#:SaM7B2+<\r3+0*U:R;@쳎k#4m`U	L\"\njp64c:D6RmM-PZ9l)\"`Z5D)>PM8hK\"	\rc(a\nE-K6ãk=^jd,SEET\"S):ZZ :<&r\r2oD.Tb\\b#A\\8v؄^dk@bOb^ϴx3_O6*\r<DC5AX`3+[rl`2S\n\"c:\$%m:m&QǮ\r) HC#IT	I㔣)d7K!R<DV <5\\.Zp7_C#,BN[2YG:} #|EH\$; rPJOas̏>i2D횪L&|ІrtiIUɈACyXλ4޸ EfNfNzuL9)h֡WfmL9spT\\A\"0\"pN@\$\0[	>(@R.ğN)d4fˊIrSlD2gY/*pK@fԶMF*\$e E|7`Ѫ7Jl;D\$-)\n&İҠ3Fkɂ)Jn(Ja.3b|	#&:o_[?p	8I\"!彗7'EО?1%L@)BO\naQ\"=T3nHm^9RRjZc\rĐ3i <H!9s'\r90Hg\n2P(CjܳF[RB2'(\\s(6!K'@BD!P\"\n(L<OPRC)-r\ncjgP&46([g,?a534%EEPHQ\r\"jmM蝌mre5s=5TS\\4}6H\"0Q	.OV.uo@S)J8p*(qsCHzURA:4dW2~KPmST`	+/ E_Y%^4aR݅ګ\$mZlʨ*of#Ĥ	Ae5!Y1`ֲDhC*hYd(5ꀘPp7)@ʲ7,6b1Oa,\r	١	-,cP!Ȅ\0L\0h=BBE#\n[V+\nAyT3H_X.Vgɤ'	p\0Xo)xBI-Nl\\l:!GU9OU\$C'ͱ%`8OərsBᬊmо\nyc-*K\0(\".\rdvܓxph%Fp`ո@͸ܹәn﵎Iwyn5.q/\"`&C,S6EU(L^=>TOe3QǓ:*^ R,E|NhAm#\$홡f@q\$C96vyBxFOBϹJvM]ts\$oMBG|eóoIFv&*7ۊsJ}?=윗2C+80\rucŞ,qjKUr9xDhpr98\0Cx\n=BbJUa<TXSdh ٠1780;POpNeHO<Q\0L\n\"Ng=\$<J\r2ͫ|40M\0~`F(RȚX/0|BP)qo'pDH\$ezìD\"R6О|LgêOET/dfάUlj.c{ZZ-,aiТƐ/NO`x0\"]l>0OOڕ3C\r	T/2P1b`\$Pl,KFqHDBuQOU,e-^ <qvQzpd\rV\re\rmFL(PE\rL)oʇK\n	;RN2OO(Bfܷ#	|'ʎI7;|!@Zp1mOU1->+ڄN.\ni9'0EFT2.Ta2Z>k`f;6_'NaRl+'0E)'N\"b2+)&H6Pe2[jڦʁ	%r^ҨB:r\0Ccd2\"س\nJǢFzOqo&{<_BƴTҊ/P@-7#\n:ԞQ>?p&";break;case"de":$e="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$h0H \r;.,(3(#;C&\r:1J j6#zZ@x:fij7b\n;C@IÄcC#Z-3:t#QC8^E.xDl\r4J@}1mIS:Cz::b;Kԥ%NBp:ǌ摏@Pë`懠b!-abtU#\rhڎ8 xZ\$NBѺC){&˄b\$\0PR03w:eVJ*.RT}\r̙T6Tez7Zރp(hh(߅b)-1<7E#][WNBsuL(c۱D 5Zr5-X	#ls8OX<jJLG\$Fl18]XAIݸ۞Zi0C\r-m{lTVBC8h´Sڴ(3dv#6#l`9PX7Y\rh`X\\r:8A8. bj \" )== gr3}~^#*7Hz\"C\ry:\0<w2e5GF<&(p\"L`LA2&gSZmM@䝈/~#PXG\nQΈ(b%Z^T\n/ia:bD'PܡF\0000XhLi3؛pG0'XdS#7'\0Co[yD }1o1d&ԬFkG92ըM9`\$\0BdXM='T(BJ^d68oK+d0BcQ\$膖>_PT20`	%`N\0B֘g\rبtL;9#C %8:8KٱGOC\"gsIGAAQ 0h3dˢCo%ڮ0Q,Y)\0007ځf,ID6(XmU\rW;2WC !,'dNh+ru4֛QP0 \n\nF/))E~(Ƞ@<0QHgGM!5T:2rM\n'\0RA\"_ÓM.*?AH!f+\"MuPޓVEOMNdHh\$S3\0 -],8JS50 =5l]G(\$J!}ô~DO\";cW1PDv2\nQT035ܽ(FQlG*BEQ4K\rW\"5dKoF[x04@BD!P\"҄B`E*´Վ(u'[ja<8K	=&L'^5{sѭZR?Ԓ) wSŻ#X>GB50;SYKM+gQ<˄ÆrWkD1@}tBLK]&XMlMY B~\n#8TlpEAo%TRqf1fgTgHQV[ڡ\r9X,@U/0\0Py`<\ndpA;LF3&.;@ëmє)a\rf6PWU`%ug#2,reL*\0qݜ:8#]+ȔuS3YFybj\\,Rќj|S) KLjung*BtB`Ag(2<q]L1A.O\0@֒kęO6/a';\\ρ\0[ԏ<wsyʝb/,7K30_ֻ\$y`3CH_\nYnt+ˍ> RLTr&RLj<B+ږSņW()4XuFx\\xHiCs}¦h>+(6Y.;7G%?og/+ro[PƳf|`whr1_)A]]}.Ī'[\\B1EDIH0^t+f[lGXN֦*Y8( P	T,BgOɬ~PF5>B̲B0Flrϓ%\\n=`nnVzoj/dd0~?P\r	N#\r6w/\r%P0l0rp\r,0\0V\r~0\0KO:#>6pBfYh #ZGZDC,Jzpbr y{R >+'-M|vBlFhf-f9Q4 Ͱ٣1DIppU\nTpPq̮\"є0q-(j7C*7̮\ne\\#`	Ijlt*[\0hۯ1g!pM\n	1e^\\`AR:@R?\$RH:T1.6 2 \reWCil-+{(4ˏ(y\$ҒG^æP܍)Cy(+nE'(&CR,R#q\"B!`\"܊=`\r&S(X\r,=/rFIOq/&`wfiֳ>DR`kL'pne0\rW1j֓`0I+\$m,1& \np4ޑK6&p|p0n@ɓP' O%T+2m؃RpO`;/*?nD\$\"73J0b먲3U'bfH#'bEkB-:EsI:X̒:b PSdH/H@wAp)Co@\0PBM]Dɓ\0Q\$u)~\ng4=M@x2\"Hkjl\$x0!N`5Ţp\nR'D&225\$.	4S B\0Ÿ7e_5NB4,!FT&N=fWC\rjg\"M2vO@BY@b84\nB  ";break;case"el":$e="J=Z &r͜gY{=;	E30\ng%!F3,̙i`dLIs9e'A='\nH|xVeH56@TБ:hΧg;B=\\EPTD\rd.g2MF2AV2iq+Nd*S:d[hڲG%..YJ#!j62>h\nQQ34d%Y_\\Rk_U[\nOWx:X +\\g+[Jy\"Ebw1uXK;rhs3D6%`YJF((zlܦ&s/2/%A[7[JX	đKںm늕!iBdABpT20:%#q\\5)*@I\$Ф6>rϼgfy/.J?*X7p@2C90F9nJ,b\noi٢*	Ӡɢ,ArLzNjR71N+ÆuKS02\rH8 2a:#è8Nv 1v\0]\0^#1#H4\r㭔;c X90z\r8a^\\0Nc8^2}9H^0A9u97^0\$k1|%@,@P+~;P^bAIAnÍK@Y.go+hR%oJ@N2z9褱-\n7ZJ2:NǲH- RN\r;J6&t+ze=-bXh~cO:\nWHG.@Q@MJ#\r\r,]>o)lK\$PPgгu\"Zo9>܂ƈK;)V_?~/,ܺpVReF\$\nb|Jd+(A_tr\$&Vc 'b{P\$T:мsܷ@\0f\r\rTJ]:V=i8TtR>_q'iNVYUA!zV\\isA45ق	7VTA<6ܳs0h\$2ƌ^\")W.YQRCd#t I䫨a(L	ZFg\$z{	9\0(6@J**Ȳ TT4ߙpݜNr,:>Sё2YR\nV_!izM+ERf9I(yaq)^J'1`..ZS1d.*\$_d̵\"ɡiw8eSK1cțfNff\"Pzie MҶD:.)AP4ҰXrg墭ʻK1x5_4a\0_E`H\"ՍQf<(DWc\\ʌE+ץxrCӚ=M2_<\"LYx/()# ST/%轗_QX;	z0S\"R+>H(OV.@VV&qq.e\0RJWŁVҒCK5FX!RgԹC%@3A5ٸp	<DI(Xh[k.ŸC`lll8'\n\"C+d!Q Vb[ot\0c^7Sp#6bG *j2_4@'0[9cHp&>Vr{~(A,pT+-'pAnRWak r\r!PtW\"X15arSedD,K+1\"Dx	mUNU`0Vh 7-ท\"]ɲpCh\n3[y.4P2T Vy&D(>R;j!BKGU\$(]l@*J\nZ,Hw6\"RȨi̪=hx(cZtGJp4;.˪AC%prU8\0eqOJ(g*(eKYK>#OW0JpMLF	L*CǏ8(Iz8#zu>gkb?Gң򊩵CCªjĲ̞f%D>FJbo}\"A\0F\n^),f.aS&bN!XcLpFA\"a&)NќOI_\$zΨDg	RwqCCG̲JzREx /ʑPЎ[PupHAU񆢒_Sc\$M{~<3Wr,{.;a\0At\$~yK)EQdoCM\$mI!g0GO4#r*9L*&\0ud@#&p0MI-^O3|.zLJ%xz,yM&AO\0.\"πD.rkcJsV>\\r&qff{@@PRf@DgG%bU&o|`OhXХ,(inPVo4	XԤRdz\"nGXg(dN\rI  VPx -x7Pj@Gp\rXe4do\\!\0QX\$ \n`\0\r%ZEǥY,mޒEHg#&A;C&mFBKd.l<x؏hI+z7!*b(i0-mdHћ-!1~82f{ɾ(GQ\"Bmq NM0\$њN\n'2 \"Gє/\"g \r\"}.Y\rM\nif@G-!Fƈ8&NTIϠXӅ%j@%e\$o3)CNO+.5*@q#DVsfƨj8\"p%VϰG0(d̈#(t(pzB*rX5Ä2fFNĒưJROr2vC\n4xkSFlRBіW;5\\ò!c(fpE5!\nڐ(\$/83U8hn7sSVA7\nniG(Qq)^<N@\0~v`/H<P)<hu<)	?)hf<(i09bv>sBdm0,-@RxN.K5j(yE}E)Fhob&S;h:3i:>:T.AKH,P,TFv?!/Pi2 7؛\$tw\"&ѷ\"j	-K2=KbKL#Mwtv_\nB^,z(4eHѼEOĈFS'3G]Oe TGԝ9fC gC%S`CZ+2DFH.fڄ6\nMWF1DHÂ\$ZcX-\0G܆՗[CSSn5YSz52-,uq\"M[Ǝo2~dBZGhhu%<6\rXd܆m9P3`1ԅ+H#TV@7bQ0(2^J/563eQ0]at/aKb.,Ue3;H5I<5M	?3eqڮ,ilp\"pDke\"tnǰ5M2+j{C`*PcfVL+Iga-oJBuGd6gBF/_\r;jS֓	sd\n/\$]?hzs9s0eswDpS7tP-27'T;iDv,V v4I\rhj&7n.v=j3gt9:f{I-'#0dw	dxAi-8eLh7s9U-9QvWBhy}\$5hWsHrs~v\$Ԯz&&FKUN|p	0 t&Ru,S?X2>68BiDLkti2th1߄)lq4P\"r(wK#b7\$M.QΪ`\r\riJtL\$\$D^c +wRyQ2!VDʑ'd:Rn	g7C\np)@Iui,t6O78\$vĨã\\͆f3aS^'ꀫWy&<l,DE/S\r/(Izm?38JEIYC~Q'k<@&p\0V)\$XK\\'͙rUʊ%I##Q!2]EN?({ riTc	59QOI^KCy9<G`rs[wQ՟7r\rn!B:v'zXsىzsU`\$cucOV.TUxqi'u=BSDS˛a\$h%8%)' n(ty2Kmp*2:*%<JE p1[.rѤ:U%	Z_1;sGd7Bq>ؔK@dm{m6\$pOo\"w!w\$igXh(";break;case"es":$e="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9`\rKpKD>+ݽ@n 9@IP&\r7SD,Čj?{R;XF1(Ԗx\0\04C7k; X:D49Ax^;́p3^8IҀ2\rrDrr8^0ɠ4m=7:9S7&:c,\nåM*N0L#߶:8++B\$\0<\0Ms]<\"6hJ8B#kP7le'B 3[Cdj;.ue\$l@:ڐx܌,[XN#1&gjDB|漱\n9ۊ2+-R@]?11Wx؛i\nvh☢&S(ݨOTT3\"N8ՏXR2hp5P4Մ<\$rP݈ph-Q\$j 2/p*Dn*z<3τ\"ugnb0ʗ\nb5!<ֈ2C,&aݳLR\r0^iBR_7[xQ1z3`#	#0.A_u2R\nh>0=38@a*\nOP\04^cU*`LI;g}rkM^>(%ӵ8IL>I&G%l3=%ZLԑ~/84Lp\r&02䨕BXu/ƙS;с)78bv`Bä<,`P '!=P}8q#\$F\$>5\nӳ^DeWF4Ĳ7Vr!g}\rx#b\n8Pfy818꽲*xWV?8(FH\n73\\FAJ% cho/9\0&-d+pFD-?dr\rZ\\<.Qj(2.ZNq>dFGI\$M]r`KpK\0Oh6\nv01|`l]	\0S~#lH6hxGU(i5n;]#Q9\"㌾!P?II\"a͟e49hƖ@\r^&hxS\n!rG91l^z0䬽ɒtO-XpRc\$( J&X:@oŗBA*K:H'\$h3U`B̜&'%*  U\$-blB	H)\\bCj6b{ta`P%\$/>q('q2 TJa2ĵ\0M*7lR)uaRH)z1<q\rj7f4t:	U C'*\nA rJV>ubR)1az?YB18G7|iT07۩LB\na=1>ߌni>yEBvø\nPꎅ60k\rݠA.pbs1Ƣkg+O!8!DzW%RFLFOubyNl pϰf%Sh	\0R6lSQI`e\rN=mIAW@ezW[]Y/1{4%=6-Ӯv;3ͶF[RFd+zlU`=U+VcqnGÀweG:/8{ԍN&l!M}'5<Uk%jIEE<,<6uQn1%@&i.^VoLfiؑ_qvu\n?b?\$+[#-媃yVD[=T\nwC>آe0Y}\r1x5OoZ0B-t.Jʥrr<`p;-o3V%> ?v54x\neEeJfIj9}luR(xlVc0#<>@y\$)*O7yVpaL\rg.(yBe2ݭN,&Fm#\\jXX0p,cmJVl|&.>-/CaH(/Cd/e\r(i\n*bk,/O0D;Xu8\nې\nK	̅P.'|KiƊTD7mLXZL8l;Fo8u,mS./g A\$!0ZBмB-%|%\$Bkee>J\rV.NE0kq&*hG^/op8lt1іa8.]Rj -i4Ҥ/%--NUAeq7eimhAPE q/.LZvW?Ce.6L\r#!#%t2C%\\QW%BViP͵&h-&(Y&\rV+Bi0xbh@\rF\ny\npÆ0b&\0,oߣ5\"8#/̜K\r8G/-2j-NDBD2r~D2O/BHKLj\nDD.qE(/Q-QJ<9R#G ).\"0J>Èf/&/J=62d\"7C5J\$E̪TBPrhK?vbb&b0\$PGjKΥ>\0@X{ɂJ!7e^ңvI<J1<XB(t1\0޽-1B5j>XO2v: 	\0@	t\n`";break;case"et":$e="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfYb΍~=(L3|7\$80( B`޶\"	Nx AP9 ҳ*ԥc\\0c;A~ծH\nR;CC-H;# X90z\r8a^\\:x\\x7ㄍ\$C ^)(P̴4px!j+\$mPM\nj~\$,\\\nH++߶(j9GB~CP\nd\"**@MtW+<N#Ã7A{fP(J\$2P(#2C`Y.:#tA%ZL Pw,M%Ic\0zų):B4K23T4cZ4v.#\\CcL 0cx1a6ncxrJq4,%VBQU(~	H\rQJy\$Jμ!.O	?6bPW6IJ>A KHAX7]\"k#M'n`wԸ6㜄!լ/Km#cŢ+0̍-% .;7:Ʊq/9z/0څo\n@nvyS\n:Z\np*rNBLRX>HdQ&XKIq/&N΢fM'OL?h} g͆uUZj\\Ǵ6<Hٗ;C&\$2RnaOzE1)0.I9%4[K/4ę RfpI¦Y\n@\rӻQpp=䞬.b`%ABxu?ij@\rxưO!\"LKcДGi'4C{\r̚RSx#)2\0_0iz*((L;\0PCO1sC4FܝH-GQ7xrk-)AH|T_iU(ԍ5Ĥ:Iܳ0qKZUXH6dmxb&%L04!&K~\r	òx4p~q=\\xu*1ZPڶRz\r𚄒(L)q@i2\$%RP0c_FE8J`MF\0 -mjhܚ[\n GF\"P2\\LzڬmLR3ja,n73\0ɟa\\`-:uk0>~EP\nbXdʂ^rp(}<3֦U	d2Ĺ\0U\n @@D0\"冱L\$%I7NZ	a,QeLʣ:'Lꒅ\$t\r2\$WP\0ʞCa~.)	iI.~YG*PBv]b[ t-H]Etb-J0H0h¤U1	\n,{FKyq|g0@bcw3;OLlAe\rB[I'.}C	ʉ1!CfUTW3Z6-lgXLR<ň8(u%CMp89=zI\"%BE:vɻyxP'9WkR\"`ST(B@߳PQA@օ@@ lҺhQxp_6!(%^-W^^MFIa\rݟqTD_I1k5C\n_|HFQou:.>!܋7HI\$׃8St'\nA4j\r52}`fl#Y4ZWߢ4~xPK܎.<kKß&sALɸjBw_9|[=`k\$%h>y8wbnR\\t72!lu|a۽*h8|;_ԸvnA?gΌrH:x?C\"Ahȩa4o<^ɧ4H,[=:5v[QߙG,5/M=Cv*QNZٷf@D5qq|O-ψ;EU-{U'M}(tD401.i.+mWjjbNbN0p\0K0Ê/)\0*θJ	J.'D3cޖhčh``Drk\r\$èf= č7ͭBG#BqL4i%buO/+.,ZhVk\\;eS)zS>0\r*<S<T.0%0\rK1T\0\$\"2߀*&Q%\rqƆq9~sʿH4 @Pӭ>\nF\\΅jC	'B_ZÀ8E\$iJQKߌRpd]0&+\$QDg],,1&)-L\n1梨l͌b0AH\\0VVOJ1ʬ!l e%R%P\rЍA9qY,@7.\$Wq=ߒX2Q̔ P	_`cgK\r#R	zWG+1h2)W `Yo~ۆ+bl2VdqM{FFe#9&  @h`&eNs\")k\\\nZ\r\$M#~`f\\|F鍢\"`@\0r \"9d}l03Z9-%\$y6;`ݢ>;pf\nT4Ļɂ7f>oZ/VQ5l,`rl.:!\0ތFߒs<\rB@34%\"L\$2L PSX^Ej)LϮ\"RˊOi.b9B.Pq\nOɀ(f	\$Ŋ,&E.O 6a;L<Cx5eAfYsU@@-CXA|1e>C&_c<`	\0t	@\n`";break;case"fa":$e="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx.*Fɖ(%I&Т:_+k	qBk,`Xk2B\"68@2\r(@C6:##!o`1:#9\04@:Ɂ\0-c2\0y*3:x?wpPp_3sLJ|6R3ACl4px!BSj	,Z;d\$jB̻^ϳM<\$kᐌ	DΈ\"9\rҒ8%~U6dBOӆ\02k\"V_k\rκ?}X+ImtԵ:LZUqq{\$D#Yc\r::55S\r<,#(0(/o%e@^ma\n&0)RBYcvVNz__C=*bWVWwvMj\"'B[zȆ*Z0%w^Hɲ즊i񵅎K?x!_TB 9#dT7rs(:Q2:9KIir:hR@<^\0'esª 5\";gh^\$8H>C(fC6I)D&&OBYVFq\\,\nǐ(SXn*2DF(VA&WMJ[{Ww>Pwƥ'3hoŴߋ~9r?9-s_DǜQXI][{ (*@:<\r67NC\">M84{O;(rP\$8@+)ڧ	[Bmޙ;*HWUFM!7ZX[66'dh@E1,k#\n[cz!Bo\\6q\"D|OAC2QNMHX!)leW䒪%h굒\nױn\rXTc![h84HT	*3ԛ^\r!6\0ėCA2P\$3a'%\0fl\rM\n]r4CtX!8W̡Q|H5ڙK:eBhUUo(\"3>Ʉ\0((`ku6(\\ac:IrrdܚD\r2n 9ʨcւ5\r%j ARRsL>YYCdLɡ5%@ia#Ν]0PPS\nA|֢_	'Ԓ3uFdd\$\rS&eePp`[Bcƒ&t<	\$h<4*RFKjuHI3 \"z>(1\$>+CLv\r.J#nX¦KMhQEVJ]HKW0(I\\(ڥ%.qfMzK~=g磌)m(CϘ#J?TynHxڙ/QNn?»U38~ ('@BD!P\"|(L)Z\n еLd2?\nUTIhǑuH%-bAg~I\$3n|DiJ̤+q7iEGTmGDvtкUVʾF+щ1ttz<p\\J:oR1I!k*#+k\"F/@ aD.[mJQVsT},|.3Uܬ,gSD6Kjv-ؙQ`l4g\$`cK7Nɺ-cCH1Z-80/l\\|Lğ5>G{~K Aa \\RT#S8LjZbF_wNBhcp)7YԲŇ).BÉ/3%}b^Mu5[]SC\r'kU2vIʹY;JM1Q4<٪\n IbBcq%o?<{'zL`;zn'_l=W|;f|Gu䢛22~`JK\n+\$/8sGZϿٻݚ><B#a}D80gV\$j PPYm\0\rihC&[!\0P\"n,gFހ,Em8~3~ql-4φ;8X\$ong\nϮڕ4涳ϰ.C\n(L0,Te\"WOŘ\\¯W0#lJKopF-rkDPT2è^A\nlAN{?'\0lϢG(d\\?l&lLƸ01,[΃%	Ў]hm~Em䅙qQm;]PPMe)Nn0^,D@\"CpBcLpPЬ-O)Rqui~'ώoPl<)-\$:,C)zm`PpR%Q	&CE#1'bw\nvNY#)(kqv7Bk):7qo\$<kM,JDcBV<bwn,\n\rDx1&+:3\"Jd0W-~5poCN2 r-	\rV\rie\rP3f\npV35\\/)*TJ۱O\nKEjf%BS%㺘\\ }!CM:7\"^\\0l@ELFɞ\r1b~O0#&ZoDBVmd:'ؑ??	r#	q7\nw6\r4	@ҌѪj;@7hT0zSwlcVz=T\"`,dÈJ0GFˬnPi}~h*fؗݓq;@j\n3D%\0-7GeTA	JBFc@t6Mxo'H,s)et\\@";break;case"fi":$e="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1e#Q4p%ɂSɍɈқ%0,{4:BBX'9-p0\r2@29(c\rLP(\n%0@4Ry	Лn0:h*R94lj90z\r\n\09Ax^;́rOap9zc;c ^)ֶ\rXx!j+%;%@a7c(Hܶ\rc魴R׶,@:k/T`(#[:!#^;HK]%5)@#8AX-.%p V{.hV!XѲ4#=Z7c80vD#\r43ZX	Ӿ\n挨:5Wp2\$Jӧ&Cu2SVr/f\roKb6 BR6EL0ĈiNeK	);\r/!Y'1\\=bX}+6ϡ.P%H:~O0KZ[#Mr׳y)eÿXmiJ@0K4Je'g\\\n\r-߄>	ҀނvԧN#z1([â30l&2č#L6ʴzR)j44U=Z-tW(.DP-II((:c_tMK'4w4hQcacϡ~?hp/όمPF^Z-h]#a䤥\r` FiĢ:\\KɁ1&D̚Rl`䜓v\ru2LZuVՊGI5	/R~Q;2\0w0HH Z*lΗsRHIu%(tL5\ruN<\0ܫJbP,L)ؠsȍB@uIK&-*xvT\n)EB6L<3*C[\n'dlGwR47x;*(/)EךwIedvV,'zeXri~o0@@Pq8()w3O=K\0S(e-,Dh\r(!4>\0ܝ|~Q\nGM=`مd8}ɜtESQWaY*|BfQ(Qm(D[DQt}Q(Rp 	XBvdMδR\nK'l Դ]C?f<jKBDS9\$Oɜ .6UJOTMTr|<6liD9`iW˒pN8O\naP)D\"s@uЎb: n3D	FnXII&2VOnJL*\0tO39B%kD^JjsZ4pAb\\a<'\0 A\n^ЈB`EhAKyYz:Q̂\0XA[A:堓gr ĉd9PlG\$&ґ/%f̩3cE)%EUZ\"gfuSHllƘCk%D#9Lnz%ޙ\"+ydKfN)A,I^frsX0&Ì.nębT`)IMcɱA\$71GѲt23Uniis8>rVb6TmuZwՏ)GlD\\aJNm	Zep\0KZ@C(s3HZRD<풮PNC>mhc/\nKY үё\r9r+0i㻉	{{}%{曀پР͛T'Wsp^x5ϻiliC	p<vk?htE((̾j\"VKn2fo*p|s;roQmstw#̡\nHrV+4L+tӮ#*e+~(^\nLocHwАB\rQ0xH9<Pc0|K2Nbt\r/[7VֶDT\\rhPu*>r>u}lcLp2NvuKxRq	 Wk\$Bk צWlܣB_Rz=dHj(YV	n9'}]fiF/˳~Noo	cDRפ|\$ȮߧN-xP.|p-#N.<\\B}o>gOʦ6 6E4F \$vکlp-YLv|U\$`:'o\$|p йN%(J#=E\n<BP`@f8D\n,_pxX\nWoTNF/AUOZ\" -!OVr)\0X+ɎQ0Ft,g `bhb&	 	D&|#%P&R&z1op:\0]%֜BG~\".ѠqCr\$\"E4w\0c\rZq^T\0K)PYp\$1J a1'lqm5\$p:<h\0/MrD@>Avʯ{##.Q%\$_`g4q;&\rnp6ft?ʺRŀU`*`@cnL8FtHx)2R\n	&2r];&MH[!/P fQB0q\"+0)'f5,/cX5\\\"R61+,Ww\"d[,cmnPB-ClSXm/cDn^f \"7G/7p∙Q4L7TepDDvP/̆	(ثa\"o\"&QV(l1<\\F\$L6J7,ąC6J-<<*=LLf(>8\0%h%(w`@qХq*,NG0\\";break;case"fr":$e="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P<PBHcR@P#0P-c\\9P%(̚2Ljk\r/Gڵ;-bR j ETB<4XЃ)Zpz420z\r\r9Ax^;p&\\3_5sh2\rrPr^0Ђ`;QQ6':7K1\roTBr2&62o\n7KJ2xƁMlm:!da܃m͕6t8\"2222ok	Yc-+#;8[U\">W&{LJa P9+VTc{9/6H:(0)yM	E`9N5~eVD)\"b:C>O_)z1LquRT{mf Pz&\"9޻4n>E<_@P.aP3hBǈqt8En\$\"C8@[*qhJ]ثpbiІ4&\\£012%4oZoKB;'|kp3FYZ3Mz§B#&a,c0.'ee8UN`MR8-P#1!+}'jZ\0K'\rG[x\0j \"\rQ3*A , U\$?&@a\$)%u9SxOI?(\0#D^`<	S1ڇ(Րg9l0`UBDFzϣ2:#Ĕ}OABgȰ\"r^E|؁\0m{)M%&FT7(يA4L5vJ)H.;id`1J\rؔƖØf372Q>Fp0eJJ9(;i*K	ck\r5:S3@\$8R.E\r1_1̐Cܗ;a7P+[8DIAA2B␑ڜ؃\"tr!*֐6n&ܙ	6%<C\r6)-7pS\nAT\nRNV\0\r\0%3SFyxT2E%P )<5dS3`U#iҚsRjY^\r\\ɐvȌP|EJhzSG%#ȍk}.|\0¡>~ \0R;OR66ql]d'94wYa;K}\0&0P4F,sW>2ne\"VɃT	`=36ZKet	{7gXH`cV2p \n@\"o&\\W~'as>!Y#<5Q\nzNC<8)Vp}Y=iO[e9DhHp\$\\Ɉk?((8lr21d?*gVe\$FИts\n7&Fcl3;r /PHS4>X)HH:vܞY&%v(ҏQvU_A@=wl脔'gK-[G0a\nJ2e){	a\nv|LhΨ*N<RC\nmJ\rnDblqD\nI}=E/pM'i.^Tq83+9\$HbitГ!U+m>vT\n!AAJZD)GNr2{b_\"`VL_8e[aw-dLTdMHc=4R4`O;+EӘۇawZc|p9,\$oԺ?5+tP]9%+>J\"r9cٚNJ϶e!22|0Fr[M굘\$6ckp@(bȻ3-؂tζQ:quA!'Oُ\nPA:Y/\nu\\*gW}O~XҸ&tlN+?jL2&OA\0E2pxL%\0dRO_N+efYb\"ZC`g\rha)TMPTS_|3N]DZ%iZg§0*g#p֧\0L)\0\0\"xmbp\$]ФllUқ!0	p\n\0\$Ysn`\0\niԋp bmfb!PP̅(/Q\r\roS\nB8'kd.eRʮެL2&(P6@.en3t!1d}htCT\rEE<\"q'1*MJuB\$Rof.2ͲbQ\0E{P\r̷my(rr1]\0.RfPϹ/\n!Rc'\",\r6:G\$!FͶ32K\"NYݒ_#<nDDPw\\\"º_L!EO\0Q\nIY	%9)p\$2Ყ%%\0002Xie2e+=V^2g%b0e,n,2^%]f2Cek+1\n\$r}ms0D[03%C˦ݲ0ݒ0.\nO`R=&/ᭀy -41ҩ13ZC`_\$`?f-+RY4 ʌpd9\"F|%3s)C1径!X3^I7%\$N[*0\$S,@k_c5q-\n8iA\0r'bg|jJ3@Z6@N>0CbUBtqD\$TD+^hdcE`@@nE\\iM\0EG\0DG81w!|pvZGFqT!U;C<4;o)PvQ}9;&\"!4Delu\0LN;D\rM:5tM)L¢Th&;dIآ):cF:\\O\". KҶpT\"c͞#5͂y#ɋĦh\0\rBt=/c@qNldǳ\n\rpYC\\1ޗ e	\\BZ=>`A`";break;case"gl":$e="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M\nf\$)MJʽΠh#.Jᎈ+dǊ\nRsjP@1@#\"*L(8\$cph0º9#4\rlG#2\0xC@:t㼼1SxrSJ|6.3/)ʜx?C*@1p:03ޔX!-7+pԷ@U/Lx\"cxC(BP\r]\0<Mi[W.7ھBҍXܓO#\"1vT+Hz|P +.5o(c4L@\n07PfQ;630:c0߉3\0Ǩw\0c(&ej֪nU\r4p_PW\$dX(T~WM4PC	0s#U76z6:r24X5KE)\"fcjC-Dz P!H5C7#\nR>\r+%Ci0H1UTXDaoOENQBk^߳G\$2cT:2;ڈB;zX֪ɾ0I\nS(wڠOzꇃ~\"Cv\$hAkQ]5\"_	c|F#ޚ\n#)_\"VRk#@C*SJ],?)4^T{BzqɅITxr[3NJQeeQc\r(Td\$䠔VK	i.%,L30`N	ɰ@)ĨRXMgJÂ<J(a1\rƬR`\r	6D9RCUj0cJr8a\09ؒiުa8^C,x'a.@\0\rF\0PUL eLvG\"oGт<;ç,'g/|.vH-)v\r<?`f~i#I#pH!6&	ph3elHC_O!BS\nAPC@ ֮1+xd4glƲQ='K)e\raZNF\np}i6\$a_aPdH.CPR#QS'0bbɖȚu6AS\\V|4^% .UPSΆ#e(䭗a\r a'\$S\n:툓-֨tI	+2hs4_EEP՝\"I+	Ȩ)Q 0BL	!h )p \n@\"nA&' yo=&[veYa,LM( jF\"u(d8YLץ9GuLAz.zC^ Ehǳ\$+E<1Vv\n;(i()U,mt3|Тm&S|Uf*#,|W.:pPSce`-c̒~1f1b^lUԺbXȝ.]C@2\rallH\nx§mM[zqb0i%RuR8&<0z@NշEs]7-S^޾F495eORLvL!ͮ堀!fJ*0*KN/F<ތL4ls\"_a3]@!ԖNjt\"C4aIĆ.<LqR*0!yL,46Zkvw+0+\\ε|eiV>\"Sr~3Q'FC}!Ӧ\$?lڢ[ePڼ~!\\kzr2h!)u^\r;'4\"(QwC]m3TJcrcbZU]S#;&DɰASô]gM41&7oӢKw<xtP{MȅC<hȰ U.0dVA3+GcoXfJ| )\$\0uh/mƀQBhUol	m00\"n@D 0r2BP`nXЎ^ƎBpE	)N82T>9#\n\"BBE0gB]Fq\".3p\n@v%\\ij\"&3&I	<,PBe\"\"±05%ذG#m	>XF1,bj?\rL10RP8\$ЙkO~SmIj܄+	7QʅOUg\nf%1{ V%Nc@deR7>+4ިb{hI?QFʑM\\gjcq%#f޲NET>͘C!͌=#(٭/2\$h#R,# UE%[P\r2;	qi%Rf3`@B\"`F\"2TxWr\0j|\rj(b4.)#Z\")ʨq1v*\$w+oR{^Dxpw@A``Ơ`ƙ@ġj\\t1N+.\"Ɯ;	%4bd@Z\n\$i1NBDz.#\"6#9FozeE-0\\E/f=nmڂ/l-/-;4ˢC 87<gl~3>(3PL<,(n]#PoicC;;=:	)sy=;G@_r>.FbPPbo BޚtB.1>l1A;!B(+:bd1.Ĩ^HV=LH)E~\n2>@/C-j:#~\".lJEB\r";break;case"he":$e="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9Blwq-m^|_|mzS;Iʡn,c0N(fLקJ# 4@2\r(;C2:#\rp0:#9\04@:ā\0c2\0y3:x+%\n;s3(㜃!\rk\n#x|@kzHJס[H2	Ѩl#n↠jjTB9\rR4[AZkEt(\nfL947\ri\"k?S/s-p}'U2A;dA㠿).\$'Hm\"	i--zI@B&Y\\5Ԫp?TшS']!rin3qEPuYMZ)6ki6y.ԻLlB 9#dj7i:\\7i(:LQL9ω4yUpȂ^Qlս6)5u6C[[2 O)OL'vs:}\"Y sH52ko\ra'm@2^\rP*9W]ug޲4%It)Jˏ0pƠ:ND&rLN:p ( u<3,N:\nIjOJ)M*pRK0&\$M)SIأ|c^JwLŘrDl濘`3Q˄rN{\nWi\r\$jqA2a\"b`l\r\nDr5iP4!ѯ4!5@B(\0P	@\na{(!d*nEa7CJ*F:\r%Arh:Kə+'!ކhsGFX/CppG \$ Ch\r!4&|MF1㝄\naC?rDthRHwؚԵr!ݙ%o	\")ftBT<~C\0Z^#ZI;+h\\&O1HN('\$8P2DAё>\\ُ<zRӿRBb%I/E<Y:Κu6 \$@=\nH9-sI5Ǹ*{L('\rv,es)uB&b`M=X&(djʖ\\HxlH@g\r-g`nZ*6ؽ5!6zOv	VW!XnIi %GkArF%n!\nZZ JOI{#ds9Mҏ\$ȣV*AAbHޥT[bJ1lż,cXՎs\rzX0U,ə+!ciN 5v2ҮYU1nC7F\$\\T\"!P*sg\\H<>19\"ERňcmzs0j	=%dᚐyI8el㙏ٝ!d쉃P\\R:!^i]5Yϩch,)/7#q@-DViEmUv19aCi5\rhۻUD	7\0[{k=EJGlpݷؘ@WGĆ H4Ēz`w^,6oxgTDQ-rk\rjB!(93ZpD׌{*fEZp%@p~\nr9UƤrKPQz)gݞ́2s[QmQ\\%7DttI*dBU<rpU9asL	8Â\\Vm~;+?}vnfk쫗	k-+N.3{'WMbnO{8@k_53*toS=Bif;\0.B!`XZM0R,['^߶-N?3I>0?8}{f?Z0H_Z:t\\|#{FMQjv|݆_UR?LԵK.PPэ74X%p0 \$bP<6V9>M/pDn\0.sF-lR#gԮ'z%J80xʐ|Ȭ\0ߥ9m :h/&k9^k-n<='e5Z0@v6nL-(Hd~n1clVl4횄h.bGq,䨆R*YK/\0E1r0*@]\r]-q&2Eh,!^nE&3l:1n0'l^\\#ȯh0ƾpϥ -[ލ݂<XqĊِWP~gFG`4ؽ1몺[!Oo:xǌY2E-QIg#b baD!(<#k	C2\0BY>@Ef?g\r;#b+\$^*>n @";break;case"hu":$e="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737J{z:H(XCTf	IC\r'|\"PlBP\"=A\0\r(ڻAH@Pݎb0c\n9Ʉ|8Z;,O#; XФD49Ax^;pǐl3@^8KR2\rcZ`\r#x|퍉()5Lk'*i /n/QUUaCRB0\0K\rr2h:6%YTN5PS#^Vɲ8žcm*i[X- 3#R:PٿB0cL<58Τ+}.5[CCMb\r˝)X\r5Ch7S&Ԡ3b7ZCc0آ&K#LʺK<&Cգ3[SjU(%j➴ˋ1{BN%EBd>8:и@6ȴh+lFѬNzvY=h\"(.#lc>7sMjs<+#tGl[5~ZP\"\"(\$2db(-8ʒ-3QK5x3(Ro}k*\r}ф\$c5\rU/ӣ`3+AYQq@\n\"YEEJPI:wh0șBjM8tH.N7H2P Ԃ85\$BQ\rO:%*mr3Fю9+!,4L\r% 2gM)6ߴ!iӺW	Ts8hn!>sHe@ф~e('rJy؄ʁ\$8 I-FR9r*d\0J@X'`JJDHcr&%\"s/%C4p\ri2@1CW1\0%R4eL1ϘdɾVQt3>|H \n (LX2ˑE2G2>M!R&ǃblͩX\$L%\".DaW  Wdq~d43J7-bw8!4 Axi?\0FY010J95qgYl\rbVL4>a\"I>(DG5JTR*G`J+J3@t	I\"!ӣvkJ,@(jfs\$1xS\n@Xdg\$9P\\j* CV':2ʳW\"<H\rڙNi81Q@2+`\0&@Xǲe] (\$9\"Zi4ɕ\\\nj-T-ѻIjT)n*Z+zBPHf!i\n.iҜ\r\0z/%\$P;['jX؊\n\nqbfSN\0)2ZmMĶpUpF;Mv1b̈́1)*\$!=Wb_aC\$MfM`/LIEF\n-)-(\n\$50\nX2r:Y\\/1yxkYVd\0CgW-sMкD`\r\n#GLU ٛQ=GCp.cD[[CK<*@@ =\n+g4m]cD\"d]ǹYmƓ!np´_Nz͗rAp	dż*oþ6(n8.y ⷸt%/s7	bq\rQ*m-\rݬ|S9'U b:T:I2%09D\"/lO4TYL`=E&ڵ&0jGFO61m\\ ޅUCxO8.a1GN'\nwx	Xl5kg~Q^Fcq/jAϫp̂/+YUŰ[p^቉'B3Kڪa*bfQarC\\G7`R-XGK-+^v@IϺ-;妦kR'0D/ޱcv9+2jCbV58oj&2`3%A!ZFnLnP\0UnJ<l-P]zH0j6Pn \0pS	 ؘhHpM\n%\"z+\ni&tHjd3Uaul[\n\rd&0&t Z/%\r#!P\r8%l^AA+I6H+\n&M	V&&~O̀mBrEMl)0hrW|TSZqqhF{'l)#O|Gl;q`;+@N|#\"EBN2>3+o&S[`Fe)KX`F`gTU\rv\$o R\ro,^k'\"/1E\\\n˲C(%*-:G\nS>ѩe'\${!E)&h#&|=+w\"ֱ4o&7D:rkҢd8 + *mz*g(?7E^Q\0>?R5oaQ#ƨrP\"ƅq2r03/R	r@%odX1YO:gNOS3Ђ-3	AE:\rVoȰI^Z\nJnv\r)H~@\nps#7H^&h~fH-sps/󢸓'R#@\$BH\$J_h^&/dv\"v\0EaB 0+kH:\rM#Vj	%R҈\"(mn	޶e\n)x NcC7\0\\cUd>S*N\\nUp\rJ-1ζNv6Th+v|\"5For%*8(5cZ GlG\rFb<sHtxcF	@fnMfmf{%F5Ah\nĐ𾴞^?#\"hR	CVUuE2-atp<t~+-cUQт*\r.d+\"\r9\$wc:ۢl t\r";break;case"id":$e="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9jNznQ9<)LdBjV:p	@ڜP2\rBP l#c1tVKFCV9@4C(C@:t㼌(pܔ@z29^)1@Aj|ҒĠP5H9@J5l<˂t4ɐ\nޢ!(ȓENh7{%#K+\$1BxM#T#؍:4B2B3ppvO8nZ*΃\n\\%or5'#:2h&lrQ6>P.	((P9agTK6	(5Z\\:8>a^͢(3r\$oE	po#wP}U	\"@P]B\"ӱ@@hl2\rܽc]C\0Ε\"VGv JNو3TIrd-42UfJd\r0̴ihuᏈ70[t\$0?Օ7@NcʄI#Cn2RZvad[雪ބ|FBqq r,\$OL(\rxȲի,w3̓2QXĽFe(	rI|r2ѬoG!H0\$B̚9I򎁡h9f6\0ԚYl!\" E~lX{1J(@h1y15#.	9%6hIzD	Q2a1):A[4`_-H\n()\0ĲKBeIa\$̹MBniPB\rd;ƲZW	*\0BJ\"e8hn:9dt|M!َjō9\nC\naH#EI(K\r&P6hbe:\"JfzlTSZ5R*-OI9|H93CHk(𖄒LA;RqōviQqWc+]3%157ɹ3PQl\0T[ȢrhLOH 	inJP䞀rʁ,A3A3`H0fM<JBRy{A a*E3r#hrr {b\$!D*X*	8PT*\0B`E@('CPTȺf`ݩH|Xѡ2M\$Mi:YK9c.N]sM\n퉲Ӊ`v\"Be0AXղd(\\:\rER3զ\rx{M5^[,zW1ոf#\$k:'N (aMRfX2vMMPj.HE\"%6@zxP>hD1wJ2	-,\n*dFPR6!B[cP#N(\$Aa N%f9\ra\r!:N%Z(Dh&ʿh/x2؇X_ʑnУdN(bs)HGe\0oB\$lr\"xF9y~H3&0cr{GR|q	i~\0:G0]	C\r-L^A~.1\"XԎ\\еIjPUqKK(jS`NVꞶrؚ44Kjd(*Pajgx\"pPP&EB\r-Ez-[Ef=յ)je\0ӱFVSykh\0(5p{ll1pޤɞ݈-z|Kֿ0NW_o}X~5{ZqOXaV?wޞ';n|qݍ{lH۔\0C7u	{x\n	N܎A\0jub*z&=b\rצ;ӫPtmZ:st+6d6\"sX-(`^m9&>;yƜI|yt\nGt;u0e \$Uз6Gc*0W_-\\/pA龨ϥ6/N>X-cQ]y2vGo<O	0e^{}-^W\\︅KQ QoX\\>Fo;\"hDTΣ(iůփ/,Ќ%/UbdӐd|\rRkBN~d\rV\"ʤEjVDnEBZPȅ'\nZrК#&8%Biް	%U\0C-8,ö>2k pxb,7\"@`%)\rBKdr(c:Bn4o6rvق,ʯ׎e1Pn&&1UnSP\$ـA`Qr8O@@X잠Hy[eJ'M\", b^E&Cjl/\0V\"/\"b^@0nS,\$N\$%\\5m\r(4,(fd I jjO";break;case"it":$e="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCS2u,˳TAE	h2k vI	zԒs P2\r[F:!C1p@4V4212`4C(C@:t㼔0,8^h\rC7Brݤ^0h7=E\r35h7\n\0/K`*sMb6\r60\rr\0<M9OT\n7\"\nL?S\0004+XC{#6C`\nt\n/3c03ǬmlcpaB|lKRP\ns3,*5YTe#X_C\"0)\"`0L+\r@Q1ݯP8I6ΰHK9V.2Rc!NAf/#T֤*0@*`ĦZ&2jo3]x\"/ۭUtN#z)2HB73+	V\r<DFÌATcpoeG\naJZ%K{7).'czZ*2W0Mj7'0QB]ltǱ!Ȳ<%ɽ9JRLtysa3M4Jrl0IbR6*lƴ8\r1G1{ HR\$\$IC;y/94R&Y=@|QM[gF\ntГpP\rH=JИHN;@)0a!.d|bj'o58]ɂuQNP'n8Gh5nW)-EbI		GPaJ(.xVA\0P	A[\0((Ȯ	-j24LhX)\$yNVjr!Q;N8F:G4էi%)|8 f-5,P!U؇!ģ7\np(C\naH#I@A%\nA`L[\r+*	!}d.^D]J RHXy2\$N\rDGmx]\0B򌒆5RpIJyFS\r\$(& rn\"HF겛 #ԆMz7t\nm̒5RQ:1Sf0 R6/Cwp{cѩ9@\$ʌ+'@BD!P\"ڜ(LPhR9DӔb]naB\n\r+C@PR&J@T\"̿NXyFΛ̚dc`\0nLtb!@5ȳc\nFhj	9(_M	\",Z\\{K*8kӺlҕtRA⅝)sTZ/ḽ)*||xsHvL@I`y0\\-84`6+L2bce0[T Aa N\"g1H!fxa,x  tEcUn:5R!o<%Ge0\0@Co.\\b'pvbhڱ_`@G/Ty?h@St?,m\nI]_tA!7͔]FDf#1jZ}BEAZ~çpŕ!Xotd{y\03-y/\n(+aXO\r])\nr}Dܖwovp!,U;,Y\r\\>	vMzIO(f>VTCk%vg}Jw`w[Jeyoa'NkIT\nialdGSyt@HH#tsp:/MEAo PPRĨuy0-y֐\n\r1ba9̪BLf{tI7zoPo藻 ==xh?F\\\"r4TΦiH}\"aTtsFDD<s\"ȩ5sv[)\$vw})Clx/>y\niZ0fG5^g>3bq>\"+|<.co-C/!k+L@#v&Ďp%\"O꙯bGpZ DOf:Yp>5hɆO4\0AY/\n&Bpx.fcƧ[Nۯ\nKP\nЦ	t]ꎚ6c\ne\"ZGF#͸ִ̰DJP\"Tg\"-\0})~#W\\kn=	B&W,)C1<&k̋(Hc\rV8BI[ U.@%	a \nphr/G`%1ħR̍-(b&H(]pfL\"N0T,e~;#qZ߬1nZi*b0X\$ޥf%Þ>/&B##\$1_H#\n4,b΂] ( \$3.g!3\"\"\"r;^@5c(\"\"vB~oQZbD&\r&EEN6\n(\$HG\r\"k+JD@j庢dN\$-+\"L8cg!T\0ޯGF-OЏr>[\"] e2PD\$^\nq\$T	\0@	t\n`";break;case"ja":$e="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99E8i\\A\\t/>B ЁlrjH8WA#	ʨEYp\$r?( h7A\07-h:|8Ar1m)\0+8.H94a7c2\0y53:xG)t3(9xDlJc46#H7xAkNE\$ЎhKJ	se*WXEt)M1\\rDDb9\r@DK\$E8wvץJI.Q @>gI\\StJ\0S\$CEiR9hQ9vs}^72FڌD:K6J1*dNB06\rےK7B&#='&X,E3Pt!	p-V)Ic7З\$=hj?&;y_'ARq8N7AFģfDoFЈXf6*!:u}H<8CtWna͚{fJs,r8UnڨH*A?w㜷6HMTT3e)ZǒbRADP7`<l:̓0ͣ`ҘsOuR  t N(`\$PGj\nTg\rɥ(@C\r!*P\"Q\n)F( 2ReMwZr@*FU\rBz YOF^1qbš(@(fa57(@CyOh<\0Ҡ .O(UTZQH4SJe)o I\r4\"@>uK'Eo\$a\rj.J(I1>'JAλ]@86k@U94@dP~K.r]	8NG݆X<IpCc',PQx-G0 B\r:aIf'@\$9dtOB\"\n&s؏ʲV༬%,˙{>MCUP1Fny6fۆUҘt7G-&&ý&9FaZ(3ԋ5|~bkju2q@nA;>CaNΡ9Ûӌ0TL5!0F|9D3,qЁK+¤r_Ag'\0< qI+a-45ORI(!	#xԼH4,_\0dt.>qM҂!ܥ̂h RTpNxS\n!)PI&bHd[sWU.\0cT\nh,mگ%˺i?\$=V\rH&\0IMa*Hii[mCAR	a [x.SZ9E&	8PT+\0B`EK\"#xϏhczQB%b+r>2-Fm@{b,Ep9&t,5j^3ٟ<7fT%&!s}0ĖQq-0^eEugqZr	(y^^*%Q+\"lXXrdzěy˨gg9\0;Tʢk\r\n&0Ay_VkZLFȅMyMeeOV#{R<7-ixEū2o[hk0&Ƚ̘7HBv4\"1&@@ h#ok\rr\\K(i`Hg*I\0u#7:wF鍁6 DH_T.{0Y=iuas Dw0s(;{QJ4?Egʵ<dA\$ qBN-nșبt,A\\2+}m( U1f\"1ΡdQk \" ER,^YC[#Z زZqbBG]\"+Qk-bY'vG\$oib20\0/>rm\0nr%g(ɏL\n`^VF\"#*pM@%?)^IM\rmP5B\"ݭ[G^frgBE\"0b\\\nLּsE-&mbOΫ-[1\rЧ0\"ق*o.OP찠ZPPnp\$\08	Kη1Sb>e'>/>E]\nh\"E*0@,Fpm\n0b3p+107XXH؍omg+,ʮ\"m܎GXQ?_X]X1@2\r11\nFfaWbt26?\"\00|0Vkce.K7&+M'8b\$ߍv8mF([rs/+D,#ѡ{NN qC215\"r-\n!P+../#E/x 'jl3BM#1e*	ޛ&҆pG[Aa0=ap'')!ȳEj&IHŊnec\$RH/qn\$c+3i7&`y\$m%\0000g\rV\0`uDM`x	8\rdNc \rKj\npuRHF9gn3a#g\$ +F9\\G*c1&֎6q%B\"2nڽ4&,B^W#DEB=9Dm<'9/O <h<bm'~Ɯ8R@H6vIp?Iƪ#)/R	J+\"0'\"`tt5#V%4u@nHtYΕ 	:8ݴ>^o'0U\r%qpu.лC4 @L`G\0aKe\rH2(iZZ.I]ņFn#h\"Jgtܠ@6Cm>'!c*f\0xҍU!";break;case"ka":$e="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-:%/(iZdbMR#3\njsZ=1hAM܇\$ˬ:N[pD6D̓j*SS.# 4(\rI0)('r<J3Z\$Ԣ,\0x0@2D49Ax^;ցpAP0\\7C8^2x0c^xD\n?)^0\n=tjǮT/\r1R?-9Dd;*Űe]sy5ףO7Q+v#v8\"J˨z>_Ҕ'1L@A3202	;[,*U;J]s,CFq#dW<BĈy)m]A\0/OKN(\rċ+(y;oBJy=j6nH.+3Шr}D)\"ފrwh,{+*|)\"e'z(kw3zo*cNsqeBzwSk-'v'ގNEü)3%)m-\$dI-=>|Ŝfzb?;w}T堿亼9i,\"UK2+NP1f.@ӱtADaG3vn~7P+-@wi9K+I-fM%2IeoG3N0:fzsXH*Iɩ*DrZqT@&0ޥJ2K!`>BNy^bD\0r̢;]OPrweNω c)tJPjCHcʪ@2\n8E4Qd(1?ܡGTjSVUzVj[ȵt7LYK6'hQgMIj##rm5NOl̏F&a9J	4bgeKn|J|ApG'RA1uS*TrVJ;eq#ڽW2X+,9ȈubYYvs`SV{9w5?c6(9F|u^(h 	4qfg9W1ʫD&TWMq9ʪ[oHw2׼k%ڛ:\$	F>ɅRElM>@2i% A_&2/yj|ZnIxVbi&ШNu'kt%/gu֩thtkSd^G6XM܄Ey@NP{iƴWkK%6eLRΎ߲&##J4=Rĭr80'99\n\"bK(;-3BIi,˩h7͇9KE|܋1vH(0i0W_trs6#\\zcZ\"c:4(*kCRudV85Hg8TsvAQT25lgU,ZfC8X/m0n96@_٧\rwIi#fǾ*b0T\n3u/JMg]R	^*><0ehsx,JOi  _(\rg<߳n96P2N)^hnl!7]g/X^mBloE#lk;GmXK#u9d3OEqR^f>Y%u̳=r0tKmRAF0NO\07au7']A'2#W+l16-!9z3lFg(i.a[e]*z(wv9A{rG{Hy2{vd\$5'3Cq5tDE#l{}gKj-tzз_bJ\nTQܟ<];[=`RP?{\n.+z؄Yt\nu>=J։BT!\$:8{&^AYyG=8sX.#\"y|ͳjMl\nEJA(#\rn{J)\\fYå%d^\r}CN0^Fwo&>'ȎsMϪL@**ܮ;N|,Ӱ&nnGЧ\\φ\"`/@GN+72@LC(\\ԬvВ/1	kHx(K1>L\0|̦nJ2Iu4iZ5O-,m\rsZf\rւ'szpxJ\\9\0PZ>hf昏)/8utn\n]K§\",ާ^=h;	0멖(EmjR{NΦkOoꀧΔc\"\nק10|`x30_\$ͧdO/oq/ѳ\0,ޢr w^hεfMnJ<H)RFEQOp,\$MbQj4JAJV+t\0007khm'N&)Ҏ'\"hipy)qBARdrxpl'\r>}7ZRV\$ZҺi*|rq*څ	OT΂zdl+&0N}rJ) .|sE%}cNO\"Hhg~o56p4O7k7\\Q 	7'='M9:Cvߤ: V{fhu'mDP	r.0W	m]!>2%8%!ș92@\$\"\$:S72d(R;6d@A<p2#B~y'<?C!	.CQBio/+Qwn*@Q]9qİAR/55Ө4WH;TF^n3GJEBqFb2dS)ӱkVHC52M3+aBQ&2wLMEM1IQJ!f{@A\\N0@DYyQ78#X:4І)(b5=ϻ2ї9E#&|GCF욑|\\Bh^\rVN?A<mSS0gRQ-aXJg u\n`pU\${/K(q!1rO,OFȨo,\$r{K>tێP^PH[աcS4oSYK2y;ff,V|L%BYJ-kS ^akRO0ppϐLv0\$@)~H+&5=|E΄J~@PMref,쏪`&	,HLUfo55)M\\D?XLg)Ri)LMSU6F+jdrfk,SgcK]_(3)G'NPi;|Z'm(n:({gl5b'=^7Msq6pDWu}2Q=h-(>4ݵ{hefDLu\0\r* qr\0dTZk܂DQQU.\$6jf4";break;case"ko":$e="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠝mvBZ!\"L:dB@0R\rM/d!DAL1pt45E6Nga0@EP'a8^%ɜ\"X2\rx9Pc8BS81s\00#1#H4\r;C X90z\r8a^\\0˒'x7HEѡxDl%?4\$6#H7xBy<BiNHEIBj/Eh*LI\0cټŝY](9ZuEKSIr[P###X6y\$E0PBDqaG(LNπJ#3:%gDPv'+:cA+TT&8JeX?N)+tec6OEJL> H #c`A=Cd9c\"cU%sjncX4}\r\$T=s].vE!Smtû=ok߸G{3+۰Alݰ8~dqt7]l|wB|ȔPeH=ʜ	Aw?䌣Uu\niQcO\\Xڏtaz،S\"V>90JFJ̐5nT#,6AB\rPܚSrxϨsQ9@@	h\$0eDde-H5FYk@؃ZdWA3A<1 \nMJu2T!QP܃rUJ0`试`\"u^e3bV:\$K\"zrJ \$(BtDZZ\\&ןrL	\0ҥ .R\nIJ)e0T\nRD%NJUO9FdHm\rx6!A \rj3\0tiCMH	r%R&PП|_W\0004ƴPV :h%W\rP*\rtehrBWDD'HkH\nPUIv0:~+e|B<YAj+8A5XlA2;tAt4.*JldND6T\rC(\$Z\r1C:zS=H0F ft'l4Gj.cZD)%-vvܚ4GLJ2RaFDțuGƐw\n	H)v\\u.)X:T*`3-dRŒ4mY/r~DxS\n`O0-b׈{5kC4F`/u2 w4PP\"im=VW`@)(oȦ`/=s ӊVKIy1DKrEĜ@f'x&EExϚqߞa*aNtuvGpES`Ls,(!/<tF82aD2%|NY/\nu1svhuWQn\$v#~34,߬dCZ3zջ~Z8\ry(QFAJ/EBhXIT%􅿄h9Zv2׬Pl\"),\0dl<䅐6Lpmע&ؒybD x\\.U4=]\"-Hvp7bN?IE)U流qPnD^bvE7%\"#{_*@@ <44-MiQ~-EL0@=́Q6tx]qx\nd갱/^&W%;i4;Xh	jתYiҮ~ш\$aDsDU\nDtKZ@|0R	rt9oUnxhٜ	fLٝe+z|^K̓,Hc7<fNu45蜭c̏ksgr`hJ4sTEP4\$|=\$v\"#F8a7H*KN*ɡa-֨poʊ}~5R5:FghΏXюɋA|3h`PwkHZp0C{n3n6/NF䢼0'- J,N,V ΃pJ\r\r\np\n0\r\npc4<ס%p)&\"8v'DD8/̚/xM, =\"<fpq&+,!*<p\0]M Pp\rF1-PIK	gY5eѭpJ0؍.PLylq<3BZ,nd\$0/\"clmåNHWk0 ~l\nTM^8\"\"GG\\K	#r@t`\rT'.>DBD7M%&Ihl22%\nzr9%S&!G5\\Ef&0'hҙdTbRs!pΩ*CO2	 Prㆱl-,nemL J\nK.=B?b=H-Ů1!jb>g50+0%O0Jh(\rV\n\rgAd&FORV\r ̀( \rLȃ@\npx56<#%1Ou/YmƲ,4\rpge;D;2psg#_<A\")i+\0kXno\$%2Ft#<3(+Ȋ;@Nfg&8dfpk<\0@v#Ɍb:6IA\\!QE:s+E/0k2LnVy@#F#QIStQ.G&Ff/\0p`ϧ&fC`0d?2&QtQDmTraj[0rgJETF/ftly\n!\nMf6F))Fin\\Ak)a00Fe<!a`F\n&";break;case"lt":$e="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9X:9V>B94-\nc`8	_\r\")#jHBȔC\nB;%2\r1+-B6@l4c:1K\"c\"l0\0;c XD49Ax^;p#\\z#.t\r*Vpx!H \nPR.bckx 2T=T.6͜kP8Ά\$:B#b*	eK;@8.j>|4@ЄH1*@:bX:U)K/4L5qކ#;3ъ\$*c9B4*W	RTh5\"bTBʔ\\̆*9hm6\r[Zʎc7;%4c.f<BtC8hr4?اQa&Ž\rv<>K;\r,;!H!APoKAj3nK݂'_(5roћa:>7%4hdB)JrtA^׼5.JR91ʍ06G4D:*\rV7:P:Hx-zK,fGu2R	U\"^-bRpuLortSHGI&D̚RlM;\$PxOAУ!`\"йOٟo\0=B	z尔@ 	44+FIQR:O9,`/Q&5JkM88+\nCyOq]Ӻbp.BB4xt.!D8D]k,Ӱ<!#eR40	M!+  zX33~ß*~|ԑ>6\r;`!\r^`\rԱi\r!^Gq\"2DB*PP	A8.GV\nJc=4g\n!zE.٠ol</%BWeTl?DRC>C~KVM8OK*Ήpe\$<P\0C\naH#G4ZX LĦp]E]#)jH d @o\"ɣ\$ZK˃HBeh6ӆCahI5>'dʓ^BɐGm!\$D15G8CGmpPQ&H{6'0OdFll\\_zmdmB\r,\$PzRaՒ(YU!_cYsf:3hsI\0ψU`5)oi\r\$@^Hb>漮7A)'x@*Dt-ՍsJȼˬ)j0ʭW8~osxlVCr,\"Ȭ&;'n17\$}Eqj`4G?\"K9ԙY[y\$mK^DKC.P)}eVŪ᱆G^,qء\\\" ޒn	\nlh'\\K@AtdGsV`:N20Bw˽~PLjݸoo\0	^z(JiuTW9&gt\0(	d@\0 ԕn SgH;g<	,yS\njpy2\$(P]fJ)܌%_\0W3qYq8U\rJ;a*@@ \rڐ-ܗК s)KfVM(A^p8Ng3dt3B5~>zQ\nu`\$*V)Ӯ@Aw\$\\qIcq]*X+y4| tOyO7+3{_\\39UF9ՑCّ1:a=KO#KPdɺ,0WpΆ&% VdxŀMg#}N0*F-ZN,/gTazOz۞,_/=o\"t;r-0bYYD{Z_k\$zS>^{ؼ_zb\"Y/f5Il;|p%peŃwFg /6bP\":58%8\r%[ @T&RƯ+2q#\\TLm\\@/P8a.W\0&\$	,0t%K^7}\0[0?-Q욐pł%rB\"e<jJQ=\r\rlxp\rpdRxi7:հT\"i,:\"<\\\"#z#}^jg#`x=DӮ7C@(bRK'σ,.r-d킪V@ϑ\rҰMQUP^zc0-/pۢ)PRUn#\rDNjX <RdZi=Џ\nі	1\nw ѠoHkbc\"\0R!PTÙm|\";2#8o׍PR`@prm,8ؑ#ҁ'Mi;X@)NABdj Ғ*\"Hҹ-R\n g0,>TBY3\$d(% r!M<#X8~*6q]!DXȘa	0Q_P1s\"0,>\r31261ne*\rV\0`tCE2Pj;\"z@*:~ \nps0@\$,^l)!3#Ӕ.~s`#[İrppϥ\0@B&\"\"v8Rb,b/dp8@Uc\0B3Cڲ96\n٪`޷E\nJd48B%\"O|FXs^3n:kh!BB)\0R?.*\$J4UF/ LBƀs\$z2dtD dm\0`/:E[l\naUqF1fe@hd	'\\T Db^4RnҀ\r	G6=-N'bGl&Ɩ\nME\rd>]:\"KeJlv\$CQ<\ri=͒>,%\"@! ٣\n2)O8";break;case"ms":$e="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7rf\0633Pj0؊;IΠ::`ޜ+	B6AP2\rK\r(拍賔8z,0cL'\nu/CH4\r^ Ø`@ c@2D49Ax^;ˁr΀\\z|\$\r|vԌzZ-!^0(4Dh* KÇ\"Pɽ\rb	.zhP0MRp#\n<MKS舖7蔟10\"Z|7Bu\022PK#8	\$RzC0\"@'ibn0j0:L\\\$(ڮ^	-ݿpROv)\"`ߨ R`0+(wRj@%)cȉ4zţ~[MJV! \"YՒ@1\rڔ=wiQ>Þ7&K:'V޷]<)5w٪~-n0Pٮ\n7I3lQ*n#o1YU	NR6')\nG%&\n0A/V*D(2s}sP0\$S5`(HARW\$ͯY@74HܘI҄*Jĵ.0\$7\"Ҋ+L8'#Se2z@X|22-LB?`)GrKI=(4[K}&0S;Uje&0:5@94j3T`\rwtL#q`hGh<z=!:#8f9ȈTb0u#	xB?GaޣƓs.!o\rRD<@@P&(\nIшeҤU\n~:0AtFJ'\$/('l\r\$'4N*255K7RGJ;B!Qȕew0\0F:UAfA7Bq<ra(؝>P4ĲTrQ6&!8:IBQ dJ\r&vI0!l}0\"7C>uQ-g9B\"<)H'tPe\r8gBԤ@I,lT'D敻IJLF\n#&jz2xdCF5`Qh\n	8PT@-rX0,+V49Sb\nRI@ %GQl@X\nh@ك%ў8	VCj78J肙媟SAhD&zq6~>T+AXDqZ6GBn)H]!R6!\r7b0Hb/E:H\n	Lpi`%~PEpk:9lkYI 0؈j_r\nd̞OKlؤej\"#cdA\rn9>ټAI!a8i3\\tQ@<S'erJ 8HZ8\\܁KـIJNPe.6BA2#yFUWmX>Hv	UmЩ)\"dVY#Ԃw6PnfʔJ^?66kx\r9#@֋^`j{W%^YLT#L'~'5K	\ruK^7R߼0G;~ԥ	݆6IOӼ_m-OB.GϤB4\"<FrHxd^~'XW+g!LŉKji\rvLZv#)\rz.Ќ'5\\>ڎyN&ON؇czkxt]_x±{me(Ki\"yz}~E`'>&(\":1BF<ș3*yͲq0A7dB9yQ sН#ʩW@]Mk\$tA}}&{_wnTtߑ|7\\O'W\rK(Oa:^wá%ONgi(ڙ[B>FT(viO\$2D2RNʌϲ1\08lɰ\rȌ%F-ֹ\"ZQ\0YϦP<\\p5DN\nC\\ƐZkul Yw.Qǂ\"Y0b/̢lh@s		khMnBUp8(0%VG@ƅGD:*|!GNB\$k`-r(5B2\$@\"%c8\$nlު\np\$6\\DBvi#m8	mL8H0++\"Q\"30X켂Xʝb\$(RB\\\n2pROn_[\"b1\0oNl.5mУQ6&n*6REJfu\"hf`\r,'*BbO!`@l8ʈĞF\0`?##z_V;4-?\"\$z;Q&8Np@\r:\00l㒶`Pm@";break;case"nl":$e="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	H<\nhk=oj9n4OP7%;ãR(ڎP2\r'@m` pƒn@<m5O8x3(:7A^\\+zft2#R7˰ڡ+x!j	.CW+9jĊe:++üͣF67S'+í44p(JCVilBXޗb8C6crLEëT\rV0̮0b;#`j,#uq1uȋI	!3%\"PÌ#!i(@\\]sח#6`1&{Z9BP}28OT	ܐKMeSߐP+ P2j\$<6cȈƃG22.E5\"ڮJ	* Cj*`#\$04k	K4\n7\".K3(+\r5&YtpA=	OCHϿҨ̶paO+ˣn@78ɵ<㬃|ʆ#4JĴ˲;qe3SL2,S8C:;O<**|Gːt2Jc2\0uJFpdR[{1&GBj\rɩ(dӐs%%>kNlJV{L*\$\r9f	~͓*~xZ0T \rs!!Yt.9PEI!E0`cJeڌlGPC#.@\$#\"!#a5SAUw@)cb4aҚx(hS6h!@b^E(A\"dx2*Q6\$T	\n4m+`V\$g) OX.E(q9dv-Q5&䝓P,8D+6l6#mh(Lz@Rg\rSJo S	|s(2^͉Mp\0 -iԨ=k.Nșc_=nFx)4kazI)TI@^Leb/\01@ia:*HbTZ<`z!52C\0\nzF\0U\n @ED0\"ez:@a@G`3`tܿxۥFm7\"synD4k3P0qK4f!4Rb(i0(FI*:bM7!2f6,I:*E9g1'1cVcq;IE/2Q\$\\yNa7Qq؏RiC(wRf4<XCVHB)0\"v&9zz]i'f0+80Caʁ%{(`*ކ~:fBaFxwPBH0\$\"9\r\nV\$r\$@AWʙUgCTHc \0C\\&sJ)#b7b_cbf#(pW9#DIgZה\0Z|9MNX:cs\"Q)܋KU10_:K6z!<Z	V\$}\03E }5~;-2?WX\nQ'l`K/,GBRT2FrWxIUAS*e4#mwZ\rKU	_vƱk㷦Xd68#l0SZ!*Oht<:niňB'SaʨW ,5`	(`sGZڦlAΩ?\rvtRs̎J\nd_&͛vqv٘߼}^ø}u_VxVW񝛐\$XkuFt5H[pm#8tQ!L`:DzRY4z>:km?~eo%Y C8X/[5`dT+l6'2\"HW|n4\r#jTfJ9GDnPb<_q:0[B\r#ǎ NYs/\\̱PL[l2S#ip)o&]vê饈L8TĬTn\n\nRe9P\n0]'D;,ADg\niR=LAp\rWP`3 Z\nD!bf/cC\"!eW#G5\rϱb\r\$~!vCTYb\nm_Q>\rNUR*p_ R jT=\$krz&B1C.ʠsg hv@\npn\$R&\r& -J\0#ˏ #4(\">\$/⠶`gb%l<> @Q\r`DbzC6XZ;bj	iPJg#xȦ#(\$Yf:0.B2PRVB%ß#6%HJc%Q(f*c838Q0'KCS\",]v\"8DRB`k`ΌE&\r, 2t#BE(@k'E*QEì\r.*R%.bV/2l(dlD,r*d;1:\"}(\rZ.e.C|%F	\0@	t\n`";break;case"no":$e="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+DyٰG#[NQB<ΎC#0<2.[z?Ȣs69k` jءx<p:kC0c>.A\0@2H4\rN`@EB|3Лt㼤1p.9@a|z9qJ(|63-f7^0H\$b\nʂ\n:<#X:+RՎH;T3T@'.#\n7-8憌\0<\0HKPi>%-\nUhڥ/\r`֟V269ò:3B2*S\0)5bn;-̨0~! P#BC\$2\rczc\$\"`Z5:4Â.#C#tz\n5C+\"	-d0D+[\0\$BeLH\0V=A >*r/*#D)z0\r&2	\0܃N@)n8'&\"@~ަp\$e3p#+OǴ	1\\6PA^~RGc5B@R¶0%C+GC(P9)H:B:0iH4^؀c{JT1KȁbI2X&*rĵ.\r|:HD}p%;9NILP\\xpZ0n`*y	nTДj_@\n bCHĜwJe`lM&fxo/@!7Z0٫19Y\$  :lFiճ3p4̢Q4TDb\"nCfo\$:D+v(g\\ٌ9s)DE'H!P	@GO	i'4E&M톖pKYDƉ?\"\\lOA}wA<Pcwy5<M3&?\"QSF7t@F40\r.=,b.7) Cz)0dfP̒VSy12HؒR~C	k9Eb>d|ҋՉHI\"!C-ʡFE1&/ABТ3f2iik}˞( /vL`nHE࡮O	)hӔV	0gP|s15\"8G\"\$ҜAi&`%`gJS3U)e!`FpܸL\n@\rP*VQc E	ʑ5[)?j<eHYhZ|L8 :\$hI]fJPU#bUYL5 &a\$1>'!h\\12lٕo*Sr9tJJIi*	wk~B;%<䎔ig*jyHzATkPD=݄K\0QJ1>탍1(阼1a	d~L[rҖMa		-P߳,1P d)kԾ\"5]AI>U:f1(eAa Rb#4) R-\r&ŢxPKz\0#2\0%\n4A9<%-b@Q!Ȅh.@JimbTzvC\"yr4e!H&vGG	HK܆4s`wS%\n2:Gԭ[\\U-@P#`L\0Wloʈ\$ފ\0001f%>+j'_(Nɋ3,@RXI81u8_⻌lPlS\"PZ土-/&lZ\n5*h2P`0\"j02\n@]4uOl;u+%-{tVJϪ@\nь-qeTW=]*SSDHứ)vLo@Ps-V\\ۼkY4ڭ‟4Ftbܸz-*vOl9G0c\\O{'Wr7+N*V_+4\0Ŧ~bP/3D\nd-|J\$0&her7,-.ĠoƠQp\$!87Kds\"Sp̬PTBOhd#V&V)n4]@\rt]@T(\r<0.:NB.S2˰n\no6ph#L<?rG( qe+0Z;k/#PV8NbZ\0004Pl0m@z0;쯆%#!.m\n_3,\n^gCȂP)0mV(jPf	e\\T	V EDO`ՍbQ@P\0``\"ycJ4Z5ڂ#Nf\n\r%1m>1\rc&x\"`b)pͮ8J/\"H8qΩ.K:j(m˯\$\ni.KfŎ#\\olDb\nrj#'ضfR&˚'ʘ5Nr撡)2rf2&!l7FEˮ#2 \rmc#lT_ܥ\$2Ze2Bڶ\nfJ!GuRx]@(#%\n1Ҙ0\0ޡ-+i ș:A}'%!Q`";break;case"pl":$e="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7,I()h9<	3\$#R7\n7#ݍxcK+5\n5DbȺ+D7`:#13¾Pʡ\r#7c2\0xC@:t1xOx*J̘^*^7p7^0ʘ5)D-9[`-.CBCM;@Ϣ2C\"40H\$\0005M{_V}\$	cx:\0*#7B#p[.\rn9)JA6+UHP:-: ( L`P2Hz6(oH0Rz6a\n1`Һ:R:=փL 8oCIcorH>n>\r{X(Tn;=]E\0N]'zuZ9ItAf#R>CL6*.^Ao>5@P6w@\"[:*J垍j{S!-YĐ@ˎ\\9s(\r9£\">ph@H:Ԍo3 Ѕ72-.Ce.:Ό2E¸3dniZZ:0jʌA;S_C)jqO	W6,KgEkv\$1_/Pgp5 KG:%hv~CɰDa',Eے\ni-#\nxoGuIsڒ[	t2*gM)6dp\rє>4e		apА\"D&H\\(mez2RB%%3\\v,%bL4&/Sz;F7LPnOi1KхH dFT} EA	aA DAVZW@ oEΆ(&R+5!\0hhIh3a&IjA%f {&\$U8%Ikҭax/Q\$=\n6C(s6Ux(7\"^LIvb#S.]pIh'.\\k@)A'bgQJ(4rt,g	b@b	N	ik9DLCiL54l@,R07pÚUJ4]C:bU0[*X3jy) %BƲ;Gºhm*A6\rgvNI;ԃ/-La2NP&(_MVdVF E\":Om>A:|ySfX2N 1%pvJs,+C<LK๪jHź#W·jZLd^G,JH#\$wR R|r<D<6`LHK@oX3R!\$|lSn:-?7	ݿ+9h\nw#L1,	}sΨt:fīfgi(2Shfdfq*(Qg *3@5B)gyej\rJƼ)|ү\03PސyiJFBo39!AC\n@oZ&1Gy\n`2Q^t5٦i]BZC\":S#h7!eC#7MXЦN0¡@Q6 ߜP\\xb(}D274\r3=!HϝL#[:|҇P@L_,l˸T|g` @BH#uL{TT?pu\"j冭1E+6}@Gc\$5]_ewz\\2pg{=^C*?;2vv<xLGv{OР;%z>݃7719իy#duF\"F\$ʞ#K8-\n׉T\$zdl*͏CKbΤl'St8\rH)#QI_G, )yw)&0C\"j%&ш8CL>	~4|\n%jsaFfu(0N(DbZp[PaPXpJ\$\"&̞G6\0\ri4h\\\"KV]b\"@W4h+A`004`\n(o@w{ZYZ\"\nV,%D,,ѫlq;pk117x `ڴH9D. JM9M1gmE#&FH{1[peKe0Y*Iq.QܹBlMvFdCal(+4	t\$F_Vjf-dGb%Z]mu4qv#YE\$@)v-R!CK\\@	Pm((llm##	p9%PQaO'k'Jܬ_)Np.U#8Q%q.\\('V6o,2+a+T,,R%,p3-rz&HZZc8c,Ie <K).^n\$vǔ@`nq]Q0-䑛)M3sT\rh&јG*5_6ƾHETჺ{D{N)8a_9mr&Vstl'* \"=R;A@A96q<=(\$*ӟ4.==O9㤀)dgB2њ<\n!EZ3c;AOf/\0/#j!BqB= C#7/Ϛ#6*\"Xi<EC2!8-Fh3qOF#(&R`*>ei\$)ú),L1,FtQ#B\$]imIi\nZlj>%nGtoE@MN2Һ~JM\r\$Bb0B;\$u6㓌`4b3%'Mt9H>FjCMV{0E9d5*\nOFd%#3p;(U\r\$&0zsQ` L0%SX͙WP PXEO_W)-Y-bpEZՎa);{R(In 5v|G6\npP6p__\"'OY,T kcK\\(1Ɛ -u&0mb+\"3Q\n-{XayI4\\GdF#X\0ͣ>e6\"\r W^>l!`qگ|;W ";break;case"pt":$e="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stL@% L4\r\nh:T8s㫞pȔ4TX.pǉ\n4n' P2\rT:\"m< c<ܰpP@;#\rIC9430z\r8a^h]#r.8^A,C ^*΄̺'{|B-xƸ0,NLJ\r]21+ѫűU<9T,;#\"<̶P\r:(\0< MaX!`꼧#J=erL΍Ch09\"0:g%J15e7\n	P㋆6`7؟>|\rm(3xbi6jr {\r3157Zܤ&LYRUlGIqEWR焾BWictS#k0\$Z[PŭD@!L>\"#2]N9g.{e%(q:iպocXRKŮ,.%`U4m*Y0I\09N.S&;ޠ'Agc؎c5ak%.<^3+\n42SHy=Øx8曧-;Ph\r=GCs2CLKRL)2tҚhwM9 p/)EAD<1G>xep&0ĆRphb3#]>,BMN.K~D̚RlM@䝓Ì5?\rz9p8@R6o\0005tGH;2[ 'vHW%\$	O4[T&i\nVՂC42}/gR7h\ngP1%ac.\n~!&H@IKqaMƄ|@PH- PTI'+dŇ2<I l'07' s߬[#;ٍ?I\00L9굒7ؙCzA%a ^EpXKI<(],y9WlaL)g6&\"KB]\n\n'I PJE 06R?!A.%uNI&~ٙ7uPM7N()\n\"R7X3`xS\n,\"Rx㔸譙`@ u!t 3&?M)j@n0gjEM{Ê]7'e\n5@FaȒ i#Sd2(L9('@BD!P\"KL(LtsrB9X0X<d 1jL朣X0řD(ʎ4VAhGiZ0(U7FG43dԻ=nVsZkQ/\nsUVҪJ@\n\nrEs`T)i}`\"VW1F Fb3U@a\"0^+1eW7@nLzKP/F8ո1Ɋh\nܰ!u.^[T~\\*@dj3MDS6FߞH=O\$o<&3ᓨr\\1tALRHsD+-\$7\n!@K>u4)#%%`rcp2Ƃ׊p@CP.knhf/6=U++jBR{|;N<OflfpM|\$9rR60O{	\rߕ3G)\0r)ˣgdȫ-<B120Ɣ0On\"ˣ'*1rfxbqG<q7ɴS>A<NjBsbfc)!|+V4MzdpGtvu`/3o*cxٌwtGn1\0( L\$^>5SiIpqD6c1>OmE0:E2_GVvsBHX\$^ZAEecUyQ%dw;%3򿑀/}QX>vqclp.\rMqBo/\rܔ˚f߮v\$)don5,\0+[nʷn`JC?H3cdb6e\r@/jxbkdTnY\"<#-[ PRj-\0\0:TNƷcUN1 Z\0WZU/jӫ\n},[\0.#0i*	m8 +!Zd̀\$>(܃*J(' :\$'p}9E+/FTp%\r-)cyQL;FZ\nBkq\$oON}br:Q7'OО%F˖b\0\r:q0\"p\nR[]qB}0d=\rJ(XVB|@\rg fRr5H0BX3oJYc\rVca+\n!D|}`P3qTݢN@*k\rH\np\$T/\n0/):#<I	rFk	Un	th\rqk |bX'\0PdLDΩyjat]#bFh1W26E?rV!'Fe1*Ebk֎'\0006O0\\Dnn~'q(|v:4*\r9rI2U`b`RF/3*0c\n\"ˈoE'@T,Jì#&2:2I6`͂Cbh.i+<4n01+Y+ .6*frM5\$K Xg 5 ";break;case"pt-br":$e="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM83@ij;êBVB¤+92`޿x䞍Z#\"\nKn؎v\01I\r1B\0(j0p; X`ьD49Ax^;́t7ar3X^8IҀ2(7z^031,c\r@P<nCA\r4@%\"7LSTMJpޯM\$\n\nx(CUlہB6\nt45A*7m#jƽ=0:!`CkD:`e9Zבhtuӌt(0I\r	VC6kn:7*W\nw( 6%2ji*&L[>c( ([3F\"B6!}f5Wl4F#lpB(񫲚\\Hlh\"foYC,ϸŏkA3/DX0՞Ӣ#}&;/t*Y+Ў2LmSXx3\r\0,t7)X#6n_)x3/q|2S\$hHS\$ާ\"\\7`:q[4R)Թ/L;wMsh,\rAoJPR)MMɂ2ja\$&4IrVpPV})m.*g~i9&I[:	;Pm`t@\nbTP'Ȩoa!`ΩM@ɔ;iCY0h>QwIxpY\$ѡKc#&t43ߡn#L:nn!^&(7\0TYqdbPNUnE!srH\rP6ͫ[?TC0id,d\0P+'Q=(R{	8\$@ҊF8!4D|d/qӺS\nA=C4I CĴ(v!f(E\$Z\"D􊡨A@rp!\$VJ4\"Į%phfƜ= c_\$\$hP	L*3sĉQ3ԇ' #FT˳6|s&		MM'd'ݯ6#d2KK\0F\n|+25ҕ\"N\$`Hc\00\0P*[, E	ΑzXJA`K癇.E.(G*umŰ\"^IGU\"jDt*ͮ\rSm&~3zo]ij5TvQXBIYr'h+<G\n:HS\\c&N*\\.Ct8ͫfa:1f40\njqYi	e3puMH_	e(+Ŋf'CFY#'#\0_j\0m=jL1|护CuRS,T\0s\nlؤN09 IΊqM1TQ`T\n!@3t1#ub\\3JyCzVzUb*%=Z12ǹF>^(g5%F8ybɮbLZbRN1X8` Qu|PC!Z!aӇr/&expQl,nb&黩G\n\n/?ay01DV6 +0ݺ6Ɏ)xecIsX%\08-/_W(db0a>O600}bוO`\rϱ'Fn;)3`fAǗ{xHB]4b8}v,f4f8@&YZ;o8v+j<S>D+n2fUFoh#\0j!fė,kTA\0,Ywg]0o{/⼆,^x|)T3K2(!ۧg.8?Bm^'[KaO6Ω~̩/\0\0,\n(-Wf/%cC\"˦\$\$<.NY(\nXJh*od%D>0>,bPR?#h/oQ\n=+\n̸?hk2Id#6]@&%/ȬOA\rC\n\r3oѥ8>Zλos悌о	:+k@(zDX#8&6e-IP/PfQa,&n,.\"vZ*:z0J0\"\nhfžoF̫͂l@gFd&xL\nX&bμBBQ 'd11QbXIbzLш3er\$i%4EQKD*ڥz_#b7#0o<2ra#f\$u&Pc\rV@_B,\rOB9qLۣ2`Z_s>\rFx`\nqŮ2L'-~O\nA	-'ok-%	#<\$D\$\\%#0,HE\0!/\ngBC)I@\"g@[/rDJO\$4=,C\nDatS\"n,6>qIP<N\$ojR\"7oh!gCj71LZk7p!#Dz9^;Ӕ?*,`1\r쌷`{BsJܶ~pxh]\"8a`4slG`꒦;ct3/82X0ĹEBbIS&QW0k@/V*;\$G\$@~/";break;case"ro":$e="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)9j6If\rBpK\n@P0`L#1P+>:L7\"p8&j(2L肥i@2\r1À+CƫhKHlS\$0!\0\r\r`@%C3:x;RAr3^8L32\rp:\r.x!6C)<Dh̥C <o-UV\r5sɍ\rbANJ+ăr3h\r:!-hh(k04Q :ۏ\"`hCsm(2\njtm[bF%1,;&bL;V5h|@)E⁏	{2blȌLΐ&9 V415V!ňiSV4-:Ưpʃ(7M˒bH%C:\"魴(i^в@\")ZpZ\ny**rʄRz)	]EiaڔB\$_?qB8smh6F\0Sbր3\r\nz\$*\rt<'̡3Fak(aJm}^5Ҵ枊S^H3~ɚf;npÕRM84úyH	?zD/P(}RRe@M		 !	L>3SEIMK0%ỡ< 3ӂrN<'SP,J>nAʮ\nC'UCZ+H9#hf2 LA%ܼ,Su-ldɸr(egP{ρqheҞCwK4e9),چ\$od9\"KnǨ'乃r;iLn\"oE8r8̐\\SC\nq!ǚܻG#jijߴ˒X!W}FH#څLh4Gy'үBOBS\nA;GyF*'L\\\$QJ9m\$`Ffg\r4m\"VHs%_Ry\\<\$V|4!gsyX+AJ<t,✡\rI+50Thy)dH;pd!}BRK#\\BlI2vAƨſ']\nl쭳cvK0T\nr>US9FȜ&2Lo%dѕ3ɐ-]vubje]R\00S~n*E't[>IN)8ܭ.gC0H}\rjNțVxAYuK*tmx ta\$\0hʒ~nh>|1iV %8t[ͩ0@!?Dģ/92pGeVk\"=S[mQ\\raj:D2V.lWt:E\\+N`LRa?0 1mJpWm\$R\"A\\2f`KX3SRvs_İJ!!P*?&StpL0x/eQh8A)cXkUgkPQg`)\"3Ը[W.;񻌎*;nwGj-:Wh'z6+}quwweFT VWD\"`q*eoG䥮4&|G:Me's9qPx+\"3OaiEuݨeY/nA[ٽͦg6*0RN)b\n3W6n܇+G22&J`wJ:yyIo|ҺxnS'UJ.\\8y{`΄DJS&յuɊS2唶kMH({!CuBd0i<\rpX*}\\濏L*p5Y\0Ly\0´oG*: lnV,.եD.U\r0.ND-:cU@50D5L(lh:F&cpHoptЏ1,H\n=CP|**>v/¥<,cMc\\\rc;'D[i	pxo.);elFkLGϨ[3VEhoDLej%~,j\rxeaL@lGL OPL.reP<oT)F F[#ƶqBOBB:@aDCob~S\$:c:ZYFaQo:-Yq:-^TQ\r`\$U1WP9%D\"M{F#Jw<E/%\"єzR@o.Dp>Q!#FBBbom%B\\fQnh@(\$n?id\nA)[): 2d'K1:\nr3D\\ NW\$/T?d!b@2,hFqgGcX/Gm!%pdCE.R	S1m\\5F\0m*W p-Fh&z'~fڀb\nZ2\$>.Y䥅x|#,b:#B\$gcGfj̄<#4bOo4\">[B 琬,Vp !bzFbm8xDGw`_bD+Ed_cW0W12, 4loLS(QƥA40T826l2jd Bmgm@/%_NƼӤqF8eRt`b:Ed.XF8/`@ZVp,/:% DJB:nn4\$-0\"fPjt@\r\\mhxQ8\\(`	\0t	@\n`";break;case"ru":$e="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$(!y&h02XE4\$n)56d+RC<%NE3# 4(<\$5BϤ>Bnrb_EV֖S MV<*\$xX@4C(C@:t㽜41Mx3(9K|h5ihʵj)*D2\\x.#ӴֹN	a\$̙,dO!iDEdnG&γ!6]C L(IcH9?3Ά7:%VN{օdk⌮~Kʟʆ5 ijt\$;7voL67l~Խ*|۳@\"]bR&){>3zD|꼴.3GNdvJRDcBaOT}6#\nM{m!\\W!%t(9˞ݻYA\nb\\\"#)+\$\\F,/=cwi2	W%Ac؆C%P)0,^4Xx繱VM)ёZpda\"	#`#?9ؠ	˕DV@D\r!0 KsX-k\r;Se趃i\r9^RÊH\0004O!x\nkEM1,hq5&C\\=ki6@,I3M_QTDochsy|yq0=gUQ)F xH#uC*ա#C`RċlP0YBt,*19%℀SN\"Dh%VNO)E!;\",IK#%F7%f9K)	%=3ЋhGs6Q.3uwCb+\"JaNQ~Y#xV>LZ UUK9'(-']BǹSz\nXd֍%ZYl-^\"Xa)m%h>9rx,颙ZTzN(b.mS?L%\$\\=4E&*4\nIGd-QyGUe+Nu\"Y)f,&Z]lEL\\hH]ZsRc\r\$9y:W!GUID|*z\\ldիBQ\0zŒ'XYJ;/e('ĎgMlYHm(I\"weQNۢ싩<DN\$!Sݓ,*\$\\#衪zd(.@?rFnTBzCkcPHLb\$5Gj>}5Q[11+vJ(Y˪\rub}AwJKY.\\ٕGcw^@7 FR֥3T9ǧB~\rPQBF\"GdFtJR%tdҫ9K6T(%Q*S\r]r_a@\"	٠IZN]->e\$\$g췑XͧpBFW\0£Uf)\"&*k34DU[@rLRn]{&?Iy^4`8T*kLOq5xu\\&A˧o%]^-b\0O%4ӥlh8[Kvd+_ȝAnVjHg9v!~pA:#zoL̆ER#i*ROd}GJ8]8&~)L!9>.Q[`p1=	J). o3;aPd'Bv\raYڐxXr	d}__ZrP XLyƧBLJ!AA@\$	>\rC:.5z)',Efq̆7:A~CψMp|oJFnO֯ƛCM.6F,c-@bWnd\$'ʸwBa@|pN0gcn(LLΆb|\0H=Bk)&Dj/IzPbKn@/BЁPf0\$e\n]>nH&2bmG^aAp0ATC+n/NelN\n 	&L,QK&NPJs z\$g^1Tʴ\$ک1_#&;H̦&+z\$|˰J\nOt0aqnO	Frzq~1Fre,h}MX\$qѸ8K(#cܖ(*޺Ɲf2\0 /Cur .\$rdFbv@`Ql%&\"XNT/xv!%\"C%b%n/-=J\"¶0晄(2hH`刈vbHLic3F'2P,KdmdJƠ>2ЊA1nG8N,cC2lJ\$%/Co)`E0K3NH0,&.BFNO,R3[3=sB/s4y@*X@bdyfLB)P33FZo,o\$u.B\"ZMOa8tILB>%i-&pLw\">PCN\$\0R3w<&65i/2`lL4JC2JFYAߧU4Sl5BEC=q56pD3i3EfWr0QBsY>TJ	F/!4g\$FÂaAGR&e*TR~t1HtcH7L\$oIaIьG}J\"%DA2l}4m3ΉMMΒHGN\"CN>BU:Ը\$*,.jSk,I8-B%%bbam͸!j!̶P]?0T\$4?LhU0ibmˡåNV>gH00е7FB6<tdЌ!f:딗4L#,:f3A\\r5Au1Jo^;6]]Q\0^c]]z+O h;2]P.0S9bV<)|j\"!A\reBBg0\n˶E@MZKԖgH0VfPgLQ\\A{3+hUK56c&%+puֱ\$DQIV&I6CkBp>olhadNw		RPNt.В!tMpaEpqbcc~[oЪEqq\0VHGO*A/O40!]WRtpi5vN!vworWtK\"ShKtx+2l}Hbыt2k{41{vd\$wfxʷn=jbNuEÛ*sy}hr{qɗLt7w/tw2G{#0dB8h\rVS{º]ae9V,%N{\\Wk,#2'XUp>UVmZ\n`qrl^UBol	ωladXlUjt=ы}{c	.V-wb?ckx'|p6CxWsr\\Wۅn9XF8P`\$hvAv.'e`+5f3&&PL(o>)fl!\$qDƴfOtH;UH4aGbR8q?IQ+-9|y>Y5Ƶ0Z'Y3;8\ru	>r3S6C~MxfNP\"t::\0M>@\n`Ko\0\$u\nDPm\"\0003>Z?OGG.2\0AjGff\$}dPs.a]YHt~j:Btz-SbSZ%n046\nfՑ*TN%";break;case"sk":$e="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"jeHڇ?\n -~	\rR@n0b<4\rp991	R4D#( j \"x5#Dcp0\0000j`4C=\"E;c XH2D49Ax^;r#\\zrԸ9xDj&.2&H7x%\"8<q*2&7c@:\"\nC6\n\"44'WVmP'hv5â:7<hJ2:6=e6me\rMh!t8*RP7ՃuPPbքH1C-:C :R:T0VL:co`_/P5*#(C҄JŴX\rbkFc^\rc`0	1#r(bV:&|:&Vl6PU=\\#-.J ȧ=z\0 P1bCH!^(>{Z\\;^;R\$\"6ʘ\ns)ZeGGiH2de26q6Ɏ4OI۶K`9.8r.|l꒎x3\rR'qCސcp`#I5\$9/0\n}tu@C\nbCeD;\"f)\nEIIh:\0ibQ0ƙS:iMi7ӲxOAfTzй\ru\"ʊHQw\n_E쬔JЊvRJ)O-J0&%BjM8taBwI=n/8n UTǰCZGp9=r!Tm	yt#\"<MA\$X`6Y/@Xf6DQ>}M*8EU` ^zCL{/`ƼV\"2	ĥtVM|\\\"B^)0\0PCQ`1ԕ#Ԭjͪ=H7v<JBquiD4X1L\"p-8_\">w\ru@w6yt(LgD2\n~'!0:*L \$\"o# o8d^ǢXK2{dj9.N&Wǎ./U#@%9RHXy3\rONVBU+8²2\0vRRQ>R<\$\nO\naQ؜n<4ʊpIU~6h (!30qDhe\rUxt ql@_`b.`)\n<{*A.oו[A%!:@3Y?\",3]Lm8PT@-WEŲj>XIYPet+T}%9@S\"+/0\n9h6+tLeP\",C%(eDkg794|F#IŪ5ߎ0-卻PXoHa#1bG@\$\\8g\$Ld\0o9#Fbb\r@\rɸ	mL4e:Avݎ)0X0ʹ}X0mvfNubSD\0J1Bz<8QS#V96#gh4a٠\0PFQjue&<[hU#F,ZI#A#cP\n!A]O1TB\$\0'\r죔|{ygt֑F₵Ah2\0foRT%S\njmQZ!\n&᧓2w+ߗs65XB9Y\rlr	IyF]slHQ3+9˻?<qp&YnϺN\04NQJ\n\n=.jAM9VL\"D%Gu+(Ҡx9f]p8\r(e{BAU̟3\$Pt꿒d쇓@˵x/:Âéгl~/17rdPP>#xIOO,|Z.oFDl@\"~o\nͪ:B6JG\02  F*Ov#eb>m\n#p^Ĥ(@ElnnzRE.Vl[Ɯeo0ʬhp\0Lt-ȐG\\\0жCq\$0pP	n\$\rSt\$ p.HnT̞\0H1/O匞0_m\0quЂ1\0Pmt׋C0HLPU{vURi*% \rExEb,\"[@\"C(&`ڦW.KfYѴFњ\"(Sd.ةT*CVS<\"Ѣ\"®H\$q-~+WBg\0Xm:փ&n9bźӭ>Zp]\"c#nqXo#!#6kҒ.:(BR@ǰC&\r4]&'/\$\r<|1Tl#)1n48eQb[\$|SӮj'Qt p4B-SW&R'p\r-+҃'f@ɆU)|F/)-\$n\"JZѱDؑU&o#s,b(lM3|Pڱ0%k4m)f5XAgRvrm)A|425\r:ݓrw\$d8D!7s48n4.:A<do1{01TLr,N5Se\$bEH(\$\ndWƚF B9&лeJ\rV\rg?+8\n(\$T&He#\$% 	\"G\np?#cΨB&Zꎄ'nsy3too')(#4#<\$_%Th\nFm^f@	\\6E\$0<\n79L%\0	޸O4c[{!B4bp-0a\nQ=*pRX-\n-G'&(~0,\rnp!23Q[T\$5c@'F''*FuVpGր/K\"'?:#\\\r\n(2~Y'*ɤFT5\nN'K^mp%\$\"g51eJc1LҕR-^,@lF\$\$nlj_4RT2c?#dAg{abvB	\0@	t\n`";break;case"sl":$e="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(֫K (a֘y2B;4B0B(0\0*5R<ɍ0d j\${4ȧ>'1C&\n0h\r\\J`@&`3:x'ʹ4Ar43(v9xD\nڔ#x|k(\n[X\$֌)+<;.28M.'\r&2#(\n\r:*\0ĘMQUU\r]TcRKY2%C`2`P4\0P7k## 	2OfB\$0bk\r:K:+\0C ::J5Òx8Kb7ڀP4K7&*͟k863.h[?7&-C\"mc]HrMUT=%\"E;9Mu\0AN|P{ZN(\"@P\\K(4K[\0@2MÚ^if)Ay\r#fh#CP*Q!dSÒ[TJ3'J^'bMC{%5=<R3[@9t0_)P9)|\n9<s#=T1)QǸ6w 1,#IT'J7*̶2Md1߂<Գbj*x	cz-ش (	/	\$<l8\0B|i\$úQC/+\$mKM-0Hm]d|TQ	!=N-GO7D`@b\$dkey2J3bHaT:Qcu3F@a?1Hr@޿u9	<2`ICBj)@\0()\0d&Mo%\r7̊2aN'.f* E\\7u8֩vA@ɴb\\g1Q.8pw%R c(h3x4ǘ\\ĴgaL)h	7F Ih5؜L	4X뷂@eAF!dJ1\$IjU@C؊	S4	V6Dɋ\$v]#M! q@az?H)t̼\"\nNIO\$InxS\n-:@u4IvIVo	H14>H\r,UE2 K0#I@BKD̟3J`nGR1Bȝ\0sf̤8!H2|QH'cA4aY(7uuG0R'Enb9~b`f	1MȡfyfgQ]b<2a;CtXz6\0 )#\$R~  cq'Ù3P\0(-Eb2	Y\0\ne` xripN\nȂtI>(8_0TA&^͑nY6y\rLE2bLLܐYk[/{\0l>&%q:qHź\\PFMD>Y^O9>'w<'蝡pC	\0.T>i*#_%N[&j*^Vy0u\\iJP⫁Y㼑Cu@doH+[l⶙F\0uU9Տ 2%u)ϗ6ϊu7Cغc9uR\0k6K{gblcga֛-Is4s\$Ր)/nnzGx*ut\r*8IyN\$d%T8[cbAxs,\"8Jb#يsi*f/BKض>P|2ӥGgϩ؂cCsAH<\"\"0y>/k`K%bND.Ϋ_\r©dSR>1NFk	xtÕ*stW%nƢJtfLhf)^IV\0OZq:O	HL,9\0^|Ƙ]z6cX hvP_F\$\nyaQk</ONFt@'J(c\"%E~\rm-{x9\$lَ-80=Bo0GJNKMm<0e`LMPV0L!/@7p!/Lޏ\0&vNhr̄6K>WҋSL=갨`訣d\$`*b&J6ғ0δ1*\$Ȱ\rC\$|CKG\r\nlL7~LRlzW傞\\U(\0ť\nC\nQ\\p\rRan(q`oWLv'\0QZlѐ(c%MŀO2fKw\01eGH?/1ؐͱLp\$X]\$*fK\rqr\rejPgq0X#\$)+'p8 =\"k\0q&J;!%p,rL* #Mn/ϑЍ#'RA\$Zx/cb-1!ʉP/8Ɔp~Ǝ+g\0Bn&#؎:3P[,R\$_ܱ\nqKvU+So*rT3,1Ps1,S2gf\rV@'~7(%(i6\npl{bTi/E0vc8ٰT'\r8p7+ӆ#m:c&@X/` \nOY! ΓVr?)7&&k I:\"ܲN0^	ޭ\$ D\\`7>F<\08\$b̢f6B(bBrRKvCϼ':64FPs\n1E#PC2\$4EIQE)*2Oho@Ť/*\\<	7IBt'\\CਫƳL\nLFƷ/\"L\0+5\084B&/#\$ދ*7D\"XON6@2;F;4%pE&i";break;case"sr":$e="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9<12?b0QȧsֲσT\$R&ˋ`Ϊ\n|%8	!?/,nLS L l% 8Cx:cg;#p3#;.w>8H;c X(90z\r8a^H\\0ͳ|ix7%JC ^-07^0γʋjh#,!]\\(\0Tl]-򽢂)w¸9\rF#>N(aa,\">S\$_R:^HHH'ixZˈ¾Dd@N#;:ZMyR<C&3܏k+u\\9s',̒wlC;*	sm(̒܏H&fyHYrRsJ]BhX)\"b	5*銥I^̪n+1rqQZ5WI\rIy|J	۴J%޾ԪJ~|zϭ{'gaMB 2Rۼ@AwC\rd2(y!\\[SVQb6\rؔ4c&N(\$Yr7&B)0lMO/4Bo87@`uO\00033`@xgBAK@g(HEFpu:9>5li\r͹B\nB`6E`\r!8)zTJS*T#JYVHR-m2xk_/Iłe!ĂDuザjMJJL)\0\nTTuVCr0Y+H\0\$W\$6Ut I5<%N6`]!!N\"XJi(y(j\r>`l\r1|a!3KEq\"%\"vN\$Ap\00igP!(!ב,6#yq\nH\nӗ#^&4PȚ!H9qA9yNYYD,fnjmLc]),COUZR2\\0vha3(v)Pcf**跍d) 4[04.l[*D\$B;*ZeTJ(;\$湅ZTn*>Q-TzFJ	J%yh(A\$X#k\$Jt<i3# &pȸ1ąJkR9ڣNPHP	L*Tn[?f-1#eIbY;R[)̒ڙ)uܛ%CL<4HUY@@f@P*Xa\r\$4oea#CL]odnäp \n@\"A\0(dK\$CUO\0R@ &\\ߜsZ\"Nb	tDZŤe>+[ZWڲ̸73XІ%k\"68'r2\$2J5\$h:ׅj#5lØ#|RZëX	 P)sHjZKiwt1iEuE?p<1>2Ƒ(U#\$2\\(򰴑]SR`&eIw#zJCS\\Jo:<&ڶcVPxiLشBe9urnƐٯC.vNHei5hǹc `A:HxI\$Lmp,5ɗ\$Ԛ&VmwڛކawF%*O7h{+A@LꤢNv)hZs9LEzXMaP*F:03pӸsO)6Ʃ@@W.a8y'P@ny%\"2Ԍ(	UR?}U%Bیf7Uk*ڏ?k4/n\\@ /x&FOAʢ]4~&Rg6M-\"i.ïOIOǃP >O/3Yp^~+aBЀ 	Q@F@\$bJ.,)Nkj.dFOni斠v)\rHo~D 0\nv_!.%rߥέk~,C,C\$?/[0JO*\0ƄBVmK0Lq*d?'.0*n\"ooP#Aqx?Mpbdwl:*#7kc:M*K<ON@F@8ll.@֧%	Dۑ[\$Q&1S/z4p>f d-)lN2g.\rm|t&GͰҧ%*ǔvCM&D2k2pm­&''pl.5}(*\\{l\"`>P\$e\0B2q1+0R~pޯ6&(,\\R\$R)o,04<,C%E,n(R!0\$2^Ql\"@DF:.,B>\"q2JRJ*s:*Ve!61 F2ZpFrPLDlۇ`Z!-[7B00/3cN9gfxƷm-pxuHqQ1CIF6֓k4?i3(uO8S)1q2`k\"sB&.QٴB5DGL҃:{LVHcXyG5\$:J}Т>-T1*-3cCyIRJg(fJi/o[5PuJwXhMMl\\vK&@BI.iPC2\"NAMKC\$@Hwt8uI!%\$3BfH\\&u-u[VU^U)\$UR2K>1-JBDnڒAO`Zb\"<_[a.0i3Ԫt\\u=oBҿ./\0pu`u3.CL/`5r`К\rV5~.T*n@`ֲ@Z+BbZa-վ=g_ϣ/+fN]]m)5Nβv]\0\rY>.9)cM:ޏ=_b!/s.>&:j]6{1\$ϳ,dv0_N6\rF2\"֕p{41AvnHf\rqq	d+q~ew;pwO)֍njuSΕ2\$50B\0nEmҕ]CI)8D?83iyt*@OYum'ho3Z6tqj¡=sr)A:/B&v.&E\r464ʠ8Pm~^cPǧSj'";break;case"sv":$e="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5dymE8Ye*	(8Ю\0000R:\nX0ɒ.h܎6z(감4((9v֧A*]\n\$9p@%#C3t㼜\$Q*(8^9(^)0,&px!h+!`ԁ\0P4j9X:AC\\\"p/\0l4AM#X7ů<\0UF6&KC<)\r \rt:)o3&2<\$x2ӈè?\r3K ;	/C0VB< 2O(];(:'\"d(O=59p)\"`Z507X;BPiLh1A@RݾMcFBAķBp0&,\$l94ÒQk\" X3:<:B;\ndd N8#ZF3Gx-[K'ckr8<-V2(0\r(x3\r\nh&AL]d3\0ڍ2#2\$52ac<[H9l0#ssSҔ\\\"7#ɔA-7΍ͣ]t=Kl*T)'\\ӱ%\r,].0^ys#E`J]e|)M1!Ȳ8\$rl(tp/YS)6 ʖk2D`h0 }%WUS& :` \r&` B葒BJI8;ȔrJawRaf<``>kH*I3~\$e1hZB紀 Np)4^ܥ9TQ8H,ֶ<T\$BR\n~-\0ZB1\$08H\n\0L\nFꃛ'D2`PSIIy}|H8IED5@eɛ\r&\nOv@b'FRfzs-5޹\$IdyRUQUfa*E\nȮO\$04\r(\0K%&9N*xЌ^c'4Hem9p^PptS	Omve0\n}A[R))A dUX`s\r\$\0 -FSQM#/v@Xέ2%bFd(	0b^ i%!*sY7ʃBFl1rtITB  \n@(@(R	!8#BxR\nP pjjT|0`o]Tp+tO9s{h:Dd;E^HF\\>w'0 PUH&M~woXבFůB\n@X3ܽBP[RDE7%@G!eHmT&rRZUR\$pGk*(.vȮp	p<xM\r.	bA1&aEUIēcr4\\TAȹ:_TIe\$nwEd!*\09QܿB\n#xtL#&cBƑsAQu(;?}_fOmHWaVD<wi\$iH\$1:M1]d#nOj9~Fۻnjj{O\nZQ5rn)^I3Oho5v\n{gϣa,\n)w_A04{	M^{2T\$ɱ5\nqW5\\SySビV[~,h1PE\nF^w{5iH^~a6JEBm9V'Qtq{4\\ϓSߘOm\rhUI׾\\Рd\$嫫oO]0Eb\\/4LW1\r\0x0Rmq:缰EED aUwl|c<\"@\ro'OMB\nYOE=)Ԭ&²[s|S\$ii^{v'v\rù,)񰊤j6)tU!u5}Hv6GNai,ma\\	h.e#kL(MB\$荆&HPϢ/\00FB\"',m0FPH,l\ndZ[\rE\r\"5aJ_4\$v:#20\$/Vϝb}eZc.:@eYI /\0P>WBt\0A0,8V,p;-lXi\0002e\nż<G?q @q#4\"DC\"\$zL|PU\"	2C\nɘ[ؿ0{mB\r3_n2b'j@S	#SnnxQZpR11Aju&O``q*)\"Xg~0\$5)*ڞcP\0\n\rɞթ\nұ&x0NUmƭ\"i\"Ͷ}x#4XN(n:cR\\Ģr	ܥZ Dh@=0j'Bj/-ā'pE@ax1t2Sr*-	\$4.С*7(/\"r=,\n>t>bicM|ib%.2~0c.\\+tɢ:_*|0k+xF\"Th4+2\\*e⒤r1\$'EU\0";break;case"ta":$e="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx\0O2~)#6nzZ*ʜӜSU-I\\BF@92/\n)IJ6l\"D,mEȌM%YVAC&E\"lUB/N l3 cx(#g#r@6K4@;/˹j<;C X90z\r8a^\\tMC8^2xu]L\0|6O3MCk4px!\"4\"T)Ju6)M4[5Kcq`GU\\'\rwŐQjSQwM6ʚA8b,62h7[IJ2FZ\\ّNeKQV)m1\".3Ћr)gґmڢ\0T8z#g:R	Nf#p:drB*g1)3Ϗ47g/OF*|ku?#﵌(DEoEh+G찀R'Q,PJywn6{	\0c!\"RK7du^;Os-Aoƀ߁i%7\nm5_NSW֓k.GPѯVؤX-(@#U6MCoF3]ph[>nax|`:=K	T(	&ig?]I\"S!hp.DgUG	DU4hU@왃9`<F\0&Q>VP}h[I|\nt=	%C=q\\:OM^UXE!&;G-EW\r]\"A UQF #PC,5@)Շ vv<A3`رqM6@+\r;VΨ0ΒKq礀AG0S@e44-^\"EQnHR`c1%x*|re\$S:llEN^}/X魄d,PV>Y%M\0[ԅI43w\0%\"\"sAsS d=HdH \n_B\nM\\'ޡ0jf4@`j^|w`kc1l6*{(FJ +C[Y3Ы{ZmD(\n@H*V5Y\r/+OAZ2@C⹁ʠC5ZF8E?'\0<\0c4vg|mhLKip@td2c\0\n\n (Kps>锤LfwhSzOYi |Z7|/'3J4nؾszoU=Lh-ֽLHMb-;.i_xPuRx!0A00]:fZ62]!3`úk^jǈӁ#P-2\r-l4WmёVyMEOD_x5~ABXcef*Zi[]uS'Ri I'qdyz\r]v4ڍk5B͉15~rK=vTL\0¢^n4U\$fF<v-	83< 6z&PgC.;<8m:76&RP*Ϲ8 =Kt#LKi;`@uqYg:.o	v P*^ E	¸@y~p^f|͎r5(*Uy,NŦp/^2y[v=ZiB+/y\nE	?]O-!Bd;Hέ=c49IF(c'6D__t'=]yTHxjDv\r ۨo>/.Xm/\\Ƈ\nׄh찐ʐsDNx~\n= JXD%\\%0\\,@5n\\֊snh t#M `@lJhx)d8Rx}#\0l9DA\0^`RPf.\n`GbNgb\n`=~g*8\$oBpnkhG..pLR il(g\":f*.b`B1ujnQ*BoY\r\n8Q	IMNjVrEhx`qf\nJDr+,hRB\$:>R,\$/`./֝PD)-	\"mo=hÌ 	\0@\r%LZ\0ȣ {\"&qCz#fX/apF1A1.ʎ^DCM^GFpD%prlrm.	)`\\,FBS i3q(͗)j)PlHW(y)&Q\" \$r␘ѯ0\rgRRl>;2_+g2,\r,#,*&\$\$/p,F3P5M`r4](28E熒Mr惪'(Ӂ5]88NB(S()MY*K\r%R6O)hm%l&4`ONv3.\rq9[7.fm4*qbe6Q,z)3TseFA4o<&Q~	-eD06bZ\0=PPp-Jeㆉ\00`ORI9m~%5,bsCHҬ唇FIΏ NeQ}IB<q5KCM4/3ԱѶTFiӽ/\rMt\rSGMHVOJM*ΑhǬ =p7؋!NRuns2r M B5@AJ#RZrsUV, %sgQދ[k-)4YNjAHU	Xc*\r4u\0+R	F\\vD\rWUmZ2uoOI+ڭiNM*1OJ2^X\\lmȕO;PN_u_YY]a\rPz+3T]Bs`P1R\",-Ra-JVY:MGv7drmӱ^L]^0f)\"q=\nuCЂHk=%2.&S2nUb`:m6=VAK0UV!btzմbLTIqcXq/ZIfdniZ,adI	g|`@rH#~hA6rP/WGqDgssQq1cLqtw#WV5g4VSO5 dWWj*'ЉFawn1nu)U`?H/.6ׄױx1zt@qivk{V-luyy	`dx1c~#!V)K+LXE0ԧOtbE< b~\rTe7t8-nxsgxv8|ON(umC7\r7}Xi!na##e:w\n渟Y88݋e쭅4hHQO;tr'RP/mhtJ-T|\"QiVe;}vaNL=hi2gӈAfXe*ߏÈ-tXDw|l2&ykWY|fC!!i'r)ٌ%,';%~m;oxŔpTȐ&YYd6ߕыXQa;˅+\r42e0C~/Z!xWqaR\"'Fj>mxUɵP8;qpO>y.xWZ\\ zIekzY\\+MvEF}0IX'O17ٷuAO@l1,B!S.o5ZE6ȱ/E&B&-Epg(:rZ5o8ҝΎ_kM+߲o<ZogUi\rV`֕[Zu ̡+ E<\nZ	^n~I\"ǝ,fW1nǋڽ9P{Cegѻ1:ktNwC{ {3ch-~P<S*)ҰF5VUӷkM,J\"&#}WG#8yA\\3qKȊ7w\"Į?m;	F2[3[ZCT>6K=r7뭮^h Cw(GzR:PƻLۗfkZZU+mmˤؑkٿVՃu݄@C;ϠaZ5uu	ˮQ1y/Q63O,A 	Q?AzI%zQZS.\0^cj)XO\0\rcd'mƆ8x @rG8*0v[LU5yqOj'\\>wI@Iek/P>}/JP\\P`\r>-cзnb=wu}LD	\0t	@\n`";break;case"th":$e="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\rĐZԻb8+q1a80¿/\nzL)5''Q  Si'qyJS{J7(\\1圔m<W;CN* l7 >xp813\rALگ94C(C@:t6-9N#8^2xuݣL@|6/|3N#l4px!,,Xy\"mӷJ!riJR\n4`\\;.8/iLƎޣ2<R[Oe=#\$Vr=p+#miȓ9P]@ 	Y,ÉhFP+R+4v3qI%Ɓ\".	ܳY-sm<Y6\nں	@\"^6Y6..B1Gq\\i*ث\\.3:D>%Ǝ|9Vũa%QZ\0Q+5󺞧z:{qcR|浗ZB7F6?ca\rψ\\9*QH \naD&5PR+ZjȈ𩳄WYjQ%0ѫhb\0Ǌ<TŢ.cĘ2z{HQC\0	?%l3;#3byQZ8F0\"ވj@s%m\rѴß(x@m2\ni(zHHAH\$x;e3߹ 5*Z8D̃4 rG60f\rVWhh܅@|n :ft`6ΕCaR  `P((`Zp<WJK<֎,pm rbh?p9LEěɹx8C\"^Gzu`,\r6S*9F@A>}+26JV٣/9X\\6\"Kb.%),p̵ST@/x\"ǚvɷQ`&\$?Xxs]6Wdy`;Fp.a,-ǘi	!8&Wu}!,\rxfʪLj8@Tg.[2@CcGÇ)]xa=hLuTS=6.Ts5:^KP#i)LLc-;.s'o\0\0(1\0!HOu%%QU*(!g>G[zAmo^I>Z,ncGo6&l@h7	mCC:W'nBK\\  aL)fuKIX[C˪`cB.UtD=\0\n׽)RnX,-,Wf\nl.eSsNS;^:ICY4#`A^ԇ5m5db4jc2C'h{sEȶBi6yU*\0!ĳQh.d`cu|אcZ[֞}\0Sbn<a`uM4E6'(	;;&j8.\\!E2p \n@\"@W\"Gy==Z^sN\n~]YSC\\FBӸkA+.BkXCJCuaK0Aw\"09G[aB<+2\0Kj*YrsѮ㦆ʒWk2Zظ]~wo\$̖;^KTIƖ\rԓb\n#\$'>2.gV\" ׀EV&yzҎ3mCgēwL!^K3CӪp:R~l\0ij,Ko>;MZ-\"L'cWQsP%p	'~òqmef *|਄²B~oO&>?iTDF<'~vo0;DM1Z}hԝ\$^(ÌnEV+q\nn\nlF fKރ 	\0@҄\r%Z D\nHڇj\"1yI\0^3DWbvi	\$&pā8wx;m̃~)~\rL-PZje	&+O(Uo0	E\0	\\@N\0mCh+e&#2}n1p΅K \$	0D5|pplF\nE߅gȑ&1D&*3x 9vBpl~G#-\\6b\039N^!hhfD,9BBk\nZ|)\rbH\$ǦB~-<Vd;\$2b<hychez&rQ\"#\$P/fҁ(82쒌Ro'1r/He1|Fs Ȭvd(oCh+fj{Rb\0PQG/r0\$|E1\0.i(8zSBF)32H|.oJIN*+\\S+j3,ЇK\$e*(.s\r+/6wM`ʦ7S\0hT9899	C2s\\93Gy'i0/h?\"_f;p7 Id.PDUHIN7s;@:T;05ƫBҝ\$@Non&ÍBf\$#Q;N8&Hs,sLDG8{'fɓB3<;jp{w<PH\"3IFPTEsco^ooly=׎	@L4jǶtK)\"4iG&o4xi*h\$DhSPWA;?N7Eu\0;LlTR.14rpxx јE\$ӧ3<\"T4A\$M::3QSwUQ[RRTӬhSVENkuRk5U<\$e|:#h+̂Xjhg\r9Cȗ[5rR`]'uI7Um]]5PӱVW^<ң9tSC7)XU@@ܿC2UVv>[\0ꊰ<\$vEN5cU%9pۂF	4뀩A`ssAumg,aguL3}a-2gEhp*URVah3a8cҥj֕1DGYW5T9	R3<PjB+\0	%Sm3	VJ6Q6gm	\ro=3\nnbzP\\Ek>ĔoW2HB _ 6fmyG8r[s+1a<rG^39?[oI\n`m@\r \rm1S8#Rۧ݀Ɖ\nZ[q=?5\\;bWDmY5&N})5f@	{(^R 9.gyEnhK4UNS9ҨXrVnfN2b+\0\rc[xI{p'gη-,nwC\"t.ua\nh	dDil}sHLg!*;x?6ԋwإK^6}_=`a\n<Xϲh(FP3!]D+vv?Ks75QI({135|qDIhFKn|f\nŬ\r\rONRB^'=Rg#N̇ǩ,lOCE_1r3p58NF/=έ1\"J\r@y&+kU轫vgBr\0	\0t	@\n`";break;case"tr":$e="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78K')NgI,n:]gn|c7+%1>ň#(Ħ.80 ܏*#x9\n9Ɏh03.H4\r.8FC`@\"@2D49Ax^;ʁp\nH\\zbǑL~9xDjJ C2J6K| 2`P0	X֏@ȯj*cJ:A+s'IҢ\rlba(ț0CUUR%듸*/h'|J3.uN)υ8#8#Z6OUFc P#떠(=^.4-Hϥ0Rlc8oȦ(P>-;w<<\nP\$OҎO\$VuVOITd˔2RTBR\"ׅ\"I(z6Yٙ䙨OY\"@Tg>S(\r\$[t<=rjB3NeTRք{=ObB-4-ϣP::fhɥ{I?,\r|0\00ObUZ\r. ˥\0\rbUX\r5\"`.<I=P&S=pྨ|05|2ͥfv5utHD&I҄VK\\%ļy3m*P`|@,8'keQ7'Dj\rrfCB\r:bbS#%GK:*#bGw02P\\l>\rZ	c)%%ԞRUJ\$+p&-&p)L&qA|+ \rЁ:ԉ4&|3`d!&rhCk36r`Gɮz}E|!7,\\S|փy`4C!2mpr4I\rBP	@Ku(\0Rz)82 ʦqXݖGP*E݂\\ưH	q9cG\"\$Q6\$:`plC\\9&fH7M8\0 1a65M08GZzwL0FϜr\r,2a'gvc^Ag3ZYd2BTr\rI<p<<#\$mF1DfW\n<YӈwRy/`(\ri \nsZwEDSK#pC9jGCeMPR^F%ɵqsɳ\"LU>B >=5k#\n.Bv-m)07BRe8+P*YrHyG@@*d\nnu0\"[vC5ۉ8q5Ve\ncW]B\$阢9(N	×(,[PeA`pbQ OMAmg6@3G\"-CihK(k/j \"GR\"6eԼra39\\,U;αpːnS\$+Uɩ48A5Bp *\r-nQY09KCumLW*\rym8\"͑-r\niJ'BN+k\n(+v\r|	Kg\"v ׍I;6Aa E%M9!t/^UՃ0A}^U]A:75.]\$+0}dw>rQoO3wpcYx\\{ʶ񅐩3RIՃRNJ\r([Ӄ8sy:g35aI&oK>Eⲹ{;y;PDyd#&`Ca+5YE;?yC4 .Y(7\r@I\n2pə^	lf1κ~ʞIUv05~SRYK1g=գR md+`iF^S/(5ɓw?CTHJtx@JjpfuX:0zf^IZ?GJ@d;(lPb[\0D%tHp\r*nt`PnBJ-Es?!b:&J&;m\\aOP/@kխ^q+b/h-Fp	\$VPED(iΆȃ:jDD	\$	g?9&ò=\n	\$>ǨТb0BՐdt.F\\eRR\rbQ- Ѱx@\"QkЇ\rpp͖0Q21~ّ/H&U[FÃpN-#p\"Xv(@GaO&YAQW\0J[\">O4\"Dш[C\"WQ=sO@b`\nmlX6MooE(1-gQn;:>mo/02	 hjl}?{D@O22keݣ2crR,wx5F2Ǐ\$4O,?łϰ*UM[0U%Vn>pZo@؇\$#.}c8 c`%.\0re/圭\0Z\$l\nɨa'&)+\$(-8j.ln&\n\"Rh&qlmQ)e0cfUG<}\"|+\\\"Vu/\n+V91on0GVk^W,@O	Ȓ%2	217j^h^e6__8` k\"AB!m(.P7QP	2\$OL\n6O*:Sjo1 ނf8.o|lWR55',#@Ô.@3ig&10xТ(s7-4V?k\0#Rqs^-Ч";break;case"uk":$e="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвPp`ͶJbDbd*5\"=[ލLZ\r>ɿΩ2\\Jhq\\V^0..P2\rH2K9Ţ^媊yJ:D%rcd-6k2xX@4C(C@:t|4%\rDx3(90K8}1h['B/|\$i\r͈Ħ0'6\nVTM#eijLXtWr4k\0BbK@JRD`J2Tk^LeF%_e,)#hH(D@;K#D>hwf.8l70j0j65^ӻ,|LE\nܬƯ4R5hjsL#lD_h`Zݡ2G2hæ͈~-4\$I&\0J!J.8!zzn&B&k:fA#Nls9mS!Г8'~pOvo.BB )FN^+(T(mi%^#qo\0h=`^*6'1Wz!<ڻpD\r!0 K0s,;#Q%貃i\r9SrЋPӑ2&L@8N~dʝ4iA~vrm'\\CaV6IP9BhIދyTzSs)ɔXWx. ;C46B3(|]`\\^de7qF(pq1\nAP܏=@XZt+A9+-d\$JLfiUFAzRyGiE\$\${~T)E=-EaB %..Y7E\0Q|ƈ5u&r\n\n\rBpGrE̵XV\\+xXSbu\$3!,D1q.].ԐϺ:ͅ0HT\"5B2G\nA)HƜtGLTK,V/JY]<\r:\$cWg4AzVj[vUc,at0Qk\rLB)5#`|A\$g7pxO)>JL|q|7R'I@RTsYM&K9<KNx2&cX|ʍ9EС*lT][zLbHN29 :H[#\nԲTs9b^6h|\n (۱^1pSafqT!UJ( k5[4@\n1-#cRmTTK\rgh_]RP̴(!ICos!R\\عJLH\$^w\"K:T4}6fI>.P01植^R]'	]E-Tm<4C_Pŀ'rA\rf.ﰕ:RWM:-<!-bXip(TM!7B)%qAN9(6U-F##L_O:v.!R;,SN(<5}PtL~%P;hѡp\"qb^:l/JeN;t&=d:%l]\nR7ZxX{wP.oWpՍʕ>d5r%c`RהG24܌r'<4PהԗJ/9Fee*b7r@IZ1)K}Ar|I5!\$ݴ&ۺ\nM]%BZJzٸ-nb=^N}.6^rd4Qf]q?ԔE姿b\nwma,m/d_cAH7Vu\r~\$җvD.ôg-*s\ry7ĥ\02ʩ7}v;s܆KQ|_;@\raDl\nm\n(`8Outl*2&|RJsOܪcKIhvg:8\$ŬL^&-\\>d*4XZ\$z	Kk5\$\n 	G|:E,G>H\$*w8^FZEaEf#qs\r,A6w)\"N\"⃲g0q\nH	_\"pfjcJkOOВӑgeAq#9և,w~4`'Z1l8P#pӎ\$_koQ>ðVf20sl:챆6067ڗ\r%|mw\r\"b0]Q,qXl>Jm-v'FJf(Q2*D,1>VcHLGGX^\0&f2'4j\\KNF*^&D@DȎ.gN,8K^p&(X#B,b#\n/bo(DRҲfgҐ4DcǰD*Q*nT\"%*\rNf2lFw<>m:D,\$ez#CL&['C+%3,kPoqB2*ǝ)*e2{tǼBd(@Qt)r.m,`IE:(``eIstlģ3||sOms7/87,4NzSӣ+͟'2\05rh1\r.hUq|cd8ϋ43A3ʵi,*=ex8S4<?S?a=k=I;E8Pp2.23't;IC4'QyE*CCY3|SEdlL0k8Gp,)(Fc+S/T)<L8~bHIH~Cp`qJ\0thn72͊rLKlH+>n#EQFE\$^(F{}P#5FL>S4ORF})9RSGkFh\n|\nBKS=DAE1rSA1VmVUJ;HU~XPP5kD*ZhBd>~+ha'{2c?=DE\\!T\0^7V=UTuXST&{&xbyՎ5BrYUV_	`fV6|V\\\$_\0gHE䪤TsE\n]OVQd-WU3T6YUOFM,U{`beϏU/	b-dĮvF=WK6vPiq*tCRT6.?_yT!J>~61_1Q\$+\0G>[\0[Gt\")ooS{	oџp-'pvo8pm.φpgK]N[r11ѽop\$<vkSr>qSF1!BKv^uUB~@ pHl;lQJua67B-b4j4ZQĀ\nqIs`Tu9,(_4P9<7Ps~MCK}5Qq&Ij|.mp\nv\r;J:AdO#t%(rD ED\"ǖ!␊9,@ve`-.,2yLİOxi3.@ՓnR\"Pj<%H1e*88Y,DXԱSZW|5{ы8Ui]I(ҹc>p\0h?oTbyaP_x,LRPǬ%-r\rt~hAoL\$ \\&*-/1&&n\n`X澯%.iP+sLixP{D4=\$j\$qT.:.sMRH#XV8<1u+N,&/NIS#:-#\n^ReLCH";break;case"vi":$e="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7ĊlԶ	;l# \\	Z:\nzT\"Pi>2AQtV\0P<0P6( 4#p k=cx9c|(91cc :#9\04x*94C(C@:t2,?#8^2|9^)̮7^0p2oc,6F;r\$V( ƀaHk(jxed_3C+#-(ȼ#aH!#t7%oh&L4h'dH+`=#\n:UVnv'Jv7]2pJG+5%n]7Q7,tWëZ^i\$T2H;FR!	\n(ܙ7(Sd΄[46)8@)\"`<UPYdH!b&WiX©މU\r\\WCx5EXMJ<1TY\nP:P1pwL܈ǲH0*?!!vgsیŴ7KU cG8]=~H/A:\nf9@\0a\00\"j23PAḥx3VpʥCq4@xũ\$:RHS1|454vtـnN\\Q4xrJo䣭pPn2\"QSIBRwCZLST]\"F~:7C\"HN<'P;rQD2*ED>QL	pP\rA@tM'eC 'mbEw,JX%5	!D,.\"|(_FnKSwO)>*Q0E䣔xJA0=DP(b>}f>\$_@h\"TH\"ieQ՚Rt4^S(p>6UC2چA+̾HoG3h]  鄿94܄Aj8 --TAvB\n\0	3DxKpI)!R?`0to9C<MQ&;\$f1.9k`>u&0曒 ;s~joN!kx)0gO\"5#mcA2PۀR4++34ЫጡHݺLĎGSbAp d.z7+%\"Dȸ8OuW*e_ 5D˰ܵO&%@~9Qs}[ޙ(\nLMdDB!/d^xS\n,s\"-We틮fGk:'nNäuJ\",V\n#]K\\Ux䀫˃OmA#J\0s+%=D8r]EV5ZMqH\\ŵe(Nb%jr>\0A%MNzaYaF#tE\$	|\\]ԏ@YEs2BeTyd؋[[s\\\$=D1Y,g.-&|&tW^Z?xrw:Ȅqg(\n)ӞW();tK0%itHktZK +\0Fe-a2.kCY\$N9X]iO*H\\try43~\\7N懴&7`%	{t-N7\n ̀()& d![dcn[oǖᆄ`A\nP 0\"K}Υ)Y!\rq@KiZqk\0^rL2IfWC.ŉ;;)[ə5&4A8##YT3^|EjIw ̓5B\"Hb*Vi#!Cȣ}6<ch]n\$PL7RaI\\e|bS;9}ﾑ\r`\nSx7Nލx	S[0(e]2#n0bЊXtMOjK^|umk,Pkng%8D斃*\"G[ϸֽ2~#Vьb[?H T.+ꈘ)va|ot6͜א8\\:Fjz\r%l;f|/Bl0N(nnB\\<\\LaMHm:H%,C:>cO/9_G\r	\0f&<\"'kcb&m*NҰc=rZÐ-,Rd&@!*\$b	ppp&Zm#\"Z˽	HHՅXu	{]0\n@)ls>hGLEkq-^0kWь]mt{!^BlrcGe!,\rm:%zNrEvu	0pMd|?~юq_|cn\$rs o(gϴl9Wy\r,|\\N#M	NL*\$T C5N<%h%GHζxANfAL;%Ry&\$(gҀ{\nhА΍ep%PqX00rHN:C̋i|#Ҍ;\$Z)r!<EJb\\	TbИc\$~\$r=,p/O4B\nZN\n&C3\nֽl.U@*R<{6exITm/qGϲϸ6U5Ok5e_5JH#f\\ZF2j&ıU*iw;b7FvrilqRW<E\"|\$pr\\bъ8F_5r-\$4Cl7=\r+*k[BiMBh`!.s@-ttY(Arb\"C\nMx\n'gqP\$,9U#FwH('3ֱ@\r>8{\0003O'6 ɍӔxjI\0";break;case"zh":$e="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3W5.\".T{D-(Js\nZ1H)tIvrs	Ap2\rH2GIvL&\"s| K̂N'+\0BI1g,\r3:x'1\rCp9x79c2:e1AANI|GI\0DYS,ZZL9H]6\$O\\ZJ3qreR+ZK)v]P+V)\"E! @AA.0Y<řQ9UAUQPrDG0Br=ϥJCMdZHv]\"^9zW%s]Yx:DaJ5	CL!XMrB\rDm)\"eLnI54!P0>D\\C^Y7OTV;dd5SGAM2l.rF]4piP,uOSo91K!%~:ޯ%IXXs22YiUc\nRK]Xմ]^D`!A}\\#`9%	S=T)0\\'Ai5:eUV\$1I-9#e~ҼkXOp^ƐXXC69uyntL*&ed} HR\$\$IRd(J^t+2^2\rp:\r?1LX_!A\"ŉ<\"Z:(`;x&7W-x(TpTN	\nCH\$úQJo=+%(xl9ThzL=6\$eJf+r\n9D`mBB4\$\$0@WHs	1AReUެ>br! @mϻf)˨1EDF΃qD?\0d\$GPJ<	h\"pgX\"YAWQ(iF\"@S@K0qr˙4%P\nxqjj+WD&&!kR\\qS\nAqI+Q+ueNKa\"v5ݒ-h_dJRlN	Ҭ¸ZRjP5vX1HN#jTS|:,D0B(\0,*@'0Q\0R\nz  (\"E \"ŢtUҺؼNs  P(B(	VP&|kX'&`PǕva@|xA<'\0 A\nЈB`EeVz-Oi	@Y%E:<D:p,7p\".ԖQN.΁է&Nxڗm&h~ࠇ9@o&[	YDQ	J`\"FNӴ}P͡*}з%s8Kk2W2M&rm:2E\$⎐RjT)(4<\\\"KEА,mhAb*W*U('\\1tN+>M&HҨLZ+Ae0H\\%\r5Ab~m0@@<gLQܶ+E<eT\0^3,%|QHyA`wH#ĺ#7H^DQ1\"%լ/uwDF!}ڼH(B\n&_\n|`\n\n1jc)MxHZ-scnr4+W	'B|zHRb=aqmy/e+m:z=Lќܘr+FpwX(Gpp?Q\01go[tRb1D+Z[݌Xh#nZVii{Haay?K*#+sBd]\nhZxYpv갂nዟFT:9xxL~g:gms|#%77B\\\\j:Wn7\$ΥYXF>	,V-Bް|#.GrszFD+;w,kJqrYZ텦bF;fR{`G{>%7aOJ>䤼vϦszWcQvWgݱ's\\w*9?W^G\nZrL`hӌ\\u3Ba<N.|	ŏR4P8ߎzc#K\0p=6p@moB0LpL:£/b	\r\0K2A>-4+-J6+pt!\\'^в\\0m:ϧxag\rzg 4.pIv\nZlh*nb6#~OæՆJa!(4!^Cp;' Cn/riV!^mLHzZ4uFj`I\0\\\"\\&l%Q*2獬yX10BunFѾIt4i[.\nnffNROjɁ\\Vn\r6dn \rn\$1\$Ql4GQb?Z0M\$2FR:`r(q u\"a._.n";break;case"zh-tw":$e="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ[f]b*\\gA2yOX#vi`\\\nsP h7P	ZģBGTr{4Ǒ0&Q8),ha!\090z\r8a^\\01\\Z\rp^8#;̣ ^)AT\nt[Tex!\\\$	psd<-D%yRP	 s-~WFJQO:(\\1|FMZS\0<(P9*iXB m OgANQD<vEMQd֭TMF9zr}M) D)8!v]!bbsēs'UEs݂8*\$nuq\n/\rG~g1s\nbVI&t˃j5-;#OTԵ1tV,Zx's]%)ϣ\nƞi0WDQTaT)#@sxOTah1PP\$#hVd¦KJ12AfKG#V*\\\\*\r˕I6Q0D<C2\$7%B(J7\$rMIGF')C\$_IF3-'V~Oa:=OdQE)\nW(1H'JZKy0>ƙS:i7L\rN`s.+E,!8H@*\na7A#\"9>CCX\$,1xP?RUJe-L4&\"Cps:߇(7,L2T>D+YZElQ\nح0F!ʱtO9ێa\$T`vrA'Źvj0W)3]djš5(ě	Q	T&d,MP_\"TQ1,D0a\\p!!B>+eXEr9\0IIϟQ/G0G2Q&,#JrlS\nA@IXFÑ2/\rQ1/ÔK\n-3%ęG9pwY*''YA[i\"q6Aa<'19fl<rD@9äKh\"G4N#,xS\n#DvPLem6V訄q1(@  Q=Wi`	\"e\0,R	Ñqʂg;E\0KA|h)P5p \n@\"@U\"mHHLpd5u\\kXc+yW*sΉ:슋.'htP,yl\" sxmMrzH!1P\"s\nHHB\n3At0MWT#,]Jy{,Swo\n7IH3`	.E\n+[Ӝ2xfxJ	b*\0TXqh(#g'ey8B@+&TҦ7ZKKiM<B\\U;>͙@J<B;/\"\0].g<tضlK0_VtKolɅ\n!|SfZ|Rz>UrJ)5 	-%jf#d	~bA,]I'\r6P.ykSn2 <mAN'DdrrT7a#I9D_:'AX0P8oB#n*NXAo+E.OT	I)MT}&'vSEz`YHlB*]{w~SNbUt֎Z(9Bz<|)\rъ>ȩ1|Eva-@yEF岌l\nǧDo&+!ev{q]rU.'B6\r]1	wa\r>w6}bHnM*͠=<y\\OcNKMj~4ZGfЯBHePk>1엋s9\$\$Bd\"z_VG\"]NY\\ޑ)dzFD6T/&hF|́<GDJT>T%FvlflG3.υ!s\rTYFlf\0S&^\\ {:v*v~l*a!	\r\nPX,S^'\nn됸\\e#qYFΞYڣ\nvpA0΂0\r\0ή(s#MP<	=&T*0q.2M#_\"4fKؖ\rƅX*؏0<AHQF0bi#k3C\\%`)mF gT\r9>'\\[@2bLH6\nZBjiDB2#b:ENd,Q\nF僌068\\&%TC|x#)ǈH)q\$&bbhJfDb.z+&0l-n'\nGvE(&o̖ABi]%̮6/B0+2BA,\"+@ \r .\0 ')Nި̸SH):.Q%ƹ&RhQl1Qo_%®,sLA";break;}$Tg=array();foreach(explode("\n",lzw_decompress($e))as$X)$Tg[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Tg;}if(!$Tg){$Tg=get_translations($ca);$_SESSION["translations"]=$Tg;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$Ye=array_search("SQL",$b->operators);if($Ye!==false)unset($b->operators[$Ye]);}function
dsn($Ob,$V,$Re,$ve=array()){try{$this->pdo=new
PDO($Ob,$V,$Re,$ve);}catch(Exception$hc){auth_error(h($hc->getMessage()));}$this->pdo->setAttribute(3,1);$this->pdo->setAttribute(13,array('Min_PDOStatement'));$this->server_info=@$this->pdo->getAttribute(4);}function
quote($kg){return$this->pdo->quote($kg);}function
query($I,$ah=false){$J=$this->pdo->query($I);$this->error="";if(!$J){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($J);return$J;}function
multi_query($I){return$this->_result=$this->query($I);}function
store_result($J=null){if(!$J){$J=$this->_result;if(!$J)return
false;}if($J->columnCount()){$J->num_rows=$J->rowCount();return$J;}$this->affected_rows=$J->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($I,$m=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch();return$L[$m];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(2);}function
fetch_row(){return$this->fetch(3);}function
fetch_field(){$L=(object)$this->getColumnMeta($this->_offset++);$L->orgtable=$L->table;$L->orgname=$L->name;$L->charsetnr=(in_array("blob",(array)$L->flags)?63:0);return$L;}}}$Kb=array();function
add_driver($v,$F){global$Kb;$Kb[$v]=$F;}class
Min_SQL{var$_conn;function
__construct($f){$this->_conn=$f;}function
select($Q,$N,$Z,$t,$xe=array(),$A=1,$G=0,$ff=false){global$b,$z;$id=(count($t)<count($N));$I=$b->selectQueryBuild($N,$Z,$t,$xe,$A,$G);if(!$I)$I="SELECT".limit(($_GET["page"]!="last"&&$A!=""&&$t&&$id&&$z=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$N)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($t&&$id?"\nGROUP BY ".implode(", ",$t):"").($xe?"\nORDER BY ".implode(", ",$xe):""),($A!=""?+$A:null),($G?$A*$G:0),"\n");$gg=microtime(true);$K=$this->_conn->query($I);if($ff)echo$b->selectQuery($I,$gg,!$K);return$K;}function
delete($Q,$nf,$A=0){$I="FROM ".table($Q);return
queries("DELETE".($A?limit1($Q,$I,$nf):" $I$nf"));}function
update($Q,$P,$nf,$A=0,$Qf="\n"){$qh=array();foreach($P
as$_=>$X)$qh[]="$_ = $X";$I=table($Q)." SET$Qf".implode(",$Qf",$qh);return
queries("UPDATE".($A?limit1($Q,$I,$nf,$Qf):" $I$nf"));}function
insert($Q,$P){return
queries("INSERT INTO ".table($Q).($P?" (".implode(", ",array_keys($P)).")\nVALUES (".implode(", ",$P).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$M,$ef){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($I,$Gg){}function
convertSearch($w,$X,$m){return$w;}function
value($X,$m){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$m):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($Hf){return
q($Hf);}function
warnings(){return'';}function
tableHelp($F){}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($h=false){return
password_file($h);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($O){return
h($O);}function
database(){return
DB;}function
databases($yc=true){return
get_databases($yc);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$K=array();$vc="adminer.css";if(file_exists($vc))$K[]="$vc?v=".crc32(file_get_contents($vc));return$K;}function
loginForm(){global$Kb;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(22).'<td>',html_select("auth[driver]",$Kb,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(23).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(24).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(25).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(26).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(27)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(28))."\n";}function
loginFormField($F,$Qc,$Y){return$Qc.$Y;}function
login($Dd,$Re){if($Re=="")return
lang(29,target_blank());return
true;}function
tableName($sg){return
h($sg["Name"]);}function
fieldName($m,$xe=0){return'<span title="'.h($m["full_type"]).'">'.h($m["field"]).'</span>';}function
selectLinks($sg,$P=""){global$z,$k;echo'<p class="links">';$Cd=array("select"=>lang(30));if(support("table")||support("indexes"))$Cd["table"]=lang(31);if(support("table")){if(is_view($sg))$Cd["view"]=lang(32);else$Cd["create"]=lang(33);}if($P!==null)$Cd["edit"]=lang(34);$F=$sg["Name"];foreach($Cd
as$_=>$X)echo" <a href='".h(ME)."$_=".urlencode($F).($_=="edit"?$P:"")."'".bold(isset($_GET[$_])).">$X</a>";echo
doc_link(array($z=>$k->tableHelp($F)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$rg){return
array();}function
backwardKeysPrint($Ba,$L){}function
selectQuery($I,$gg,$qc=false){global$z,$k;$K="</p>\n";if(!$qc&&($yh=$k->warnings())){$v="warnings";$K=", <a href='#$v'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$v');","")."$K<div id='$v' class='hidden'>\n$yh</div>\n";}return"<p><code class='jush-$z'>".h(str_replace("\n"," ",$I))."</code> <span class='time'>(".format_time($gg).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($I)."'>".lang(10)."</a>":"").$K;}function
sqlCommandQuery($I){return
shorten_utf8(trim($I),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($M,$Ac){return$M;}function
selectLink($X,$m){}function
selectVal($X,$B,$m,$Ee){$K=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$m["type"])&&!preg_match("~var~",$m["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$m["type"])&&!is_utf8($X))$K="<i>".lang(36,strlen($Ee))."</i>";if(preg_match('~json~',$m["type"]))$K="<code class='jush-js'>$K</code>";return($B?"<a href='".h($B)."'".(is_url($B)?target_blank():"").">$K</a>":$K);}function
editVal($X,$m){return$X;}function
tableStructurePrint($n){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(37)."<td>".lang(38).(support("comment")?"<td>".lang(39):"")."</thead>\n";foreach($n
as$m){echo"<tr".odd()."><th>".h($m["field"]),"<td><span title='".h($m["collation"])."'>".h($m["full_type"])."</span>",($m["null"]?" <i>NULL</i>":""),($m["auto_increment"]?" <i>".lang(40)."</i>":""),(isset($m["default"])?" <span title='".lang(41)."'>[<b>".h($m["default"])."</b>]</span>":""),(support("comment")?"<td>".h($m["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($y){echo"<table cellspacing='0'>\n";foreach($y
as$F=>$x){ksort($x["columns"]);$ff=array();foreach($x["columns"]as$_=>$X)$ff[]="<i>".h($X)."</i>".($x["lengths"][$_]?"(".$x["lengths"][$_].")":"").($x["descs"][$_]?" DESC":"");echo"<tr title='".h($F)."'><th>$x[type]<td>".implode(", ",$ff)."\n";}echo"</table>\n";}function
selectColumnsPrint($N,$d){global$Fc,$Jc;print_fieldset("select",lang(42),$N);$u=0;$N[""]=array();foreach($N
as$_=>$X){$X=$_GET["columns"][$_];$c=select_input(" name='columns[$u][col]'",$d,$X["col"],($_!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($Fc||$Jc?"<select name='columns[$u][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(43)=>$Fc,lang(44)=>$Jc)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($_!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($c)":$c)."</div>\n";$u++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$d,$y){print_fieldset("search",lang(45),$Z);foreach($y
as$u=>$x){if($x["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$x["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$u]' value='".h($_GET["fulltext"][$u])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$u]",1,isset($_GET["boolean"][$u]),"BOOL"),"</div>\n";}}$La="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$u=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$u][col]'",$d,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(46).")"),html_select("where[$u][op]",$this->operators,$X["op"],$La),"<input type='search' name='where[$u][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $La }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($xe,$d,$y){print_fieldset("sort",lang(47),$xe);$u=0;foreach((array)$_GET["order"]as$_=>$X){if($X!=""){echo"<div>".select_input(" name='order[$u]'",$d,$X,"selectFieldChange"),checkbox("desc[$u]",1,isset($_GET["desc"][$_]),lang(48))."</div>\n";$u++;}}echo"<div>".select_input(" name='order[$u]'",$d,"","selectAddRow"),checkbox("desc[$u]",1,false,lang(48))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($A){echo"<fieldset><legend>".lang(49)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($A)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Eg){if($Eg!==null){echo"<fieldset><legend>".lang(50)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Eg)."'>","</div></fieldset>\n";}}function
selectActionPrint($y){echo"<fieldset><legend>".lang(51)."</legend><div>","<input type='submit' value='".lang(42)."'>"," <span id='noindex' title='".lang(52)."'></span>","<script".nonce().">\n","var indexColumns = ";$d=array();foreach($y
as$x){$sb=reset($x["columns"]);if($x["type"]!="FULLTEXT"&&$sb)$d[$sb]=1;}$d[""]=1;foreach($d
as$_=>$X)json_row($_);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($Wb,$d){}function
selectColumnsProcess($d,$y){global$Fc,$Jc;$N=array();$t=array();foreach((array)$_GET["columns"]as$_=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$Fc)||in_array($X["fun"],$Jc)))){$N[$_]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$Jc))$t[]=$N[$_];}}return
array($N,$t);}function
selectSearchProcess($n,$y){global$f,$k;$K=array();foreach($y
as$u=>$x){if($x["type"]=="FULLTEXT"&&$_GET["fulltext"][$u]!="")$K[]="MATCH (".implode(", ",array_map('idf_escape',$x["columns"])).") AGAINST (".q($_GET["fulltext"][$u]).(isset($_GET["boolean"][$u])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$_=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$cf="";$eb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Yc=process_length($X["val"]);$eb.=" ".($Yc!=""?$Yc:"(NULL)");}elseif($X["op"]=="SQL")$eb=" $X[val]";elseif($X["op"]=="LIKE %%")$eb=" LIKE ".$this->processInput($n[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$eb=" ILIKE ".$this->processInput($n[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$cf="$X[op](".q($X["val"]).", ";$eb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$eb.=" ".$this->processInput($n[$X["col"]],$X["val"]);if($X["col"]!="")$K[]=$cf.$k->convertSearch(idf_escape($X["col"]),$X,$n[$X["col"]]).$eb;else{$Za=array();foreach($n
as$F=>$m){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$m["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$m["type"]))&&(!preg_match('~date|timestamp~',$m["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$Za[]=$cf.$k->convertSearch(idf_escape($F),$X,$m).$eb;}$K[]=($Za?"(".implode(" OR ",$Za).")":"1 = 0");}}}return$K;}function
selectOrderProcess($n,$y){$K=array();foreach((array)$_GET["order"]as$_=>$X){if($X!="")$K[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$_])?" DESC":"");}return$K;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$Ac){return
false;}function
selectQueryBuild($N,$Z,$t,$xe,$A,$G){return"";}function
messageQuery($I,$Fg,$qc=false){global$z,$k;restart_session();$Rc=&get_session("queries");if(!$Rc[$_GET["db"]])$Rc[$_GET["db"]]=array();if(strlen($I)>1e6)$I=preg_replace('~[\x80-\xFF]+$~','',substr($I,0,1e6))."\n…";$Rc[$_GET["db"]][]=array($I,time(),$Fg);$eg="sql-".count($Rc[$_GET["db"]]);$K="<a href='#$eg' class='toggle'>".lang(53)."</a>\n";if(!$qc&&($yh=$k->warnings())){$v="warnings-".count($Rc[$_GET["db"]]);$K="<a href='#$v' class='toggle'>".lang(35)."</a>, $K<div id='$v' class='hidden'>\n$yh</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $K<div id='$eg' class='hidden'><pre><code class='jush-$z'>".shorten_utf8($I,1000)."</code></pre>".($Fg?" <span class='time'>($Fg)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Rc[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($Q,$n,$L,$hh){}function
editFunctions($m){global$Rb;$K=($m["null"]?"NULL/":"");$hh=isset($_GET["select"])||where($_GET);foreach($Rb
as$_=>$Fc){if(!$_||(!isset($_GET["call"])&&$hh)){foreach($Fc
as$Te=>$X){if(!$Te||preg_match("~$Te~",$m["type"]))$K.="/$X";}}if($_&&!preg_match('~set|blob|bytea|raw|file|bool~',$m["type"]))$K.="/SQL";}if($m["auto_increment"]&&!$hh)$K=lang(40);return
explode("/",$K);}function
editInput($Q,$m,$xa,$Y){if($m["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$xa value='-1' checked><i>".lang(8)."</i></label> ":"").($m["null"]?"<label><input type='radio'$xa value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$xa,$m,$Y,0);return"";}function
editHint($Q,$m,$Y){return"";}function
processInput($m,$Y,$r=""){if($r=="SQL")return$Y;$F=$m["field"];$K=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$K="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$K=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$K=idf_escape($F)." $r $K";elseif(preg_match('~^[+-] interval$~',$r))$K=idf_escape($F)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$K);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$K="$r(".idf_escape($F).", $K)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$K="$r($K)";return
unconvert_field($m,$K);}function
dumpOutput(){$K=array('text'=>lang(54),'file'=>lang(55));if(function_exists('gzencode'))$K['gz']='gzip';return$K;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($j){}function
dumpTable($Q,$mg,$kd=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($mg)dump_csv(array_keys(fields($Q)));}else{if($kd==2){$n=array();foreach(fields($Q)as$F=>$m)$n[]=idf_escape($F)." $m[full_type]";$h="CREATE TABLE ".table($Q)." (".implode(", ",$n).")";}else$h=create_sql($Q,$_POST["auto_increment"],$mg);set_utf8mb4($h);if($mg&&$h){if($mg=="DROP+CREATE"||$kd==1)echo"DROP ".($kd==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($kd==1)$h=remove_definer($h);echo"$h;\n\n";}}}function
dumpData($Q,$mg,$I){global$f,$z;$Jd=($z=="sqlite"?0:1048576);if($mg){if($_POST["format"]=="sql"){if($mg=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$n=fields($Q);}$J=$f->query($I,1);if($J){$dd="";$Ja="";$nd=array();$og="";$tc=($Q!=''?'fetch_assoc':'fetch_row');while($L=$J->$tc()){if(!$nd){$qh=array();foreach($L
as$X){$m=$J->fetch_field();$nd[]=$m->name;$_=idf_escape($m->name);$qh[]="$_ = VALUES($_)";}$og=($mg=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$qh):"").";\n";}if($_POST["format"]!="sql"){if($mg=="table"){dump_csv($nd);$mg="INSERT";}dump_csv($L);}else{if(!$dd)$dd="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$nd)).") VALUES";foreach($L
as$_=>$X){$m=$n[$_];$L[$_]=($X!==null?unconvert_field($m,preg_match(number_type(),$m["type"])&&!preg_match('~\[~',$m["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Hf=($Jd?"\n":" ")."(".implode(",\t",$L).")";if(!$Ja)$Ja=$dd.$Hf;elseif(strlen($Ja)+4+strlen($Hf)+strlen($og)<$Jd)$Ja.=",$Hf";else{echo$Ja.$og;$Ja=$dd.$Hf;}}}if($Ja)echo$Ja.$og;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$f->error)."\n";}}function
dumpFilename($Vc){return
friendly_url($Vc!=""?$Vc:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Vc,$Vd=false){$Ge=$_POST["output"];$nc=(preg_match('~sql~',$_POST["format"])?"sql":($Vd?"tar":"csv"));header("Content-Type: ".($Ge=="gz"?"application/x-gzip":($nc=="tar"?"application/x-tar":($nc=="sql"||$Ge!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Ge=="gz")ob_start('ob_gzencode',1e6);return$nc;}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(56)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(57):lang(58))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(59)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(60)."</a>\n":"");return
true;}function
navigation($Ud){global$ga,$z,$Kb,$f;echo'<h1>
',$this->name(),' <span class="version">',$ga,'</span>
<a href="https://www.adminer.org/#download"',target_blank(),' id="version">',(version_compare($ga,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($Ud=="auth"){$Ge="";foreach((array)$_SESSION["pwds"]as$sh=>$Sf){foreach($Sf
as$O=>$oh){foreach($oh
as$V=>$Re){if($Re!==null){$yb=$_SESSION["db"][$sh][$O][$V];foreach(($yb?array_keys($yb):array(""))as$j)$Ge.="<li><a href='".h(auth_url($sh,$O,$V,$j))."'>($Kb[$sh]) ".h($V.($O!=""?"@".$this->serverName($O):"").($j!=""?" - $j":""))."</a>\n";}}}}if($Ge)echo"<ul id='logins'>\n$Ge</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{if($_GET["ns"]!==""&&!$Ud&&DB!=""){$f->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.8.0");if(support("sql")){echo'<script',nonce(),'>
';if($S){$Cd=array();foreach($S
as$Q=>$U)$Cd[]=preg_quote($Q,'/');echo"var jushLinks = { $z: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$Cd).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$z;\n";}$Rf=$f->server_info;echo'bodyLoad(\'',(is_object($f)?preg_replace('~^(\d\.?\d).*~s','\1',$Rf):""),'\'',(preg_match('~MariaDB~',$Rf)?", true":""),');
</script>
';}$this->databasesPrint($Ud);if(DB==""||!$Ud){echo"<p class='links'>".(support("sql")?"<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(53)."</a>\n<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(61)."</a>\n":"")."";if(support("dump"))echo"<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(62)."</a>\n";}if($_GET["ns"]!==""&&!$Ud&&DB!=""){echo'<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(63)."</a>\n";if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($Ud){global$b,$f;$i=$this->databases();if(DB&&$i&&!in_array(DB,$i))array_unshift($i,DB);echo'<form action="">
<p id="dbs">
';hidden_fields_get();$wb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(64)."'>".lang(65)."</span>: ".($i?"<select name='db'>".optionlist(array(""=>"")+$i,DB)."</select>$wb":"<input name='db' value='".h(DB)."' autocapitalize='off'>\n"),"<input type='submit' value='".lang(20)."'".($i?" class='hidden'":"").">\n";if($Ud!="db"&&DB!=""&&$f->select_db(DB)){}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}echo"</p></form>\n";}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$hg){$F=$this->tableName($hg);if($F!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(30)."'>".lang(66)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($hg)?"view":"structure"))." title='".lang(31)."'>$F</a>":"<span>$F</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$Kb=array("server"=>"MySQL")+$Kb;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($O="",$V="",$Re="",$vb=null,$Xe=null,$Zf=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Tc,$Xe)=explode(":",$O,2);$fg=$b->connectSsl();if($fg)$this->ssl_set($fg['key'],$fg['cert'],$fg['ca'],'','');$K=@$this->real_connect(($O!=""?$Tc:ini_get("mysqli.default_host")),($O.$V!=""?$V:ini_get("mysqli.default_user")),($O.$V.$Re!=""?$Re:ini_get("mysqli.default_pw")),$vb,(is_numeric($Xe)?$Xe:ini_get("mysqli.default_port")),(!is_numeric($Xe)?$Xe:$Zf),($fg?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$K;}function
set_charset($Ma){if(parent::set_charset($Ma))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ma");}function
result($I,$m=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch_array();return$L[$m];}function
quote($kg){return"'".$this->escape_string($kg)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($O,$V,$Re){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(67,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($O!=""?$O:ini_get("mysql.default_host")),("$O$V"!=""?$V:ini_get("mysql.default_user")),("$O$V$Re"!=""?$Re:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($Ma){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ma,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $Ma");}function
quote($kg){return"'".mysql_real_escape_string($kg,$this->_link)."'";}function
select_db($vb){return
mysql_select_db($vb,$this->_link);}function
query($I,$ah=false){$J=@($ah?mysql_unbuffered_query($I,$this->_link):mysql_query($I,$this->_link));$this->error="";if(!$J){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($J===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($J);}function
multi_query($I){return$this->_result=$this->query($I);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($I,$m=0){$J=$this->query($I);if(!$J||!$J->num_rows)return
false;return
mysql_result($J->_result,0,$m);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($J){$this->_result=$J;$this->num_rows=mysql_num_rows($J);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$K=mysql_fetch_field($this->_result,$this->_offset++);$K->orgtable=$K->table;$K->orgname=$K->name;$K->charsetnr=($K->blob?63:0);return$K;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($O,$V,$Re){global$b;$ve=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$fg=$b->connectSsl();if($fg){if(!empty($fg['key']))$ve[PDO::MYSQL_ATTR_SSL_KEY]=$fg['key'];if(!empty($fg['cert']))$ve[PDO::MYSQL_ATTR_SSL_CERT]=$fg['cert'];if(!empty($fg['ca']))$ve[PDO::MYSQL_ATTR_SSL_CA]=$fg['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$O)),$V,$Re,$ve);return
true;}function
set_charset($Ma){$this->query("SET NAMES $Ma");}function
select_db($vb){return$this->query("USE ".idf_escape($vb));}function
query($I,$ah=false){$this->pdo->setAttribute(1000,!$ah);return
parent::query($I,$ah);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$P){return($P?parent::insert($Q,$P):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$M,$ef){$d=array_keys(reset($M));$cf="INSERT INTO ".table($Q)." (".implode(", ",$d).") VALUES\n";$qh=array();foreach($d
as$_)$qh[$_]="$_ = VALUES($_)";$og="\nON DUPLICATE KEY UPDATE ".implode(", ",$qh);$qh=array();$_d=0;foreach($M
as$P){$Y="(".implode(", ",$P).")";if($qh&&(strlen($cf)+$_d+strlen($Y)+strlen($og)>1e6)){if(!queries($cf.implode(",\n",$qh).$og))return
false;$qh=array();$_d=0;}$qh[]=$Y;$_d+=strlen($Y)+2;}return
queries($cf.implode(",\n",$qh).$og);}function
slowQuery($I,$Gg){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$Gg FOR $I";elseif(preg_match('~^(SELECT\b)(.+)~is',$I,$D))return"$D[1] /*+ MAX_EXECUTION_TIME(".($Gg*1000).") */ $D[2]";}}function
convertSearch($w,$X,$m){return(preg_match('~char|text|enum|set~',$m["type"])&&!preg_match("~^utf8~",$m["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($w USING ".charset($this->_conn).")":$w);}function
warnings(){$J=$this->_conn->query("SHOW WARNINGS");if($J&&$J->num_rows){ob_start();select($J);return
ob_get_clean();}}function
tableHelp($F){$Fd=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Fd?"information-schema-$F-table/":str_replace("_","-",$F)."-table.html"));if(DB=="mysql")return($Fd?"mysql$F-table/":"system-database.html");}}function
idf_escape($w){return"`".str_replace("`","``",$w)."`";}function
table($w){return
idf_escape($w);}function
connect(){global$b,$Zg,$lg;$f=new
Min_DB;$ob=$b->credentials();if($f->connect($ob[0],$ob[1],$ob[2])){$f->set_charset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$f)){$lg[lang(68)][]="json";$Zg["json"]=4294967295;}return$f;}$K=$f->error;if(function_exists('iconv')&&!is_utf8($K)&&strlen($Hf=iconv("windows-1250","utf-8",$K))>strlen($K))$K=$Hf;return$K;}function
get_databases($yc){$K=get_session("dbs");if($K===null){$I=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$K=($yc?slow_query($I):get_vals($I));restart_session();set_session("dbs",$K);stop_session();}return$K;}function
limit($I,$Z,$A,$ie=0,$Qf=" "){return" $I$Z".($A!==null?$Qf."LIMIT $A".($ie?" OFFSET $ie":""):"");}function
limit1($Q,$I,$Z,$Qf="\n"){return
limit($I,$Z,1,0,$Qf);}function
db_collation($j,$Ya){global$f;$K=null;$h=$f->result("SHOW CREATE DATABASE ".idf_escape($j),1);if(preg_match('~ COLLATE ([^ ]+)~',$h,$D))$K=$D[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$h,$D))$K=$Ya[$D[1]][-1];return$K;}function
engines(){$K=array();foreach(get_rows("SHOW ENGINES")as$L){if(preg_match("~YES|DEFAULT~",$L["Support"]))$K[]=$L["Engine"];}return$K;}function
logged_user(){global$f;return$f->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($i){$K=array();foreach($i
as$j)$K[$j]=count(get_vals("SHOW TABLES IN ".idf_escape($j)));return$K;}function
table_status($F="",$rc=false){$K=array();foreach(get_rows($rc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($F!=""?"AND TABLE_NAME = ".q($F):"ORDER BY Name"):"SHOW TABLE STATUS".($F!=""?" LIKE ".q(addcslashes($F,"%_\\")):""))as$L){if($L["Engine"]=="InnoDB")$L["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$L["Comment"]);if(!isset($L["Engine"]))$L["Comment"]="";if($F!="")return$L;$K[$L["Name"]]=$L;}return$K;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$K=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$L){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$L["Type"],$D);$K[$L["Field"]]=array("field"=>$L["Field"],"full_type"=>$L["Type"],"type"=>$D[1],"length"=>$D[2],"unsigned"=>ltrim($D[3].$D[4]),"default"=>($L["Default"]!=""||preg_match("~char|set~",$D[1])?(preg_match('~text~',$D[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$L["Default"])):$L["Default"]):null),"null"=>($L["Null"]=="YES"),"auto_increment"=>($L["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$L["Extra"],$D)?$D[1]:""),"collation"=>$L["Collation"],"privileges"=>array_flip(preg_split('~, *~',$L["Privileges"])),"comment"=>$L["Comment"],"primary"=>($L["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$L["Extra"]),);}return$K;}function
indexes($Q,$g=null){$K=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$g)as$L){$F=$L["Key_name"];$K[$F]["type"]=($F=="PRIMARY"?"PRIMARY":($L["Index_type"]=="FULLTEXT"?"FULLTEXT":($L["Non_unique"]?($L["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$K[$F]["columns"][]=$L["Column_name"];$K[$F]["lengths"][]=($L["Index_type"]=="SPATIAL"?null:$L["Sub_part"]);$K[$F]["descs"][]=null;}return$K;}function
foreign_keys($Q){global$f,$pe;static$Te='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$K=array();$mb=$f->result("SHOW CREATE TABLE ".table($Q),1);if($mb){preg_match_all("~CONSTRAINT ($Te) FOREIGN KEY ?\\(((?:$Te,? ?)+)\\) REFERENCES ($Te)(?:\\.($Te))? \\(((?:$Te,? ?)+)\\)(?: ON DELETE ($pe))?(?: ON UPDATE ($pe))?~",$mb,$Hd,PREG_SET_ORDER);foreach($Hd
as$D){preg_match_all("~$Te~",$D[2],$ag);preg_match_all("~$Te~",$D[5],$_g);$K[idf_unescape($D[1])]=array("db"=>idf_unescape($D[4]!=""?$D[3]:$D[4]),"table"=>idf_unescape($D[4]!=""?$D[4]:$D[3]),"source"=>array_map('idf_unescape',$ag[0]),"target"=>array_map('idf_unescape',$_g[0]),"on_delete"=>($D[6]?$D[6]:"RESTRICT"),"on_update"=>($D[7]?$D[7]:"RESTRICT"),);}}return$K;}function
view($F){global$f;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$f->result("SHOW CREATE VIEW ".table($F),1)));}function
collations(){$K=array();foreach(get_rows("SHOW COLLATION")as$L){if($L["Default"])$K[$L["Charset"]][-1]=$L["Collation"];else$K[$L["Charset"]][]=$L["Collation"];}ksort($K);foreach($K
as$_=>$X)asort($K[$_]);return$K;}function
information_schema($j){return(min_version(5)&&$j=="information_schema")||(min_version(5.5)&&$j=="performance_schema");}function
error(){global$f;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$f->error));}function
create_database($j,$Xa){return
queries("CREATE DATABASE ".idf_escape($j).($Xa?" COLLATE ".q($Xa):""));}function
drop_databases($i){$K=apply_queries("DROP DATABASE",$i,'idf_escape');restart_session();set_session("dbs",null);return$K;}function
rename_database($F,$Xa){$K=false;if(create_database($F,$Xa)){$yf=array();foreach(tables_list()as$Q=>$U)$yf[]=table($Q)." TO ".idf_escape($F).".".table($Q);$K=(!$yf||queries("RENAME TABLE ".implode(", ",$yf)));if($K)queries("DROP DATABASE ".idf_escape(DB));restart_session();set_session("dbs",null);}return$K;}function
auto_increment(){$_a=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$x){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$x["columns"],true)){$_a="";break;}if($x["type"]=="PRIMARY")$_a=" UNIQUE";}}return" AUTO_INCREMENT$_a";}function
alter_table($Q,$F,$n,$_c,$cb,$Zb,$Xa,$za,$Oe){$ta=array();foreach($n
as$m)$ta[]=($m[1]?($Q!=""?($m[0]!=""?"CHANGE ".idf_escape($m[0]):"ADD"):" ")." ".implode($m[1]).($Q!=""?$m[2]:""):"DROP ".idf_escape($m[0]));$ta=array_merge($ta,$_c);$hg=($cb!==null?" COMMENT=".q($cb):"").($Zb?" ENGINE=".q($Zb):"").($Xa?" COLLATE ".q($Xa):"").($za!=""?" AUTO_INCREMENT=$za":"");if($Q=="")return
queries("CREATE TABLE ".table($F)." (\n".implode(",\n",$ta)."\n)$hg$Oe");if($Q!=$F)$ta[]="RENAME TO ".table($F);if($hg)$ta[]=ltrim($hg);return($ta||$Oe?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$ta).$Oe):true);}function
alter_indexes($Q,$ta){foreach($ta
as$_=>$X)$ta[$_]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$ta));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($vh){return
queries("DROP VIEW ".implode(", ",array_map('table',$vh)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$vh,$_g){$yf=array();foreach(array_merge($S,$vh)as$Q)$yf[]=table($Q)." TO ".idf_escape($_g).".".table($Q);return
queries("RENAME TABLE ".implode(", ",$yf));}function
copy_tables($S,$vh,$_g){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$F=($_g==DB?table("copy_$Q"):idf_escape($_g).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $F"))||!queries("CREATE TABLE $F LIKE ".table($Q))||!queries("INSERT INTO $F SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$L){$Ug=$L["Trigger"];if(!queries("CREATE TRIGGER ".($_g==DB?idf_escape("copy_$Ug"):idf_escape($_g).".".idf_escape($Ug))." $L[Timing] $L[Event] ON $F FOR EACH ROW\n$L[Statement];"))return
false;}}foreach($vh
as$Q){$F=($_g==DB?table("copy_$Q"):idf_escape($_g).".".table($Q));$uh=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $F"))||!queries("CREATE VIEW $F AS $uh[select]"))return
false;}return
true;}function
trigger($F){if($F=="")return
array();$M=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($F));return
reset($M);}function
triggers($Q){$K=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$L)$K[$L["Trigger"]]=array($L["Timing"],$L["Event"]);return$K;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($F,$U){global$f,$bc,$bd,$Zg;$ra=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$bg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Yg="((".implode("|",array_merge(array_keys($Zg),$ra)).")\\b(?:\\s*\\(((?:[^'\")]|$bc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Te="$bg*(".($U=="FUNCTION"?"":$bd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Yg";$h=$f->result("SHOW CREATE $U ".idf_escape($F),2);preg_match("~\\(((?:$Te\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Yg\\s+":"")."(.*)~is",$h,$D);$n=array();preg_match_all("~$Te\\s*,?~is",$D[1],$Hd,PREG_SET_ORDER);foreach($Hd
as$Je)$n[]=array("field"=>str_replace("``","`",$Je[2]).$Je[3],"type"=>strtolower($Je[5]),"length"=>preg_replace_callback("~$bc~s",'normalize_enum',$Je[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Je[8] $Je[7]"))),"null"=>1,"full_type"=>$Je[4],"inout"=>strtoupper($Je[1]),"collation"=>strtolower($Je[9]),);if($U!="FUNCTION")return
array("fields"=>$n,"definition"=>$D[11]);return
array("fields"=>$n,"returns"=>array("type"=>$D[12],"length"=>$D[13],"unsigned"=>$D[15],"collation"=>$D[16]),"definition"=>$D[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($F,$L){return
idf_escape($F);}function
last_id(){global$f;return$f->result("SELECT LAST_INSERT_ID()");}function
explain($f,$I){return$f->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$I);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Jf,$g=null){return
true;}function
create_sql($Q,$za,$mg){global$f;$K=$f->result("SHOW CREATE TABLE ".table($Q),1);if(!$za)$K=preg_replace('~ AUTO_INCREMENT=\d+~','',$K);return$K;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($vb){return"USE ".idf_escape($vb);}function
trigger_sql($Q){$K="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$L)$K.="\nCREATE TRIGGER ".idf_escape($L["Trigger"])." $L[Timing] $L[Event] ON ".table($L["Table"])." FOR EACH ROW\n$L[Statement];;\n";return$K;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($m){if(preg_match("~binary~",$m["type"]))return"HEX(".idf_escape($m["field"]).")";if($m["type"]=="bit")return"BIN(".idf_escape($m["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($m["field"]).")";}function
unconvert_field($m,$K){if(preg_match("~binary~",$m["type"]))$K="UNHEX($K)";if($m["type"]=="bit")$K="CONV($K, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]))$K=(min_version(8)?"ST_":"")."GeomFromText($K, SRID($m[field]))";return$K;}function
support($sc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$sc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$f;return$f->result("SELECT @@max_connections");}function
driver_config(){$Zg=array();$lg=array();foreach(array(lang(69)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(70)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(68)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(71)=>array("enum"=>65535,"set"=>64),lang(72)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(73)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$_=>$X){$Zg+=$X;$lg[$_]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$Zg,'structured_types'=>$lg,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$fb=driver_config();$bf=$fb['possible_drivers'];$z=$fb['jush'];$Zg=$fb['types'];$lg=$fb['structured_types'];$gh=$fb['unsigned'];$te=$fb['operators'];$Fc=$fb['functions'];$Jc=$fb['grouping'];$Rb=$fb['edit_functions'];if($b->operators===null)$b->operators=$te;define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ga="4.8.0";function
page_header($Ig,$l="",$Ia=array(),$Jg=""){global$ca,$ga,$b,$Kb,$z;page_headers();if(is_ajax()&&$l){page_messages($l);exit;}$Kg=$Ig.($Jg!=""?": $Jg":"");$Lg=strip_tags($Kg.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(74),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$Lg,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.0"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.0");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.0"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.0"),'">
';foreach($b->css()as$qb){echo'<link rel="stylesheet" type="text/css" href="',h($qb),'">
';}}echo'
<body class="',lang(74),' nojs">
';$vc=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($vc)&&filemtime($vc)+86400>time()){$th=unserialize(file_get_contents($vc));$lf="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($th["version"],base64_decode($th["signature"]),$lf)==1)$_COOKIE["adminer_version"]=$th["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ga', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(75)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$z,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Ia!==null){$B=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($B?$B:".").'">'.$Kb[DRIVER].'</a> &raquo; ';$B=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$O=$b->serverName(SERVER);$O=($O!=""?$O:lang(23));if($Ia===false)echo"$O\n";else{echo"<a href='".h($B)."' accesskey='1' title='Alt+Shift+1'>$O</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ia)))echo'<a href="'.h($B."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Ia)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Ia
as$_=>$X){$Db=(is_array($X)?$X[1]:h($X));if($Db!="")echo"<a href='".h(ME."$_=").urlencode(is_array($X)?$X[0]:$X)."'>$Db</a> &raquo; ";}}echo"$Ig\n";}}echo"<h2>$Kg</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($l);$i=&get_session("dbs");if(DB!=""&&$i&&!in_array(DB,$i,true))$i=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$pb){$Pc=array();foreach($pb
as$_=>$X)$Pc[]="$_ $X";header("Content-Security-Policy: ".implode("; ",$Pc));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$de;if(!$de)$de=base64_encode(rand_string());return$de;}function
page_messages($l){$ih=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Sd=$_SESSION["messages"][$ih];if($Sd){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Sd)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$ih]);}if($l)echo"<div class='error'>$l</div>\n";}function
page_footer($Ud=""){global$b,$T;echo'</div>

';switch_lang();if($Ud!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(76),'" id="logout">
<input type="hidden" name="token" value="',$T,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($Ud);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($Xd){while($Xd>=2147483648)$Xd-=4294967296;while($Xd<=-2147483649)$Xd+=4294967296;return(int)$Xd;}function
long2str($W,$xh){$Hf='';foreach($W
as$X)$Hf.=pack('V',$X);if($xh)return
substr($Hf,0,end($W));return$Hf;}function
str2long($Hf,$xh){$W=array_values(unpack('V*',str_pad($Hf,4*ceil(strlen($Hf)/4),"\0")));if($xh)$W[]=strlen($Hf);return$W;}function
xxtea_mx($Dh,$Ch,$pg,$md){return
int32((($Dh>>5&0x7FFFFFF)^$Ch<<2)+(($Ch>>3&0x1FFFFFFF)^$Dh<<4))^int32(($pg^$Ch)+($md^$Dh));}function
encrypt_string($jg,$_){if($jg=="")return"";$_=array_values(unpack("V*",pack("H*",md5($_))));$W=str2long($jg,true);$Xd=count($W)-1;$Dh=$W[$Xd];$Ch=$W[0];$H=floor(6+52/($Xd+1));$pg=0;while($H-->0){$pg=int32($pg+0x9E3779B9);$Qb=$pg>>2&3;for($He=0;$He<$Xd;$He++){$Ch=$W[$He+1];$Wd=xxtea_mx($Dh,$Ch,$pg,$_[$He&3^$Qb]);$Dh=int32($W[$He]+$Wd);$W[$He]=$Dh;}$Ch=$W[0];$Wd=xxtea_mx($Dh,$Ch,$pg,$_[$He&3^$Qb]);$Dh=int32($W[$Xd]+$Wd);$W[$Xd]=$Dh;}return
long2str($W,false);}function
decrypt_string($jg,$_){if($jg=="")return"";if(!$_)return
false;$_=array_values(unpack("V*",pack("H*",md5($_))));$W=str2long($jg,false);$Xd=count($W)-1;$Dh=$W[$Xd];$Ch=$W[0];$H=floor(6+52/($Xd+1));$pg=int32($H*0x9E3779B9);while($pg){$Qb=$pg>>2&3;for($He=$Xd;$He>0;$He--){$Dh=$W[$He-1];$Wd=xxtea_mx($Dh,$Ch,$pg,$_[$He&3^$Qb]);$Ch=int32($W[$He]-$Wd);$W[$He]=$Ch;}$Dh=$W[$Xd];$Wd=xxtea_mx($Dh,$Ch,$pg,$_[$He&3^$Qb]);$Ch=int32($W[0]-$Wd);$W[0]=$Ch;$pg=int32($pg-0x9E3779B9);}return
long2str($W,true);}$f='';$Oc=$_SESSION["token"];if(!$Oc)$_SESSION["token"]=rand(1,1e6);$T=get_token();$Ve=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($_)=explode(":",$X);$Ve[$_]=$X;}}function
add_invalid_login(){global$b;$q=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$q)return;$gd=unserialize(stream_get_contents($q));$Fg=time();if($gd){foreach($gd
as$hd=>$X){if($X[0]<$Fg)unset($gd[$hd]);}}$fd=&$gd[$b->bruteForceKey()];if(!$fd)$fd=array($Fg+30*60,0);$fd[1]++;file_write_unlock($q,serialize($gd));}function
check_invalid_login(){global$b;$gd=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$fd=$gd[$b->bruteForceKey()];$ce=($fd[1]>29?$fd[0]-time():0);if($ce>0)auth_error(lang(77,ceil($ce/60)));}$ya=$_POST["auth"];if($ya){session_regenerate_id();$sh=$ya["driver"];$O=$ya["server"];$V=$ya["username"];$Re=(string)$ya["password"];$j=$ya["db"];set_password($sh,$O,$V,$Re);$_SESSION["db"][$sh][$O][$V][$j]=true;if($ya["permanent"]){$_=base64_encode($sh)."-".base64_encode($O)."-".base64_encode($V)."-".base64_encode($j);$gf=$b->permanentLogin(true);$Ve[$_]="$_:".base64_encode($gf?encrypt_string($Re,$gf):"");cookie("adminer_permanent",implode(" ",$Ve));}if(count($_POST)==1||DRIVER!=$sh||SERVER!=$O||$_GET["username"]!==$V||DB!=$j)redirect(auth_url($sh,$O,$V,$j));}elseif($_POST["logout"]&&(!$Oc||verify_token())){foreach(array("pwds","db","dbs","queries")as$_)set_session($_,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(78).' '.lang(79));}elseif($Ve&&!$_SESSION["pwds"]){session_regenerate_id();$gf=$b->permanentLogin();foreach($Ve
as$_=>$X){list(,$Ra)=explode(":",$X);list($sh,$O,$V,$j)=array_map('base64_decode',explode("-",$_));set_password($sh,$O,$V,decrypt_string(base64_decode($Ra),$gf));$_SESSION["db"][$sh][$O][$V][$j]=true;}}function
unset_permanent(){global$Ve;foreach($Ve
as$_=>$X){list($sh,$O,$V,$j)=array_map('base64_decode',explode("-",$_));if($sh==DRIVER&&$O==SERVER&&$V==$_GET["username"]&&$j==DB)unset($Ve[$_]);}cookie("adminer_permanent",implode(" ",$Ve));}function
auth_error($l){global$b,$Oc;$Tf=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Tf]||$_GET[$Tf])&&!$Oc)$l=lang(80);else{restart_session();add_invalid_login();$Re=get_password();if($Re!==null){if($Re===false)$l.=($l?'<br>':'').lang(81,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$Tf]&&$_GET[$Tf]&&ini_bool("session.use_only_cookies"))$l=lang(82);$Ke=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Ke["lifetime"]);page_header(lang(27),$l,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(83)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(84),lang(85,implode(", ",$bf)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Tc,$Xe)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Xe,$D)&&($D[1]<1024||$D[1]>65535))auth_error(lang(86));check_invalid_login();$f=connect();$k=new
Min_Driver($f);}$Dd=null;if(!is_object($f)||($Dd=$b->login($_GET["username"],get_password()))!==true){$l=(is_string($f)?h($f):(is_string($Dd)?$Dd:lang(87)));auth_error($l.(preg_match('~^ | $~',get_password())?'<br>'.lang(88):''));}if($_POST["logout"]&&$Oc&&!verify_token()){page_header(lang(76),lang(89));page_footer("db");exit;}if($ya&&$_POST["token"])$_POST["token"]=$T;$l='';if($_POST){if(!verify_token()){$ad="max_input_vars";$Nd=ini_get($ad);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$_){$X=ini_get($_);if($X&&(!$Nd||$X<$Nd)){$ad=$_;$Nd=$X;}}}$l=(!$_POST["token"]&&$Nd?lang(90,"'$ad'"):lang(89).' '.lang(91));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$l=lang(92,"'post_max_size'");if(isset($_GET["sql"]))$l.=' '.lang(93);}function
select($J,$g=null,$_e=array(),$A=0){global$z;$Cd=array();$y=array();$d=array();$Ga=array();$Zg=array();$K=array();odd('');for($u=0;(!$A||$u<$A)&&($L=$J->fetch_row());$u++){if(!$u){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($ld=0;$ld<count($L);$ld++){$m=$J->fetch_field();$F=$m->name;$ze=$m->orgtable;$ye=$m->orgname;$K[$m->table]=$ze;if($_e&&$z=="sql")$Cd[$ld]=($F=="table"?"table=":($F=="possible_keys"?"indexes=":null));elseif($ze!=""){if(!isset($y[$ze])){$y[$ze]=array();foreach(indexes($ze,$g)as$x){if($x["type"]=="PRIMARY"){$y[$ze]=array_flip($x["columns"]);break;}}$d[$ze]=$y[$ze];}if(isset($d[$ze][$ye])){unset($d[$ze][$ye]);$y[$ze][$ye]=$ld;$Cd[$ld]=$ze;}}if($m->charsetnr==63)$Ga[$ld]=true;$Zg[$ld]=$m->type;echo"<th".($ze!=""||$m->name!=$ye?" title='".h(($ze!=""?"$ze.":"").$ye)."'":"").">".h($F).($_e?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($F),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($L
as$_=>$X){$B="";if(isset($Cd[$_])&&!$d[$Cd[$_]]){if($_e&&$z=="sql"){$Q=$L[array_search("table=",$Cd)];$B=ME.$Cd[$_].urlencode($_e[$Q]!=""?$_e[$Q]:$Q);}else{$B=ME."edit=".urlencode($Cd[$_]);foreach($y[$Cd[$_]]as$Va=>$ld)$B.="&where".urlencode("[".bracket_escape($Va)."]")."=".urlencode($L[$ld]);}}elseif(is_url($X))$B=$X;if($X===null)$X="<i>NULL</i>";elseif($Ga[$_]&&!is_utf8($X))$X="<i>".lang(36,strlen($X))."</i>";else{$X=h($X);if($Zg[$_]==254)$X="<code>$X</code>";}if($B)$X="<a href='".h($B)."'".(is_url($B)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($u?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$K;}function
referencable_primary($Of){$K=array();foreach(table_status('',true)as$tg=>$Q){if($tg!=$Of&&fk_support($Q)){foreach(fields($tg)as$m){if($m["primary"]){if($K[$tg]){unset($K[$tg]);break;}$K[$tg]=$m;}}}}return$K;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$Vf);return$Vf;}function
adminer_setting($_){$Vf=adminer_settings();return$Vf[$_];}function
set_adminer_settings($Vf){return
cookie("adminer_settings",http_build_query($Vf+adminer_settings()));}function
textarea($F,$Y,$M=10,$Za=80){global$z;echo"<textarea name='$F' rows='$M' cols='$Za' class='sqlarea jush-$z' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($_,$m,$Ya,$p=array(),$pc=array()){global$lg,$Zg,$gh,$pe;$U=$m["type"];echo'<td><select name="',h($_),'[type]" class="type" aria-labelledby="label-type">';if($U&&!isset($Zg[$U])&&!isset($p[$U])&&!in_array($U,$pc))$pc[]=$U;if($p)$lg[lang(94)]=$p;echo
optionlist(array_merge($pc,$lg),$U),'</select><td><input name="',h($_),'[length]" value="',h($m["length"]),'" size="3"',(!$m["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($_)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'").'><option value="">('.lang(95).')'.optionlist($Ya,$m["collation"]).'</select>',($gh?"<select name='".h($_)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($gh,$m["unsigned"]).'</select>':''),(isset($m['on_update'])?"<select name='".h($_)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(96).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"CURRENT_TIMESTAMP":$m["on_update"])).'</select>':''),($p?"<select name='".h($_)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(97).")".optionlist(explode("|",$pe),$m["on_delete"])."</select> ":" ");}function
process_length($_d){global$bc;return(preg_match("~^\\s*\\(?\\s*$bc(?:\\s*,\\s*$bc)*+\\s*\\)?\\s*\$~",$_d)&&preg_match_all("~$bc~",$_d,$Hd)?"(".implode(",",$Hd[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$_d)));}function
process_type($m,$Wa="COLLATE"){global$gh;return" $m[type]".process_length($m["length"]).(preg_match(number_type(),$m["type"])&&in_array($m["unsigned"],$gh)?" $m[unsigned]":"").(preg_match('~char|text|enum|set~',$m["type"])&&$m["collation"]?" $Wa ".q($m["collation"]):"");}function
process_field($m,$Xg){return
array(idf_escape(trim($m["field"])),process_type($Xg),($m["null"]?" NULL":" NOT NULL"),default_value($m),(preg_match('~timestamp|datetime~',$m["type"])&&$m["on_update"]?" ON UPDATE $m[on_update]":""),(support("comment")&&$m["comment"]!=""?" COMMENT ".q($m["comment"]):""),($m["auto_increment"]?auto_increment():null),);}function
default_value($m){$_b=$m["default"];return($_b===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$m["type"])||preg_match('~^(?![a-z])~i',$_b)?q($_b):$_b));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$_=>$X){if(preg_match("~$_|$X~",$U))return" class='$_'";}}function
edit_fields($n,$Ya,$U="TABLE",$p=array()){global$bd;$n=array_values($n);$Ab=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$db=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($U=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($U=="TABLE"?lang(98):lang(99)),'<td id="label-type">',lang(38),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(100),'<td>',lang(101);if($U=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(40),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),'<td id="label-default"',$Ab,'>',lang(41),(support("comment")?"<td id='label-comment'$db>".lang(39):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($n))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.0")."' alt='+' title='".lang(102)."'>".script("row_count = ".count($n).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($n
as$u=>$m){$u++;$Ae=$m[($_POST?"orig":"field")];$Hb=(isset($_POST["add"][$u-1])||(isset($m["field"])&&!$_POST["drop_col"][$u]))&&(support("drop_col")||$Ae=="");echo'<tr',($Hb?"":" style='display: none;'"),'>
',($U=="PROCEDURE"?"<td>".html_select("fields[$u][inout]",explode("|",$bd),$m["inout"]):""),'<th>';if($Hb){echo'<input name="fields[',$u,'][field]" value="',h($m["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$u,'][orig]" value="',h($Ae),'">';edit_type("fields[$u]",$m,$Ya,$p);if($U=="TABLE"){echo'<td>',checkbox("fields[$u][null]",1,$m["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$u,'"';if($m["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$Ab,'>',checkbox("fields[$u][has_default]",1,$m["has_default"],"","","","label-default"),'<input name="fields[',$u,'][default]" value="',h($m["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$db><input name='fields[$u][comment]' value='".h($m["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.0")."' alt='+' title='".lang(102)."'> "."<input type='image' class='icon' name='up[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.8.0")."' alt='↑' title='".lang(103)."'> "."<input type='image' class='icon' name='down[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.8.0")."' alt='↓' title='".lang(104)."'> ":""),($Ae==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$u]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.0")."' alt='x' title='".lang(105)."'>":"");}}function
process_fields(&$n){$ie=0;if($_POST["up"]){$ud=0;foreach($n
as$_=>$m){if(key($_POST["up"])==$_){unset($n[$_]);array_splice($n,$ud,0,array($m));break;}if(isset($m["field"]))$ud=$ie;$ie++;}}elseif($_POST["down"]){$Cc=false;foreach($n
as$_=>$m){if(isset($m["field"])&&$Cc){unset($n[key($_POST["down"])]);array_splice($n,$ie,0,array($Cc));break;}if(key($_POST["down"])==$_)$Cc=$m;$ie++;}}elseif($_POST["add"]){$n=array_values($n);array_splice($n,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($D){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($D[0][0].$D[0][0],$D[0][0],substr($D[0],1,-1))),'\\'))."'";}function
grant($s,$if,$d,$oe){if(!$if)return
true;if($if==array("ALL PRIVILEGES","GRANT OPTION"))return($s=="GRANT"?queries("$s ALL PRIVILEGES$oe WITH GRANT OPTION"):queries("$s ALL PRIVILEGES$oe")&&queries("$s GRANT OPTION$oe"));return
queries("$s ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$d, ",$if).$d).$oe);}function
drop_create($Lb,$h,$Mb,$Cg,$Nb,$C,$Rd,$Pd,$Qd,$le,$ae){if($_POST["drop"])query_redirect($Lb,$C,$Rd);elseif($le=="")query_redirect($h,$C,$Qd);elseif($le!=$ae){$nb=queries($h);queries_redirect($C,$Pd,$nb&&queries($Lb));if($nb)queries($Mb);}else
queries_redirect($C,$Pd,queries($Cg)&&queries($Nb)&&queries($Lb)&&queries($h));}function
create_trigger($oe,$L){global$z;$Hg=" $L[Timing] $L[Event]".($L["Event"]=="UPDATE OF"?" ".idf_escape($L["Of"]):"");return"CREATE TRIGGER ".idf_escape($L["Trigger"]).($z=="mssql"?$oe.$Hg:$Hg.$oe).rtrim(" $L[Type]\n$L[Statement]",";").";";}function
create_routine($Ef,$L){global$bd,$z;$P=array();$n=(array)$L["fields"];ksort($n);foreach($n
as$m){if($m["field"]!="")$P[]=(preg_match("~^($bd)\$~",$m["inout"])?"$m[inout] ":"").idf_escape($m["field"]).process_type($m,"CHARACTER SET");}$Bb=rtrim("\n$L[definition]",";");return"CREATE $Ef ".idf_escape(trim($L["name"]))." (".implode(", ",$P).")".(isset($_GET["function"])?" RETURNS".process_type($L["returns"],"CHARACTER SET"):"").($L["language"]?" LANGUAGE $L[language]":"").($z=="pgsql"?" AS ".q($Bb):"$Bb;");}function
remove_definer($I){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$I);}function
format_foreign_key($o){global$pe;$j=$o["db"];$ee=$o["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$o["source"])).") REFERENCES ".($j!=""&&$j!=$_GET["db"]?idf_escape($j).".":"").($ee!=""&&$ee!=$_GET["ns"]?idf_escape($ee).".":"").table($o["table"])." (".implode(", ",array_map('idf_escape',$o["target"])).")".(preg_match("~^($pe)\$~",$o["on_delete"])?" ON DELETE $o[on_delete]":"").(preg_match("~^($pe)\$~",$o["on_update"])?" ON UPDATE $o[on_update]":"");}function
tar_file($vc,$Mg){$K=pack("a100a8a8a8a12a12",$vc,644,0,0,decoct($Mg->size),decoct(time()));$Qa=8*32;for($u=0;$u<strlen($K);$u++)$Qa+=ord($K[$u]);$K.=sprintf("%06o",$Qa)."\0 ";echo$K,str_repeat("\0",512-strlen($K));$Mg->send();echo
str_repeat("\0",511-($Mg->size+511)%512);}function
ini_bytes($ad){$X=ini_get($ad);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($Se,$Dg="<sup>?</sup>"){global$z,$f;$Rf=$f->server_info;$th=preg_replace('~^(\d\.?\d).*~s','\1',$Rf);$kh=array('sql'=>"https://dev.mysql.com/doc/refman/$th/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$th/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Rf)."&id=",);if(preg_match('~MariaDB~',$Rf)){$kh['sql']="https://mariadb.com/kb/en/library/";$Se['sql']=(isset($Se['mariadb'])?$Se['mariadb']:str_replace(".html","/",$Se['sql']));}return($Se[$z]?"<a href='$kh[$z]$Se[$z]'".target_blank().">$Dg</a>":"");}function
ob_gzencode($kg){return
gzencode($kg);}function
db_size($j){global$f;if(!$f->select_db($j))return"?";$K=0;foreach(table_status()as$R)$K+=$R["Data_length"]+$R["Index_length"];return
format_number($K);}function
set_utf8mb4($h){global$f;static$P=false;if(!$P&&preg_match('~\butf8mb4~i',$h)){$P=true;echo"SET NAMES ".charset($f).";\n\n";}}function
connect_error(){global$b,$f,$T,$l,$Kb;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(26).": ".h(DB),lang(106),true);}else{if($_POST["db"]&&!$l)queries_redirect(substr(ME,0,-1),lang(107),drop_databases($_POST["db"]));page_header(lang(108),$l,false);echo"<p class='links'>\n";foreach(array('database'=>lang(109),'privileges'=>lang(60),'processlist'=>lang(110),'variables'=>lang(111),'status'=>lang(112),)as$_=>$X){if(support($_))echo"<a href='".h(ME)."$_='>$X</a>\n";}echo"<p>".lang(113,$Kb[DRIVER],"<b>".h($f->server_info)."</b>","<b>$f->extension</b>")."\n","<p>".lang(114,"<b>".h(logged_user())."</b>")."\n";$i=$b->databases();if($i){$Kf=support("scheme");$Ya=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(26)." - <a href='".h(ME)."refresh=1'>".lang(115)."</a>"."<td>".lang(116)."<td>".lang(117)."<td>".lang(118)." - <a href='".h(ME)."dbsize=1'>".lang(119)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$i=($_GET["dbsize"]?count_tables($i):array_flip($i));foreach($i
as$j=>$S){$Df=h(ME)."db=".urlencode($j);$v=h("Db-".$j);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$j,in_array($j,(array)$_POST["db"]),"","","",$v):""),"<th><a href='$Df' id='$v'>".h($j)."</a>";$Xa=h(db_collation($j,$Ya));echo"<td>".(support("database")?"<a href='$Df".($Kf?"&amp;ns=":"")."&amp;database=' title='".lang(56)."'>$Xa</a>":$Xa),"<td align='right'><a href='$Df&amp;schema=' id='tables-".h($j)."' title='".lang(59)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($j)."'>".($_GET["dbsize"]?db_size($j):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(120)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(121)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$T'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$f->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}$pe="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($ib){$this->size+=strlen($ib);fwrite($this->handler,$ib);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$bc="'(?:''|[^'\\\\]|\\\\.)*'";$bd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$n=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$N=array(idf_escape($_GET["field"]));$J=$k->select($a,$N,array(where($_GET,$n)),$N);$L=($J?$J->fetch_row():array());echo$k->value($L[0],$n[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$n=fields($a);if(!$n)$l=error();$R=table_status1($a,true);$F=$b->tableName($R);page_header(($n&&is_view($R)?$R['Engine']=='materialized view'?lang(122):lang(123):lang(124)).": ".($F!=""?$F:h($a)),$l);$b->selectLinks($R);$cb=$R["Comment"];if($cb!="")echo"<p class='nowrap'>".lang(39).": ".h($cb)."\n";if($n)$b->tableStructurePrint($n);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(125)."</h3>\n";$y=indexes($a);if($y)$b->tableIndexesPrint($y);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(126)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(94)."</h3>\n";$p=foreign_keys($a);if($p){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(127)."<td>".lang(128)."<td>".lang(97)."<td>".lang(96)."<td></thead>\n";foreach($p
as$F=>$o){echo"<tr title='".h($F)."'>","<th><i>".implode("</i>, <i>",array_map('h',$o["source"]))."</i>","<td><a href='".h($o["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($o["db"]),ME):($o["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($o["ns"]),ME):ME))."table=".urlencode($o["table"])."'>".($o["db"]!=""?"<b>".h($o["db"])."</b>.":"").($o["ns"]!=""?"<b>".h($o["ns"])."</b>.":"").h($o["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$o["target"]))."</i>)","<td>".h($o["on_delete"])."\n","<td>".h($o["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($F)).'">'.lang(129).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(130)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(131)."</h3>\n";$Wg=triggers($a);if($Wg){echo"<table cellspacing='0'>\n";foreach($Wg
as$_=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($_)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($_))."'>".lang(129)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(132)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(59),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$ug=array();$vg=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$Hd,PREG_SET_ORDER);foreach($Hd
as$u=>$D){$ug[$D[1]]=array($D[2],$D[3]);$vg[]="\n\t'".js_escape($D[1])."': [ $D[2], $D[3] ]";}$Og=0;$Da=-1;$Jf=array();$vf=array();$yd=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$Ye=0;$Jf[$Q]["fields"]=array();foreach(fields($Q)as$F=>$m){$Ye+=1.25;$m["pos"]=$Ye;$Jf[$Q]["fields"][$F]=$m;}$Jf[$Q]["pos"]=($ug[$Q]?$ug[$Q]:array($Og,0));foreach($b->foreignKeys($Q)as$X){if(!$X["db"]){$wd=$Da;if($ug[$Q][1]||$ug[$X["table"]][1])$wd=min(floatval($ug[$Q][1]),floatval($ug[$X["table"]][1]))-1;else$Da-=.1;while($yd[(string)$wd])$wd-=.0001;$Jf[$Q]["references"][$X["table"]][(string)$wd]=array($X["source"],$X["target"]);$vf[$X["table"]][$Q][(string)$wd]=$X["target"];$yd[(string)$wd]=true;}}$Og=max($Og,$Jf[$Q]["pos"][0]+2.5+$Ye);}echo'<div id="schema" style="height: ',$Og,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$vg)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$Og,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Jf
as$F=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($F).'"><b>'.h($F)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$m){$X='<span'.type_class($m["type"]).' title="'.h($m["full_type"].($m["null"]?" NULL":'')).'">'.h($m["field"]).'</span>';echo"<br>".($m["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$Ag=>$wf){foreach($wf
as$wd=>$sf){$xd=$wd-$ug[$F][1];$u=0;foreach($sf[0]as$ag)echo"\n<div class='references' title='".h($Ag)."' id='refs$wd-".($u++)."' style='left: $xd"."em; top: ".$Q["fields"][$ag]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$xd)."em;'></div></div>";}}foreach((array)$vf[$F]as$Ag=>$wf){foreach($wf
as$wd=>$d){$xd=$wd-$ug[$F][1];$u=0;foreach($d
as$_g)echo"\n<div class='references' title='".h($Ag)."' id='refd$wd-".($u++)."' style='left: $xd"."em; top: ".$Q["fields"][$_g]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.8.0")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$xd)."em;'></div></div>";}}echo"\n</div>\n";}foreach($Jf
as$F=>$Q){foreach((array)$Q["references"]as$Ag=>$wf){foreach($wf
as$wd=>$sf){$Td=$Og;$Ld=-10;foreach($sf[0]as$_=>$ag){$Ze=$Q["pos"][0]+$Q["fields"][$ag]["pos"];$af=$Jf[$Ag]["pos"][0]+$Jf[$Ag]["fields"][$sf[1][$_]]["pos"];$Td=min($Td,$Ze,$af);$Ld=max($Ld,$Ze,$af);}echo"<div class='references' id='refl$wd' style='left: $wd"."em; top: $Td"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Ld-$Td)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(133),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$l){$lb="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$_)$lb.="&$_=".urlencode($_POST[$_]);cookie("adminer_export",substr($lb,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$nc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$jd=preg_match('~sql~',$_POST["format"]);if($jd){echo"-- Adminer $ga ".$Kb[DRIVER]." ".str_replace("\n"," ",$f->server_info)." dump\n\n";if($z=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$f->query("SET time_zone = '+00:00'");$f->query("SET sql_mode = ''");}}$mg=$_POST["db_style"];$i=array(DB);if(DB==""){$i=$_POST["databases"];if(is_string($i))$i=explode("\n",rtrim(str_replace("\r","",$i),"\n"));}foreach((array)$i
as$j){$b->dumpDatabase($j);if($f->select_db($j)){if($jd&&preg_match('~CREATE~',$mg)&&($h=$f->result("SHOW CREATE DATABASE ".idf_escape($j),1))){set_utf8mb4($h);if($mg=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($j).";\n";echo"$h;\n";}if($jd){if($mg)echo
use_sql($j).";\n\n";$Fe="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$Ef){foreach(get_rows("SHOW $Ef STATUS WHERE Db = ".q($j),null,"-- ")as$L){$h=remove_definer($f->result("SHOW CREATE $Ef ".idf_escape($L["Name"]),2));set_utf8mb4($h);$Fe.=($mg!='DROP+CREATE'?"DROP $Ef IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$h;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$L){$h=remove_definer($f->result("SHOW CREATE EVENT ".idf_escape($L["Name"]),3));set_utf8mb4($h);$Fe.=($mg!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$h;;\n\n";}}if($Fe)echo"DELIMITER ;;\n\n$Fe"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$vh=array();foreach(table_status('',true)as$F=>$R){$Q=(DB==""||in_array($F,(array)$_POST["tables"]));$tb=(DB==""||in_array($F,(array)$_POST["data"]));if($Q||$tb){if($nc=="tar"){$Mg=new
TmpFile;ob_start(array($Mg,'write'),1e5);}$b->dumpTable($F,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$vh[]=$F;elseif($tb){$n=fields($F);$b->dumpData($F,$_POST["data_style"],"SELECT *".convert_fields($n,$n)." FROM ".table($F));}if($jd&&$_POST["triggers"]&&$Q&&($Wg=trigger_sql($F)))echo"\nDELIMITER ;;\n$Wg\nDELIMITER ;\n";if($nc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$j/")."$F.csv",$Mg);}elseif($jd)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$F=>$R){$Q=(DB==""||in_array($F,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($F);}}foreach($vh
as$uh)$b->dumpTable($uh,$_POST["table_style"],1);if($nc=="tar")echo
pack("x512");}}}if($jd)echo"-- ".$f->result("SELECT NOW()")."\n";exit;}page_header(lang(62),$l,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$xb=array('','USE','DROP+CREATE','CREATE');$wg=array('','DROP+CREATE','CREATE');$ub=array('','TRUNCATE+INSERT','INSERT');if($z=="sql")$ub[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$L);if(!$L)$L=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($L["events"])){$L["routines"]=$L["events"]=($_GET["dump"]=="");$L["triggers"]=$L["table_style"];}echo"<tr><th>".lang(134)."<td>".html_select("output",$b->dumpOutput(),$L["output"],0)."\n";echo"<tr><th>".lang(135)."<td>".html_select("format",$b->dumpFormat(),$L["format"],0)."\n";echo($z=="sqlite"?"":"<tr><th>".lang(26)."<td>".html_select('db_style',$xb,$L["db_style"]).(support("routine")?checkbox("routines",1,$L["routines"],lang(136)):"").(support("event")?checkbox("events",1,$L["events"],lang(137)):"")),"<tr><th>".lang(117)."<td>".html_select('table_style',$wg,$L["table_style"]).checkbox("auto_increment",1,$L["auto_increment"],lang(40)).(support("trigger")?checkbox("triggers",1,$L["triggers"],lang(131)):""),"<tr><th>".lang(138)."<td>".html_select('data_style',$ub,$L["data_style"]),'</table>
<p><input type="submit" value="',lang(62),'">
<input type="hidden" name="token" value="',$T,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$df=array();if(DB!=""){$Oa=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Oa>".lang(117)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(138)."<input type='checkbox' id='check-data'$Oa></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$vh="";$xg=tables_list();foreach($xg
as$F=>$U){$cf=preg_replace('~_.*~','',$F);$Oa=($a==""||$a==(substr($a,-1)=="%"?"$cf%":$F));$ff="<tr><td>".checkbox("tables[]",$F,$Oa,$F,"","block");if($U!==null&&!preg_match('~table~i',$U))$vh.="$ff\n";else
echo"$ff<td align='right'><label class='block'><span id='Rows-".h($F)."'></span>".checkbox("data[]",$F,$Oa)."</label>\n";$df[$cf]++;}echo$vh;if($xg)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(26)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$i=$b->databases();if($i){foreach($i
as$j){if(!information_schema($j)){$cf=preg_replace('~_.*~','',$j);echo"<tr><td>".checkbox("databases[]",$j,$a==""||$a=="$cf%",$j,"","block")."\n";$df[$cf]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$xc=true;foreach($df
as$_=>$X){if($_!=""&&$X>1){echo($xc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$_%")."'>".h($_)."</a>";$xc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(60));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(139)."</a>";$J=$f->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$s=$J;if(!$J)$J=$f->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($s?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(24)."<th>".lang(23)."<th></thead>\n";while($L=$J->fetch_assoc())echo'<tr'.odd().'><td>'.h($L["User"])."<td>".h($L["Host"]).'<td><a href="'.h(ME.'user='.urlencode($L["User"]).'&host='.urlencode($L["Host"])).'">'.lang(10)."</a>\n";if(!$s||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$l&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$Sc=&get_session("queries");$Rc=&$Sc[DB];if(!$l&&$_POST["clear"]){$Rc=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(61):lang(53)),$l);if(!$l&&$_POST){$q=false;if(!isset($_GET["import"]))$I=$_POST["query"];elseif($_POST["webfile"]){$dg=$b->importServerPath();$q=@fopen((file_exists($dg)?$dg:"compress.zlib://$dg.gz"),"rb");$I=($q?fread($q,1e6):false);}else$I=get_file("sql_file",true);if(is_string($I)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($I)+memory_get_usage()+8e6));if($I!=""&&strlen($I)<1e6){$H=$I.(preg_match("~;[ \t\r\n]*\$~",$I)?"":";");if(!$Rc||reset(end($Rc))!=$H){restart_session();$Rc[]=array($H,time());set_session("queries",$Sc);stop_session();}}$bg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Cb=";";$ie=0;$Yb=true;$g=connect();if(is_object($g)&&DB!=""){$g->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$g);}$bb=0;$dc=array();$Le='[\'"'.($z=="sql"?'`#':($z=="sqlite"?'`[':($z=="mssql"?'[':''))).']|/\*|-- |$'.($z=="pgsql"?'|\$[^$]*\$':'');$Pg=microtime(true);parse_str($_COOKIE["adminer_export"],$ma);$Pb=$b->dumpFormat();unset($Pb["sql"]);while($I!=""){if(!$ie&&preg_match("~^$bg*+DELIMITER\\s+(\\S+)~i",$I,$D)){$Cb=$D[1];$I=substr($I,strlen($D[0]));}else{preg_match('('.preg_quote($Cb)."\\s*|$Le)",$I,$D,PREG_OFFSET_CAPTURE,$ie);list($Cc,$Ye)=$D[0];if(!$Cc&&$q&&!feof($q))$I.=fread($q,1e5);else{if(!$Cc&&rtrim($I)=="")break;$ie=$Ye+strlen($Cc);if($Cc&&rtrim($Cc)!=$Cb){while(preg_match('('.($Cc=='/*'?'\*/':($Cc=='['?']':(preg_match('~^-- |^#~',$Cc)?"\n":preg_quote($Cc)."|\\\\."))).'|$)s',$I,$D,PREG_OFFSET_CAPTURE,$ie)){$Hf=$D[0][0];if(!$Hf&&$q&&!feof($q))$I.=fread($q,1e5);else{$ie=$D[0][1]+strlen($Hf);if($Hf[0]!="\\")break;}}}else{$Yb=false;$H=substr($I,0,$Ye);$bb++;$ff="<pre id='sql-$bb'><code class='jush-$z'>".$b->sqlCommandQuery($H)."</code></pre>\n";if($z=="sqlite"&&preg_match("~^$bg*+ATTACH\\b~i",$H,$D)){echo$ff,"<p class='error'>".lang(140)."\n";$dc[]=" <a href='#sql-$bb'>$bb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$ff;ob_flush();flush();}$gg=microtime(true);if($f->multi_query($H)&&is_object($g)&&preg_match("~^$bg*+USE\\b~i",$H))$g->query($H);do{$J=$f->store_result();if($f->error){echo($_POST["only_errors"]?$ff:""),"<p class='error'>".lang(141).($f->errno?" ($f->errno)":"").": ".error()."\n";$dc[]=" <a href='#sql-$bb'>$bb</a>";if($_POST["error_stops"])break
2;}else{$Fg=" <span class='time'>(".format_time($gg).")</span>".(strlen($H)<1000?" <a href='".h(ME)."sql=".urlencode(trim($H))."'>".lang(10)."</a>":"");$oa=$f->affected_rows;$yh=($_POST["only_errors"]?"":$k->warnings());$zh="warnings-$bb";if($yh)$Fg.=", <a href='#$zh'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$zh');","");$lc=null;$mc="explain-$bb";if(is_object($J)){$A=$_POST["limit"];$_e=select($J,$g,array(),$A);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$fe=$J->num_rows;echo"<p>".($fe?($A&&$fe>$A?lang(142,$A):"").lang(143,$fe):""),$Fg;if($g&&preg_match("~^($bg|\\()*+SELECT\\b~i",$H)&&($lc=explain($g,$H)))echo", <a href='#$mc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$mc');","");$v="export-$bb";echo", <a href='#$v'>".lang(62)."</a>".script("qsl('a').onclick = partial(toggle, '$v');","")."<span id='$v' class='hidden'>: ".html_select("output",$b->dumpOutput(),$ma["output"])." ".html_select("format",$Pb,$ma["format"])."<input type='hidden' name='query' value='".h($H)."'>"." <input type='submit' name='export' value='".lang(62)."'><input type='hidden' name='token' value='$T'></span>\n"."</form>\n";}}else{if(preg_match("~^$bg*+(CREATE|DROP|ALTER)$bg++(DATABASE|SCHEMA)\\b~i",$H)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($f->info)."'>".lang(144,$oa)."$Fg\n";}echo($yh?"<div id='$zh' class='hidden'>\n$yh</div>\n":"");if($lc){echo"<div id='$mc' class='hidden'>\n";select($lc,$g,$_e);echo"</div>\n";}}$gg=microtime(true);}while($f->next_result());}$I=substr($I,$ie);$ie=0;}}}}if($Yb)echo"<p class='message'>".lang(145)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(146,$bb-count($dc))," <span class='time'>(".format_time($Pg).")</span>\n";}elseif($dc&&$bb>1)echo"<p class='error'>".lang(141).": ".implode("",$dc)."\n";}else
echo"<p class='error'>".upload_error($I)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$jc="<input type='submit' value='".lang(147)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$H=$_GET["sql"];if($_POST)$H=$_POST["query"];elseif($_GET["history"]=="all")$H=$Rc;elseif($_GET["history"]!="")$H=$Rc[$_GET["history"]][0];echo"<p>";textarea("query",$H,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$jc\n",lang(148).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(149)."</legend><div>";$Kc=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$Kc (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$jc":lang(150)),"</div></fieldset>\n";$Xc=$b->importServerPath();if($Xc){echo"<fieldset><legend>".lang(151)."</legend><div>",lang(152,"<code>".h($Xc)."$Kc</code>"),' <input type="submit" name="webfile" value="'.lang(153).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(154))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(155))."\n","<input type='hidden' name='token' value='$T'>\n";if(!isset($_GET["import"])&&$Rc){print_fieldset("history",lang(156),$_GET["history"]!="");for($X=end($Rc);$X;$X=prev($Rc)){$_=key($Rc);list($H,$Fg,$Tb)=$X;echo'<a href="'.h(ME."sql=&history=$_").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Fg)."'>".@date("H:i:s",$Fg)."</span>"." <code class='jush-$z'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$H)))),80,"</code>").($Tb?" <span class='time'>($Tb)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(157)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(158)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$n=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$n):""):where($_GET,$n));$hh=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($n
as$F=>$m){if(!isset($m["privileges"][$hh?"update":"insert"])||$b->fieldName($m)==""||$m["generated"])unset($n[$F]);}if($_POST&&!$l&&!isset($_GET["select"])){$C=$_POST["referer"];if($_POST["insert"])$C=($hh?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$C))$C=ME."select=".urlencode($a);$y=indexes($a);$ch=unique_array($_GET["where"],$y);$of="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($C,lang(159),$k->delete($a,$of,!$ch));else{$P=array();foreach($n
as$F=>$m){$X=process_input($m);if($X!==false&&$X!==null)$P[idf_escape($F)]=$X;}if($hh){if(!$P)redirect($C);queries_redirect($C,lang(160),$k->update($a,$P,$of,!$ch));if(is_ajax()){page_headers();page_messages($l);exit;}}else{$J=$k->insert($a,$P);$vd=($J?last_id():0);queries_redirect($C,lang(161,($vd?" $vd":"")),$J);}}}$L=null;if($_POST["save"])$L=(array)$_POST["fields"];elseif($Z){$N=array();foreach($n
as$F=>$m){if(isset($m["privileges"]["select"])){$va=convert_field($m);if($_POST["clone"]&&$m["auto_increment"])$va="''";if($z=="sql"&&preg_match("~enum|set~",$m["type"]))$va="1*".idf_escape($F);$N[]=($va?"$va AS ":"").idf_escape($F);}}$L=array();if(!support("table"))$N=array("*");if($N){$J=$k->select($a,$N,array($Z),$N,array(),(isset($_GET["select"])?2:1));if(!$J)$l=error();else{$L=$J->fetch_assoc();if(!$L)$L=false;}if(isset($_GET["select"])&&(!$L||$J->fetch_assoc()))$L=null;}}if(!support("table")&&!$n){if(!$Z){$J=$k->select($a,array("*"),$Z,array("*"));$L=($J?$J->fetch_assoc():false);if(!$L)$L=array($k->primary=>"");}if($L){foreach($L
as$_=>$X){if(!$Z)$L[$_]=null;$n[$_]=array("field"=>$_,"null"=>($_!=$k->primary),"auto_increment"=>($_==$k->primary));}}}edit_form($a,$n,$L,$hh);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Me=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$_)$Me[$_]=$_;$uf=referencable_primary($a);$p=array();foreach($uf
as$tg=>$m)$p[str_replace("`","``",$tg)."`".str_replace("`","``",$m["field"])]=$tg;$Ce=array();$R=array();if($a!=""){$Ce=fields($a);$R=table_status($a);if(!$R)$l=lang(9);}$L=$_POST;$L["fields"]=(array)$L["fields"];if($L["auto_increment_col"])$L["fields"][$L["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($L["fields"])&&!$l){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(162),drop_tables(array($a)));else{$n=array();$sa=array();$lh=false;$_c=array();$Be=reset($Ce);$qa=" FIRST";foreach($L["fields"]as$_=>$m){$o=$p[$m["type"]];$Xg=($o!==null?$uf[$o]:$m);if($m["field"]!=""){if(!$m["has_default"])$m["default"]=null;if($_==$L["auto_increment_col"])$m["auto_increment"]=true;$kf=process_field($m,$Xg);$sa[]=array($m["orig"],$kf,$qa);if(!$Be||$kf!=process_field($Be,$Be)){$n[]=array($m["orig"],$kf,$qa);if($m["orig"]!=""||$qa)$lh=true;}if($o!==null)$_c[idf_escape($m["field"])]=($a!=""&&$z!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$p[$m["type"]],'source'=>array($m["field"]),'target'=>array($Xg["field"]),'on_delete'=>$m["on_delete"],));$qa=" AFTER ".idf_escape($m["field"]);}elseif($m["orig"]!=""){$lh=true;$n[]=array($m["orig"]);}if($m["orig"]!=""){$Be=next($Ce);if(!$Be)$qa="";}}$Oe="";if($Me[$L["partition_by"]]){$Pe=array();if($L["partition_by"]=='RANGE'||$L["partition_by"]=='LIST'){foreach(array_filter($L["partition_names"])as$_=>$X){$Y=$L["partition_values"][$_];$Pe[]="\n  PARTITION ".idf_escape($X)." VALUES ".($L["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Oe.="\nPARTITION BY $L[partition_by]($L[partition])".($Pe?" (".implode(",",$Pe)."\n)":($L["partitions"]?" PARTITIONS ".(+$L["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$R["Create_options"]))$Oe.="\nREMOVE PARTITIONING";$E=lang(163);if($a==""){cookie("adminer_engine",$L["Engine"]);$E=lang(164);}$F=trim($L["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($F),$E,alter_table($a,$F,($z=="sqlite"&&($lh||$_c)?$sa:$n),$_c,($L["Comment"]!=$R["Comment"]?$L["Comment"]:null),($L["Engine"]&&$L["Engine"]!=$R["Engine"]?$L["Engine"]:""),($L["Collation"]&&$L["Collation"]!=$R["Collation"]?$L["Collation"]:""),($L["Auto_increment"]!=""?number($L["Auto_increment"]):""),$Oe));}}page_header(($a!=""?lang(33):lang(63)),$l,array("table"=>$a),h($a));if(!$_POST){$L=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Zg["int"])?"int":(isset($Zg["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$L=$R;$L["name"]=$a;$L["fields"]=array();if(!$_GET["auto_increment"])$L["Auto_increment"]="";foreach($Ce
as$m){$m["has_default"]=isset($m["default"]);$L["fields"][]=$m;}if(support("partitioning")){$Ec="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$J=$f->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $Ec ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($L["partition_by"],$L["partitions"],$L["partition"])=$J->fetch_row();$Pe=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Ec AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$Pe[""]="";$L["partition_names"]=array_keys($Pe);$L["partition_values"]=array_values($Pe);}}}$Ya=collations();$ac=engines();foreach($ac
as$Zb){if(!strcasecmp($Zb,$L["Engine"])){$L["Engine"]=$Zb;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(165),': <input name="name" data-maxlength="64" value="',h($L["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($ac?"<select name='Engine'>".optionlist(array(""=>"(".lang(166).")")+$ac,$L["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($Ya&&!preg_match("~sqlite|mssql~",$z)?html_select("Collation",array(""=>"(".lang(95).")")+$Ya,$L["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($L["fields"],$Ya,"TABLE",$p);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(40),': <input type="number" name="Auto_increment" size="6" value="',h($L["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(167),"columnShow(this.checked, 5)","jsonly"),(support("comment")?checkbox("comments",1,($_POST?$_POST["comments"]:adminer_setting("comments")),lang(39),"editingCommentsClick(this, true);","jsonly").' <input name="Comment" value="'.h($L["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'">':''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$a));}if(support("partitioning")){$Ne=preg_match('~RANGE|LIST~',$L["partition_by"]);print_fieldset("partition",lang(169),$L["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$Me,$L["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($L["partition"]),'">)
',lang(170),': <input type="number" name="partitions" class="size',($Ne||!$L["partition_by"]?" hidden":""),'" value="',h($L["partitions"]),'">
<table cellspacing="0" id="partition-table"',($Ne?"":" class='hidden'"),'>
<thead><tr><th>',lang(171),'<th>',lang(172),'</thead>
';foreach($L["partition_names"]as$_=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($_==count($L["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($L["partition_values"][$_]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Zc=array("PRIMARY","UNIQUE","INDEX");$R=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$Zc[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$Zc[]="SPATIAL";$y=indexes($a);$ef=array();if($z=="mongo"){$ef=$y["_id_"];unset($Zc[0]);unset($y["_id_"]);}$L=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["drop_col"]){$ta=array();foreach($L["indexes"]as$x){$F=$x["name"];if(in_array($x["type"],$Zc)){$d=array();$Ad=array();$Eb=array();$P=array();ksort($x["columns"]);foreach($x["columns"]as$_=>$c){if($c!=""){$_d=$x["lengths"][$_];$Db=$x["descs"][$_];$P[]=idf_escape($c).($_d?"(".(+$_d).")":"").($Db?" DESC":"");$d[]=$c;$Ad[]=($_d?$_d:null);$Eb[]=$Db;}}if($d){$kc=$y[$F];if($kc){ksort($kc["columns"]);ksort($kc["lengths"]);ksort($kc["descs"]);if($x["type"]==$kc["type"]&&array_values($kc["columns"])===$d&&(!$kc["lengths"]||array_values($kc["lengths"])===$Ad)&&array_values($kc["descs"])===$Eb){unset($y[$F]);continue;}}$ta[]=array($x["type"],$F,$P);}}}foreach($y
as$F=>$kc)$ta[]=array($kc["type"],$F,"DROP");if(!$ta)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(173),alter_indexes($a,$ta));}page_header(lang(125),$l,array("table"=>$a),h($a));$n=array_keys(fields($a));if($_POST["add"]){foreach($L["indexes"]as$_=>$x){if($x["columns"][count($x["columns"])]!="")$L["indexes"][$_]["columns"][]="";}$x=end($L["indexes"]);if($x["type"]||array_filter($x["columns"],'strlen'))$L["indexes"][]=array("columns"=>array(1=>""));}if(!$L){foreach($y
as$_=>$x){$y[$_]["name"]=$_;$y[$_]["columns"][]="";}$y[]=array("columns"=>array(1=>""));$L["indexes"]=$y;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(174),'<th><input type="submit" class="wayoff">',lang(175),'<th id="label-name">',lang(176),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.0")."' alt='+' title='".lang(102)."'>",'</noscript>
</thead>
';if($ef){echo"<tr><td>PRIMARY<td>";foreach($ef["columns"]as$_=>$c){echo
select_input(" disabled",$n,$c),"<label><input disabled type='checkbox'>".lang(48)."</label> ";}echo"<td><td>\n";}$ld=1;foreach($L["indexes"]as$x){if(!$_POST["drop_col"]||$ld!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$ld][type]",array(-1=>"")+$Zc,$x["type"],($ld==count($L["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($x["columns"]);$u=1;foreach($x["columns"]as$_=>$c){echo"<span>".select_input(" name='indexes[$ld][columns][$u]' title='".lang(37)."'",($n?array_combine($n,$n):$n),$c,"partial(".($u==count($x["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($z=="sql"?"":$_GET["indexes"]."_")."')"),($z=="sql"||$z=="mssql"?"<input type='number' name='indexes[$ld][lengths][$u]' class='size' value='".h($x["lengths"][$_])."' title='".lang(100)."'>":""),(support("descidx")?checkbox("indexes[$ld][descs][$u]",1,$x["descs"][$_],lang(48)):"")," </span>";$u++;}echo"<td><input name='indexes[$ld][name]' value='".h($x["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$ld]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.0")."' alt='x' title='".lang(105)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$ld++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["database"])){$L=$_POST;if($_POST&&!$l&&!isset($_POST["add_x"])){$F=trim($L["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(177),drop_databases(array(DB)));}elseif(DB!==$F){if(DB!=""){$_GET["db"]=$F;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($F),lang(178),rename_database($F,$L["collation"]));}else{$i=explode("\n",str_replace("\r","",$F));$ng=true;$ud="";foreach($i
as$j){if(count($i)==1||$j!=""){if(!create_database($j,$L["collation"]))$ng=false;$ud=$j;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($ud),lang(179),$ng);}}else{if(!$L["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($F).(preg_match('~^[a-z0-9_]+$~i',$L["collation"])?" COLLATE $L[collation]":""),substr(ME,0,-1),lang(180));}}page_header(DB!=""?lang(56):lang(109),$l,array(),h(DB));$Ya=collations();$F=DB;if($_POST)$F=$L["name"];elseif(DB!="")$L["collation"]=db_collation(DB,$Ya);elseif($z=="sql"){foreach(get_vals("SHOW GRANTS")as$s){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$s,$D)&&$D[1]){$F=stripcslashes(idf_unescape("`$D[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($F,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($F).'</textarea><br>':'<input name="name" id="name" value="'.h($F).'" data-maxlength="64" autocapitalize="off">')."\n".($Ya?html_select("collation",array(""=>"(".lang(95).")")+$Ya,$L["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(121)."'>".confirm(lang(168,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.0")."' alt='+' title='".lang(102)."'>\n";echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(181).": ".h($da),$l);$Ef=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Yc=array();$Fe=array();foreach($Ef["fields"]as$u=>$m){if(substr($m["inout"],-3)=="OUT")$Fe[$u]="@".idf_escape($m["field"])." AS ".idf_escape($m["field"]);if(!$m["inout"]||substr($m["inout"],0,2)=="IN")$Yc[]=$u;}if(!$l&&$_POST){$Ka=array();foreach($Ef["fields"]as$_=>$m){if(in_array($_,$Yc)){$X=process_input($m);if($X===false)$X="''";if(isset($Fe[$_]))$f->query("SET @".idf_escape($m["field"])." = $X");}$Ka[]=(isset($Fe[$_])?"@".idf_escape($m["field"]):$X);}$I=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$Ka).")";$gg=microtime(true);$J=$f->multi_query($I);$oa=$f->affected_rows;echo$b->selectQuery($I,$gg,!$J);if(!$J)echo"<p class='error'>".error()."\n";else{$g=connect();if(is_object($g))$g->select_db(DB);do{$J=$f->store_result();if(is_object($J))select($J,$g);else
echo"<p class='message'>".lang(182,$oa)." <span class='time'>".@date("H:i:s")."</span>\n";}while($f->next_result());if($Fe)select($f->query("SELECT ".implode(", ",$Fe)));}}echo'
<form action="" method="post">
';if($Yc){echo"<table cellspacing='0' class='layout'>\n";foreach($Yc
as$_){$m=$Ef["fields"][$_];$F=$m["field"];echo"<tr><th>".$b->fieldName($m);$Y=$_POST["fields"][$F];if($Y!=""){if($m["type"]=="enum")$Y=+$Y;if($m["type"]=="set")$Y=array_sum($Y);}input($m,$Y,(string)$_POST["function"][$F]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(181),'">
<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$F=$_GET["name"];$L=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$E=($_POST["drop"]?lang(183):($F!=""?lang(184):lang(185)));$C=ME."table=".urlencode($a);if(!$_POST["drop"]){$L["source"]=array_filter($L["source"],'strlen');ksort($L["source"]);$_g=array();foreach($L["source"]as$_=>$X)$_g[$_]=$L["target"][$_];$L["target"]=$_g;}if($z=="sqlite")queries_redirect($C,$E,recreate_table($a,$a,array(),array(),array(" $F"=>($_POST["drop"]?"":" ".format_foreign_key($L)))));else{$ta="ALTER TABLE ".table($a);$Lb="\nDROP ".($z=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($F);if($_POST["drop"])query_redirect($ta.$Lb,$C,$E);else{query_redirect($ta.($F!=""?"$Lb,":"")."\nADD".format_foreign_key($L),$C,$E);$l=lang(186)."<br>$l";}}}page_header(lang(187),$l,array("table"=>$a),h($a));if($_POST){ksort($L["source"]);if($_POST["add"])$L["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$L["target"]=array();}elseif($F!=""){$p=foreign_keys($a);$L=$p[$F];$L["source"][]="";}else{$L["table"]=$a;$L["source"]=array("");}echo'
<form action="" method="post">
';$ag=array_keys(fields($a));if($L["db"]!="")$f->select_db($L["db"]);if($L["ns"]!="")set_schema($L["ns"]);$tf=array_keys(array_filter(table_status('',true),'fk_support'));$_g=array_keys(fields(in_array($L["table"],$tf)?$L["table"]:reset($tf)));$qe="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(188).": ".html_select("table",$tf,$L["table"],$qe)."\n";if($z=="pgsql")echo
lang(189).": ".html_select("ns",$b->schemas(),$L["ns"]!=""?$L["ns"]:$_GET["ns"],$qe);elseif($z!="sqlite"){$yb=array();foreach($b->databases()as$j){if(!information_schema($j))$yb[]=$j;}echo
lang(65).": ".html_select("db",$yb,$L["db"]!=""?$L["db"]:$_GET["db"],$qe);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(190),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(127),'<th id="label-target">',lang(128),'</thead>
';$ld=0;foreach($L["source"]as$_=>$X){echo"<tr>","<td>".html_select("source[".(+$_)."]",array(-1=>"")+$ag,$X,($ld==count($L["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$_)."]",$_g,$L["target"][$_],1,"label-target");$ld++;}echo'</table>
<p>
',lang(97),': ',html_select("on_delete",array(-1=>"")+explode("|",$pe),$L["on_delete"]),' ',lang(96),': ',html_select("on_update",array(-1=>"")+explode("|",$pe),$L["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(191),'"></noscript>
';if($F!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$F));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$L=$_POST;$De="VIEW";if($z=="pgsql"&&$a!=""){$hg=table_status($a);$De=strtoupper($hg["Engine"]);}if($_POST&&!$l){$F=trim($L["name"]);$va=" AS\n$L[select]";$C=ME."table=".urlencode($F);$E=lang(192);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$F&&$z!="sqlite"&&$U=="VIEW"&&$De=="VIEW")query_redirect(($z=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($F).$va,$C,$E);else{$Bg=$F."_adminer_".uniqid();drop_create("DROP $De ".table($a),"CREATE $U ".table($F).$va,"DROP $U ".table($F),"CREATE $U ".table($Bg).$va,"DROP $U ".table($Bg),($_POST["drop"]?substr(ME,0,-1):$C),lang(193),$E,lang(194),$a,$F);}}if(!$_POST&&$a!=""){$L=view($a);$L["name"]=$a;$L["materialized"]=($De!="VIEW");if(!$l)$l=error();}page_header(($a!=""?lang(32):lang(195)),$l,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(176),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$L["materialized"],lang(122)):""),'<p>';textarea("select",$L["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$a));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$ed=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$ig=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$L=$_POST;if($_POST&&!$l){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(196));elseif(in_array($L["INTERVAL_FIELD"],$ed)&&isset($ig[$L["STATUS"]])){$If="\nON SCHEDULE ".($L["INTERVAL_VALUE"]?"EVERY ".q($L["INTERVAL_VALUE"])." $L[INTERVAL_FIELD]".($L["STARTS"]?" STARTS ".q($L["STARTS"]):"").($L["ENDS"]?" ENDS ".q($L["ENDS"]):""):"AT ".q($L["STARTS"]))." ON COMPLETION".($L["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(197):lang(198)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$If.($aa!=$L["EVENT_NAME"]?"\nRENAME TO ".idf_escape($L["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($L["EVENT_NAME"]).$If)."\n".$ig[$L["STATUS"]]." COMMENT ".q($L["EVENT_COMMENT"]).rtrim(" DO\n$L[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(199).": ".h($aa):lang(200)),$l);if(!$L&&$aa!=""){$M=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$L=reset($M);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(176),'<td><input name="EVENT_NAME" value="',h($L["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(201),'<td><input name="STARTS" value="',h("$L[EXECUTE_AT]$L[STARTS]"),'">
<tr><th title="datetime">',lang(202),'<td><input name="ENDS" value="',h($L["ENDS"]),'">
<tr><th>',lang(203),'<td><input type="number" name="INTERVAL_VALUE" value="',h($L["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$ed,$L["INTERVAL_FIELD"]),'<tr><th>',lang(112),'<td>',html_select("STATUS",$ig,$L["STATUS"]),'<tr><th>',lang(39),'<td><input name="EVENT_COMMENT" value="',h($L["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$L["ON_COMPLETION"]=="PRESERVE",lang(204)),'</table>
<p>';textarea("EVENT_DEFINITION",$L["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$aa));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Ef=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$L=$_POST;$L["fields"]=(array)$L["fields"];if($_POST&&!process_fields($L["fields"])&&!$l){$Ae=routine($_GET["procedure"],$Ef);$Bg="$L[name]_adminer_".uniqid();drop_create("DROP $Ef ".routine_id($da,$Ae),create_routine($Ef,$L),"DROP $Ef ".routine_id($L["name"],$L),create_routine($Ef,array("name"=>$Bg)+$L),"DROP $Ef ".routine_id($Bg,$L),substr(ME,0,-1),lang(205),lang(206),lang(207),$da,$L["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(208):lang(209)).": ".h($da):(isset($_GET["function"])?lang(210):lang(211))),$l);if(!$_POST&&$da!=""){$L=routine($_GET["procedure"],$Ef);$L["name"]=$da;}$Ya=get_vals("SHOW CHARACTER SET");sort($Ya);$Ff=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(176),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',($Ff?lang(19).": ".html_select("language",$Ff,$L["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($L["fields"],$Ya,$Ef);if(isset($_GET["function"])){echo"<tr><td>".lang(212);edit_type("returns",$L["returns"],$Ya,array(),($z=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$L["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$da));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$F=$_GET["name"];$Vg=trigger_options();$L=(array)trigger($F)+array("Trigger"=>$a."_bi");if($_POST){if(!$l&&in_array($_POST["Timing"],$Vg["Timing"])&&in_array($_POST["Event"],$Vg["Event"])&&in_array($_POST["Type"],$Vg["Type"])){$oe=" ON ".table($a);$Lb="DROP TRIGGER ".idf_escape($F).($z=="pgsql"?$oe:"");$C=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Lb,$C,lang(213));else{if($F!="")queries($Lb);queries_redirect($C,($F!=""?lang(214):lang(215)),queries(create_trigger($oe,$_POST)));if($F!="")queries(create_trigger($oe,$L+array("Type"=>reset($Vg["Type"]))));}}$L=$_POST;}page_header(($F!=""?lang(216).": ".h($F):lang(217)),$l,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(218),'<td>',html_select("Timing",$Vg["Timing"],$L["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(219),'<td>',html_select("Event",$Vg["Event"],$L["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Vg["Event"])?" <input name='Of' value='".h($L["Of"])."' class='hidden'>":""),'<tr><th>',lang(38),'<td>',html_select("Type",$Vg["Type"],$L["Type"]),'</table>
<p>',lang(176),': <input name="Trigger" value="',h($L["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$L["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($F!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$F));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["user"])){$fa=$_GET["user"];$if=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$L){foreach(explode(",",($L["Privilege"]=="Grant option"?"":$L["Context"]))as$jb)$if[$jb][$L["Privilege"]]=$L["Comment"];}$if["Server Admin"]+=$if["File access on server"];$if["Databases"]["Create routine"]=$if["Procedures"]["Create routine"];unset($if["Procedures"]["Create routine"]);$if["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$if["Columns"][$X]=$if["Tables"][$X];unset($if["Server Admin"]["Usage"]);foreach($if["Tables"]as$_=>$X)unset($if["Databases"][$_]);$Zd=array();if($_POST){foreach($_POST["objects"]as$_=>$X)$Zd[$X]=(array)$Zd[$X]+(array)$_POST["grants"][$_];}$Gc=array();$me="";if(isset($_GET["host"])&&($J=$f->query("SHOW GRANTS FOR ".q($fa)."@".q($_GET["host"])))){while($L=$J->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$L[0],$D)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$D[1],$Hd,PREG_SET_ORDER)){foreach($Hd
as$X){if($X[1]!="USAGE")$Gc["$D[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$L[0]))$Gc["$D[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$L[0],$D))$me=$D[1];}}if($_POST&&!$l){$ne=(isset($_GET["host"])?q($fa)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $ne",ME."privileges=",lang(220));else{$be=q($_POST["user"])."@".q($_POST["host"]);$Qe=$_POST["pass"];if($Qe!=''&&!$_POST["hashed"]&&!min_version(8)){$Qe=$f->result("SELECT PASSWORD(".q($Qe).")");$l=!$Qe;}$nb=false;if(!$l){if($ne!=$be){$nb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $be IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Qe));$l=!$nb;}elseif($Qe!=$me)queries("SET PASSWORD FOR $be = ".q($Qe));}if(!$l){$Bf=array();foreach($Zd
as$he=>$s){if(isset($_GET["grant"]))$s=array_filter($s);$s=array_keys($s);if(isset($_GET["grant"]))$Bf=array_diff(array_keys(array_filter($Zd[$he],'strlen')),$s);elseif($ne==$be){$ke=array_keys((array)$Gc[$he]);$Bf=array_diff($ke,$s);$s=array_diff($s,$ke);unset($Gc[$he]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$he,$D)&&(!grant("REVOKE",$Bf,$D[2]," ON $D[1] FROM $be")||!grant("GRANT",$s,$D[2]," ON $D[1] TO $be"))){$l=true;break;}}}if(!$l&&isset($_GET["host"])){if($ne!=$be)queries("DROP USER $ne");elseif(!isset($_GET["grant"])){foreach($Gc
as$he=>$Bf){if(preg_match('~^(.+)(\(.*\))?$~U',$he,$D))grant("REVOKE",array_keys($Bf),$D[2]," ON $D[1] FROM $be");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(221):lang(222)),!$l);if($nb)$f->query("DROP USER $be");}}page_header((isset($_GET["host"])?lang(24).": ".h("$fa@$_GET[host]"):lang(139)),$l,array("privileges"=>array('',lang(60))));if($_POST){$L=$_POST;$Gc=$Zd;}else{$L=$_GET+array("host"=>$f->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$L["pass"]=$me;if($me!="")$L["hashed"]=true;$Gc[(DB==""||$Gc?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(23),'<td><input name="host" data-maxlength="60" value="',h($L["host"]),'" autocapitalize="off">
<tr><th>',lang(24),'<td><input name="user" data-maxlength="80" value="',h($L["user"]),'" autocapitalize="off">
<tr><th>',lang(25),'<td><input name="pass" id="pass" value="',h($L["pass"]),'" autocomplete="new-password">
';if(!$L["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$L["hashed"],lang(223),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(60).doc_link(array('sql'=>"grant.html#priv_level"));$u=0;foreach($Gc
as$he=>$s){echo'<th>'.($he!="*.*"?"<input name='objects[$u]' value='".h($he)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$u]' value='*.*' size='10'>*.*");$u++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(23),"Databases"=>lang(26),"Tables"=>lang(124),"Columns"=>lang(37),"Procedures"=>lang(224),)as$jb=>$Db){foreach((array)$if[$jb]as$hf=>$cb){echo"<tr".odd()."><td".($Db?">$Db<td":" colspan='2'").' lang="en" title="'.h($cb).'">'.h($hf);$u=0;foreach($Gc
as$he=>$s){$F="'grants[$u][".h(strtoupper($hf))."]'";$Y=$s[strtoupper($hf)];if($jb=="Server Admin"&&$he!=(isset($Gc["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$F><option><option value='1'".($Y?" selected":"").">".lang(225)."<option value='0'".($Y=="0"?" selected":"").">".lang(226)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$F value='1'".($Y?" checked":"").($hf=="All privileges"?" id='grants-$u-all'>":">".($hf=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$u-all'); };"))),"</label>";}$u++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,"$fa@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")&&$_POST&&!$l){$pd=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$pd++;}queries_redirect(ME."processlist=",lang(227,$pd),$pd||!$_POST["kill"]);}page_header(lang(110),$l);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$u=-1;foreach(process_list()as$u=>$L){if(!$u){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($L
as$_=>$X)echo"<th>$_".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($_),));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$L[$z=="sql"?"Id":"pid"],0):"");foreach($L
as$_=>$X)echo"<td>".(($z=="sql"&&$_=="Info"&&preg_match("~Query|Killed~",$L["Command"])&&$X!="")||($z=="pgsql"&&$_=="current_query"&&$X!="<IDLE>")||($z=="oracle"&&$_=="sql_text"&&$X!="")?"<code class='jush-$z'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($L["db"]!=""?"db=".urlencode($L["db"])."&":"")."sql=".urlencode($X)).'">'.lang(228).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($u+1)."/".lang(229,max_connections()),"<p><input type='submit' value='".lang(230)."'>\n";}echo'<input type="hidden" name="token" value="',$T,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$y=indexes($a);$n=fields($a);$p=column_foreign_keys($a);$je=$R["Oid"];parse_str($_COOKIE["adminer_import"],$na);$Cf=array();$d=array();$Eg=null;foreach($n
as$_=>$m){$F=$b->fieldName($m);if(isset($m["privileges"]["select"])&&$F!=""){$d[$_]=html_entity_decode(strip_tags($F),ENT_QUOTES);if(is_shortable($m))$Eg=$b->selectLengthProcess();}$Cf+=$m["privileges"];}list($N,$t)=$b->selectColumnsProcess($d,$y);$id=count($t)<count($N);$Z=$b->selectSearchProcess($n,$y);$xe=$b->selectOrderProcess($n,$y);$A=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$dh=>$L){$va=convert_field($n[key($L)]);$N=array($va?$va:idf_escape(key($L)));$Z[]=where_check($dh,$n);$K=$k->select($a,$N,$Z,$N);if($K)echo
reset($K->fetch_row());}exit;}$ef=$fh=null;foreach($y
as$x){if($x["type"]=="PRIMARY"){$ef=array_flip($x["columns"]);$fh=($N?$ef:array());foreach($fh
as$_=>$X){if(in_array(idf_escape($_),$N))unset($fh[$_]);}break;}}if($je&&!$ef){$ef=$fh=array($je=>0);$y[]=array("type"=>"PRIMARY","columns"=>array($je));}if($_POST&&!$l){$Ah=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Pa=array();foreach($_POST["check"]as$Na)$Pa[]=where_check($Na,$n);$Ah[]="((".implode(") OR (",$Pa)."))";}$Ah=($Ah?"\nWHERE ".implode(" AND ",$Ah):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$Ec=($N?implode(", ",$N):"*").convert_fields($d,$n,$N)."\nFROM ".table($a);$Ic=($t&&$id?"\nGROUP BY ".implode(", ",$t):"").($xe?"\nORDER BY ".implode(", ",$xe):"");if(!is_array($_POST["check"])||$ef)$I="SELECT $Ec$Ah$Ic";else{$bh=array();foreach($_POST["check"]as$X)$bh[]="(SELECT".limit($Ec,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n).$Ic,1).")";$I=implode(" UNION ALL ",$bh);}$b->dumpData($a,"table",$I);exit;}if(!$b->selectEmailProcess($Z,$p)){if($_POST["save"]||$_POST["delete"]){$J=true;$oa=0;$P=array();if(!$_POST["delete"]){foreach($d
as$F=>$X){$X=process_input($n[$F]);if($X!==null&&($_POST["clone"]||$X!==false))$P[idf_escape($F)]=($X!==false?$X:idf_escape($F));}}if($_POST["delete"]||$P){if($_POST["clone"])$I="INTO ".table($a)." (".implode(", ",array_keys($P)).")\nSELECT ".implode(", ",$P)."\nFROM ".table($a);if($_POST["all"]||($ef&&is_array($_POST["check"]))||$id){$J=($_POST["delete"]?$k->delete($a,$Ah):($_POST["clone"]?queries("INSERT $I$Ah"):$k->update($a,$P,$Ah)));$oa=$f->affected_rows;}else{foreach((array)$_POST["check"]as$X){$_h="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n);$J=($_POST["delete"]?$k->delete($a,$_h,1):($_POST["clone"]?queries("INSERT".limit1($a,$I,$_h)):$k->update($a,$P,$_h,1)));if(!$J)break;$oa+=$f->affected_rows;}}}$E=lang(231,$oa);if($_POST["clone"]&&$J&&$oa==1){$vd=last_id();if($vd)$E=lang(161," $vd");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$E,$J);if(!$_POST["delete"]){edit_form($a,$n,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$l=lang(232);else{$J=true;$oa=0;foreach($_POST["val"]as$dh=>$L){$P=array();foreach($L
as$_=>$X){$_=bracket_escape($_,1);$P[idf_escape($_)]=(preg_match('~char|text~',$n[$_]["type"])||$X!=""?$b->processInput($n[$_],$X):"NULL");}$J=$k->update($a,$P," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($dh,$n),!$id&&!$ef," ");if(!$J)break;$oa+=$f->affected_rows;}queries_redirect(remove_from_uri(),lang(231,$oa),$J);}}elseif(!is_string($uc=get_file("csv_file",true)))$l=upload_error($uc);elseif(!preg_match('~~u',$uc))$l=lang(233);else{cookie("adminer_import","output=".urlencode($na["output"])."&format=".urlencode($_POST["separator"]));$J=true;$Za=array_keys($n);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$uc,$Hd);$oa=count($Hd[0]);$k->begin();$Qf=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$M=array();foreach($Hd[0]as$_=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Qf]*)$Qf~",$X.$Qf,$Id);if(!$_&&!array_diff($Id[1],$Za)){$Za=$Id[1];$oa--;}else{$P=array();foreach($Id[1]as$u=>$Va)$P[idf_escape($Za[$u])]=($Va==""&&$n[$Za[$u]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$Va))));$M[]=$P;}}$J=(!$M||$k->insertUpdate($a,$M,$ef));if($J)$J=$k->commit();queries_redirect(remove_from_uri("page"),lang(234,$oa),$J);$k->rollback();}}}$tg=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(42).": $tg",$l);$P=null;if(isset($Cf["insert"])||!support("table")){$P="";foreach((array)$_GET["where"]as$X){if($p[$X["col"]]&&count($p[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$P.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($R,$P);if(!$d&&support("table"))echo"<p class='error'>".lang(235).($n?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($N,$d);$b->selectSearchPrint($Z,$d,$y);$b->selectOrderPrint($xe,$d,$y);$b->selectLimitPrint($A);$b->selectLengthPrint($Eg);$b->selectActionPrint($y);echo"</form>\n";$G=$_GET["page"];if($G=="last"){$Dc=$f->result(count_rows($a,$Z,$id,$t));$G=floor(max(0,$Dc-1)/$A);}$Lf=$N;$Hc=$t;if(!$Lf){$Lf[]="*";$kb=convert_fields($d,$n,$N);if($kb)$Lf[]=substr($kb,2);}foreach($N
as$_=>$X){$m=$n[idf_unescape($X)];if($m&&($va=convert_field($m)))$Lf[$_]="$va AS $X";}if(!$id&&$fh){foreach($fh
as$_=>$X){$Lf[]=idf_escape($_);if($Hc)$Hc[]=idf_escape($_);}}$J=$k->select($a,$Lf,$Z,$Hc,$xe,$A,$G,true);if(!$J)echo"<p class='error'>".error()."\n";else{if($z=="mssql"&&$G)$J->seek($A*$G);$Xb=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$M=array();while($L=$J->fetch_assoc()){if($G&&$z=="oracle")unset($L["RNUM"]);$M[]=$L;}if($_GET["page"]!="last"&&$A!=""&&$t&&$id&&$z=="sql")$Dc=$f->result(" SELECT FOUND_ROWS()");if(!$M)echo"<p class='message'>".lang(12)."\n";else{$Ca=$b->backwardKeys($a,$tg);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$t&&$N?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(236)."</a>");$Yd=array();$Fc=array();reset($N);$qf=1;foreach($M[0]as$_=>$X){if(!isset($fh[$_])){$X=$_GET["columns"][key($N)];$m=$n[$N?($X?$X["col"]:current($N)):$_];$F=($m?$b->fieldName($m,$qf):($X["fun"]?"*":$_));if($F!=""){$qf++;$Yd[$_]=$F;$c=idf_escape($_);$Uc=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($_);$Db="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($_))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Uc.($xe[0]==$c||$xe[0]==$_||(!$xe&&$id&&$t[0]==$c)?$Db:'')).'">';echo
apply_sql_function($X["fun"],$F)."</a>";echo"<span class='column hidden'>","<a href='".h($Uc.$Db)."' title='".lang(48)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(45).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($_)."');");}echo"</span>";}$Fc[$_]=$X["fun"];next($N);}}$Ad=array();if($_GET["modify"]){foreach($M
as$L){foreach($L
as$_=>$X)$Ad[$_]=max($Ad[$_],min(40,strlen(utf8_decode($X))));}}echo($Ca?"<th>".lang(237):"")."</thead>\n";if(is_ajax()){if($A%2==1&&$G%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($M,$p)as$Xd=>$L){$ch=unique_array($M[$Xd],$y);if(!$ch){$ch=array();foreach($M[$Xd]as$_=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$_))$ch[$_]=$X;}}$dh="";foreach($ch
as$_=>$X){if(($z=="sql"||$z=="pgsql")&&preg_match('~char|text|enum|set~',$n[$_]["type"])&&strlen($X)>64){$_=(strpos($_,'(')?$_:idf_escape($_));$_="MD5(".($z!='sql'||preg_match("~^utf8~",$n[$_]["collation"])?$_:"CONVERT($_ USING ".charset($f).")").")";$X=md5($X);}$dh.="&".($X!==null?urlencode("where[".bracket_escape($_)."]")."=".urlencode($X):"null%5B%5D=".urlencode($_));}echo"<tr".odd().">".(!$t&&$N?"":"<td>".checkbox("check[]",substr($dh,1),in_array(substr($dh,1),(array)$_POST["check"])).($id||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$dh)."' class='edit'>".lang(238)."</a>"));foreach($L
as$_=>$X){if(isset($Yd[$_])){$m=$n[$_];$X=$k->value($X,$m);if($X!=""&&(!isset($Xb[$_])||$Xb[$_]!=""))$Xb[$_]=(is_mail($X)?$Yd[$_]:"");$B="";if(preg_match('~blob|bytea|raw|file~',$m["type"])&&$X!="")$B=ME.'download='.urlencode($a).'&field='.urlencode($_).$dh;if(!$B&&$X!==null){foreach((array)$p[$_]as$o){if(count($p[$_])==1||end($o["source"])==$_){$B="";foreach($o["source"]as$u=>$ag)$B.=where_link($u,$o["target"][$u],$M[$Xd][$ag]);$B=($o["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($o["db"]),ME):ME).'select='.urlencode($o["table"]).$B;if($o["ns"])$B=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($o["ns"]),$B);if(count($o["source"])==1)break;}}}if($_=="COUNT(*)"){$B=ME."select=".urlencode($a);$u=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$ch))$B.=where_link($u++,$W["col"],$W["val"],$W["op"]);}foreach($ch
as$md=>$W)$B.=where_link($u++,$md,$W);}$X=select_value($X,$B,$m,$Eg);$v=h("val[$dh][".bracket_escape($_)."]");$Y=$_POST["val"][$dh][bracket_escape($_)];$Sb=!is_array($L[$_])&&is_utf8($X)&&$M[$Xd][$_]==$L[$_]&&!$Fc[$_];$Dg=preg_match('~text|lob~',$m["type"]);echo"<td id='$v'";if(($_GET["modify"]&&$Sb)||$Y!==null){$Lc=h($Y!==null?$Y:$L[$_]);echo">".($Dg?"<textarea name='$v' cols='30' rows='".(substr_count($L[$_],"\n")+1)."'>$Lc</textarea>":"<input name='$v' value='$Lc' size='$Ad[$_]'>");}else{$Ed=strpos($X,"<i>…</i>");echo" data-text='".($Ed?2:($Dg?1:0))."'".($Sb?"":" data-warning='".h(lang(239))."'").">$X</td>";}}}if($Ca)echo"<td>";$b->backwardKeysPrint($Ca,$M[$Xd]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($M||$G){$ic=true;if($_GET["page"]!="last"){if($A==""||(count($M)<$A&&($M||!$G)))$Dc=($G?$G*$A:0)+count($M);elseif($z!="sql"||!$id){$Dc=($id?false:found_rows($R,$Z));if($Dc<max(1e4,2*($G+1)*$A))$Dc=reset(slow_query(count_rows($a,$Z,$id,$t)));else$ic=false;}}$Ie=($A!=""&&($Dc===false||$Dc>$A||$G));if($Ie){echo(($Dc===false?count($M)+1:$Dc-$G*$A)>$A?'<p><a href="'.h(remove_from_uri("page")."&page=".($G+1)).'" class="loadmore">'.lang(240).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$A).", '".lang(241)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($M||$G){if($Ie){$Kd=($Dc===false?$G+(count($M)>=$A?2:1):floor(($Dc-1)/$A));echo"<fieldset>";if($z!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(242)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(242)."', '".($G+1)."')); return false; };"),pagination(0,$G).($G>5?" …":"");for($u=max(1,$G-4);$u<min($Kd,$G+5);$u++)echo
pagination($u,$G);if($Kd>0){echo($G+5<$Kd?" …":""),($ic&&$Dc!==false?pagination($Kd,$G):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Kd'>".lang(243)."</a>");}}else{echo"<legend>".lang(242)."</legend>",pagination(0,$G).($G>1?" …":""),($G?pagination($G,$G):""),($Kd>$G?pagination($G+1,$G).($Kd>$G+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(244)."</legend>";$Ib=($ic?"":"~ ").$Dc;echo
checkbox("all",1,0,($Dc!==false?($ic?"":"~ ").lang(143,$Dc):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Ib' : checked); selectCount('selected2', this.checked || !checked ? '$Ib' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(236),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(232).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(120),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(228),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$Bc=$b->dumpFormat();foreach((array)$_GET["columns"]as$c){if($c["fun"]){unset($Bc['sql']);break;}}if($Bc){print_fieldset("export",lang(62)." <span id='selected2'></span>");$Ge=$b->dumpOutput();echo($Ge?html_select("output",$Ge,$na["output"])." ":""),html_select("format",$Bc,$na["format"])," <input type='submit' name='export' value='".lang(62)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($Xb,'strlen'),$d);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(61)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$na["format"],1);echo" <input type='submit' name='import' value='".lang(61)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$T'>\n","</form>\n",(!$t&&$N?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$hg=isset($_GET["status"]);page_header($hg?lang(112):lang(111));$rh=($hg?show_status():show_variables());if(!$rh)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($rh
as$_=>$X){echo"<tr>","<th><code class='jush-".$z.($hg?"status":"set")."'>".h($_)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$qg=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$F=>$R){json_row("Comment-$F",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$_)json_row("$_-$F",h($R[$_]));foreach($qg+array("Auto_increment"=>0,"Rows"=>0)as$_=>$X){if($R[$_]!=""){$X=format_number($R[$_]);json_row("$_-$F",($_=="Rows"&&$X&&$R["Engine"]==($cg=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($qg[$_]))$qg[$_]+=($R["Engine"]!="InnoDB"||$_!="Data_free"?$R[$_]:0);}elseif(array_key_exists($_,$R))json_row("$_-$F");}}}foreach($qg
as$_=>$X)json_row("sum-$_",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$f->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$j=>$X){json_row("tables-$j",$X);json_row("size-$j",db_size($j));}json_row("");}exit;}else{$yg=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($yg&&!$l&&!$_POST["search"]){$J=true;$E="";if($z=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$J=truncate_tables($_POST["tables"]);$E=lang(245);}elseif($_POST["move"]){$J=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$E=lang(246);}elseif($_POST["copy"]){$J=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$E=lang(247);}elseif($_POST["drop"]){if($_POST["views"])$J=drop_views($_POST["views"]);if($J&&$_POST["tables"])$J=drop_tables($_POST["tables"]);$E=lang(248);}elseif($z!="sql"){$J=($z=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$E=lang(249);}elseif(!$_POST["tables"])$E=lang(9);elseif($J=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($L=$J->fetch_assoc())$E.="<b>".h($L["Table"])."</b>: ".h($L["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$E,$J);}page_header(($_GET["ns"]==""?lang(26).": ".h(DB):lang(189).": ".h($_GET["ns"])),$l,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(250)."</h3>\n";$xg=tables_list();if(!$xg)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(251)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(45)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]="LIKE %%";search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(124),'<td>'.lang(252).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(116).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(253).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(254).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(255).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(40).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(256).doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.lang(39).doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$S=0;foreach($xg
as$F=>$U){$uh=($U!==null&&!preg_match('~table~i',$U));$v=h("Table-".$F);echo'<tr'.odd().'><td>'.checkbox(($uh?"views[]":"tables[]"),$F,in_array($F,$yg,true),"","","",$v),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($F)."' title='".lang(31)."' id='$v'>".h($F).'</a>':h($F));if($uh){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($F).'" title="'.lang(32).'">'.(preg_match('~materialized~i',$U)?lang(122):lang(123)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($F).'" title="'.lang(30).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(33)),"Index_length"=>array("indexes",lang(126)),"Data_free"=>array("edit",lang(34)),"Auto_increment"=>array("auto_increment=1&create",lang(33)),"Rows"=>array("select",lang(30)),)as$_=>$B){$v=" id='$_-".h($F)."'";echo($B?"<td align='right'>".(support("table")||$_=="Rows"||(support("indexes")&&$_!="Data_length")?"<a href='".h(ME."$B[0]=").urlencode($F)."'$v title='$B[1]'>?</a>":"<span$v>?</span>"):"<td id='$_-".h($F)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($F)."'>":"");}echo"<tr><td><th>".lang(229,count($xg)),"<td>".h($z=="sql"?$f->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$_)echo"<td align='right' id='sum-$_'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$ph="<input type='submit' value='".lang(257)."'> ".on_help("'VACUUM'");$ue="<input type='submit' name='optimize' value='".lang(258)."'> ".on_help($z=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(120)." <span id='selected'></span></legend><div>".($z=="sqlite"?$ph:($z=="pgsql"?$ph.$ue:($z=="sql"?"<input type='submit' value='".lang(259)."'> ".on_help("'ANALYZE TABLE'").$ue."<input type='submit' name='check' value='".lang(260)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(261)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(262)."'> ".on_help($z=="sqlite"?"'DELETE'":"'TRUNCATE".($z=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(121)."'>".on_help("'DROP TABLE'").confirm()."\n";$i=(support("scheme")?$b->schemas():$b->databases());if(count($i)!=1&&$z!="sqlite"){$j=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(263).": ",($i?html_select("target",$i,$j):'<input name="target" value="'.h($j).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(264)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(265)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(266)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$T'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo'<p class="links"><a href="'.h(ME).'create=">'.lang(63)."</a>\n",(support("view")?'<a href="'.h(ME).'view=">'.lang(195)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(136)."</h3>\n";$Gf=routines();if($Gf){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(176).'<td>'.lang(38).'<td>'.lang(212)."<td></thead>\n";odd('');foreach($Gf
as$L){$F=($L["SPECIFIC_NAME"]==$L["ROUTINE_NAME"]?"":"&name=".urlencode($L["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($L["SPECIFIC_NAME"]).$F).'">'.h($L["ROUTINE_NAME"]).'</a>','<td>'.h($L["ROUTINE_TYPE"]),'<td>'.h($L["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($L["SPECIFIC_NAME"]).$F).'">'.lang(129)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(211).'</a>':'').'<a href="'.h(ME).'function=">'.lang(210)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(137)."</h3>\n";$M=get_rows("SHOW EVENTS");if($M){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(176)."<td>".lang(267)."<td>".lang(201)."<td>".lang(202)."<td></thead>\n";foreach($M
as$L){echo"<tr>","<th>".h($L["Name"]),"<td>".($L["Execute at"]?lang(268)."<td>".$L["Execute at"]:lang(203)." ".$L["Interval value"]." ".$L["Interval field"]."<td>$L[Starts]"),"<td>$L[Ends]",'<td><a href="'.h(ME).'event='.urlencode($L["Name"]).'">'.lang(129).'</a>';}echo"</table>\n";$gc=$f->result("SELECT @@event_scheduler");if($gc&&$gc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($gc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(200)."</a>\n";}if($xg)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();