<h3>Hooks</h3>
<p>This module uses Events and Hooks to tie in external functionality.  The following hooks are available:</p>
<ul>
   <li><code>MAMSRegistration::beforeNewUser</code> - Called before a new temporary user is created in the database.
       <p>This hook is called from the registration form processing, after validating all user information, but before adding the temporary user information.  It can be used to perform further validations on the registration information.</p>
       <p>Handlers that are using this hook can throw the <code>MAMSREGValidationError</code> Exception in the event of an error.</p>
       <p>Parameters: - The hook handler should accept a single array parameter.  The contents of this parameter are an associative array as follows:</p>
       <ul>
          <li><code>username</code>: string</li>
          <li><code>email</code>: string</li>
          <li><code>password</code>: string - The plain text user password</li>
       </ul>
       <p>Example:</p>
<pre><code>\CMSMS\HookManager::add_hook( 'MAMSRegistration::beforeNewUser', function( $params ) {
    if( strlen( $params['password'] ) &lt; 4 ) throw new \MAMSREGValidationError('Your password is too short');
});</code></pre>
   </li>

   <li><code>MAMSRegistration::onNewUser</code> - Triggered when a new temporary user is created in MAMSRegistration.
       <p>This hook is called after the MAMSRegistration temporary user is created in the database, but before verification, or adding to MAMS etc.</p>
       <p>Parameters: - The hook handler should accept a single array parameter.  The contents of this parameter are an associative array as follows:</p>
       <ul>
          <li><code>username</code> : string</li>
          <li><code>email</code> : string</li>
       </ul>
   </li>

   <li><code>MAMSRegistration::onUserRegistered</code> - Triggered after a temporary user account has been converted into an MAMS user account.
       <p>Parameters: - The hook handler should accept a single array parameter.  The contents of this parameter are an associative array as follows:</p>
       <ul>
          <li><code>id</code> : int - The MAMS uid of the newly created user.</li>
          <li><code>username</code> : string</li>
       </ul>
   </li>

</ul>