<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: MAMSRegistration (c) 2020-2021 by CMS Made Simple Foundation
# An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: SelfRegistration (c) 2008-2013 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

if(version_compare(phpversion(), '5.4.11') < 0)
{
  return 'Minimum PHP version of 5.4.11 required';
}

$modname      = strtolower($this->GetName());
$table_prefix = cms_db_prefix() . 'module_' . $modname;

$dict        = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');

// validations in process
$flds     = '
         id I KEY,
         group_id I NOTNULL,
         username C(80) NOTNULL,
         password C(255) NOTNULL,
         code C(20) NOTNULL,
         createdate ' . CMS_ADODB_DT . ',
         overwrite_uid I';

$sqlarray = $dict->CreateTableSQL($table_prefix . '_users', $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$db->CreateSequence($table_prefix . '_users_seq');

$flds     = 'user I KEY NOTNULL,
         gid  I KEY NOTNULL';

$sqlarray = $dict->CreateTableSQL($table_prefix . '_grps', $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds     = 'id I KEY,
         user I NOTNULL,
         title C(100) NOTNULL,
         data X
        ';

$sqlarray = $dict->CreateTableSQL($table_prefix . '_properties', $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$db->CreateSequence($table_prefix . '_properties_seq');

$flds     = 'id I AUTO KEY,
         name C(255) NOTNULL,
         prompt C(255) NOTNULL,
         description X,
         gid I NOTNULL,
         subscr_num I,
         subscr_type C(10),
         cost F';

$sqlarray = $dict->CreateTableSQL($table_prefix . '_paidpkgs', $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// preferences
$this->SetPreference('require_email_confirmation', 1);
$this->SetPreference('send_emails_to', 'root@localhost.com');
$this->SetPreference('notify_on_registration', 1);
$this->SetPreference('mamsreg_emailconfirm_subject', $this->Lang('registration_confirmation'));
$this->SetPreference('mamsreg_emailuseredited_subject', $this->Lang('registration_info_edited'));
$this->SetPreference('mamsreg_force_email_twice', 0);

// templates
$this->SetTemplate('selpkgtemplate', @file_get_contents(__DIR__ . '/templates/orig_selpkg_template.tpl'));

$this->SetTemplate('mamsreg_reg1template', file_get_contents(__DIR__ . '/templates/orig_registration1.tpl'));
$this->SetTemplate('mamsreg_postreg1_template', file_get_contents(__DIR__ . '/templates/orig_postreg1.tpl'));
$this->SetTemplate('mamsreg_reg2template', file_get_contents(__DIR__ . '/templates/orig_registration2.tpl'));
$this->SetTemplate('mamsreg_emailconfirm_template', $this->dflt_emailconfirm_template);
$this->SetTemplate('mamsreg_emailuseredited_template', $this->dflt_emailuseredited_template);
$this->SetTemplate('mamsreg_emailuseredited_texttemplate', $this->dflt_emailuseredited_texttemplate);
$this->SetTemplate('mamsreg_finalmessage_template', $this->dflt_finalmessage_template);
$this->SetTemplate(
  'mamsreg_sendanotheremail_template', file_get_contents(__DIR__ . '/templates/orig_sendanotheremail_form.tpl')
);
$this->SetTemplate('mamsreg_post_sendanotheremail_template', $this->dflt_post_sendanotheremail_template);
$this->SetTemplate('anothergroup_template', @file_get_contents(__DIR__ . '/templates/orig_anothergroup_template.tpl'));

// Permissions
$this->CreatePermission('Manage Registering Users', 'Manage Registering Users');

// events
$this->CreateEvent('beforeNewUser');
$this->CreateEvent('onNewUser');
$this->CreateEvent('onUserRegistered');

//$this->AddEventHandler('CGEcommerceBase', 'CartAdjusted', FALSE);
//$this->AddEventHandler('CGEcommerceBase', 'OrderCreated', FALSE);
//$this->AddEventHandler('CGEcommerceBase', 'OrderUpdated', FALSE);
//$this->AddEventHandler('CGEcommerceBase', 'OrderDeleted', FALSE);

$this->AddEventHandler('Core', 'ModuleInstalled', FALSE);
$this->AddEventHandler('Core', 'ModuleUninstalled', FALSE);

//$mams     = \cms_utils::get_module('MAMS');
//$attribs = serialize(array('module' => $this->GetName()));
//$mams->AddPropertyDefn(MAMSRegistration::MAMS_PROPNAME, '', MAMS::FIELDTYPE_DATA, 1024, 0, $attribs);

$tpl = file_get_contents(__DIR__ . '/templates/admin_notify_email.tpl');
$this->SetTemplate('admin_notify_email', $tpl);

?>
