<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: MAMSRegistration (c) 2020-2021 by CMS Made Simple Foundation
# An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: SelfRegistration (c) 2008-2013 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
//namespace MAMSRegistration;
final class reg_utils
{
    private function __construct() {}

    public static function clean_params($params)
    {
        $nparams = array();
        if( isset($params['mr_data']) ) {
            $tmp = unserialize(base64_decode($params['mr_data']));
            unset($params['mr_data']);
            $params = array_merge($tmp,$params);
        }
        foreach( $params as $key => $value ) {
            if( startswith( $key, 'mr_' ) ) $key = substr($key,3);
            $nparams[$key] = $value;
        }
        return $nparams;
    }

    public static function pkg_subscr_to_expirydate($pkg,$time = '')
    {
        if( !$time ) $time = time();
        $expires = '';
        if( !is_array($pkg) ) return $expires;
        if( !isset($pkg['subscr_num']) || !isset($pkg['subscr_type']) ) return $expires;

        $type = $pkg['subscr_type'];
        switch( $type ) {
        case 'month':
        case 'year':
            $type .= 's';
            $expires = strtotime("+{$pkg['subscr_num']} {$type}",$time);
            break;

        case 'none':
        default:
            $mams = xt_utils::get_module(MOD_MAMS);
            if( $mams ) {
                $timeperiod = max(1,$mams->GetPreference('expireage_months',520));
                $expires = strtotime("+{$timeperiod} months",$time);
            }
            break;
        }

        return $expires;
    }
  
  public static function expand_group($val)
  {
    // yep, all the modules are here, now we convert a single name to an integer id
    // or an array of integer ids... then we validate them.
    $grpids = NULL;
    if(is_string($val))
    {
      $val = explode(',', $val);
    }
    if(!is_array($val) || !count($val))
    {
      return;
    }
    
    $mams = cms_utils::get_module(MOD_MAMS);
    foreach($val as $one)
    {
      if(is_numeric($one) && (int)$one > 0)
      {
        $grpids[] = $one;
      }
      else
      {
        $tmp = $mams->GetGroupID(trim($one));
        if($tmp > 0)
        {
          $grpids[] = $tmp;
        }
      }
    }
    if($grpids)
    {
      $grpids = array_unique($grpids);
    }
    if(count($grpids))
    {
      return $grpids;
    }
  }

    public static function get_verifypage( $returnid = null )
    {
        $mod = \cms_utils::get_module('SelfRegistration');
        $pref_page = (int) $mod->GetPreference('verifypage');
        if( $pref_page > 0 ) return $pref_page;

        if( $returnid > 0 ) return $returnid;

        $contentops = \ContentOperations::get_instance();
        return (int) $contentops->GetDefaultContent();
    }

} // class

#
# EOF
#
