<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SelfRegistration (c) 2008 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow users to register themselves
#  with a website.
#
# Version: 1.1.5
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This projects homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if(!defined('CMS_VERSION'))
{
  exit;
}

$mams = $this->GetModuleInstance(MOD_MAMS);
if(!$mams)
{
  $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('error_nofeusersmodule'));
  
  return;
}

$tplname = \xt_param::get_string($params, 'verifytemplate');
if($tplname)
{
  $tplname = '::' . $tplname;
}
else
{
  $tplname = 'mamsreg_reg2template';
}
$tpl       = $this->CreateSmartyTemplate($tplname);
$nocaptcha = \xt_param::get_bool($params, 'nocaptcha', 0);
$captcha   = $this->GetModuleInstance('Captcha');
if(isset($params['error']))
{
  $tpl->assign('error', $params['error']);
}
if(isset($params['message']))
{
  $tpl->assign('message', $params['message']);
}

$params         = reg_utils::clean_params($params);
$username       = trim(\xt_param::get_string($params, 'input_username'));
$username       = trim(\xt_param::get_string($params, 'username', $username));
$password       = trim(\xt_param::get_string($params, 'input_password'));
$password       = trim(\xt_param::get_string($params, 'password', $password));
$code           = trim(\xt_param::get_string($params, 'input_code'));
$noinline       = \xt_param::get_int($params, 'noinline', 0);
$nofinalmessage = (int)$this->GetPreference('mamsreg_skip_final_msg');

$nofinalmessage = \xt_param::get_int($params, 'nofinalmessage', $nofinalmessage);

if(isset($params['final']))
{
  $tpl = $this->CreateSmartyTemplate('mamsreg_finalmessage_template');
  $tpl->assign('username', $username);
  $tpl->assign('is_logged_in', (bool) $this->GetPreference('login_afterverify'));
  $tpl->display();
  
  return;
}
else if(isset($params['submit']))
{
  try
  {
    if(!$username)
    {
      if($mams->GetPreference('username_is_email'))
      {
        throw new \RuntimeException($this->Lang('error_missingemail'));
      }
      else
      {
        throw new \RuntimeException($this->Lang('error_missingusername'));
      }
    }
    
    if(!$password)
    {
      throw new \RuntimeException($this->Lang('error_missingpassword'));
    }
    if(!$code)
    {
      throw new \RuntimeException($this->Lang('error_missingcode'));
    }
    
    // get and verify user details.
    $t_uid = $this->GetTempUserID($username);
    if(!$t_uid)
    {
      throw new \RuntimeException($this->Lang('error_usernotfound'));
    }
    
    $t_details = $this->GetTempUserDetails($t_uid);
    if(!$t_details)
    {
      throw new \RuntimeException($this->Lang('error_usernotfound'));
    }
    if($code != $t_details['code'])
    {
      throw new \RuntimeException($this->Lang('error_codesdontmatch'));
    }
  
//    if(!$nocaptcha)
//    {
//      $captcha = \cms_utils::get_module('Captcha');
//      if(is_object($captcha) && !$captcha->CheckCaptcha(\xt_param::get_string($params, 'input_captcha')))
//      {
//        throw new \RuntimeException($this->Lang('error_captchamismatch'));
//      }
//    }
    
    // and verify the password too
    $e_key = $this->get_encryption_key($username);
    $d_pw  = $this->decrypt($e_key, base64_decode($t_details['password']));
    if($d_pw != $password)
    {
      throw new \RuntimeException($this->Lang('error_incorrectpassword'));
    }
    
    // all good, now do the work
    if($this->GetPreference('autocreate_feu', 1))
    {
      $res = $this->_CreateFrontendUser($t_details['id'], $username, $password);
      
      if($res[0] === FALSE)
      {
        throw new RuntimeException($res[1]);
      }
      
      $mams_uid = $res[1];
      $this->DeleteTempUser($t_details['id']);
      audit('', $this->GetName(), $username . ' validated their account');
      
      // where are we going after this?
      $tpl2 = $smarty->CreateTemplate('string:' . $this->GetPreference('redirect_afterverify'));
      $tpl2->assign('uid', $mams_uid);
      $tpl2->assign('username', $username);
      $tmp = trim($tpl2->fetch());
      
      if($tmp)
      {
        $dest_page = $this->resolve_alias_or_id($tmp);
        if($dest_page)
        {
          $returnid = $dest_page;
        }
      }
    }
    else
    {
      # try but don't make a big fuss about it (JM)
      try
      {
        // user is verified, but is not auto created.  send admin an email.
        $this->_SendRegistrationNotification($username);
      }
      catch(\Exception $e)
      {
        \audit('', $this->GetName(), $e->GetMessage());
      }
    }
    
    // do we automatically log this user in?
    if($this->GetPreference('login_afterverify'))
    {
      $res = $mams->Login($username, $password);
      if(!$res[0])
      {
        throw new \RuntimeException($res[1]);
      }
    }
    
    if($nofinalmessage)
    {
      // redirect out
      $this->RedirectContent($returnid);
      
      return;
    }
    
    // redirect out of here to display the final message
    $parms                = [];
    $parms['mr_username'] = $username;
    $parms['mr_final']    = 1;
    $this->Redirect($id, 'verify', $returnid, $parms);
  }
  catch(\Exception $e)
  {
    $tpl->assign('error', 1);
    $tpl->assign('message', $e->GetMessage());
  }
}
$tpl->assign('unfldlen', $mams->GetPreference('usernamefldlength'));
$tpl->assign('maxunlen', $mams->GetPreference('max_usernamelength'));
$tpl->assign('pwfldlen', $mams->GetPreference('passwordfldlength'));
$tpl->assign('maxpwlen', $mams->GetPreference('max_passwordlength'));
$tpl->assign('username', $username);
$tpl->assign('password', $password);
$tpl->assign('code', $code);
if(is_object($captcha) && !$nocaptcha)
{
  $test = method_exists($captcha, 'NeedsInputField') ? $captcha->NeedsInputField() : TRUE;
  $tpl->assign('captcha_title', $this->Lang('captcha_title'));
  //$tpl->assign('captcha', $captcha->getCaptcha());
  //$tpl->assign('input_captcha', $this->CreateInputText($id, 'mr_input_captcha', '', 10));
  $tpl->assign('need_captcha_input', $test);
}

$inline = $this->GetPreference('inline_forms', TRUE);
if($noinline)
{
  $inline = FALSE;
}

$parms = [];
if(isset($params['noinline']))
{
  $parms['noinline'] = $params['noinline'];
}

if(isset($params['nofinalmessage']))
{
  $parms['nofinalmessage'] = $params['nofinalmessage'];
}

$tpl->assign('startform', $this->XTCreateFrontendFormStart($id, 'verify', $returnid, $parms, $inline));
$tpl->assign('endform', $this->CreateFormEnd());

$tpl->assign('title', $this->Lang('title_verifyregistration'));

if($mams->GetPreference('username_is_email'))
{
  $tpl->assign('prompt_username', $this->Lang('email'));
}
else
{
  $tpl->assign('prompt_username', $this->Lang('username'));
}

/* don't need this stuff any more, but keep it for a while, for backwards compat */
$tpl->assign(
  'input_username',
  $this->CreateInputText(
    $id, 'mr_input_username',
    $username,
    $mams->GetPreference('usernamefldlength'),
    $mams->GetPreference('max_usernamelength')
  )
);
$tpl->assign('prompt_password', $this->Lang('password'));
$tpl->assign(
  'input_password',
  $this->CreateInputPassword(
    $id, 'mr_input_password',
    $password,
    $mams->GetPreference('passwordfldlength'),
    $mams->GetPreference('max_passwordlength')
  )
);
$tpl->assign('prompt_code', $this->Lang('code'));
$tpl->assign('input_code', $this->CreateInputText($id, 'mr_input_code', $code, 30, 30));
$tpl->assign('submit', $this->CreateInputSubmit($id, 'mr_submit', $this->Lang('submit')));
$tpl->display();

#
# EOF
#?>