<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: MAMSRegistration (c) 2020-2021 by CMS Made Simple Foundation
# An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: SelfRegistration (c) 2008-2013 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) return;
if( !$this->GetPreference('allowselectpkg') ) throw new \CmsError403Exception('Permisson Denied');

// we're allowing the user to select his own package (group(s)).
if( \xt_param::exists($params,'mr_submit') && \xt_param::exists($params,'mr_selpkg') ) {
    try {
        $pkgids = array();
        if( is_array($params['mr_selpkg']) ) {
            $pkgids = $params['mr_selpkg'];
        }
        else {
            $pkgids = [ $params['mr_selpkg'] ];
        }
        $myfilter = function( array $list ) {
            $out = [];
            foreach( $list as $one ) {
                $one = (int) $one;
                if( $one > 0 && !in_array($one,$out) ) $out[] = $one;
            }
            if( count($out) ) return $out;
        };
        $pkgids = $myfilter( $pkgids );

        if( count($pkgids) > 1 && $this->GetPreference('allowselectpkg') < 2 ) {
            throw new \RuntimeException($this->Lang('error_multiplepkgs'));
        }

        $query = 'SELECT * FROM '.cms_db_prefix().'module_mamsregistration_paidpkgs WHERE id IN ('.implode(',',$pkgids).')';
        $pkgs = $db->GetArray($query);
        if( !is_array($pkgs) || count($pkgs) == 0 ) throw new \LogicException('Database error');

        $mams = $this->GetModuleInstance(MOD_MAMS);
        $gids = array_unique(xt_array::extract_field($pkgs,'gid'));
        $allgroups = $mams->GetGroupListFull();
        $allgroups = array_keys($allgroups);
        foreach( $gids as $gid ) {
            if( !in_array($gid,$allgroups) ) throw new \LogicException('Database error');
        }

        $parms = [ 'mr_group'=>$gids,'mr_pkg'=>$pkgids ];
        $parms = [ 'mr_data' => base64_encode( serialize( $parms ) ) ];
        $this->Redirect( $id, 'signup', $returnid, $parms );
    }
    catch( \Exception $e ) {
        echo $this->_DisplayErrorPage( $e->GetMessage() );
        return;
    }
}

// build the template
$query = 'SELECT * FROM '.cms_db_prefix().'module_mamsregistration_paidpkgs ORDER BY name';
$ppkgs = $db->GetArray($query);
if( !$ppkgs ) {
    $this->_DisplayErrorPage($id,$params,$returnid, $this->Lang('error_nopkgs'));
}

$pkgs = array();
for( $i = 0; $i < count($ppkgs); $i++ ) {
    $rec =& $ppkgs[$i];
    $pkgs[$rec['id']] = $rec['prompt'];
}


$tpl = $this->CreateSmartyTemplate('selpkgtemplate');
$mod = cms_utils::get_module('CGEcommerceBase');
$tpl->assign('currency_symbol','$');
$tpl->assign('currency_code','USD');
if( $mod ) {
    $tpl->assign('currency_symbol',\cg_ecomm::get_currency_symbol());
    $tpl->assign('currency_code',\cg_ecomm::get_currency_code());
}

$tpl->assign('error_msg',$this->session_get('reguser_error'));
$this->session_clear('reguser_error');
$tpl->assign('pkgs',$ppkgs);
$tpl->assign('pkglist',$pkgs);
$tpl->assign('formstart',$this->XTCreateFormStart($id,'selpkg',$returnid,$params));
$tpl->assign('formend',$this->CreateFormEnd());
if( $this->GetPreference('allowselectpkg') == 2 ) $tpl->assign('inputtype','checkbox');
$tpl->display();

#
# EOF
#
