<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SelfRegistration (c) 2008 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow users to register themselves
#  with a website.
#
# Version: 1.1.5
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This projects homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
use \MAMS\RRUtils as RRUtils;
//
// this file does all of the registration portions... assuming that all input data
// has already been validated.
//
$mams = \cms_utils::get_module(MOD_MAMS);

try
{
  $params = $this->session_get('signup');
  
  // check for required parameters
  // if( !isset( $params['group'] ) ) throw new \RuntimeException($this->Lang('error_insufficientparams'));
  //if( !isset( $params['pkg']) ) throw new \RuntimeException($this->Lang('error_insufficientparams'));
  
  // Get property definitions
  $grpids     = reg_utils::expand_group($params['group']);
  $defns      = $mams->GetPropertyDefns();
  $properties = [];
  
  {
    $tmp = [];
    foreach($grpids as $gid)
    {
      $grelns = $mams->GetGroupPropertyRelations($gid);
      $tmp    = RRUtils::array_merge_by_name_required($tmp, $grelns);
      uasort($tmp, 'xt_array::compare_elements_by_sortorder_key');
    }
    foreach($tmp as $one)
    {
      $properties[$one['name']] = $one;
    }
  }
  
  
    //
    // all validation is done
    // were ready to do work now.
    //
    $username = \xt_param::get_string($params,'input_username');
    $password = \xt_param::get_string($params,'input_password');
    $overwrite_uid = \xt_param::get_int($params,'overwrite_uid');
    $email = \xt_param::get_string($params,'use_email');

    // generate a unique code that the user can enter to double confirm his login.
    $code = substr(strtoupper(md5(__FILE__.microtime().$username)),0,20);

    // have to add the record to the database so that we know who this guy is when he comes back
    $return = $this->CreateTempUser( $grpids, $username, $password, $code, $overwrite_uid );
    if( $return[0] == false ) throw new \RuntimeException($return[1]);

    // and add his properties too
    $tmpuid = $return[1];
    foreach( $properties as $propname => $prop ) {
        // check if the value exists (it may be an optional field)
        if( !isset($params['input_'.$propname]) ) continue;

        $value = $params['input_'.$propname];
        $return = $this->AddTempUserProperty( $tmpuid, $propname, $params['input_'.$propname] );

        if( $return[0] == false ) throw new \RuntimeException($result[1]);
    }

    // send an event
    \CMSMS\HookManager::do_hook( 'MAMSRegistration::onNewUser', [ 'username'=>$username, 'email'=>$email ] );

    //
    // okay we're done creating temporary users
    //
    $redirect_pref = 'redirect_afterregister';
    $action = 'post_registeruser';
    $parms = array();
    $parms['mr_username'] = $username;
    $parms['mr_email'] = $email;
    $expires_months = (int) max(1,$mams->GetPreference('expireage_months',520));
    $expires = strtotime(sprintf("+ %d months",$expires_months));
    $docreatefeu = $this->GetPreference('autocreate_feu',1);

    if( $this->GetPreference('allowpaidregistration') ) {
        try {
            $pkg = $group_id = null;
            $pkgid = $params['pkg'];
            if( is_array($pkgid) ) {
                if( count($pkgid) > 1 ) throw new \RuntimeException($this->Lang('error_subscribe_multiple'));
                $pkgid = (int) $pkgid[0];
            }
            if( $pkgid ) {
                $group_id = $params['group'];
                if( is_array($group_id) ) $group_id = $group_id[0];
                $query = 'SELECT * FROM '.cms_db_prefix().'module_mamsregistration_paidpkgs WHERE gid = ? AND id = ?';
                $pkg = $db->GetRow($query,array($group_id,$pkgid));
                if( !is_array($pkg) ) throw new \LogicException('internal error: package '.$pkgid.' was not found for the specified group');
            }

            if( $pkg && $pkg['cost'] > 0 ) {
                // this package costs money.
                $expires = reg_utils::pkg_subscr_to_expirydate($pkg);
                $cart = cg_ecomm::get_cart_module();
                if( !$cart ) throw new \LogicException('internal error: no cart module found');

                $redirect_pref = 'redirect_paidpkg';
                $docreatefeu = 0;

                // now we gotta add an item to the cart.
                $item = new cg_ecomm_cartitem('',$tmpuid,1,$this->GetName());
                $item->set_type(cg_ecomm_cartitem::TYPE_SERVICE);
                $item->set_allow_quantity_adjust(FALSE);
                $item->set_allow_duplicate(FALSE);
                $item->set_base_price($pkg['cost']);

                $smarty->assign('tmpuid',$tmpuid);
                $smarty->assign('username',$username);
                $smarty->assign('pkg',$pkg);
                $sku = 'sr-'.sprintf('%03d-%05d',$pkg['id'],$tmpuid);
                $smarty->assign('sku',$sku);
                $tmp = $this->XTGetPreference('cartitem_summary_tpl','{sitename} membership for {$username}');
                $item->set_sku($sku);
                $item->set_summary($this->ProcessTemplateFromData($tmp));

                $item->set_item_total($pkg['cost']);
                $subscription = new cg_ecomm_productinfo_subscription();
                switch( $pkg['subscr_type'] ) {
                case 'year':
                    if( $pkg['subscr_num'] != 1 ) $this->Audit('',$this->GetName(),'Invalid Subscription package (more than one yer)');
                    $subscription->set_payperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_YEARLY);
                    $subscription->set_deliveryperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_YEARLY);
                    break;
                case 'month':
                    switch( $pkg['subscr_num'] ) {
                    case 1:
                        $subscription->set_payperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_MONTHLY);
                        $subscription->set_deliveryperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_MONTHLY);
                        break;
                    case 3:
                        $subscription->set_payperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_QUARTERLY);
                        $subscription->set_deliveryperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_QUARTERLY);
                        break;
                    case 6:
                        $subscription->set_payperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_SEMIANUALLY);
                        $subscription->set_deliveryperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_SEMIANUALLY);
                        break;
                    case 12:
                        $subscription->set_payperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_YEARLY);
                        $subscription->set_deliveryperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_YEARLY);
                        break;
                    default:
                        // error;
                        $this->Audit('',$this->GetName(),'Invalid Subscription package (wierd number of months)');
                        $subscription->set_payperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_MONTHLY);
                        $subscription->set_deliveryperiod(cg_ecomm_productinfo_subscription::SUBSCR_PERIOD_MONTHLY);
                        break;
                    }
                    break;
                }
                $subscription->set_expiry(-1);
                $item->set_subscription($subscription);

                // could throw an exception, or return false.
                $res = $cart->AddCartItem($item);
            }
        }
        catch( \Exception $e ) {
            audit('',$this->GetName(),'Problem adding registration to cart');
            \xt_utils::log_exception( $e );

            // couldn't add this item to the cart (maybe the policy got in the way)
            // so redirect back to the start.
            // and display a message?
            $this->DeleteTempUser( $tmpuid );
            $this->DeleteTempUserProperties( $tmpuid );

            $msg = $e->GetMessage();
            if( !$msg ) $msg = $this->Lang('error_policycantadd');
            $this->session_put('reguser_error',$msg);

            $this->RedirectContent( $returnid );
        }

        // if we get here either the cost is 0 or there is some problem with the cart
        // so we just proceed like normal.
    }

    if( $this->GetPreference('require_email_confirmation',1) ) {
        // okay, we're now ready to send the email, yahoo, yahoo, yahoo
        // now we have to decide what goes in it.
        $this->_SendUserConfirmationEmail($id,$returnid,$email, $username, $code );
    }
    else if ($docreatefeu) {
        $action = 'post_createuser';

        // it appears we're allowing instant registration
        $result = $this->_CreateFrontendUser( $tmpuid, $username, $password, $expires );
        if( $result[0] == FALSE ) throw new \RuntimeException($result[1]);

        // woohooo, the user be created (hopefully).
        // delete the records from the SelfReg tables
        $this->DeleteTempUserProperties( $tmpuid );
        $this->DeleteTempUser( $tmpuid );

        // do we automatically log this user in?
        if( $this->GetPreference('login_afterverify') ) {
            $mams = $this->GetModuleInstance('MAMS');
            if( $result[1] != $mams->LoggedInId() ) {
                $res = $mams->Login( $username, $password );
                if( is_array($res) && $res[0] == FALSE ) audit('',$this->GetName(),'Problem with auto-login: '.$res[1]);
            }
        }
    }

    // Check if we have to redirect to a page or not
    $destpagestr = null;
    if( isset($params['destpage']) ) {
        $destpagestr = trim($params['destpage']);
    }
    else {
        $destpagestr = $this->ProcessTemplateFromData($this->GetPreference($redirect_pref));
    }
    if( $destpagestr ) {
        $destpageid = $this->resolve_alias_or_id($destpagestr);
        if( $destpageid ) $returnid = $destpageid;
    }

    if( (isset($params['nofinalmessage']) && $params['nofinalmessage']) ||
        $this->GetPreference('mamsreg_skip_final_msg') ||
        ($this->GetPreference('allowpaidregistration') && isset($params['pkg']) && $params['pkg']) ) {
        // redirect back to the content page we started the form on.
        if( isset($params['mr_orig_url']) && empty($destpagestr) ) {
            redirect($params['mr_orig_url']);
            return;
        }
        $this->RedirectContent($returnid);
        return;
    }

    $this->session_clear('signup');
    $this->Redirect($id,$action,$returnid,$parms);
}
catch( \Exception $e ) {
    // we got an exception
    // so we're going to set an error in the session
    // and redirect back to the signup action
    audit('',$this->GetName(),$e->GetMessage());
    \xt_utils::log_exception( $e );
    $this->session_put('reguser_error',$e->GetMessage());
    $this->RedirectContent($returnid);
}

#
# EOF
#
