<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: MAMSRegistration (c) 2020-2021 by CMS Made Simple Foundation
# An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: SelfRegistration (c) 2008-2013 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !defined('CMS_VERSION') ) exit;
if( !$this->CheckPermission('Manage Registering Users') ) exit;
if( !isset($params['user_id']) ) {
    echo $this->_DisplayErrorPage($id,$params,$returnid,$this->Lang('error_insufficientparams'));
}
$tmpuser_id = (int)$params['user_id'];

$query = 'SELECT * FROM '.cms_db_prefix().'module_mamsregistration_users WHERE id = ?';
$row = $db->GetRow($query,array($tmpuser_id));
$key = $this->get_encryption_key($row['username']);
$row['password'] = $this->decrypt($key,base64_decode($row['password']));

$this->_CreateFrontendUser( $tmpuser_id, $row['username'], $row['password'], '' );

$query = 'DELETE FROM '.cms_db_prefix().'module_mamsregistration_properties WHERE user = ?';
$db->Execute($query,array($tmpuser_id));
$query = 'DELETE FROM '.cms_db_prefix().'module_mamsregistration_users WHERE id = ?';
$db->Execute($query,array($tmpuser_id));

$this->SetCurrentTab('adminusers');
$this->SetMessage($this->Lang('msg_userpushed'));
$this->RedirectToTab();

#
# EOF
#
