<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SelfRegistration (c) 2008 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow users to register themselves
#  with a website.
#
# Version: 1.1.5
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This projects homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !defined('CMS_VERSION') ) exit;

$mams = $this->GetModuleInstance('MAMS');
if( !$mams ) return;

$tpl = $this->CreateSmartyTemplate('mamsreg_sendanotheremail_template');

if( isset($params['mr_submit']) ) {
    try {
        $username = trim(\xt_param::get_string($params,'mr_username'));
        if( !$username ) $username = trim(\xt_param::get_string($params,'input_username')); // bc
        if( !$username ) throw new \RuntimeException($this->Lang('error_insufficientparams'));

        $tempuserid = $this->GetTempUserID( $username );
        if( !$tempuserid ) throw new \RuntimeException($this->Lang('error_usernotfound'));

        $details = $this->GetTempUserDetails($tempuserid);
        if( !$details ) throw new \RuntimeException($this->Lang('error_usernotfound'));

        $email = null;
        if( $mams->GetPreference('username_is_email') && is_email($username) ) {
            $email = $username;
        }
        else {
            // gotta find an email address property for this user.
            $tempuserprops = $this->GetTempUserProperties( $tempuserid );
            if( $tempuserprops == false ) throw new \RuntimeException($this->Lang('error_noproperties'));

            $relations = $mams->GetGroupPropertyRelations( $details['group_id'] );
            if( $relations[0] == false ) throw new \RuntimeException($relations[1]);

            $props = $mams->GetPropertyDefns();
            if( $props == false ) throw new \RuntimeException($this->Lang('error_dberror'));

            // now we find an email address property
            $found = null;
            foreach( $relations as $reln ) {
                foreach( $props as $prop ) {
                    if( $prop['type'] == 2 && $relns['name'] == $prop['name'] ) {
                        // found an email property
                        foreach( $tempuserprops as $tempprop ) {
                            if( $reln['name'] == $tempprop['title'] ) {
                                $found = $tempprop['data'];
                                break;
                            }
                        }
                    }
                    if( $found ) break;
                }
                if( $found ) break;
            }
            if( $found ) throw new \RuntimeException($this->Lang('error_noemailaddress'));
            $email = $found;
        }

        $this->_SendUserConfirmationEmail( $id,$returnid,$email, $username, $details['code'] );

        // now we're gonna display a message.
        $config = cmsms()->GetConfig();
        $tpl = $this->CreateSmartyTemplate('mamsreg_post_sendanotheremail_template');
        $tpl->assign('sitename',$config['root_url']);
        $tpl->assign('username',$username);
        $tpl->assign('email',$email);
        $tpl->display();
        return;
    }
    catch( \Exception $e ) {
        $tpl->assign('error',1);
        $tpl->assign('message',$e->GetMessage());
    }
    // process the form.
}

// build output
if( isset( $params['error'] ) ) $tpl->assign('error', $params['error']);
if( isset( $params['message'] ) ) $tpl->assign('message', $params['message']);

$inline = $this->GetPreference('inline_forms',true);
if( isset($params['noinline']) ) $inline = false;

$tpl->assign('startform', $this->CreateFormStart( $id, 'lostemail', $returnid, 'post', '', $inline));
$tpl->assign('endform', $this->CreateFormEnd ());
$tpl->assign('prompt',$this->Lang('username'));
if( $mams->GetPreference('username_is_email') ) $tpl->assign('prompt',$this->Lang('email'));
$tpl->assign('max_usernamelength',$mams->GetPreference('max_usernamelength'));
$tpl->assign ('input_username',
              $this->CreateInputText($id, 'input_username', '', 20,
                                     $mams->GetPreference('max_usernamelength')));
$tpl->assign('submit',$this->CreateInputSubmit($id,'mr_submit', $this->Lang('submit')));
$tpl->display();
?>