<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SelfRegistration (c) 2008 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow users to register themselves
#  with a website.
#
# Version: 1.1.5
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This projects homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit();

if( !$this->GetPreference('reg_additionalgroups') ) {
    audit('',$this->GetName(),'Attempt to use the anothergroup action when the option is disabled');
    return;
}

$mams = cms_utils::get_module(MOD_MAMS);
$uid = $mams->LoggedInId();
if( $uid < 1 ) {
    audit('',$this->GetName(),'Attempt to use the anothergroup action when not logged in to FEU');
    return;
}
$tmp = $mams->GetMemberGroupsArray($uid);
$membergroups = \xt_array::extract_field($tmp,'groupid');

$inline = (int) $this->GetPreference('inline_forms',0);
$tmp = xt_param::get_int($params,'noinline');
if( $tmp ) $inline = 0;

$groupname = trim(xt_param::get_string($params,'group'));
$grpids = reg_utils::expand_group($groupname);
if( !count($grpids) ) {
    audit('',$this->GetName(),'no valid groups found in call to anothergroup action.');
    return;
}
$grpids = array_diff($grpids,$membergroups);
if( !$grpids ) {
    audit('',$this->GetName(),'anothergroup: no new group ids to register to');
    return;
}
$uinfo = $mams->GetUserInfo($uid,TRUE);

// now we have group ids, get a list of the groups properties.
$relations = array();
foreach( $grpids as $gid ) {
    $grelns = $mams->GetGroupPropertyRelations( $gid );
    $relations = RRUtils::array_merge_by_name_required($relations,$grelns);
    uasort( $relations, 'xt_array::compare_elements_by_sortorder_key');
}
// now we merge in property info
$defns = $mams->GetPropertyDefns();
foreach( $relations as &$oneprop ) {
    foreach( $defns as $onedefn ) {
        if( $onedefn['name'] == $oneprop['name'] ) {
            $oneprop['prompt'] = $onedefn['prompt'];
            $oneprop['type'] = $onedefn['type'];
            break;
        }
    }
}

// filter out some of the relations
$relations2 = array();
foreach( $relations as $reln ) {
    if( $reln['type'] ==  9 ) {
        // data fields are ignored.
        continue;
    }
    if( $reln['required'] == 3 ) continue; // ignore hidden fields.
    $relations2[] = $reln;
}

$get_user_propval = function($name) use ($uinfo)
{
    if( !isset($uinfo[1]['fprops']) ) return;
    foreach( $uinfo[1]['fprops'] as $rec ) {
        if( $name == $rec['title'] ) {
            return $rec['data'];
        }
    }
};

$rowarray = null;
foreach( $relations2 as $reln ) {
    $defn = null;
    if( isset($reln['mapto']) ) {
        $defn = $mams->GetPropertyDefn( $reln['mapto'] );
    } else {
        $defn = $mams->GetPropertyDefn( $reln['name'] );
    }

    $attribs = null;
    if( isset($defn['attribs']) ) $attribs = unserialize($defn['attribs']);

    $onerow = new StdClass;
    $onerow->color = $onerow->marker = null;
    if( $defn['encrypt'] ) {
        $onerow->color = $this->GetPreference('secure_field_color','yellow');
        $onerow->marker = $this->GetPreference('secure_field_marker','^^');
    }
    if( $reln['required'] == 2 ) $onerow->color = $mams->GetPreference('required_field_color','blue');
    if( $reln['required'] == 2 ) $onerow->marker = $mams->GetPreference('required_field_marker','*');
    $name = $reln['name'];
    $onerow->required = $reln['required'] == 2;
    $onerow->name = $name;
    $onerow->type = $defn['type'];
    $onerow->required = ($reln['required'] == 2);
    $onerow->prompt = $reln['prompt'];

    // get initial value from FEU if possible
    $onerow->val = $get_user_propval($name);
    if( $defn['type'] == 1 && isset($attribs['checked']) ) $onerow->val = $attribs['checked'];

    switch( $onerow->type ) {
    case 4: // dropdown
    case 5: // multiselect
    case 7: // radio buttons
        $onerow->options = array_flip($mams->GetSelectOptions($defn['name'], 1));
        break;
    case 6: // image
        $dest_dir = $config['uploads_path'].'/'.$mams->GetPreference('image_destination_path','feusers').'/';
        $dest_url = $config['uploads_url'].'/'.$mams->GetPreference('image_destination_path','feusers').'/';
        $filename = $dest_dir.$onerow->val;
        $fileurl  = $dest_url.$onerow->val;
        if( is_file($filename) && is_readable($filename) ) {
            $onerow->image_url = $fileurl;
            $onerow->mimetype = \xt_utils::get_mime_type($filename);
            $onerow->is_image = ( startswith($onerow->mimetype,'image/') ) ? TRUE : FALSE;
        }
        break;

    }

    // fill the rec->value properly.
    $key = 'mr_ctl_'.$reln['name'];
    if( isset($params['mr_submit']) && (isset($params[$key]) || $onerow->type == $mams::FIELDTYPE_IMAGE) ) {
        $val = null;

        switch( $onerow->type ) {
        case $mams::FIELDTYPE_MULTISELECT:
            if( is_array($params[$key]) ) {
                $val = \xt_param::get_string_array($params,$key);
            } else {
                $val = \xt_param::get_string($params,$key);
            }
            break;

        case $mams::FIELDTYPE_DATE:
        case $mams::FIELDTYPE_DROPDOWN:
        case $mams::FIELDTYPE_RADIOBUTNS:
        case $mams::FIELDTYPE_CHECKBOX:
        case $mams::FIELDTYPE_TEXT:
            $val = \xt_param::get_string($params,$key);
            break;
        case $mams::FIELDTYPE_EMAIL:
            $val = \xt_param::get_string($params,$key);
            break;
        case $mams::FIELDTYPE_TEXTAREA:
            $val = \xt_param::get_html($params,$key);
            break;
        case $mams::FIELDTYPE_IMAGE:
            // get the image from $_FILES
            $fkey = $id.$key;
            if( isset($_FILES[$fkey]) && $_FILES[$fkey]['size'] > 0 ) {
                // found a file... overwrite existing value with a special value
                // so that we handle the file upload stuff below
                $onerow->have_file = $fkey;
                $val = $_FILES[$fkey]['name'];
            } else {
                // no file, but if there's already a value... we use it
                if( $onerow->val ) $val = $onerow->val;
            }
            break;

        case $mams::FIELDTYPE_DATA:
            // do nothing
            break;
        }
        $onerow->val = $val;
    }
    $onerow->value = $onerow->val;  // for convenience
    $onerow->fldname = $id.'mr_ctl_'.$onerow->name;

    $rowarray[$onerow->name] = $onerow;
}
if( count($rowarray) == 0 ) {
    audit('',$this->GetName(),'anothergroup action found no displayable properties for '.$mams->LoggedInName());
    return;
}

$tpl = $this->CreateSmartyTemplate('anothergroup_template');
$parms = array('group'=>$groupname);
$tpl->assign('formstart',$this->XTCreateFormStart($id,'anothergroup',$returnid,$parms,$inline));
$tpl->assign('formend',$this->CreateFormEnd());
$tpl->assign('properties',$rowarray);
$tpl->assign('pwfldlen',$mams->GetPreference('passwordfldlength',50));
$tpl->assign('groupname',$groupname);
$tpl->assign('groupids',$grpids);
$tpl->assign('req_color',$mams->GetPreference('required_field_color','blue'));
$tpl->assign('req_marker',$mams->GetPreference('required_field_marker','*'));

if( isset($params['mr_submit']) ) {
    try {
        // validate the username and password
        $pw1 = \xt_param::get_string($params,'mr_password');
        $pw2 = \xt_param::get_string($params,'mr_password2');
        if( trim($pw1) == '' || $pw1 != $pw2 ) {
            throw new \RuntimeException($this->Lang('error_passwordsdontmatch'));
        }

        $username = $mams->LoggedInName();
        if( !$mams->CheckPassword($username,$pw1) ) {
            throw new \RuntimeException($this->Lang('error_incorrectpassword'));
        }

        // validate the properties
        foreach( $rowarray as $name => $rec ) {
            // validate our properties (required, unique,...)
            if( $rec->required && !$rec->val ) {
                throw new \RuntimeException($this->Lang('error_requiredfield',$name));
            }

            // validate values
            switch( $rec->type ) {
            case $mams::FIELDTYPE_MULTISELECT:
                if( is_array($rec->val) ) $rec->val = implode(',',$rec->val);
                break;

            case $mams::FIELDTYPE_DROPDOWN:
            case $mams::FIELDTYPE_RADIOBUTNS:
            case $mams::FIELDTYPE_CHECKBOX:
            case $mams::FIELDTYPE_TEXT:
                // do nothing
                break;

            case $mams::FIELDTYPE_DATE:
                $rec->val = strtotime($rec->val); // dates are stored as timestamps.
                break;

            case $mams::FIELDTYPE_EMAIL:
                if( $rec->val && !is_email($rec->val) ) {
                    throw new \RuntimeException($this->Lang('error_emailinvalid'));
                }
                break;

            case $mams::FIELDTYPE_IMAGE:
            case $mams::FIELDTYPE_TEXTAREA:
            case $mams::FIELDTYPE_DATA:
                // do nothing
                break;
            }
        }

        // handle adding the user to the gruop
        foreach( $grpids as $gid ) {
            $mams->AssignUserToGroup($uid,$gid);
        }

        // handle setting the user proeprties
        foreach( $rowarray as $name => $rec ) {
            switch( $rec->type ) {
            case $mams::FIELDTYPE_IMAGE:
                if( isset($rec->have_file) && $rec->have_file ) {
                    // we have a file in $_FILES that we need to upload
                    if( !$mams->is_allowed_upload($rec->val) ) throw new \RuntimeException($mams->Lang('error_invalidfileextension'));

                    // need to get the proper location, and move it.
                    // creating the directory if necessary.
                    $destname = $mams->get_upload_filename($uid,$rec->name,$rec->val);
                    $destdir =  $mams->get_upload_dirname($uid);
                    @mkdir($destdir,0777,TRUE);
                    @touch($destdir.'/index.html');
                    if( !is_writable($destdir) ) throw new \RuntimeException($mams->Lang('error_destinationnotwritable'));
                    $dest = $destdir.'/'.$destname;
                    @cms_move_uploaded_file($_FILES[$rec->have_file]['tmp_name'], $dest);
                    $rec->val = $destname;
                }
                $mams->SetUserPropertyFull($name,$rec->val,$uid);
                break;

            default:
                $mams->SetUserPropertyFull($name,$rec->val,$uid);
                break;
            }
        }

        // and... done.
        $tpl->assign('final_message',$this->Lang('msg_addedothergroup'));
    }
    catch( \Exception $e ) {
        $tpl->assign('error_message',$e->GetMessage());
    }
}

$tpl->display();