<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: SelfRegistration (c) 2008-2016 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow users to register themselves
#  with a website.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This projects homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !defined('CMS_VERSION') ) exit;
if( !$this->CheckPermission('Modify Templates' ) ) return;
$this->SetCurrentTab('reg1template');

if(\xt_param::exists($params, 'submit'))
{
  $this->SetTemplate('mamsreg_reg1template', $params['reg1_templatecontent']);
  $this->SetTemplate('mamsreg_postreg1_template', $params['postreg1_templatecontent']);
  $this->RedirectToTab();
}
else if(\xt_param::exists($params, 'reset'))
{
  $this->SetTemplate('mamsreg_reg1template', file_get_contents(__DIR__ . '/templates/orig_registration1.tpl'));
  $this->SetTemplate('mamsreg_postreg1_template', file_get_contents(__DIR__ . '/templates/orig_postreg1.tpl'));
  $this->RedirectToTab();
}

$tpl = $this->CreateSmartyTemplate('admin_reg1template_tab.tpl');
$tpl->assign('reg1_templatecontent', $this->GetTemplate('mamsreg_reg1template'));
$tpl->assign('postreg1_templatecontent', $this->GetTemplate('mamsreg_postreg1_template'));
$tpl->display();
