<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: MAMSRegistration (c) 2020-2021 by CMS Made Simple Foundation
# An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: SelfRegistration (c) 2008-2013 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if(!isset($gCms))
{
  exit;
}
if(!$this->CheckPermission('Modify Site Preferences'))
{
  return;
}
$mams = $this->GetModuleInstance('MAMS');
if(!$mams)
{
  return;
}

$modname      = strtolower($this->GetName());
$table_prefix = cms_db_prefix() . 'module_' . $modname;

// initialization
$this->SetCurrentTab('regpkgs');
$error              = $pkgid = NULL;
$rec                = array();
$rec['name']        = '';
$rec['prompt']      = '';
$rec['description'] = '';
$rec['gid']         = '';
$rec['subscr_num']  = 1;
$rec['subscr_type'] = 'yearly';
$rec['cost']        = '';
$groups             = array_flip($mams->GetGroupList());

// handle incoming params
if(isset($params['pkgid']))
{
  $pkgid = (int)$params['pkgid'];
  $query = 'SELECT * FROM ' . $table_prefix . '_paidpkgs WHERE id = ?';
  $tmp   = $db->GetRow($query, array($pkgid));
  if($tmp)
  {
    $rec = $tmp;
  }
}

// handle form submit
if(isset($params['cancel']))
{
  $this->RedirectToTab($id);
}
if(isset($params['submit']))
{
  try
  {
    // fill in the record
    $rec['name']        = trim($params['pkg_name']);
    $rec['prompt']      = trim($params['pkg_prompt']);
    $rec['description'] = trim($params['pkg_description']);
    $rec['gid']         = (int)$params['pkg_gid'];
    if(isset($params['pkg_cost']))
    {
      $rec['cost'] = (float)$params['pkg_cost'];
    }
    if(isset($params['subscr_num']))
    {
      $rec['subscr_num'] = (int)$params['subscr_num'];
    }
    if(isset($params['subscr_type']))
    {
      $rec['subscr_type'] = trim($params['subscr_type']);
    }
    
    // check for errors.
    if($rec['cost'] < 0)
    {
      throw new \RuntimeException($this->Lang('err_subscrcost'));
    }
    switch(\xt_param::get_string($rec, 'subscr_type'))
    {
      case 'month':
        switch($rec['subscr_num'])
        {
          case 1:
          case 3:
          case 6:
          case 12:
            // these are all okay.
          break;
          default:
            throw new \RuntimeException($this->lang('err_subscrmonth'));
        }
      break;
      case 'year':
        if($rec['subscr_num'] != 1)
        {
          throw new \RuntimeException($this->Lang('err_subscryear'));
        }
      break;
    }
    
    $flds = array('name' => $this->Lang('name'), 'prompt' => $this->Lang('prompt'));
    foreach($flds as $fld => $lbl)
    {
      $query = sprintf('SELECT id FROM ' . $table_prefix . '_paidpkgs WHERE %s = ?', $fld);
      $parms = array($rec[$fld]);
      if($pkgid)
      {
        $query = sprintf('SELECT id FROM ' . $table_prefix . '_paidpkgs WHERE %s = ? AND id != ?', $fld);
        $parms = array($rec[$fld], $pkgid);
      }
      $tmp = $db->GetOne($query, $parms);
      if($tmp)
      {
        $val = $rec[$fld];
        if($fld == 'gid')
        {
          $val = $groups[$rec[$fld]];
        }
        throw new \RuntimeException($this->Lang('error_pkgexists', $lbl, $val));
      }
    }
    
    // we're ready to insert or update.
    $res = '';
    if(!$pkgid)
    {
      $query = 'INSERT INTO ' . $table_prefix . '_paidpkgs
                (name,prompt,description,gid,cost,subscr_num,subscr_type)
                VALUES (?,?,?,?,?,?,?)';
      $res   = $db->Execute(
        $query,
        array(
          $rec['name'], $rec['prompt'], $rec['description'],
          $rec['gid'], $rec['cost'],
          $rec['subscr_num'], $rec['subscr_type']
        )
      );
    }
    else
    {
      $query = 'UPDATE ' . $table_prefix . '_paidpkgs
                SET name = ?, prompt = ?, description = ?, gid = ?, cost = ?,
                    subscr_num = ?, subscr_type = ?
                WHERE id = ?';
      $res   = $db->Execute(
        $query,
        array(
          $rec['name'], $rec['prompt'], $rec['description'],
          $rec['gid'], $rec['cost'],
          $rec['subscr_num'], $rec['subscr_type'],
          $pkgid
        )
      );
    }
    
    $this->RedirectToTab($id);
  }
  catch(\Exception $e)
  {
    echo $this->ShowErrors($e->GetMessage());
  }
}

// build the form
$smarty->assign('grouplist', $groups);
$smarty->assign('pkgdata', $rec);
$smarty->assign('formstart', $this->XTCreateFormStart($id, 'admin_addpaidpkg', $returnid, $params));
$smarty->assign('formend', $this->CreateFormEnd());
$smarty->assign('input_description', $this->CreateTextArea(TRUE, $id, $rec['description'], 'pkg_description'));
$subscr_type          = array();
$subscr_type['none']  = $this->Lang('none');
$subscr_type['month'] = $this->Lang('month');
$subscr_type['year']  = $this->Lang('year');
$smarty->assign('subscr_types', $subscr_type);

$tmp = [1 => 1, 3 => 3, 6 => 6, 12 => 12];
$smarty->assign('nums', $tmp);

if($this->GetModuleInstance('CGEcommerceBase'))
{
  $smarty->assign('currency_symbol', cg_ecomm::get_currency_symbol());
  $smarty->assign('currency_code', cg_ecomm::get_currency_code());
}

$obj = cms_utils::get_module('CGEcommerceBase');
if(is_object($obj))
{
  $smarty->assign('can_edit_cost', 1);
}
echo $this->ProcessTemplate('admin_addpaidpkg.tpl');

#
# EOF
#