<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: MAMSRegistration (c) 2020-2021 by CMS Made Simple Foundation
# An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: SelfRegistration (c) 2008-2013 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

require_once(__DIR__ . "/functions.php");

final class MAMSRegistration extends \CMSMSExt\XTModule
{
  const MAMS_PROPNAME = '__MAMSREG';
  var $dflt_emailconfirm_template = '
<!-- EmailConfirm template -->
<html>
<body>
<p>Greetings {$name} welcome to {sitename}.  This email is being sent because somebody registered for access to {$sitename} using this email address. If this was you, please click on the following link and enter your username, password, and the unique code below</p>
   <p>Follow this link: <a href="{$url}">{$url}</a></p>
   <p>Code: {$code}</p>
</body>
</html>
<!-- EmailConfirm template -->
';
  
  var $dflt_emailuseredited_template = '
<!-- EmailUserEdited template -->
<html>
<body>
<p>Greetings {$name} welcome to {sitename}.  This email is being sent because, although you have already registered with {$sitename}, there was an error in your input.  The administrator has done his best to correct this data, and you are now being sent an updated registration form. Please click on the following link and enter your username, password, and the unique code below</p>
   <p>Follow this link: <a href="{$url}">{$url}</a></p>
   {if !empty($password)}<p>Password: {$password}</p>{/if}
   <p>Code: {$code}</p>
</body>
</html>
<!-- EmailUserEdited template -->
';
  
  var $dflt_finalmessage_template = '
<!-- FinalMessage Template -->
{if !empty($iscreated)}
  <p>Welcome {$username} to {sitename}.  Your registration is complete.  Please login to continue</p>
{elseif !empty($is_logged_in)}
  <p>Welcome {$username} to {sitename}.  Your registration is complete.</p>
{else}
  <p>Welcome {$username} to {sitename}.  Your registration is complete.  Your account is now waiting approval by an administrator.</p>
{/if}
  ';
  
  var $dflt_post_sendanotheremail_template = '
<h3>{$mod->Lang(\'title_lostemail\')}</h3>
{if isset($message) && $message != \'\'}
  {if isset($error) && $error != \'\'}
    <div class="alert alert-danger">{$message}</div>
  {else}
    <div class="alert alert-info">{$message}</div>
  {/if}
{/if}
<p>Thank you {$username} for registering with <a href="{root_url}">{sitename}</a>.  We are sorry you had difficulty receiving your email.  A second email has been sent to {$email} with instructions on how to continue the registration process</p>
';
  
  public function AllowAutoInstall(){ return FALSE; }
  
  public function AllowAutoUpgrade(){ return FALSE; }
  
  public function GetName(){ return 'MAMSRegistration'; }
  
  public function GetFriendlyName(){ return $this->Lang('friendlyname'); }
  
  public function MinimumCMSVersion(){ return '2.2.5'; }
  
  public function LazyLoadAdmin(){ return TRUE; }
  
  public function GetVersion(){ return '1.0'; }
  
  //public function GetHelp(){ return @file_get_contents(__DIR__ . '/help.inc'); }
  
  public function GetAuthor(){ return 'Jo Morg'; }
  
  public function GetAuthorEmail(){ return 'jomorg@cmsmadesimple.org'; }
  
  //public function GetChangeLog(){ return file_get_contents(__DIR__ . '/changelog.inc'); }
  
  public function IsPluginModule(){ return TRUE; }
  
  public function HasAdmin(){ return TRUE; }
  
  public function GetAdminSection(){ return 'usersgroups'; }
  
  public function GetEventDescription($eventname){ return $this->Lang('event_description_' . $eventname); }
  
  public function GetEventHelp($eventname){ return $this->Lang('event_help_' . $eventname); }
  
  public function GetAdminDescription(){ return $this->Lang('moddescription'); }
  
  public function InstallPostMessage(){ return $this->Lang('postinstall'); }
  
  public function UninstallPostMessage(){ return $this->Lang('postuninstall'); }
  
  public function VisibleToAdminUser()
  {
    $status = $this->CheckPermission('Manage Registering Users')
              || $this->CheckPermission('Modify Site Preferences')
              || $this->CheckPermission('Modify Templates');
    
    return $status;
  }
  
  public function GetDependencies()
  {
    return ['CMSMSExt' => '1.0.1', 'MAMS' => '1.0', 'SmartyExt' => '1.0'];
  }
  
  public function HandlesEvents()
  {
    return $this->GetPreference('allowpaidregistration', 0);
  }
  
  public function InitializeFrontend()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();
  
    $this->SetParameterType('mode', CLEAN_STRING);
    $this->SetParameterType('nocaptcha', CLEAN_INT);
    $this->SetParameterType('group', CLEAN_STRING);
    $this->SetParameterType('noinline', CLEAN_INT);
    $this->SetParameterType('destpage', CLEAN_STRING);
    $this->SetParameterType('group', CLEAN_STRING);
    $this->SetParameterType('pkg', CLEAN_INT);
    $this->SetParameterType('onlyhref', CLEAN_INT);
    $this->SetParameterType('linktext', CLEAN_STRING);
    $this->SetParameterType('noinline', CLEAN_INT);
    $this->SetParameterType('allowoverwrite', CLEAN_INT);
    $this->SetParameterType('nofinalmessage', CLEAN_INT);
    $this->SetParameterType('input_username', CLEAN_STRING);
    $this->SetParameterType('input_code', CLEAN_STRING);
    $this->SetParameterType('input_group_id', CLEAN_INT); // todo, remove me.
    $this->SetParameterType('input_password', CLEAN_STRING);
    $this->SetParameterType('linktext', CLEAN_STRING);
    $this->SetParameterType('regtemplate', CLEAN_STRING);
    $this->SetParameterType('verifytemplate', CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP . '/mr_.*/', CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP . '/mamsreg_.*/', CLEAN_STRING);
    
    $this->RegisterRoute(
      '/[Mm]amsreg\/register\/(?P<returnid>[0-9]+)\/(?P<group>.*)$/',
      array('action' => 'signp')
    );
    $this->RegisterRoute(
      '/[Mm]amsreg\/confirm\/(?P<returnid>[0-9]+)\/(?P<mr_data>.*?)$/',
      array('action' => 'verify')
    );
  }
  
  // deprecated
  protected function myRedirectToTab($id, $tab, $params = '')
  {
    $parms = array();
    
    if(is_array($params))
    {
      $parms = $params;
    }
    
    unset($parms['hidden_password']);
    unset($parms['hidden_repeatpassword']);
    unset($parms['input_password']);
    unset($parms['input_repeatpassword']);
    unset($parms['password']);
    unset($parms['repeatpassword']);
    unset($parms['action']);
    $this->RedirectToTab($id, $tab, $parms);
  }
  
  protected function myRedirect($id, $action, $returnid, $params = '')
  {
    // unset any password things
    unset($params['hidden_password']);
    unset($params['hidden_repeatpassword']);
    unset($params['input_password']);
    unset($params['input_repeatpassword']);
    unset($params['password']);
    unset($params['repeatpassword']);
    unset($params['action']);
    
    return $this->DoAction($action, $id, $params, $returnid);
  }
  
  public function DoAction($action, $id, $params, $returnid = -1)
  {
    $gCms   = cmsms();
    $smarty = $gCms->GetSmarty();
    $smarty->assign('mamsregactionid', $id);
    $smarty->assign('mamsregparams', $params);
    $smarty->assign('mod', $this);
    $smarty->assign($this->GetName(), $this);
    
    switch($action)
    {
      case 'deletetempuser':
        if($this->CheckPermission('Manage Registering Users'))
        {
          $this->_DoDeleteUser($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      case 'do_deleteusersbulk':
        if($this->CheckPermission('Manage Registering Users'))
        {
          $this->_DoDeleteBulkUsers($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      case 'set_reg2template':
        if($this->CheckPermission('Modify Templates'))
        {
          $this->_SetAdminReg2Template($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      case 'set_emailconfirm_template':
        if($this->CheckPermission('Modify Templates'))
        {
          $this->_SetAdminEmailConfirmTemplate($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      case 'set_emailuseredited_template':
        if($this->CheckPermission('Modify Templates'))
        {
          $this->_SetAdminEmailUserEditedTemplate($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      case 'set_finalmessage_template':
        if($this->CheckPermission('Modify Templates'))
        {
          $this->_SetAdminFinalMessageTemplate($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      case 'set_sendanotheremail_template':
        if($this->CheckPermission('Modify Templates'))
        {
          $this->_SetAdminSendAnotherEmailTemplate($id, $params, $returnid);
        }
        else
        {
          $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
        }
      break;
      
      default:
        return parent::DoAction($action, $id, $params, $returnid);
    } // switch
  }
  
  
  /*---------------------------------------------------------
   _CreateFrontendUser($id, $params, $return_id )
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _CreateFrontendUser($tmpid, $username, $password, $expires = '')
  {
    $gCms    = cmsms();
    $db      = $gCms->GetDb();
    $mams = $this->GetModuleInstance('MAMS');
    
    if(!$mams)
    {
      return array(FALSE, $this->Lang('error_nomamsmodule'));
    }
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . 'module_mamsregistration_users WHERE id = ?';
    $row   = $db->GetRow($query, array($tmpid));
    
    if(!$row)
    {
      return array(FALSE, $this->Lang('error_usernotfound'));
    }
    
    $q    = 'SELECT gid FROM ' . cms_db_prefix() . 'module_mamsregistration_grps WHERE user = ?';
    $grps = $db->GetCol($q, array($tmpid));
    
    if(!is_array($grps) || count($grps) == 0)
    {
      $gid = $this->GetPreference('default_group', -1);
      
      if($gid != -1)
      {
        $grps = array($gid);
      }
    }
    
    # we won't be enforcing mandatory groups
//    if(!is_array($grps) || count($grps) == 0)
//    {
//      return array(FALSE, $this->Lang('error_nogroups'));
//    }
    
    if(!$expires)
    {
      $timeperiod = max(1, $mams->GetPreference('expireage_months', -1));
      if($timeperiod > 0)
      {
        $expires = strtotime("+{$timeperiod} months");
      }
      if(!$expires)
      {
        $expires = PHP_INT_MAX;
      }
    }
    
    if($row['overwrite_uid'])
    {
      // we're overwriting a user account
      $result = $mams->SetUser($row['overwrite_uid'], $username, $password, $expires);
      if($result[0] == FALSE)
      {
        return array(FALSE, $result[1]);
      }
    }
    else
    {
      $result = $mams->AddUser($username, $password, $expires);
      if($result[0] == FALSE)
      {
        return array(FALSE, $result[1]);
      }
    }
    
    $uid = $result[1];
    //$mams->SetEncryptionKey($uid, 1);
    
    // and add the user to whatever group specified in the groups parameter
    if(is_array($grps) && count($grps))
    {
      foreach($grps as $gid)
      {
        $res = $mams->AssignUserToGroup($uid, $gid);
//        if(!$res)
//        {
//          return array(FALSE, $this->Lang('warning_couldnotaddgroup'));
//        }
      }
    }
    
    // he's in.... now just add his properties if we have groups
    if($res)
    {
      $q        = "SELECT * FROM " . cms_db_prefix() . "module_mamsregistration_properties WHERE user = ?";
      $dbresult = $db->Execute($q, array($tmpid));
  
      if(!$dbresult)
      {
        return array(FALSE, $this->Lang('error_dberror'));
      }
      while($row = $dbresult->FetchRow())
      {
        $mams->SetUserPropertyFull($row['title'], $row['data'], $uid);
      }
    }
    
    // do a hook
    \CMSMS\HookManager::do_hook('MAMSRegistration::onUserRegistered', ['username' => $username, 'id' => $uid]);
    
    // and notify the administrator
    // if the admin wants notifications.
    // off we go.
    try
    {
      $this->_SendRegistrationNotification($username, $uid, $grps);
    }
    catch( \Exception $e )
    {
      \audit('', $this->GetName(), $e->GetMessage());
    }
    
    audit('', $this->GetName(), "User $username assigned to MAMS");
    
    return array(TRUE, $uid);
  }
  
  protected function _SendRegistrationNotification($username, $uid = NULL, $grps = NULL)
  {
    if($this->GetPreference('notify_on_registration'))
    {
      $cmsmailer = new \cms_mailer;
      
      $tmp = $this->GetPreference('send_emails_to');
      
      if($tmp)
      {
        $list = xt_array::smart_explode($tmp);
        
        foreach($list as &$one)
        {
          $one = trim($one);
          
          if(!empty($one) && is_email($one))
          //if(!empty($one))
          {
            $cmsmailer->AddAddress((string)$one);
          }
        }
        
        $gCms = \cmsms();
        $subj = $this->GetPreference('admin_notify_subject', 'New user regisered on ' . $gCms->config['root_url']);
        $cmsmailer->SetSubject($subj);
        $tpl = $this->CreateSmartyTemplate('admin_notify_email');
        $tpl->assign('uid', $uid);
        $tpl->assign('username', $username);
        $tpl->assign('groups', $grps);
        $msg = $tpl->fetch();
        $cmsmailer->SetBody($msg);
        $cmsmailer->SetPriority(1);
        $cmsmailer->IsHTML(TRUE); // we're not sending an html mail
        $cmsmailer->Send();
      }
    }
  }
  
  /*---------------------------------------------------------
   DisplayErrorPage($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _DisplayErrorPage($id, &$params, $returnid, $message = '')
  {
    $this->smarty->assign('title_error', $this->Lang('error'));
    if($message != '')
    {
      $this->smarty->assign('message', $message);
    }
    
    // Display the populated template
    echo $this->ProcessTemplate('error.tpl');
  }
  
  /*---------------------------------------------------------
   _DoDeleteBulkUsers($id, $params, $return_id)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _DoDeleteBulkUsers($id, &$params, $returnid)
  {
    $tmp = array();
    foreach($params as $key => $value)
    {
      if($key == 'markdelete_' . $value)
      {
        $tmp[] = $value;
      }
    }
    if(count($tmp))
    {
      $this->DeleteTempUser($tmp);
    }
    $this->myRedirectToTab($id, 'adminusers');
  }
  
  
  /*---------------------------------------------------------
   _DoDeleteUser($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _DoDeleteUser($id, &$params, $returnid)
  {
    if(!isset($params['user_id']))
    {
      // this is ugly for the user to see
      // but at least the admin will be able to figure it out
      $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('error_insufficientparams'));
      
      return;
    }
    
    $id = $params['user_id'];
    $this->DeleteTempUser($id);
    $this->myRedirectToTab('', 'adminusers');
  }
  
  /*---------------------------------------------------------
   SendUserConfirmationEmail($address,$username,$code);
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _SendUserConfirmationEmail($id, $returnid, $address, $username, $code)
  {
    $config    = cms_config::get_instance();
    $cmsmailer = new \cms_mailer;
    
    $cmsmailer->AddAddress($address);
    $tpl = $this->CreateSmartyTemplate('mamsreg_emailconfirm_template');
    $tpl->assign('name', $username);
    $tpl->assign('code', $code);
    $tpl->assign('sitename', $config['root_url']);
    $parms     = ['mr_input_username' => $username, 'mr_input_code' => $code];
    $parms     = ['mr_data' => base64_encode(serialize($parms))];
    $prettyurl = "mamsreg/confirm/$returnid/{$parms['mr_data']}";
    $url       = $this->create_url($id, 'default', $returnid, $parms, FALSE, FALSE, $prettyurl);
    $tpl->assign('url', $url);
    $htmlbody = $tpl->fetch();
    
    $cmsmailer->SetBody($htmlbody);
    $cmsmailer->IsHTML(TRUE);  // we're sending an html mail
    $cmsmailer->SetBody($htmlbody);
    $cmsmailer->SetSubject(
      $this->GetPreference('mamsreg_emailconfirm_subject', $this->Lang('registration_confirmation'))
    );
    $cmsmailer->Send();
  }
  
  
  /*---------------------------------------------------------
   SetAdminReg2Template($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _SetAdminReg2Template($id, &$params, $returnid)
  {
    if(isset($params['defaultbutton']))
    {
      $this->SetTemplate('mamsreg_reg2template', file_get_contents(__DIR__ . '/templates/orig_registration2.tpl'));
    }
    else if(isset($params['templatecontent']))
    {
      $this->SetTemplate('mamsreg_reg2template', $params['templatecontent']);
    }
    $this->myRedirectToTab($id, 'reg2template');
  }
  
  /*---------------------------------------------------------
   SetAdminEmailConfirmationTemplate($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _SetAdminEmailConfirmTemplate($id, &$params, $returnid)
  {
    if(isset($params['defaultbutton']))
    {
      $this->SetTemplate('mamsreg_emailconfirm_template', $this->dflt_emailconfirm_template);
    }
    else
    {
      $htmltemplate = '';
      $subject      = '';
      if(isset($params['templatecontent']))
      {
        $htmltemplate = $params['templatecontent'];
      }
      if(isset($params['input_subject']))
      {
        $subject = $params['input_subject'];
      }
      if($subject == '')
      {
        $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('error_mustspecifysubject'));
        
        return;
      }
      
      $this->SetTemplate('mamsreg_emailconfirm_template', $params['templatecontent']);
      $this->SetPreference('mamsreg_emailconfirm_subject', $params['input_subject']);
    }
    $this->myRedirectToTab($id, 'emailconfirm_template');
  }
  
  /*---------------------------------------------------------
   SetAdminFinalMessageTemplate($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _SetAdminFinalMessageTemplate($id, &$params, $returnid)
  {
    if(isset($params['defaultbutton']))
    {
      $this->SetTemplate('mamsreg_finalmessage_template', $this->dflt_finalmessage_template);
    }
    else if(isset($params['templatecontent']))
    {
      $this->SetTemplate('mamsreg_finalmessage_template', $params['templatecontent']);
    }
    $this->myRedirectToTab($id, 'finalmessage_template');
  }
  
  
  /*---------------------------------------------------------
   SetAdminEmailConfirmationTemplate($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _SetAdminEmailUserEditedTemplate($id, &$params, $returnid)
  {
    if(isset($params['defaultbutton']))
    {
      $this->SetTemplate('mamsreg_emailuseredited_template', $this->dflt_emailuseredited_template);
    }
    else
    {
      $htmltemplate = '';
      $subject      = '';
      if(isset($params['templatecontent']))
      {
        $htmltemplate = $params['templatecontent'];
      }
      if(isset($params['input_subject']))
      {
        $subject = $params['input_subject'];
      }
      if($subject == '')
      {
        $this->_DisplayErrorPage($id, $params, $returnid, $this->Lang('error_mustspecifysubject'));
        
        return;
      }
      
      $this->SetTemplate('mamsreg_emailuseredited_template', $params['templatecontent']);
      $this->SetPreference('mamsreg_emailuseredited_subject', $params['input_subject']);
    }
    $this->myRedirectToTab($id, 'emailuseredited_template');
  }
  
  /*---------------------------------------------------------
   SetAdminSetAnotherEmailTemplate($id, $params, $return_id, $message)
   NOT PART OF THE MODULE API
   ---------------------------------------------------------*/
  protected function _SetAdminSendAnotherEmailTemplate($id, &$params, $returnid)
  {
    if(isset($params['defaultbutton']))
    {
      $this->SetTemplate(
        'mamsreg_sendanotheremail_template', @file_get_contents(__DIR__ . '/templates/orig_sendanotheremail_form.tpl')
      );
      $this->SetTemplate('mamsreg_post_sendanotheremail_template', $this->dflt_post_sendanotheremail_template);
    }
    else if(isset($params['templatecontent']))
    {
      $this->SetTemplate('mamsreg_sendanotheremail_template', $params['templatecontent']);
      $this->SetTemplate('mamsreg_post_sendanotheremail_template', $params['templatecontent2']);
    }
    $this->myRedirectToTab($id, 'sendanotheremail_template');
  }
  
  /////////////////////////////////////////////////////////////////
  // API FUNCTIONS
  /////////////////////////////////////////////////////////////////
  
  public function AddTempUserProperty($uid, $propname, $propvalue)
  {
    $db       = $this->GetDb();
    $id       = $db->GenID(cms_db_prefix() . "module_mamsregistration_properties_seq");
    $q        = "INSERT INTO " . cms_db_prefix() . "module_mamsregistration_properties VALUES (?,?,?,?)";
    $dbresult = $db->Execute($q, array($id, $uid, $propname, $propvalue));
    
    if(!$dbresult)
    {
      return array(FALSE, $db->sql . ' - ' . $db->ErrorMsg());
    }
    
    return array(TRUE);
  }
  
  public function CountTempUsers()
  {
    $db       = $this->GetDb();
    $q        = "SELECT count(id) as count FROM " . cms_db_prefix() . "module_mamsregistration_users";
    $dbresult = $db->Execute($q);
    if(!$dbresult)
    {
      return FALSE;
    }
    $row = $dbresult->FetchRow();
    
    return $row['count'];
  }
  
  protected function get_encryption_key($username)
  {
    $config = cmsms()->GetConfig();
    
    return md5(__FILE__ . $username . $config['root_url']);
  }
  
  public function CreateTempUser($gid, $username, $password, $code, $overwrite_uid = NULL)
  {
    $db = $this->GetDb();
    if($username == '' || $password == '')
    {
      return array(FALSE, 'Username or password is invalid');
    }
    
    $mams      = cms_utils::get_module('MAMS');
    $key      = $this->get_encryption_key($username);
    $password = base64_encode($this->encrypt($key, $password));
    
    // get an id
    $id       = $db->GenID(cms_db_prefix() . "module_mamsregistration_users_seq");
    $q        = "INSERT INTO " . cms_db_prefix() . "module_mamsregistration_users (id,group_id,username,password,code,createdate,overwrite_uid)
            VALUES (?,0,?,?,?,NOW(),?)";
    $dbresult = $db->Execute($q, array($id, $username, $password, $code, $overwrite_uid));
    if(!$dbresult)
    {
      return array(FALSE, $db->ErrorMsg());
    }
    
    $q = 'INSERT INTO ' . cms_db_prefix() . 'module_mamsregistration_grps (user,gid) VALUES (?,?)';
    if(!is_array($gid))
    {
      $gid = array((int)$gid);
    }
    foreach($gid as $one)
    {
      $dbr = $db->Execute($q, array($id, $one));
    }
    
    audit($id, $this->GetName(), sprintf('User %s registered', $username));
    
    return array(TRUE, $id);
  }
  
  function CSVOldTempUsers($expirycode)
  {
    $db      = $this->GetDb();
    $expires = $db->DbTimeStamp(strtotime($expirycode));
    // find all the user id's that match
    $q        = "SELECT * FROM " . cms_db_prefix() . "module_mamsregistration_users WHERE createdate < ?";
    $dbresult = $db->Execute($q, array($expires));
    $result   = '';
    
    while($row = $dbresult->FetchRow())
    {
      $vals      = array_values($row);
      $result    .= $row['id'] . "," . $row['username'] . "," . $row['code'] . "," . $row['createdate'] . ",";
      $q2        = "SELECT * FROM " . cms_db_prefix() . "module_mamsregistration_properties WHERE user = ? ORDER by id";
      $dbresult2 = $db->Execute($q2, array($row['id']));
      while($row2 = $dbresult2->FetchRow())
      {
        $result .= $row2['data'] . ",";
      }
      $result .= "end\n";
    }
    
    return $result;
  }
  
  public function EditTempUser($uid, $username, $password, $code = NULL)
  {
    $db = $this->GetDb();
    if($username == '')
    {
      return FALSE;
    }
    
    $q      = "UPDATE " . cms_db_prefix() . "module_mamsregistration_users SET username = ?";
    $params = array($username);
    if($code)
    {
      $q        .= ",code = ?";
      $params[] = $code;
    }
    
    if($password != '')
    {
      $q        .= ",password = ?";
      $mams      = cms_utils::get_module('MAMS');
      $key      = $this->get_encryption_key($username);
      $params[] = base64_encode($this->encrypt($key, $password));
    }
    
    $q        .= " WHERE id = ?";
    $params[] = $uid;
    
    $dbresult = $db->Execute($q, $params);
    if(!$dbresult)
    {
      return array(FALSE, $db->ErrorMsg());
    }
    
    return array(TRUE);
  }
  
  public function ExpireOldTempUsers($expirycode)
  {
    $db      = $this->GetDb();
    $expires = $db->DbTimeStamp(strtotime($expirycode));
    // find all the user id's that match
    $q        = "SELECT id FROM " . cms_db_prefix() . "module_mamsregistration_users WHERE createdate < ?";
    $dbresult = $db->GetCol($q, array($expires));
    
    if(is_array($dbresult) && count($dbresult))
    {
      $this->DeleteTempUser($dbresult);
    }
    
    return TRUE;
  }
  
  /**
   * @internal
   */
  public function DeleteTempUser($uid)
  {
    if(!is_array($uid))
    {
      $uid = array($uid);
    }
    
    $db = $this->GetDb();
    $ql = array();
    $q1 = 'DELETE FROM ' . cms_db_prefix() . 'module_mamsregistration_grps WHERE user IN (' . implode(',', $uid) . ')';
    $db->Execute($q1);
    $q2 = 'DELETE FROM ' . cms_db_prefix() . 'module_mamsregistration_properties WHERE user IN (' . implode(',', $uid) . ')';
    $db->Execute($q2);
    $q3 = "DELETE FROM " . cms_db_prefix() . 'module_mamsregistration_users WHERE id IN (' . implode(',', $uid) . ')';
    $db->Execute($q3);
    
    return TRUE;
  }
  
  /**
   * @internal
   */
  public function DeleteTempUserProperties($uid)
  {
    $db       = $this->GetDb();
    $q        = "DELETE FROM " . cms_db_prefix() . "module_mamsregistration_properties WHERE user = ?";
    $dbresult = $db->Execute($q, array($uid));
    if(!$dbresult)
    {
      return FALSE;
    }
    
    return TRUE;
  }
  
  /**
   * @internal
   */
  public function GetTempUserDetails($uid)
  {
    $db       = $this->GetDb();
    $q        = "SELECT * FROM " . cms_db_prefix() . "module_mamsregistration_users WHERE id = ?";
    $dbresult = $db->GetRow($q, array($uid));
    if(!is_array($dbresult))
    {
      return FALSE;
    }
    
    return $dbresult;
  }
  
  /**
   * @internal
   */
  public function GetTempUserID($username)
  {
    if($username == '')
    {
      return FALSE;
    }
    $db  = $this->GetDb();
    $q   = "SELECT * FROM " . cms_db_prefix() . "module_mamsregistration_users WHERE username = ?";
    $dbr = $db->GetOne($q, array($username));
    if(!$dbr)
    {
      return FALSE;
    }
    
    return $dbr;
  }
  
  /**
   * @internal
   */
  public function GetTempUserProperty($uid, $propname, $dflt = NULL)
  {
    $db  = $this->GetDb();
    $q   = "SELECT data FROM " . cms_db_prefix() . "module_mamsregistration_properties WHERE user = ? AND title =  ?";
    $dbr = $db->GetOne($q, array($uid, $propname));
    if(!$dbr)
    {
      return $dflt;
    }
    
    return $dbr;
  }
  
  /**
   * @internal
   */
  public function GetTempUserProperties($uid)
  {
    $db       = $this->GetDb();
    $q        = "SELECT * FROM " . cms_db_prefix() . "module_mamsregistration_properties WHERE user = ?";
    $dbresult = $db->Execute($q, array($uid));
    if(!$dbresult || $dbresult->RecordCount() == 0)
    {
      return FALSE;
    }
    $result = array();
    while($row = $dbresult->FetchRow())
    {
      $result[] = $row;
    }
    
    return $result;
  }
  
  public function get_product_info($temp_user_id)
  {
    $res                 = array();
    $res['id']           = $temp_user_id;
    $res['product_name'] = 'Account Registration';
    
    return $res;
  }
  
} // end of class
