<h4>Config Variables</h4>

<div class="information">
  <p><b>Note:</b> on install <b>CMSMSExt</b> copies existing <b>config.php</b> entries from <b>CGExtensions</b> to a <b>config.inc</b> situated on its <b>data</b> folder.</p>
</div>
<div class="information">
  <p><b>Note:</b> in the future these settings will be also accessible via this module settings page except for <b>deprecated settings</b>, <b>rarely used settings</b>, or <b>critical settings</b> that should not be easily accessible.</p>
</div>

<p>This functionality listens to a few different <em>(optional)</em> variables in the <b>config.inc</b> file:</p>
<ul>
  <li><code>$config['xt_prettyhtml']</code> = (bool:false)
    <p>A flag indicating wether to prettify the HTML output after rendering.  Note:  The head section is not formatted.</p>
  </li>
  <li><code>$config['xt_minhtml']</code> = (bool:false)
    <p>A flag indicating wether to minify the HTML output after rendering.   If both xt_prettyhtml and xt_minhtml are specified, xt_prettyhtml will have precedence.</p>
  </li>
  <li><code>$config['xtjs_cachelife']</code> = (int:24)
    <p>The number of hours that each signature js and/or css file should be cached for, before being regenerated.  The default is 24 hours.</p>
  </li>
  <li><code>$config['xtjs_nocache']</code> = (bool:false)
    <p>This config entry, if set, and true explicitly disables caching.  The combined css and js files will be regenerated for each request.</p>
  </li>
  <li><code>$config['xtjs_nominify']</code> = (bool:false)
    <p>This config entry, if set, and true explicitly disables minifying of javascript or CSS code, independent of other params or flags.</p>
  </li>
  <li><code>$config['developer_mode']</code> = (bool:false)
    <p>This config entry, if set, and true explicitly disables the behavior of the &lbrace;xt_cache} and &lbrace;xt_cache_block} plugins.</p>
  </li>
  <li><code>$config['xt_relax_sql']</code> = (bool:false)
    <p>This config entry, if set, and true attempts to set the mysql sql_mode to TRADITIONAL to fix some errors cropping up in queries for users running mysql 5.7+</p>
  </li>
  <li><code>$config['xt_ignore_csrf']</code> = (bool:false)
     <p>This config entry, if set and true indicates that CSRF tokens set by the &lbrace;xt_form_csrf} tag should be ignored.  This is not recommended.</p>
  </li>
  <li><code>$config['xt_upload_allowed_filetypes']</code> = (string)
     <p>This config entry, if set indicates a list of file types that can be uploaded by modules that use the xt_fileupload functionality.  If not specified no filtering is done.</p>
     <p>This config entry, if specified should contain a comma separated list of file extensions (case insensitive).</p>
  </li>
  <li><code>$config['xt_imageextensions']</code> = (string:jpg,jpeg,png)
  </li>
  <li><code>$config['xt_allow_watermarking']</code> = (bool:false)
  </li>
  <li><code>$config['xt_watermark_text']</code> = (string:CMSMS SITE NAME)
  </li>
  <li><code>$config['xt_watermark_textsize']</code> = (int:12)
  </li>
  <li><code>$config['xt_watermark_angle']</code> = (int:0)
  </li>
  <li><code>$config['xt_watermark_font']</code> = (string:ARIAL.TTF)
  </li>
  <li><code>$config['xt_watermark_textcolor']</code> = (string:#FFFFFF)
  </li>
  <li><code>$config['xt_watermark_bgcolor']</code> = (string:#000000)
  </li>
  <li><code>$config['xt_watermark_transparent']</code> = (bool:true)
  </li>
  <li><code>$config['xt_watermark_file']</code> = (string:null)
      <p>The name of an image file, relative to either the uploads directory or the assets path to use when watermarking images.</p>
  </li>
  <li><code>$config['xt_watermark_alignment']</code> = (int:0)
      <ul>
          <li>0 = Upper Left</li>
          <li>1 = Upper Center</li>
          <li>2 = Upper Right</li>
          <li>3 = Middle Left</li>
          <li>4 = Middle Center</li>
          <li>5 = Middle Right</li>
          <li>6 = Lower Left</li>
          <li>7 = Lower Center</li>
          <li>8 = Lower Right</li>
      </ul>
  </li>
  <li><code>$config['xt_watermark_translucency']</code> = (int:100)
  </li>
  <li><code>$config['xt_allow_preview']</code> = (bool:false)
  </li>
  <li><code>$config['xt_preview_size']</code> = (int:800)
  </li>
  <li><code>$config['xt_delete_orig_image']</code> = (bool:false)
  </li>
  <li><code>$config['xt_allow_thumbnailing']</code> = (bool:false)
  </li>
  <li><code>$config['xt_thumbnail_size']</code> = (int:75)
  </li>
  <li><code>$config['xxxxxxxxx_adminsection']</code> = (string:extensions)
      <p>For some modules derived from CMSMSExt, Config entries that begin with the module name in lowercase, and followed by _adminsection allow
         specifying the section of the admin navigation that the module will appear in.  Possible values are: content, layout, files, usergroups, extensions, preferences, siteadmin, myprefs, ecommerce.</p>
      <p>i.e: <code>$config['cgblog_adminsection'] = 'content';</code></p>
    <div class="information">
      <p><b>Note:</b> this functionality does not work for all modules.  Only modules that were updated in the later half of 2019 or later. Other modules may have other means of changing the admin section.</p>
    </div>
  </li>
</ul>

<h3>Admin Styles</h3>
<p>This module, and all modules derived from CMSMSExt support loading a separate stylesheet for use in admin requests for that module.  This allows adjusting styles on a per-module basis within the admin console.</p>
<p>To use this, plase a file named admin_styles.css in the <root>/module_custom/<modulename>/css directory, with the css that you want to adjust or override.  i.e:  for the FrontEndUsers module you would:</p>
<p><pre><code>mkdir -p module_custom/FrontEndUsers/css
vi module_custom/FrontEndUsers/css/admin_styles.css</code></pre></p>

<h3>Email and Email Templates</h3>
<p>This module provides a set of classes to allow storing email templates, and destination email address configurations in files.  This is perfect for applications where as much as possible should be stored in files to allow for revision control, and to allow for easier migration between development, staging, and live environments.</p>
<p>The Email API's must be utilized by other third party modules that wish to send mails.</p>
<h4>File location:</h4>
<p>The Email functionality looks for files ending with .eml first in your <code>$config['assets_path']/emails</code>.  Which is by default <code>&lt;cmsms root&gt;/assets/emails</code>.</p>
<p>Next this functionality will look in <code>$config['assets_path']/module_custom/&lt;module name&gt;/emails</code>.</p>
<p>Lastly this functionality will look for the .eml file in the module's email directory, in the module source directory.  You should never modify these files directly.</p>
<h4>File format:</h4>
<p>The files must end in a <code>.eml</code> extension, and be ASCII files.  The file is divided into 3 primary parts separated by lines starting with and ending with ====.</p>
<ul>
   <li>The top configuration section (in ini file format</li>
   <li>The smarty template for the email subject.</li>
   <li>The smarty template for the email body.</li>
</ul>
<h4>Example: <code>assets/emails/feu_onloginfailed.eml</code></h4>
<pre>[email]
to_admin_groups=Admin
to_feu_groups=
to_current_admin=0
to_current_feu=0
to_addr=some.email@domain.com
to_addr=another.email@domain.com
==== subject ====
User login failed for &lbrace;$username}

==== body ====
A user login at &lbrace;$ip} attempted to login at &lbrace;sitename} with username &lbrace;$username} and failed.

</pre>
<h4>Accepted ini keys</h4>
<ul>
    <li><code>to_admin_groups</code> : string array - An array of admin group ids or names to which this email should be sent. Separated by commas.</li>
    <li><code>to_feu_groups</code> : string array - An array of FEU group ids or names to which this email should be sent. Separated by commas.</li>
    <li><code>to_current_admin</code> : bool - Indicates that this email should be sent to the currently logged in admin user (if available).</li>
    <li><code>to_current_feu</code> : bool - Indicates that this email should be sent to the currently logged in FEU user (if available).</li>
    <li><code>to_addr</code> : string array - An array of fixed email addresses to receive this message.</li>
    <li><code>cc_addr</code> : string array - An array of fixed email addresses to be carbon copied on this message.</li>
    <li><code>bcc_addr</code> : string array - An array of fixed email addresses to be blind carbon copied on this message.</li>
    <li><code>priority</code> : int [1-5] - An integer priority for the email system (clients may ignore this).  1 = High Priority,  5 = low priority.   3 is the default.</li>
    <li><code>encode_subject</code> : bool - Indicates that the subject for this email should be base64 encoded.</li>
</ul>
<h4>Notes:</h4>
<ul>
  <li>Only ASCII characters are allowed in the email subject line, therefore you may need to decode entities from some plugins for use in the subject, or base64 encode the subject using the encode_subject flag in the ini section.</li>
  <li>Translation in emails is not a straightforward process.
      <p>Primarily because different emails can be triggererd from different processes and it may not be possible to determine the language that should be used for a particular user. It is usually best to begin with hardcoding the language in the email content until you know better how the messages work.</p>
      <p>For example: it is difficult to know what language to use when an email is sent to a site visitor triggered by a background task or an admin action.  It is also difficult to know what language to use when an email is sent to multiple admin users.</p>
      <p>If you would like the ability to translate emails for each particular user, AND can determine what that language should be, then you may want to use the CGml and CGmlGUI modules for creating and managing translations that are separate from the modules you are using.</p>
  </li>
  <li>See the documentation for the CMSMSExt\Email\Email, CMSMSExt\Email\FileEmailStorage, and CMSMSExt\Email\SimpleEmailProcessor classes in theAPI documentation for the methods that are available.</li>
</ul>

<h4>Additional smarty data.</h4>
<p>The <code>\CMSMSExt\Email\Email</code> class has methods to add additional smarty variables to the email before template processing.  This is done in code. In code file attachments can also be provided.  The example above assumes that the code that triggers this email will add the &lbrace;$ip} and &lbrace;$username} varaibles.</p>
<h4>Sample:</h4>
<p>This code illustrates a potential handler for the FrontEndUsers modules's onLoginFailed Event.  This code would potentially go into a third party module's constructor.</p>
<pre><code>
\CMSMS\HookManager::add_hook( 'FrontEndUsers::onLoginFailed', function( $params ) &lbrace;
    // this method provided by CMSMSExt loads the email object.
    $eml = $this->get_email_storage()->load('feu_onloginfailed.eml');
    // add data specific for this hook.
    $eml = $eml->add_data('ip',$params['ip'])->add_data('username',$params['username']);

    $mailer = new \cms_mailer;
    $sender = new \CMSMSExt\Email\SimpleEmailProcessor( $eml, $mailer );
    $sender->send()
});
</code></pre>

<h3>File Templates</h3>
<ul>
    <li>sortable list template - <code>sortablelist.tpl</code>
    </li>
    <li>error template - <code>error.tpl</code>
    </li>
</ul>

<h3>Admin side javascript</h3>
<p>This module utilizes the GetHeaderHTML() method to inject some javascript utilities that can be used by any module that extends \CMSMSExt\XTModule in their admin panel.</p>
<ul>
    <li>Make buttons work like links
        <p>Creating a button with a data-href attribute that has a URI in it will cause the button to redirect to the URI when clicked.</p>
	<pre>&lt;button data-href="http://www.cmsmadesimple.org"&gt;go&lt;button&gt;</pre>
    </li>
</ul>