<h3>Dynamic CSS and Javascript</h3>
<p>Frequently when doing site design, some javascript plugins and custom css are needed explicitily for a single page, or a single form.  You often need to include some javascript code that is unique to that page or form to initialize or activate jquery plugins.   Next you may need to add some specific css styles that will only be used on this page or for this form.  It would be best (for management reasons) if all of that code (requesting the javascript libraries, including extra javascript and/or css) could be maintained from within the single template where it will be used.   However, including javascript inline can impede performance, it is bad form to include javascript libraries from within the (middle) of the html page, and it is bad form and problematic to embed inline stylesheets into html output. The CMSMSExt module <em>(v 1.39+)</em> Introduces a few new tags to allow inserting javascript and stylesheets in a &quot;reasonably&quot; cache efficient, and convenient to use mechanism.</p>

<p>The CMSMSExt plugins &lbrace;xtjs_require}, &lbrace;xtjs_add}, &lbrace;xtcss_add} and &lbrace;xtjs_render} allow queing javascript libraries (with their dependencies), single javascript and css files, and inline css and js into single minified urls (one for javascript, and one for css).  This aides in performance (as multiple javascript and css files are concatenated and minified), keeps all relevant code (smarty. javascript, and css) together, and eliminates the issuees of inline code.</p>

<h4>Javascript Libraries</h4>
<p>Numerous CMSMSExt derived modules (MAMS, MAMSRegistration, etc) share various javascript libraries. Requiring that these libraries be included in your output html code is as simple as using the <code>&lbrace;xtjs_require lib=&lt;libname&gt;}</code> tag in the relavent template.</p>

<h4>Rendering Output</h4>
<p>The <code>&lbrace;xtjs_render}</code> tag will open all required libraries <em>(and their dependencies)</em>, all required javascript and css files, and all inline javascript and css files, concatenate them into a single javascript file, and a single css file.  Each unique combination of requested libraries, javascript, and css files, and inlined code is hashed into a single 'signature', which is used to determine the output javascript and css filenames.  The tag will then concatenate all of the javascript, minify it, and output to a single javascript file.  Similarly css is output to a single minimized css file.   To improve server side performance, the render functionality will not resolve dependencies, or generate the resulting javascript and css files if the output files already exist (unless they are older than the preset expiry age).</p>
<p>The <code>&lbrace;xtjs_render}</code> tag should (typically) be put just before the end of the &lt;head&gt; section of the page template. This is because it renders javascript and stylesheets.</p>

<h4>Admin Templates</h4>
<p>The <code>xt_jsloader::render()</code> function is called automatically for each CMSMSExt derived admin action.  This means that the &lbrace;xtjs_require}, &lbrace;xtjs_add} and &lbrace;xtcss_add} plugins can all be used from within action templates for CMSMSExt derived modules.</p>

<p><strong>Note:</strong> In admin requests, because the CMSMS standard OneEleven admin theme automatically includes the jquery, and jquery ui plugins, these plugins are automatically excluded from rendered output.</p>