<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CMSMSExt (c) 2020-2021 by CMS Made Simple Foundation
#  An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: CGExtensions (c) 2008-2014 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 * A set of high level convenience methods.
 *
 * @package CMSMSExt
 * @category Utilities
 * @author  calguy1000 <calguy1000@cmsmadesimple.org>
 * @copyright Copyright 2010 by Robert Campbell
 */

/**
 * A class to provide some methods for managing templates.
 */
final class xt_template_utils
{
    /**
     * @ignore
     */
    private function __construct() {}

    /**
     * Get all of the templates for a specific (or the current moduel) that begin with a specified prefix.
     *
     * @param string $mod The module name.  If none specified, the current module is assumed.
     * @param string $prefix A prefix to filter templates by.
     * @param bool $trim Wether the prefix should be trimmed from the output array.
     * @return string[]
     */
    public static function get_templates_by_prefix($mod = '',$prefix = '',$trim = false)
    {
        if( !is_object($mod) || !($mod instanceof CMSModule) ) $mod = xt_utils::get_module();

        $templates = $mod->ListTemplates();
        if( $prefix == '' ) return $templates;

        $items = array();
        foreach( $templates as $onename ) {
            if( preg_match('/^'.$prefix.'/',$onename) ) {
                if( $trim ) {
                    $items[] = substr($onename,strlen($prefix));
                }
                else {
                    $items[] = $onename;
                }
            }
        }
        return $items;
    }

    /**
     * Get a list of templates in the form of a dropdown.
     *
     * @deprecated
     * @param string $id The module action id.
     * @param string $name The name of the dropdown.
     * @param string $prefix The prefix for templates.
     * @param string $selectedvalue The item that should be currently selected.
     * @param string $addtext Additional text for the select element.
     */
    public static function create_template_dropdown($id,$name,$prefix = '',$selectedvalue = -1,$addtext = '')
    {
        $templates = self::get_templates_by_prefix('',$prefix);
        $items = array();
        foreach( $templates as $onename ) {
            $tmp = substr($onename,strlen($prefix));
            $items[$tmp] = $onename;
        }

        return xt_utils::get_module()->CreateInputDropdown($id,$name,$items,-1,$selectedvalue,$addtext);
    }
}

#
# EOF
#
?>