<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CMSMSExt (c) 2020-2021 by CMS Made Simple Foundation
#  An add-on module for CMS Made Simple to provide useful functions
#  and commonly used gui capabilities to other modules.
#-------------------------------------------------------------------------
# A fork of:
#
# Module: CGExtensions (c) 2008-2014 by Robert Campbell
#         (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# CMSMS - CMS Made Simple is (c) 2006 - 2021 by CMS Made Simple Foundation
# CMSMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# Visit the CMSMS Homepage at: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

use CMSMS\HookManager;
use CMSMSExt\FileTemplateResource;
use CMSMSExt\HourlyHookTask;
use CMSMSExt\DailyHookTask;
use CMSMSExt\internal\settings;
use CMSMSExt\smarty_plugins;

/**
 * @ignore
 */
define('CMSMSEXT_TABLE_ASSOCDATA', cms_db_prefix() . 'module_cmsmsext_assocdata');

function __xt_unserialize_callback(string $classname)
{
  throw new \RuntimeException('Cannot unserialize object of type ' . $classname);
}

# a minor temp hack for now (JM)
include_once cms_join_path( __DIR__ , 'lib' , 'class.XTModule.php');

/**
 * A base class for CMSMS modules
 * to provide optimizations
 * and conveniences that are not built into CMSMS.
 *
 * @package CMSMSExt
 */
class CMSMSExt extends \CMSMSExt\XTModule
{
  /**
   * @ignore
   */
  private static $_initialized;
  
  function __construct()
  {
    spl_autoload_register(array($this, 'autoload'));
    parent::__construct();
  
    global $CMS_INSTALL_PAGE, $CMS_PHAR_INSTALL;
  
    if(isset($CMS_INSTALL_PAGE) || isset($CMS_PHAR_INSTALL)){return;}
    
    $class = get_class($this);
  
    if(!defined('MOD_' . strtoupper($class)))
    {
      /**
       * @ignore
       */
      define('MOD_' . strtoupper($class), $class);
    }
    
    if(self::$_initialized || $class != 'CMSMSExt'){return;}
  
    self::$_initialized = TRUE;
    
    ini_set('unserialize_callback_func', '__xt_unserialize_callback');
    
    HookManager::add_hook('Core::ContentPostRender', [$this, 'onContentPostRender'], HookManager::PRIORITY_LOW);
  
    $smarty = $this->cms->GetSmarty();
  
    if(!$smarty)  return;

    $smarty->register_resource('xt_modfile', new FileTemplateResource());

    # ????
    $_plugins = new smarty_plugins($this, $smarty);
    $_utils = new xt_utils($this, $this->xt_settings());
    $_image = new xt_image($this->xt_settings()->thumbnailsize);
    $_setup = new xt_setup($this->config, $this->xt_settings(), $this->GetModulePath());
    
    $db = cms_utils::get_db();
  
    if(is_object($db))
    {
      $query = 'SET @xt_ZEROTIME = NOW() - INTERVAL 150 YEAR,@xt_FUTURETIME = NOW() + INTERVAL 5 YEAR';
      $db->Execute($query);
      //$config = $this->config;
      $config = \CMSMSExt\config::GetInstance();
      if(xt_param::get_bool($config, 'xt_relax_sql'))
      {
        $query = 'SET SESSION sql_mode=\'TRADITIONAL\'';
        $db->Execute($query);
      }
    }

  }
  
  public function autoload($classname)
  {
    if(!is_object($this)){return FALSE;}
    
    // check for classes.
    $path = $this->GetModulePath() . '/lib';
    
    if(strpos($classname, '\\') !== FALSE)
    {
      $t_path = str_replace('\\', '/', $classname);
      
      if(startswith($t_path, $this->GetName() . '/'))
      {
        $classname = basename($t_path);
        $t_path    = dirname($t_path);
        $t_path    = substr($t_path, strlen($this->GetName()) + 1);
        $path      = $this->GetModulePath() . '/lib/' . $t_path;
      }
    }
    
    $fn = $path . "/class.{$classname}.php";
    
    if(is_file($fn))
    {
      require_once($fn);
      
      return TRUE;
    }
    
    // check for abstract classes.
    $fn = $path . "/abstract.{$classname}.php";
    
    if(is_file($fn))
    {
      require_once($fn);
      
      return TRUE;
    }
    
    // check for interfaces
    $fn = $path . "/interface.{$classname}.php";
    
    if(is_file($fn))
    {
      require_once($fn);
      
      return TRUE;
    }
    
    // check for traits
    $fn = $path . "/trait.{$classname}.php";
    
    if(is_file($fn))
    {
      require_once($fn);
      
      return TRUE;
    }
    
    // check for a master file
    $fn = $this->GetModulePath() . "/lib/extraclasses.php";
    
    if(is_file($fn))
    {
      require_once($fn);
      
      return TRUE;
    }
    
    return FALSE;
  }
  
  /**
   * Return the version of this module.
   *
   * @return string
   * @see CMSModule::GetVersion()
   * @abstract
   */
  public function GetVersion()
  {
    return '1.0';
  }
  
  
  /**
   * Return the Author of this module.
   *
   * @return string
   * @see CMSModule::GetAuthor()
   * @abstract
   */
  public function GetAuthor(){ return 'Fernando Morgado (Jo Morg)'; }
  
  /**
   * Return the email address for the author of this module.
   *
   * @return string
   * @see CMSModule::GetAuthorEmail()
   * @abstract
   */
  public function GetAuthorEmail(){ return 'jomorg@cmsmadesimple.org'; }
  
  
  /**
   * Return if this is a plugin module (for the frontend of the website) or not.
   *
   * @return bool
   * @see CMSModule::IsPluginModule()
   * @abstract
   */
  public function IsPluginModule()
  {
    return TRUE;
  }
  
  /**
   * Return if this module has an admin section.
   *
   * @return string
   * @see CMSModule::HasAdmin()
   * @abstract
   */
  public function HasAdmin()
  {
    return TRUE;
  }
  
  /**
   * @ignore
   */
  function HasCapability($capability, $params = array())
  {
    switch($capability)
    {
      case 'tasks':
        return TRUE;
    }
    
    return FALSE;
  }
  
  /**
   * @ignore
   */
  public function get_tasks()
  {
    $out   = NULL;
    $out[] = new HourlyHookTask();
    $out[] = new DailyHookTask();
    
    return $out;
  }
  
  /**
   * Get the section of the admin navigation that this module belongs to.
   *
   * @abstract
   * @return string
   */
  public function GetAdminSection()
  {
    $name = strtolower($this->GetName() . '_adminsection');
    
    return xt_param::get_string($this->config, $name, 'extensions');
  }
  
  /**
   * Get a human readable description for this module.
   *
   * @abstract
   * @return string
   */
  public function GetAdminDescription()
  {
    if(get_class($this) == MOD_CMSMSEXT)
    {
      return $this->Lang('moddescription');
    }
    
    return parent::GetAdminDescription();
  }
  
  /**
   * Get a hash containing dependent modules, and their minimum versions.
   *
   * @abstract
   * @return string
   */
  public function GetDependencies(){ return []; }
  
  /**
   * Display a custom message after the module has been installed.
   *
   * @abstract
   * @return string
   */
  public function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }
  
  /**
   * Return the minimum CMSMS version that this module is compatible with.
   *
   * @abstract
   * @return string
   */
  public function MinimumCMSVersion(){ return '2.2.9'; }
  
  /**
   * Return a message to display after the module has been uninstalled.
   *
   * @abstract
   * @return string
   */
  public function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }
  
  /**
   * Test if this module is visible in the admin navigation to the currently logged in admin user.
   *
   * @abstract
   * @return bool
   */
  public function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Site Preferences') || $this->CheckPermission('Modify Templates');
  }
  
  /**
   * Get a settings object
   *
   * @return settings
   */
  protected function xt_settings() : settings
  {
    static $_obj;
    
    if(!$_obj)
    {
      $_obj = new settings($this->config);
    }
    
    return $_obj;
  }
  
  
  /*************************************/
  /**
   * backward compatibility
   */
  
  /**
   * A convenience method to generate a new smarty template object given a resource string,
   * and a prefix.  This method will also automatically assign a few common smarty variables
   * to the new scope.
   *
   * Note: the parent smarty scope depends on how this function is called.  If called directly from a module action for
   * the same module the parent will be the current smarty scope.  If called from any method that is using a different
   * module than the action module, then the parent scope will be the global smarty scope.
   *
   * @param string $template_name The desired template name.
   * @param string $prefix        an optional prefix for database templates.
   * @param string $cache_id      An optional smarty cache id.
   * @param string $compile_id    An optional smarty compile id.
   * @param object $parent        An optional parent template object.
   *
   * @return object
   */
  public function CreateSmartyTemplate(
    string $template_name, string $prefix = NULL, string $cache_id = NULL, string $compile_id = NULL, $parent = NULL
  )
  {
    $smarty = NULL;
    
    if($parent){$smarty = $parent;}
    
    if(!$smarty){$smarty = $this->GetActionTemplateObject();}
    
    if(!$smarty){$smarty = $this->cms->GetSmarty();}
    
    $tpl = $smarty->createTemplate(
      $this->XTGetTemplateResource($template_name, $prefix), $cache_id, $compile_id, $smarty
    );
    
    // for convenience, we assign a few smarty variables.
    $tpl->assign('module', $this->GetName());
    $tpl->assign($this->GetName(), $this);
    $tpl->assign('mod', $this);
    $tpl->assign('actionid', $this->get_action_id());
  
    if(($actionparams = $smarty->getTemplateVars('actionparams')))
    {
      $tpl->assign('actionparams', $actionparams);
    }
  
    return $tpl;
  }
  
  
  
  /*********************************************************************************************************/
  
} // class

/**
 * @ignore
 */
function xt_lang()
{
  $mod  = cms_utils::get_module(MOD_XTMODULE);
  $args = func_get_args();
  
  return call_user_func_array(array($mod, 'Lang'), $args);
}

?>