<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if( !defined('CMS_VERSION') ) exit;

// Setup Module Permissions
$this->CreatePermission(Dashboard::USE_PERM,'Dashboard - Use');
$this->CreatePermission(Dashboard::MANAGE_PERM,'Dashboard - Manage');

// Set Preferences
$this->SetPreference('friendly_name', 'Dashboard');
$this->SetPreference('admin_section', 'extensions');

// Create Table module_nestedadmin2
$db = $this->GetDb();
$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');
$fields = "
   id I KEY AUTO,
   title C(255) NOTNULL,
   section C(20),
   url C(255),
   new_tab I1,
   dashboard C(255)
   ";
$sqlarray = $dict->CreateTableSQL(CMS_DB_PREFIX.'module_dashboard', $fields, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);


// add to Admin Log
$this->Audit(0, $this->Lang('friendlyname'), $this->Lang('installed', $this->GetVersion()));


