<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

class DashboardQuery extends CmsDbQueryBase {

   public function __construct($args = '') {
      parent::__construct($args);
   }

   public function execute() {
      if ( !is_null($this->_rs) ) return;
      $sql = 'SELECT * FROM '.CMS_DB_PREFIX.'module_dashboard';
      if ( isset($this->_args['new_tab']) ) {
         // store only new_tab or non-new_tab items
         $tmp = $this->_args['new_tab'];
         if ( $tmp === 0 ) {
            $sql .= ' WHERE new_tab = 0';
         } else if ( $tmp === 1 ) {
            $sql .= ' WHERE new_tab = 1';
         }
      }
      $db = \cms_utils::get_db();
      $this->_rs = $db->Execute($sql);
      if ( $db->ErrorMsg() ) throw new \CmsSQLErrorException( $db->sql.' -- '.$db->ErrorMsg() );
      $this->_totalmatchingrows = $db->GetOne('SELECT FOUND_ROWS()');
   }

   public function &GetObject() {
      $obj = new DashboardItem;
      $obj->fill_from_array($this->fields);
      return $obj;
   }



}


