<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

class DashboardItem {

   private $_data = array(
      'id' => null,
      'title' => null,
      'section' => 'extensions',
      'url' => null,
      'new_tab' => false,
      'dashboard' => null
   );

   public function __get($key) {
      switch( $key ) {
         case 'id':
         case 'title':
         case 'section':
         case 'url':
         case 'new_tab':
         case 'dashboard':
            return $this->_data[$key];
      }
   }

   public function __set($key,$val) {
      switch( $key ) {
         case 'title':
            $this->_data[$key] = trim($val);
            break;
         case 'section':
            $this->_data[$key] = trim($val);
            break;
         case 'url':
            $this->_data[$key] = trim($val);
            break;
         case 'new_tab':
            $this->_data[$key] = (bool) $val;
            break;
         case 'dashboard':
            $this->_data[$key] = trim($val);
            break;
      }
   }

   public function save() {
      // test if valid before calling save()
      if ( $this->id > 0 ) {
         $saved = $this->update();
      } else {
         $saved = $this->insert();
      }
      return $saved;

   }

   protected function insert() {
      $db = \cms_utils::get_db();
      $sql = 'INSERT INTO '.CMS_DB_PREFIX.'module_dashboard (title, section, url, new_tab, dashboard) VALUES (?,?,?,?,?)';
      $dbr = $db->Execute($sql, array($this->title, $this->section, $this->url, $this->new_tab, $this->dashboard));
      if( !$dbr ) return FALSE;
      $this->_data['id'] = $db->Insert_ID();
      return TRUE;
   }

   protected function update() {
      $db = \cms_utils::get_db();
      $sql = 'UPDATE '.CMS_DB_PREFIX.'module_dashboard SET title = ?, section = ?, url = ?, new_tab = ?, dashboard = ? WHERE id = ?';
      $dbr = $db->Execute($sql, array($this->title, $this->section, $this->url, $this->new_tab, $this->dashboard, $this->id));
      if( !$dbr ) return FALSE;
      return TRUE;
   }

   public function delete() {
      if( !$this->id ) return FALSE;
      $db = \cms_utils::get_db();
      $sql = 'DELETE FROM '.CMS_DB_PREFIX.'module_dashboard WHERE id = ?';
      $dbr = $db->Execute($sql,array($this->id));
      if( !$dbr ) return FALSE;
      $this->_data['id'] = null;
      return TRUE;
   }


   /** internal */
   public function fill_from_array($row) {
      foreach( $row as $key => $val ) {
         if( array_key_exists($key,$this->_data) ) {
            $this->_data[$key] = $val;
         }
      }
   }

   public static function &load_by_id($id) {
      $id = (int) $id;
      $db = \cms_utils::get_db();
      $sql = 'SELECT * FROM '.CMS_DB_PREFIX.'module_dashboard WHERE id = ?';
      $row = $db->GetRow($sql,array($id));
      if( is_array($row) ) {
         $obj = new self();
         $obj->fill_from_array($row);
         return $obj;
      }
   }



}
