<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

$lang['friendly_name'] = 'Dashboard';
$lang['postinstall'] = 'Successfully installed!';
$lang['postuninstall'] = 'See you soon!';
$lang['postuninstall_instance'] = 'The admin menu item: %s - has been removed.';
$lang['really_uninstall'] = 'Really? You\'re sure you want to uninstall this fine module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['prefsupdated'] = 'Module preferences updated.';

// admin menu items
$lang['admin_menu_items'] = 'Admin Menu Items';
$lang['title_menu_items'] = 'Menu Items';
$lang['title_admin_section'] = 'Admin Section';
$lang['title_url'] = 'URL';
$lang['title_edit'] = 'Edit';
$lang['title_delete'] = 'Delete';
$lang['none'] = 'none';
$lang['add_menu_item'] = 'Add menu item';
$lang['prompt_menu_name'] = 'Menu text';

// module admin section options
$lang['main'] = 'Main';
$lang['content'] = 'Content';
$lang['layout'] = 'Layout';
$lang['usersgroups'] = 'User Management';
$lang['extensions'] = 'Extensions';
$lang['siteadmin'] = 'Site Admin';
$lang['myprefs'] = 'My Preferences';
$lang['ecommerce'] = 'E-Commerce';


// options
$lang['options'] = 'Options';
$lang['prompt_friendly_name'] = 'Custom Module Name';
$lang['prompt_url'] = 'URL of website to be displayed';
$lang['prompt_url_help'] = 'URL to start with protocol: https://, http://, or //';
$lang['prompt_admin_section'] = 'Module admin section';
$lang['prompt_new_tab'] = 'Open in new tab';
$lang['prompt_new_tab_help'] = 'opens in a new tab';
$lang['prompt_dashboard'] = 'Dashboard content';
$lang['prompt_dashboard_help'] = 'Content that will be displayed to the user, can include Smarty tags, UDTs or templates e.g. {include file="blah"}. Leave Url field empty.';

$lang['options_updated'] = 'Options have been successfully updated.';
$lang['moddescription'] = 'Extend the admin interface by linking to or embedding external websites or create a simple dashboard page with CMSMS.';

$lang['submit'] = 'Submit';
$lang['cancel'] = 'Cancel';
$lang['menu_updated'] = 'Admin menu updated';
$lang['confim_delete'] = 'Are you sure you want to delete menu item: %s?';
$lang['deleted'] = 'Dashboard item has been deleted';

// errors
$lang['error_menu_text_empty'] = 'Menu text required';
$lang['error_module_already_exists'] = 'A Module of the same name already exists';
$lang['error_instance_does_not_exist'] = 'Module \'%s\' does not seem to exist';









###    ###   #########   ###        #########
###    ###   #########   ###        #########
###    ###   ###         ###        ###   ###
##########   #########   ###        #########
##########   #########   ###        #########
###    ###   ###         ###        ###
###    ###   #########   #########  ###
###    ###   #########   #########  ###

$lang['help'] = <<<EOT

<h3>What does this do?</h3>
<p>Dashboard allows you to embed or link to other websites and create dashboard pages inside the CMSMS admin area.</p>
<p>You can add multiple menu items, choose the admin section for that menu item, and add/edit the url to embed, or dashboard content</p>
<p>Note: this uses an iframe to include an external website/dashboard within CMSMS. Some 3rd party sites, block their content from working cross domain - i.e. Google Analytics. For those sites you can open a new tab to display the full external website.</p>
<br>


<h3>Dashboard content</h3>
<p>This is a option that is processed by Smarty. Simply call a UDT or include a template, to generate a dashboard that can be shown to authorised users. The 'Url' field must be left empty for the dashboard content to be used.</p>
<p>A sample template is provided with the module, just put the following in the Dashboard content field:<br>
   {include file='module_file_tpl:Dashboard;dashboard_template_sample.tpl'}</p>
<p>Alternatively copy the template from 'modules/Dashboard/templates/dashboard_template_sample.tpl' into a Design Manager core generic template, e.g. 'dashboard_sample' and put the following in the Dashboard content field:<br>
   {include file='cms_template:dashboard_sample'}</p>
<br>


<h3>Permissions</h3>
<p>Permissions can be added both for Managing the Dashboard menu items and for Using the menu items.</p>
<br>


<h3>History &amp; Inspiration</h3>
<p>The module has been inspired by:</p>
<ul>
   <li>NestedAdmin (the original) - developed by Jonathan Schmid (Foaly*) - this module is a fork of that original</li>
   <li>Simon Radford - www.conceptfactory.com.au - for the drive and support to develop this module</li>
</ul>
<br>


<h3>Support</h3>
<p>As per the GPL licence, this software is provided as is. Please read the text of the license for the full disclaimer.
The module author is not obligated to provide support for this code. However you might get support through the following:</p>
<ul>
   <li>For support, first <strong>search</strong> the <a href="//forum.cmsmadesimple.org" target="_blank">CMS Made Simple Forum</a>, for issues with the module similar to those you are finding.</li>
   <li>Then, if necessary, open a <strong>new forum topic</strong> to request help, with a thorough description of your issue, and steps to reproduce it.</li>
   <li>Contact me via the CMS Made Simple Slack channel @KiwiChris</li>
   <li>If you find a bug you can <a href="http://dev.cmsmadesimple.org/bug/list/000tbc" target="_blank">submit a Bug Report</a>.</li>
   <li>For any good ideas you can <a href="http://dev.cmsmadesimple.org/feature_request/list/000tbc" target="_blank">submit a Feature Request</a>.</li>
   <li>If you found the Module useful - shout out to me on Twitter <a href="//twitter.com/KiwiChrisBT">@KiwiChrisBT</a></li>
</ul><br>


<h3>Copyright &amp; Licence</h3>
<p>Copyright © 2019, Chris Taylor <chris at binnovative dot co dot uk>. All Rights Are Reserved.</p><br>
<p>This module has been released under the GNU Public License v3. However, as a special exception to the GPL, this software is distributed as an addon module to CMS Made Simple. You may only use this software when there is a clear and obvious indication in the admin section that the site was built with CMS Made Simple!</p><br>
<br>
EOT;









#########  ###    ###  ##########  ###    ###  #########  ########  ###       #########  #########
#########  ###    ###  ##########  ####   ###  #########  ########  ###       #########  #########
###        ###    ###  ###    ###  #####  ###  ###        ###       ###       ###   ###  ###
###        ##########  ##########  ### ## ###  ###        ########  ###       ###   ###  ###
###        ##########  ##########  ###  #####  ###   ###  ########  ###       ###   ###  ###   ###
###        ###    ###  ###    ###  ###   ####  ###   ###  ###       ###       ###   ###  ###   ###
#########  ###    ###  ###    ###  ###    ###  #########  ########  ######### #########  #########
#########  ###    ###  ###    ###  ###    ###  #########  ########  ######### #########  #########

$lang['changelog'] = <<<EOD

<h3>Version 1.2 - 01Jul20</h3>
<ul>
   <li>Bug fix</li>
</ul>
<br>

<h3>Version 1.1 - 01Jul20</h3>
<ul>
   <li>Bug fix for permissions</li>
</ul>
<br>

<h3>Version 1.0 - 29Jun20</h3>
<ul>
   <li>Initial release. A fork of Nested Admin module v1.0.2, that is compatible with CMSMS v2+</li>
</ul>
<br>

EOD;


