<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if ( !defined('CMS_VERSION') ) exit;
if ( !$this->CheckPermission(Dashboard::MANAGE_PERM) &&
     !$this->CheckPermission(Dashboard::USE_PERM) ) {
         $this->ShowErrors( $this->Lang('need_permission') );
         return;
}


if (isset($params['message'])) {
	echo $this->ShowMessage($this->Lang($params['message']));
}

if (isset($params['errors']) && count($params['errors'])) {
	echo $this->ShowErrors($params['errors']);
}

// Create Admin tabs
echo $this->StartTabHeaders();
echo $this->SetTabHeader( 'maintab', $this->Lang('admin_menu_items') );
echo $this->SetTabHeader( 'optiontab', $this->Lang('options') );
echo $this->EndTabHeaders();

// Create Tab content
echo $this->StartTabContent();

   echo $this->StartTab('maintab');
   include dirname(__FILE__) . '/function.admin_maintab.php';
   echo $this->EndTab();

   echo $this->StartTab('optiontab');
   include dirname(__FILE__) . '/function.admin_optiontab.php';
   echo $this->EndTab();

echo $this->EndTabContent();


