<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if( !defined('CMS_VERSION') ) exit;

if ( !$this->CheckPermission(Dashboard::MANAGE_PERM) &&
     !$this->CheckPermission(Dashboard::USE_PERM) ) return;

if (isset($params['message'])) {
   echo $this->ShowMessage($this->Lang($params['message']));
}

if (isset($params['errors']) && count($params['errors'])) {
   echo $this->ShowErrors($params['errors']);
}

$menuItem = new DashboardItem();
if ( isset($params['itemid']) && $params['itemid']>0 ) {
   $menuItem = $menuItem::load_by_id( (int)$params['itemid'] );
}

$smarty = \CmsApp::get_instance()->GetSmarty();
$menuItemUrl = $menuItem->url;
$menuItemDashboard = $menuItem->dashboard;
if ( !empty($menuItemUrl) ) {
   $tpl = $smarty->CreateTemplate( $this->GetTemplateResource('dashboard_iframe.tpl'), null, null, $smarty );
   $tpl->assign('dashboard_url', $menuItemUrl);
   $tpl->display();

} elseif ( !empty($menuItemDashboard) ) {
   $tpl = $smarty->CreateTemplate( $this->GetTemplateResource('dashboard_display.tpl'), null, null, $smarty );
   $tpl->assign('dashboard_contents', $menuItemDashboard);
   $tpl->display();

}
