<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if( !defined('CMS_VERSION') ) exit;
if( !$this->CheckPermission(Dashboard::MANAGE_PERM) ) return;


if (isset($params['message'])) {
   echo $this->ShowMessage($this->Lang($params['message']));
}
if (isset($params['errors']) && count($params['errors'])) {
   echo $this->ShowErrors($params['errors']);
}

$menuItem = new DashboardItem();

if (isset($params['cancel'])) {
   $params = array('active_tab' => 'maintab');
   $this->Redirect($id, 'defaultadmin', $returnid, $params);
}

if ( isset($params['submit']) ) {
   if ( isset($params['itemid']) && $params['itemid']>0 ) {
      $menuItem = $menuItem::load_by_id( (int)$params['itemid'] );
   }
   if ( empty($params['title']) ) {
      $menuItem->title = $this->GetName().'*';
   } else {
      $menuItem->title = trim($params['title']);
   }
   $menuItem->section = trim($params['section']);
   $menuItem->url = trim($params['url']);
   $menuItem->new_tab = isset($params['new_tab']) ? (bool)$params['new_tab'] : false;
   $menuItem->dashboard = trim($params['dashboard']);
   $menuItem->save(); // if id set will update, else will create new

   $this->RefreshCache();  // Touch menu cache files - core will refresh

   $params = array('message' => 'menu_updated', 'active_tab' => 'maintab');
   $this->Redirect($id, 'defaultadmin', '', $params);

}


// uses core 'lang' function to get core language strings
$admin_sections = array(
   'main' => lang('main'),
   'content' => lang('content'),
   'layout' => lang('layout'),
   'usersgroups' => lang('usersgroups'),
   'extensions' => lang('extensions'),
   'siteadmin' => lang('siteadmin'),
   'myprefs' => lang('myprefs'),
   'ecommerce' => lang('ecommerce')
);

if ( isset($params['itemid']) && $params['itemid'] > 0 ) {
   $menuItem = DashboardItem::load_by_id((int)$params['itemid']);
}

// display add/edit form
$tpl = $smarty->CreateTemplate( $this->GetTemplateResource('add_edit_item.tpl'), null, null, $smarty );

$tpl->assign('menuItem', $menuItem);
$tpl->assign('admin_sections', $admin_sections);

$tpl->display();


// if (!empty($errors)) {
//    $this->ShowErrors($errors);
// }

