<?php
#---------------------------------------------------------------------------------------------------
# Module: Dashboard
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/dashboard
# Licence: GNU General Public License version 3
#          see /Dashboard/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------
# A fork of module: Nested Admin
# Original Author: Jonathan Schmid / hi@jonathanschmid.de / www.jonathanschmid.de
#---------------------------------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2019 by CMS Made Simple Foundation (copyright@cmsmadesimple.org)
# Project's homepage is: http://www.cmsmadesimple.org
#---------------------------------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify it under the terms of the
# GNU General Public License as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#---------------------------------------------------------------------------------------------------

class Dashboard extends \CMSModule {

   const MANAGE_PERM = 'manage_dashboard';
   const USE_PERM = 'use_dashboard';

	public function GetVersion() { return '1.2'; }
   public function GetName() { return 'Dashboard';	}
	public function GetFriendlyName() {
      return $this->GetPreference( 'friendly_name', $this->Lang('friendly_name') );
   }
   public function IsPluginModule() { return false; }
	public function HasAdmin()	{ return true;	}
	public function GetAdminDescription() { return $this->Lang('moddescription');	}
	public function MinimumCMSVersion()	{ return "2.0"; }
	public function InstallPostMessage() {	return $this->Lang('postinstall'); }
	public function UninstallPostMessage()	{ return $this->Lang('postuninstall');	}
	public function UninstallPreMessage() { return $this->Lang('really_uninstall'); }
	public function GetHelp() { return $this->Lang('help'); }
   public function GetChangeLog() { return $this->Lang('changelog'); }
   public function GetAuthor() { return 'Chris Taylor'; }
   public function GetAuthorEmail() { return 'chris@binnovative.co.uk'; }



   public function __construct() {
      $fn = cms_join_path( $this->GetModulePath(), 'lib', 'class.Dashboard.php' );
      if ( file_exists($fn) ) require_once($fn);

      parent::__construct();
   }



   public function GetHeaderHTML() {
      $smarty = \CmsApp::get_instance()->GetSmarty();
      $tpl = $smarty->CreateTemplate( $this->GetTemplateResource('dashboard_header_html.tpl'), null, null, $smarty );
      $tpl->assign('module_path', $this->GetModuleURLPath());
      return $tpl->fetch();
   }



   // this does all the hard work :)
   public function GetAdminMenuItems() {
      $out = [];
      if ( $this->CheckPermission(Dashboard::MANAGE_PERM)) {
         $out[] = \CmsAdminMenuItem::from_module($this);
      }
      if ( $this->CheckPermission(Dashboard::USE_PERM) ) {
         $query = new DashboardQuery;
         $menuItems = $query->GetMatches();

         foreach ($menuItems as $menuItem) {
            $obj = new CmsAdminMenuItem();
            $obj->module = $this->GetName();
            $obj->title = $menuItem->title;
            $obj->section = $menuItem->section;
            // $obj->description - not set
            $obj->action = 'admin_dashboard_display';
            $obj->priority = 50;  // 2 = top of 3rd party items, 50 = alphabetical
            if ($menuItem->new_tab) {
               $obj->url = $menuItem->url.'?newtab=1';
            } else {
               $params = ['itemid' => $menuItem->id ];
               $obj->url = $this->create_url('m1_', $obj->action, '', $params);
            }
            $out[] = $obj;
         }

      }
      return $out;
   }



   /* internal */
   public function RefreshCache() {
      // Touch menu cache files - core will refresh
      $cacheFilePattern = version_compare(CMS_VERSION, '1.99-alpha0', '<') ? "themeinfo*.cache" : "cache*.cms"; // v1.11 : v2.0
      foreach ( glob(cms_join_path(TMP_CACHE_LOCATION, $cacheFilePattern)) as $filename ) {
         touch( $filename, time() - 360000 );
      }
   }

}


