<?php

namespace Sagepay2;

final class gateway implements \CGEcommerceBase\payment_gateway {

   use \CGEcommerceBase\dflt_gateway_implementation;
   private $_mod;

   // module limits
   public function AllowsInstantCheckout() { return TRUE; }
   public function RequiresCreditCardInfo() { return false; }
   public function RequiresSSL() { return false; }
   public function RequiresShippingInfo() { return false; }
   public function RequiresBillingInfo() { return false; }
   public function SupportsOfflineCharges() { return false; }
   public function SupportsRefunds() { return false; }

   public function __construct( \Sagepay2 $mod ) {
      $this->_mod = $mod;
   }

   public function GetName() {
      return $this->_mod->GetName();
   }

   public function IsConfigured() {
      $tmp = null;
      $configured = false;
      $mod = \cms_utils::get_module(MOD_SAGEPAY2);
      if ( $tmp = explode(':', $mod->GetPreference('vendor_email')) ) {
         foreach ($tmp as $tmpEmail) {
            if ( filter_var($tmpEmail, FILTER_VALIDATE_EMAIL) ) {
               $configured = true;
            }
         }
      }
      return $configured;
   }

   function CheckInfo() { return true; }

   function FinishTransaction() {
      if( !isset($this->_data['destination']) ) return FALSE;

      $mod = \cms_utils::get_module(MOD_SAGEPAY2);
      $key = $this->SaveState(true);
      $url = $this->_data['destination'];
      $url = html_entity_decode($url);
      $url .= "&cntnt01datakey=$key";
      $url .= '&cntnt01gateway='.$mod->GetName();
      redirect($url);
   }

   function GetForm($returnid) {
      $mod = \cms_utils::get_module(MOD_SAGEPAY2);
      if( !$this->CheckInfo() ) return FALSE;

      $key = $this->SaveState(true);
      $url = '';

      $vendorName = '';
      $cryptKey = '';
      if( $mod->GetPreference('prodmode') ) {
         $url = $mod::PROD_URL;
         $vendorName = $mod->GetPreference('prod_acct');
         $cryptKey = $mod->GetPreference('prod_token');
      } else {
         $url = $mod::TEST_URL;
         $vendorName = $mod->GetPreference('test_acct');
         $cryptKey = $mod->GetPreference('test_token');
      }

      $parms = array();
      // add some SagePay specific values
      $parms['VPSProtocol'] = $mod::VPSProtocol;
      $parms['TxType'] = 'Payment';
      $parms['Vendor'] = $vendorName;

      // for SagePay the 'Crypt' field should contain all the other transaction information
      $_crypt = array();
      // get all mandatory fields
      $_crypt['VendorTxCode'] = $this->GetOrderId().'-'.date('Y-m-d-TH-i-s');
      $_crypt['Amount'] = number_format( $this->GetTransactionAmount() ,2,'.','' );
      $_crypt['Currency'] = ($tmp = $this->GetCurrencyCode()) ? $tmp : cg_ecomm::get_currency_code(); // mandatory
      $_crypt['Description'] = 'Ecommerce Order';
      $_crypt['SuccessURL'] = str_replace( '&amp;', '&', $mod->CreateLink('cntnt01','return_success',$returnid,'',
         array('order_id'=>$this->GetOrderId(),'mycustom'=>$key),'',true) );
      $_crypt['FailureURL'] = str_replace( '&amp;', '&', $mod->CreateLink('cntnt01','return_cancel',$returnid,'',
         array('order_id'=>$this->GetOrderId(),'mycustom'=>$key),'',true) );

      // add optional fields
      $_crypt['SendEMail'] = $mod->GetPreference('send_email_selected');
      $_crypt['VendorEMail'] = $mod->GetPreference('vendor_email');

      // add address details - also mostly mandatory
      if ( ($address = $this->GetBillingAddress()) ) {
         $_crypt['BillingSurname'] = $address->get_lastname();
         $_crypt['BillingFirstnames'] = $address->get_firstname();
         $_crypt['BillingAddress1'] = $address->get_address1();
         if ( ($addr2 = $address->get_address2()) ) $_crypt['BillingAddress2'] = $addr2;
         $_crypt['BillingCity'] = $address->get_city();
         if ( ($state = $address->get_state()) )  $_crypt['BillingState'] = $state;
         $_crypt['BillingPostCode'] = $address->get_postal();
         $_crypt['BillingCountry'] = $address->get_country();
         if ( ($phone = $address->get_phone()) ) $_crypt['BillingPhone'] = $phone;
         $_crypt['CustomerEMail'] = $address->get_email();
      }
      if ( ($address = $this->GetShippingAddress()) ) {   // also mostly mandatory
         $_crypt['DeliverySurname'] = $address->get_lastname();
         $_crypt['DeliveryFirstnames'] = $address->get_firstname();
         $_crypt['DeliveryAddress1'] = $address->get_address1();
         if ( ($addr2 = $address->get_address2()) ) $_crypt['DeliveryAddress2'] = $addr2;
         $_crypt['DeliveryCity'] = $address->get_city();
         if ( ($state = $address->get_state()) )  $_crypt['DeliveryState'] = $state;
         $_crypt['DeliveryPostCode'] = $address->get_postal();
         $_crypt['DeliveryCountry'] = $address->get_country();
         if ( ($phone = $address->get_phone()) ) $_crypt['DeliveryPhone'] = $phone;
      }

      // add basket items, including Tax & Delivery
      $basket = '';
      $count = 0;
      $items = $this->GetItems();
      foreach( $items as $name => $data ) {
         // add each basket line format: 'Items:Quantity:Item value:Item Tax:Item Total:Line Total'
         $itemName = str_replace(':', ' ', $name);
         $itemQty = $data['quantity'];
         $itemValue = number_format( $data['amount'],2,'.','' );
         $basket .= ':'. $itemName .':'. $itemQty .':'. $itemValue .':::'.
            number_format($itemQty*$itemValue ,2,'.','');
         $count++;
      }
      $_crypt['Basket'] = $count.$basket;


      // roll all _crypt into an encrypted query string
      $queryStr = $this->arrayToQueryString($_crypt);
      // Encrypt order details using base64 and the secret key from the settings.
      $parms['Crypt'] = $this->encryptAes($queryStr, $cryptKey);

      // give everything to smarty
      $gCms = cmsms();
      $config = $gCms->GetConfig();
      $smarty = $gCms->GetSmarty();
      $smarty->assign('posturl',$url);

      $str = '';
      $fmt = '<input type="hidden" name="%s" value="%s"/>'."\n";
      foreach( $parms as $key=>$value ) {
          $str .= sprintf($fmt,$key,(string)$value);
      }
      $smarty->assign('formvalues',$str);

      return $mod->ProcessTemplateFromDatabase('form_template');
   }



   public function get_cartitem_policy() {
      $mod = \cms_utils::get_module(MOD_SAGEPAY2);

      $policy = new \cg_ecomm_cartitem_policy;
      // if( $mod->GetPreference('allow_subscriptions') && $mod->GetPreference('enable_ipn') ) {
      //     $policy->set_max_subscriptions(1);
      // }
      // else {
         $policy->set_max_subscriptions(0);
      // }
      // $policy->set_max_subscription_periods( 52 );
      $policy->set_max_subscription_periods( 0 );
      $policy->set_mixed_subscriptions(FALSE);
      return $policy;
   }



   public function ProcessTransaction() {
      die(__METHOD__.' is not implemented');
   }



   public function ProcessSyncTransaction() {
      die(__METHOD__.' is not implemented');
   }



   //***********************************************************************************************
   // added functions - from Sagepay - for API v3.0
   //***********************************************************************************************

   /**
   * PHP's mcrypt does not have built in PKCS5 Padding, so we use this.
   *
   * @param string $input The input string.
   *
   * @return string The string with padding.
   */
   protected function addPKCS5Padding($input) {
      $blockSize = 16;
      $padd = "";

      // Pad input to an even block size boundary.
      $length = $blockSize - (strlen($input) % $blockSize);
      for ($i = 1; $i <= $length; $i++)
      {
         $padd .= chr($length);
      }

      return $input . $padd;
   }


   /**
   * Remove PKCS5 Padding from a string.
   *
   * @param string $input The decrypted string.
   *
   * @return string String without the padding.
   * @throws SagepayApiException
   */
   protected function removePKCS5Padding($input) {
      $blockSize = 16;
      $padChar = ord($input[strlen($input) - 1]);

      /* Check for PadChar is less then Block size */
      if ($padChar > $blockSize) {
         echo $this->ShowErrors($this->Lang('error_encryption_string'));
      }
      /* Check by padding by character mask */
      if (strspn($input, chr($padChar), strlen($input) - $padChar) != $padChar) {
         echo $this->ShowErrors($this->Lang('error_encryption_string'));
      }

      $unpadded = substr($input, 0, (-1) * $padChar);
      /* Chech result for printable characters */
      if (preg_match('/[[:^print:]]/', $unpadded)) {
         echo $this->ShowErrors($this->Lang('error_encryption_string'));
      }
      return $unpadded;
   }


   /**
   * Encrypt a string ready to send to SagePay using encryption key.
   *
   * @param  string  $string  The unencrypyted string.
   * @param  string  $key     The encryption key.
   *
   * @return string The encrypted string.
   */
   public function encryptAes($string, $key) {
      // AES encryption, CBC blocking with PKCS5 padding then HEX encoding.
      // Add PKCS5 padding to the text to be encypted.
      $string = self::addPKCS5Padding($string);

      // Perform encryption with PHP's MCRYPT module.
      $crypt = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $string, MCRYPT_MODE_CBC, $key);

      // Perform hex encoding and return.
      return "@" . strtoupper(bin2hex($crypt));
   }


   /**
   * Decode a returned string from SagePay.
   *
   * @param string $strIn         The encrypted String.
   * @param string $password      The encyption password used to encrypt the string.
   *
   * @return string The unecrypted string.
   * @throws SagepayApiException
   */
   public function decryptAes($strIn, $password) {
      // HEX decoding then AES decryption, CBC blocking with PKCS5 padding.
      // Use initialization vector (IV) set from $str_encryption_password.
      $strInitVector = $password;

      // Remove the first char which is @ to flag this is AES encrypted and HEX decoding.
      $hex = substr($strIn, 1);

      // Throw exception if string is malformed
      if (!preg_match('/^[0-9a-fA-F]+$/', $hex)) {
         echo $this->ShowErrors($this->Lang('error_encryption_string'));
      }
      $strIn = pack('H*', $hex);

      // Perform decryption with PHP's MCRYPT module.
      $string = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $password, $strIn, MCRYPT_MODE_CBC,
         $strInitVector);
      return self::removePKCS5Padding($string);
   }


   /**
   * Convert a data array to a query string ready to post.
   *
   * @param  array   $data        The data array.
   * @param  string  $delimeter   Delimiter used in query string
   * @param  boolean $urlencoded  If true encode the final query string
   *
   * @return string The array as a string.
   */
   public function arrayToQueryString(array $data, $delimiter = '&', $urlencoded = false) {
      $queryString = '';
      $delimiterLength = strlen($delimiter);

      // Parse each value pairs and concate to query string
      foreach ($data as $name => $value) {
         // Apply urlencode if it is required
         if ($urlencoded) {
            $value = urlencode($value);
         }
         $queryString .= $name . '=' . $value . $delimiter;
      }

      // remove the last delimiter
      return substr($queryString, 0, -1 * $delimiterLength);
   }


   /**
   * Convert string to data array.
   *
   * @param string  $data       Query string
   * @param string  $delimeter  Delimiter used in query string
   *
   * @return array
   */
   public function queryStringToArray($data, $delimeter = "&") {
      // Explode query by delimiter
      $pairs = explode($delimeter, $data);
      $queryArray = array();

      // Explode pairs by "="
      foreach ($pairs as $pair)
      {
         $keyValue = explode('=', $pair);

         // Use first value as key
         $key = array_shift($keyValue);

         // Implode others as value for $key
         $queryArray[$key] = implode('=', $keyValue);
      }
      return $queryArray;
   }



} // end of class
