<?php
#---------------------------------------------------------------------------------------------------
# Module: Sagepay2
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/sagepay2
# Licence: GNU General Public License version 3
#          see /Sagepay2/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

# A

# B

# C
$lang['checkout_button_message'] = 'Checkout';
$lang['checkout_message'] = 'Checkout with Sagepay:';

# E
$lang['error_transaction_invalid_amount'] = 'An invalid amount (not the entire amount?) was received for order %s. Status: %s';

$lang['error_invalid_data'] = 'Insufficient data was received from Sagepay';
$lang['error_ipn_invalid_orderid'] = 'Invalid or missing order id';

$lang['error_missing_custom_verifier'] = 'A code used to uniquely identify this transaction could not be found in the data returned from the payment gateway';
$lang['error_no_mcrypt'] = 'No encryption functionality found... this module will not function properly until mcrypt extensions are enabled';
$lang['error_payment_declined'] = 'Payment declined';
$lang['error_retrieving_transaction_data'] = 'An error occurred trying to retrieve transaction information from the gateway';
$lang['error_restoring_transaction_state'] = 'An error occurred trying to restore saved transaction information';
$lang['error_transaction_failed'] = 'Transaction failed for order %s. Status: %s';
$lang['error_transaction_id_missing'] = 'The transaction appeared to succeed, but we could not find a transaction id';
$lang['error_transaction_pdt_failed'] = 'PDT Failed';

$lang['error_encryption_string'] = 'Invalid encryption string';


# F
$lang['form_template'] = 'Form Template';
$lang['friendlyname'] = 'Sagepay2 Gateway';

# H
$lang['help_order_id'] = 'Specifies the order id of the order we\'re try to complete.';

# I
$lang['info_test_settings'] = 'When test mode is enabled, the system will use the Sagepay Test system, you must enter valid test system credentials';


# M
$lang['moddescription'] = 'Part of the E-commerce collection, provide the ability to perform checkounts via SagePay';
$lang['msg_testmode'] = 'Sagepay2 module is in test mode';
$lang['msg_transaction_cancelled'] = 'Transaction Cancelled for order %s. Status: %s';
$lang['msg_transaction_declined'] = 'Transaction Declined for order %s. Status: %s';
$lang['msg_transaction_success'] = 'Received successfull transaction reply for order %s %s';
$lang['msg_transaction_waitingipn'] = 'Transaction %s marked as PENDING until IPN confirmation arrives (%s)';
$lang['msg_unconfigured'] = 'This module has not yet been properly configured, it will not operate properly until it is configured.';


# O
$lang['online_purchase'] = 'Online Purchase';

# P
$lang['postinstall'] = 'The Sagepay2 gateway module has now been installed.  You can select this gateway module from your Calguys Ecommerce Base module, Payment Settings tab.';
$lang['postuninstall'] = 'The Sagepay2 gateway module has now been removed';
$lang['preferences'] = 'Preferences';
$lang['prodmode'] = 'Enable Production Mode';
$lang['production_settings'] = 'Production Settings';
$lang['prompt_form_template'] = 'Edit the payment form template';

# R
$lang['really_uninstall'] = 'Really? You\'re sure you want to uninstall this Sagepay2 module?';

# S
$lang['sagepay_vendor_name'] = 'Sagepay Vendor Name';
$lang['sagepay_password'] = 'Sagepay Encryption Password';
$lang['shipping'] = 'Shipping';
$lang['send_emails'] = 'Sagepay Send Confirmation Emails';
$lang['send_email_none'] = 'Do not send either customer or vendor emails';
$lang['send_email_both'] = 'Send customer and vendor emails if addresses are provided';
$lang['send_email_vendor'] = 'Send vendor email but NOT the customer email';

# T
$lang['test_settings'] = 'Test Settings';

# V
$lang['vendor_email'] = 'Sagepay Vendor Conformation Email Address';
$lang['vendor_email_info'] = 'If provided, an email will be sent to this address when each transaction completes (successfully or otherwise). Use a colon (:) to separate multiple email addresses.';








###    ###   #########   ###        #########
###    ###   #########   ###        #########
###    ###   ###         ###        ###   ###
##########   #########   ###        #########
##########   #########   ###        #########
###    ###   ###         ###        ###
###    ###   #########   #########  ###
###    ###   #########   #########  ###

$lang['help'] = <<<'EOD'

<h3>What does it do?</h3>
  <p>This module is used by the Orders module to complete purchases using Sagepay.  After checkout is completed (successfully or unsuccessfully) on the SagePay site, the user is redirected back to the Orders module to show the checkout receipt page.</p>
  <p>See <a href="http://calguy1000.com/Blogs/8/60/cmsms-quick-e-commerce-how-to.html">http://calguy1000.com/Blogs/8/60/cmsms-quick-e-commerce-how-to.html</a>  for more information on how to setup the Cart, Orders and other associated modules.</p>

<h3>How Do I use It</h3>
<p>First you create a Sagepal account, and obtain the Sagepay Vendor Name, Test System Encryption Password and (when you are ready to go live) the Production System Encryption Password.</p>
<p>Leave 'Enable Production Mode' set to 'No' until you are ready to go Live. </p>
<p>You can choose to have Sagepay to send emails to website owner and the customer after checkout is completed, using the 'Sagepay Send Confirmation Emails' option. If selected the customer is only sent an email on successful completion of the checkout. If selected the Vendor is sent either a success or failure email.</p>
<p>In 'Calguys Ecommerce Base > Payment Settings' select Sagepay2 as the Payment Gateway Module.</p>

<h3>Implementation Notes</h3>
<p>Sagepay2 use the Sagepay Form v3.0 Protocol.</p>
<ul>
   <li>Taxes: are shown as line items.</li>
   <li>Shipping: all shipping costs are entered as line items.</li>
   <li>Discounts: are included in the displayed line item amount</li>
</ul>
<p>Sagepay2 does not (at this time) support subscriptions / repeat payments
<p>Based on Calguys PaypalGateway v 2.3.11 - April, 2013 - calguy1000 and the original SagePayGateway module v1.0</p>

<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit the cms development forge at <a href="http://dev.cmsmadesimple.org">dev.cmsmadesimple.org</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
</ul>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2015, Chris Taylor. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>

EOD;







#########  ###    ###  ##########  ###    ###  #########  ########  ###       #########  #########
#########  ###    ###  ##########  ####   ###  #########  ########  ###       #########  #########
###        ###    ###  ###    ###  #####  ###  ###        ###       ###       ###   ###  ###
###        ##########  ##########  ### ## ###  ###        ########  ###       ###   ###  ###
###        ##########  ##########  ###  #####  ###   ###  ########  ###       ###   ###  ###   ###
###        ###    ###  ###    ###  ###   ####  ###   ###  ###       ###       ###   ###  ###   ###
#########  ###    ###  ###    ###  ###    ###  #########  ########  ######### #########  #########
#########  ###    ###  ###    ###  ###    ###  #########  ########  ######### #########  #########

$lang['changelog'] = <<<'EOD'

<h3>Version 1.1 - 06Nov19</h3>
<ul>
   <li>Rewritten to work with CGPaymentGatewayBase 1.6.x+</li>
   <li>Will now return to Checkout page (without clearing Cart) if user cancels SagePay payment</li>
</ul>
<br>

<h3>Version 0.9.2 - 22Jul15</h3>
<ul>
   <li>added some optional debug code (default to OFF)</li>
</ul>
<br>

<h3>Version 0.9.1 - 15Jul15</h3>
<ul>
   <li>Sagepay response 'REJECTED' now sets order status to cancelled, otherwise Orders sets status to SUCCESS and payment to Declined</li>
   <li>bug fix to correctly accept Sagepay response amount 1000+</li>
</ul>
<br>

<h3>Version 0.9 - 14Jul15</h3>
<ul>
   <li>0.9 - initial release</li>
   <li>Based on Calguys PaypalGateway v 2.3.11 - April, 2013 - calguy1000 and the original SagePayGateway module v1.0</li>
   <li>NOTE: PHP 5.3.x IS REQUIRED</li>
</ul>
<br>

EOD;


