<?php
#---------------------------------------------------------------------------------------------------
# Module: Sagepay2
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/sagepay2
# Licence: GNU General Public License version 3
#          see /Sagepay2/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if ( !isset($gCms) ) exit;

if ( !isset($params['mycustom']) ) {
    $this->SetTransactionError($this->Lang('error_missing_custom_verifier'));
    $this->Audit('',$this->GetName().':return_success',$this->Lang('error_missing_custom_verifier'));
    $this->FinishTransaction();
    return;

} else if ( !isset($params['order_id']) )  {
    $this->SetTransactionError($this->Lang('error_ipn_invalid_orderid'));
    $this->Audit('',$this->GetName().':return_success',$this->Lang('error_ipn_invalid_orderid'));
    $this->FinishTransaction();
    return;
}

// decode Sagepay response
$cryptKey = '';
if( $this->GetPreference('prodmode') ) {
   $cryptKey = $this->GetPreference('prod_token');
} else {
   $cryptKey = $this->GetPreference('test_token');
}
$crypt = $_REQUEST['crypt'];
$decrypt = $this->decryptAes($crypt, $cryptKey);
$response = $this->queryStringToArray($decrypt);

if (!$decrypt || empty($response)) {
   $this->SetError( $this->Lang('error_invalid_data') );
   $this->Audit('', $this->GetName(), $this->Lang('error_invalid_data'));
}

if( !isset($response['VPSTxId']) ) {
   $this->RestoreState($params['mycustom']);
   $this->SetTransactionError($this->Lang('error_transaction_id_missing'));
   $this->Audit('',$this->GetName().':return_success',$this->Lang('error_transaction_id_missing'));
   $this->FinishTransaction();
   return;
}

$this->RestoreState($params['mycustom']);
if( !$this->CheckInfo() ) {
   $this->SetTransactionError($this->Lang('error_restoring_transaction_state'));
   $this->FinishTransaction();
   return;
}


$config = $gCms->GetConfig();
$tmp = '';
$amt = '';
$txn_id = '';
if( isset($response['VPSTxId']) ) {
   $txn_id = trim($response['VPSTxId']);
}

if( isset($response['Amount']) ) {
   $amt = preg_replace('/[^0-9.]/', '', $response['Amount']);
}

if( empty($amt) ) {
   $this->Audit('',$this->GetName().':return_success',$this->lang('error_transaction_invalid_amount'));
} else if( isset($this->_data['amount']) && $amt != $this->_data['amount'] ) {
   // amount is invalid, that's wonky
   $this->Audit('',$this->GetName().':return_success',$this->lang('error_transaction_invalid_amount'));
}


if( $response['Status']!='OK' || $txn_id=='' ) {
   // strange response problem.
   $this->SetTransactionError( $this->Lang('error_transaction_pdt_failed').' - status = '.$response['Status'].': '.
      $response['StatusDetail'] );
   $this->Audit('',$this->GetName().':return_success',$this->Lang('error_transaction_pdt_failed'));

} else { // Status=='OK' && $txn_id!=''
   $this->SetTransactionId($txn_id);
   $this->SetTransactionAmount($amt);
   $this->Audit('',$this->GetName().':return_success',$this->Lang('msg_transaction_success', $txn_id));
   $this->SetTransactionStatus(PAYMENT_STATUS_APPROVED);

}

$this->FinishTransaction();


