<?php
#---------------------------------------------------------------------------------------------------
# Module: Sagepay2
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/sagepay2
# Licence: GNU General Public License version 3
#          see /Sagepay2/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if( !isset($gCms) ) exit;

// is this code still used?
if ( !isset($params['mycustom']) ) {
   $this->SetTransactionError($this->Lang('error_missing_custom_verifier'));
   $this->Audit('',$this->GetName().':return_cancel','Custom Verify Code not specified');
   return;

} else if ( !isset($params['order_id']) ) {
   $this->SetTransactionError($this->Lang('error_ipn_invalid_orderid'));
   $this->Audit('',$this->GetName().':return_cancel','Order ID not Specified');
   return;

} if ( !$this->RestoreState($params['mycustom']) ) {
   $this->SetTransactionError($this->Lang('error_restoring_transaction_state'));
   $this->Audit('',$this->GetName().':return_cancel','Error Restoring transaction state');
   return;

}

// decode Sagepay response
$cryptKey = '';
if( $this->GetPreference('prodmode') ) {
   $cryptKey = $this->GetPreference('prod_token');
} else {
   $cryptKey = $this->GetPreference('test_token');
}
$crypt = $_REQUEST['crypt'];
$decrypt = $this->decryptAes($crypt, $cryptKey);
$response = $this->queryStringToArray($decrypt);

if (!$decrypt || empty($response)) {
   $this->SetError( $this->Lang('error_invalid_data') );
   $this->Audit('', $this->GetName(), $this->Lang('error_invalid_data'));
}

if ($response['Status']=='ABORT') {
   $mod = \cms_utils::get_module('Orders');
   if (is_object($mod)) {
      $cartId = $mod->GetPreference('billingpage');
      $manager = $gCms->GetHierarchyManager();
      if ( $cartId!='' ) {
         $node = $manager->find_by_tag('id',$cartId);
         if( $node ) {
            $content = $node->GetContent();
            $url = $content->GetUrl();
            audit('',$this->GetName().':return_cancel','payment cancelled, return to cart - id:'.$params['order_id']);
            redirect($url);
         }
      }
   }
}

// Otherwise cancel transaction and clear out the cart
audit('',$this->GetName().':return_cancel','transaction cancelled - id:'.$params['order_id']);
$this->SetCancelled();
$this->FinishTransaction();


