<?php
#---------------------------------------------------------------------------------------------------
# Module: Sagepay2
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/sagepay2
# Licence: GNU General Public License version 3
#          see /Sagepay2/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------

if ( !isset($gCms) ) exit;

// do functionality tests
if ( !function_exists('mcrypt_module_open') ) {
  echo $this->ShowErrors($this->Lang('error_no_mcrypt'));
  return;
}

if( !$this->IsConfigured() ) {
    echo '<div class="information">'.$this->Lang('msg_unconfigured').'</div>';
}

// start tabs.
echo $this->StartTabHeaders();
if( $this->CheckPermission('Modify Site Preferences') ) {
  echo $this->SetTabHeader('prefs',$this->Lang('preferences'));
}
if( $this->CheckPermission('Modify Templates') ) {
  echo $this->SetTabHeader('template',$this->Lang('form_template'));
}
echo $this->EndTabHeaders();

echo $this->StartTabContent();
if( $this->CheckPermission('Modify Site Preferences') ) {
  // handle the form
  if (isset($params['submit'])) {
    $this->SetPreference('prodmode',(int)$params['prodmode']);
    $this->SetPreference('prod_acct',trim($params['prod_acct']));
    $this->SetPreference('prod_token',trim($params['prod_token']));
    $this->SetPreference('test_acct',trim($params['test_acct']));
    $this->SetPreference('test_token',trim($params['test_token']));
    $this->SetPreference('vendor_email',trim($params['vendor_email']));
    $this->SetPreference('send_email_selected',trim($params['send_email_selected']));
  }

  echo $this->StartTab('prefs');
  $smarty->assign('formstart', $this->CGCreateFormStart($id, 'defaultadmin', $returnid));
  $smarty->assign('formend', $this->CreateFormEnd());

  $smarty->assign('prodmode',$this->GetPreference('prodmode',0));
  $smarty->assign('prod_acct',$this->GetPreference('prod_acct'));
  $smarty->assign('prod_token',$this->GetPreference('prod_token'));
  $smarty->assign('test_acct',$this->GetPreference('test_acct'));
  $smarty->assign('test_token',$this->GetPreference('test_token'));

  $smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));

  $contentops = $gCms->GetContentOperations();
  $the_returnid = $contentops->GetDefaultContent();

   $smarty->assign('vendor_email',$this->GetPreference('vendor_email'));
   $sendEmailOptions = array(
      '0'=>$this->Lang('send_email_none'),
      '1'=>$this->Lang('send_email_both'),
      '2'=>$this->Lang('send_email_vendor')
   );
   $smarty->assign('send_email_options', $sendEmailOptions);
   $smarty->assign('send_email_selected', $this->GetPreference('send_email_selected'));


  echo $this->ProcessTemplate('prefs.tpl');
  echo $this->EndTab();
}

if( $this->CheckPermission('Modify Templates') ) {
  echo $this->StartTab('template');
  include(dirname(__FILE__).'/function.template_tab.php');
  echo $this->EndTab();
}


echo $this->EndTabContent();
// EOF
?>
