<?php
#---------------------------------------------------------------------------------------------------
# Module: Sagepay2
# Author: Chris Taylor
# Copyright: (C) 2019 Chris Taylor, chris@binnovative.co.uk
# Module's homepage is: http://dev.cmsmadesimple.org/projects/sagepay2
# Licence: GNU General Public License version 3
#          see /Sagepay2/lang/LICENCE.txt or <http://www.gnu.org/licenses/>
#---------------------------------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2019 by CMS Made Simple Foundation (copyright@cmsmadesimple.org)
# Project's homepage is: http://www.cmsmadesimple.org
#---------------------------------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or modify it under the terms of the
# GNU General Public License as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#---------------------------------------------------------------------------------------------------

final class Sagepay2 extends CGPaymentGatewayBase {

   private $_helper;
   const TEST_URL = 'https://test.sagepay.com/gateway/service/vspform-register.vsp';
   const PROD_URL = 'https://live.sagepay.com/gateway/service/vspform-register.vsp';
   const VPSProtocol = '3.00';

   function __construct() {
      parent::__construct();
      $this->_data = array();
   }

   function GetName() { return get_class($this); }
   function GetFriendlyName() { return $this->Lang('friendlyname'); }
   function GetVersion() { return '1.1'; }
   function GetHelp() { return $this->Lang('help'); }
   function GetAuthor() { return 'Chris Taylor'; }
   function GetAuthorEmail() { return 'chris@binnovative.co.uk'; }
   function GetChangeLog() { return $this->Lang('changelog'); }
   function IsPluginModule() { return TRUE; }
   function HasAdmin() { return TRUE; }
   function GetAdminSection() { return 'ecommerce'; }
   function GetAdminDescription() { return $this->Lang('moddescription'); }
   function InstallPostMessage() { return $this->Lang('postinstall'); }
   function UninstallPostMessage() { return $this->Lang('postuninstall'); }
   function UninstallPreMessage() { return $this->Lang('really_uninstall'); }
   function MinimumCMSVersion() { return '2.1.5'; }
   function VisibleToAdminUser() { return $this->CheckPermission('Modify Templates') ||
                                          $this->CheckPermission('Modify Site Preferences'); }
   function GetDependencies() { return array('CGExtensions'=>'1.56.2','CGPaymentGatewayBase'=>'1.6.2'); }
   function LazyLoadAdmin() { return TRUE; }
   function LazyLoadFrontend() { return FALSE; } /* we register a dynamic route, cannot lazy load */


   function SetParameters() {
      $this->RegisterModulePlugin();
      $this->RestrictUnknownParams();

      $this->RegisterRoute('/sagepay\/return\/(?P<returnid>[0-9]+)$/', array('action'=>'return'));

      $this->SetParameterType('process', CLEAN_STRING);
      $this->SetParameterType('order_id', CLEAN_INT);
      $this->SetParameterType('mycustom', CLEAN_STRING);
   }


  //////////////////////////////////////////////////
  // Begin methods required for payment gateways
  //////////////////////////////////////////////////

   protected function get_new_gateway() {
      if( !$this->_helper ) $this->_helper = new \Sagepay2\gateway($this);
      return $this->_helper;
   }


} // class

?>